/*
 * Decompiled with CFR 0.152.
 */
package puzzle.pieces;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.Vector;
import puzzle.GameCommander;
import puzzle.GamePreferences;
import puzzle.Offset;
import puzzle.PuzzleProperties;
import puzzle.Turnable;
import puzzle.edge.Edge;
import puzzle.storeage.JigsawPuzzleException;
import puzzle.storeage.Storeable;

public abstract class PuzzlePiece
implements Storeable,
Turnable {
    protected static final int GAP_X = 5;
    protected static final int GAP_Y = 5;
    protected static final int GAP_WIDTH = 10;
    protected static final int GAP_HEIGHT = 10;
    protected transient Shape puzzleShape;
    protected boolean highlighted = false;
    protected transient List<Edge> edges;

    public abstract boolean isHit(Point var1);

    public void highlight() {
        this.highlighted = true;
    }

    public void unhighlight() {
        this.highlighted = false;
    }

    public final void renderInClip(Graphics2D graphics2D) throws JigsawPuzzleException {
        Rectangle rectangle = this.getBoundingRectangle();
        GamePreferences gamePreferences = GameCommander.getInstance().getPreferences();
        if (gamePreferences.isShowShadow()) {
            this.renderShadowInClip(graphics2D, rectangle);
        }
        this.renderFaceInClip(graphics2D, rectangle);
        if (gamePreferences.isShowOutline() || this.highlighted && gamePreferences.isHighlight()) {
            this.renderOutlineInClip(graphics2D, rectangle);
        }
    }

    protected abstract void renderFaceInClip(Graphics2D var1, Rectangle var2);

    protected void renderShadowInClip(Graphics2D graphics2D, Rectangle rectangle) {
        graphics2D.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        int n = GameCommander.getInstance().getPreferences().getShadowLength();
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(n, n);
        Shape shape = affineTransform.createTransformedShape(this.puzzleShape);
        graphics2D.setColor(PuzzleProperties.PIECE_SHADOW_COLOR);
        graphics2D.fill(shape);
    }

    protected void renderOutlineInClip(Graphics2D graphics2D, Rectangle rectangle) {
        graphics2D.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        GamePreferences gamePreferences = GameCommander.getInstance().getPreferences();
        graphics2D.setStroke(gamePreferences.getOutlineStroke());
        if (!this.highlighted || !gamePreferences.isHighlight()) {
            graphics2D.setColor(PuzzleProperties.PIECE_COLOR);
        } else {
            graphics2D.setColor(PuzzleProperties.PIECE_HIGHLIGHTED_COLOR);
        }
        graphics2D.draw(this.puzzleShape);
    }

    public abstract Rectangle getBoundingRectangle() throws JigsawPuzzleException;

    public abstract boolean isWithinRectangle(Rectangle var1);

    public Shape getShape() throws JigsawPuzzleException {
        return this.puzzleShape;
    }

    protected abstract void buildShape() throws JigsawPuzzleException;

    public PuzzlePiece snap() throws JigsawPuzzleException {
        GameCommander gameCommander = GameCommander.getInstance();
        List<Edge> list = this.getResolvableEdges();
        List<PuzzlePiece> list2 = gameCommander.getPieceDisposer().getPuzzlePieces();
        for (Edge edge : list) {
            int n = edge.getEdgePairNumber();
            Edge.Type type = Edge.contraryEdgeChar(edge.getType());
            for (PuzzlePiece puzzlePiece : list2) {
                double d;
                Object object;
                List<Edge> list3;
                if (puzzlePiece == this || (list3 = puzzlePiece.getResolvableEdges(type)).isEmpty()) continue;
                Object object2 = null;
                Object object3 = list3.iterator();
                while (object3.hasNext()) {
                    object = object3.next();
                    if (((Edge)object).getEdgePairNumber() != n) continue;
                    object2 = object;
                    break;
                }
                if (object2 == null || !((d = ((Point2D)(object3 = edge.calculatePoint())).distance((Point2D)(object = ((Edge)object2).calculatePoint()))) < 20.0)) continue;
                Offset offset = new Offset(((Point)object).x - ((Point)object3).x, ((Point)object).y - ((Point)object3).y);
                this.move(offset);
                PuzzlePiece puzzlePiece2 = GameCommander.getInstance().getPieceDisposer().assamblyPieces(this, edge, puzzlePiece, (Edge)object2);
                return puzzlePiece2;
            }
        }
        return null;
    }

    public List<Edge> getEdges() {
        return this.edges;
    }

    public abstract List<Edge> getEdges(Edge.Type var1);

    public Edge getEdge(int n) {
        List<Edge> list = this.getEdges();
        for (Edge edge : list) {
            if (edge.getEdgePairNumber() != n) continue;
            return edge;
        }
        return null;
    }

    public List<Edge> getOpenEdges() {
        List<Edge> list = this.getEdges();
        Vector<Edge> vector = new Vector<Edge>();
        for (Edge edge : list) {
            if (!edge.isOpen()) continue;
            vector.add(edge);
        }
        return vector;
    }

    public Edge getOpenEdge(int n) {
        List<Edge> list = this.getOpenEdges();
        for (Edge edge : list) {
            if (!edge.isOpen() || edge.getEdgePairNumber() != n) continue;
            return edge;
        }
        return null;
    }

    public List<Edge> getResolvableEdges() {
        List<Edge> list = this.getEdges();
        Vector<Edge> vector = new Vector<Edge>();
        for (Edge edge : list) {
            if (!edge.isResolvable()) continue;
            vector.add(edge);
        }
        return vector;
    }

    public List<Edge> getResolvableEdges(Edge.Type type) {
        List<Edge> list = this.getEdges(type);
        Vector<Edge> vector = new Vector<Edge>();
        for (Edge edge : list) {
            if (!edge.isOpen()) continue;
            vector.add(edge);
        }
        return vector;
    }

    public abstract int getPieceCount();

    public abstract void move(Offset var1);
}

