/*
 * Decompiled with CFR 0.152.
 */
package puzzle;

import java.awt.BasicStroke;
import java.awt.Stroke;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import puzzle.edge.AbstractEdgeProducer;
import puzzle.storeage.LoadGameException;
import puzzle.storeage.SaveGameException;
import puzzle.storeage.StorageUtil;
import puzzle.storeage.Storeable;
import puzzle.ui.PuzzleImage;

public class GamePreferences
implements Storeable {
    private static final Logger logger = Logger.getLogger(GamePreferences.class);
    private AbstractEdgeProducer edgeProducer;
    private int sideLength;
    private PuzzleImage image;
    private boolean allowTurn;
    private int columns;
    private int rows;
    private int initialPieces;
    private int shadowLength;
    private Stroke puzzleOutline;
    private boolean antiAliasing;
    private boolean showOutline;
    private boolean showShadow;
    private boolean highlight;
    private boolean sound;

    public AbstractEdgeProducer getEdgeProducer() {
        return this.edgeProducer;
    }

    public GamePreferences() {
    }

    public GamePreferences(int n, PuzzleImage puzzleImage, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, AbstractEdgeProducer abstractEdgeProducer) {
        this.sideLength = n;
        this.shadowLength = n / 12;
        this.image = puzzleImage;
        this.allowTurn = bl;
        this.showOutline = bl2;
        this.showShadow = bl3;
        this.highlight = bl4;
        this.sound = bl5;
        this.edgeProducer = abstractEdgeProducer;
        logger.debug("constructing new GamePreferences, sideLength:" + this.sideLength + ", shadow:" + this.showShadow + ", outline:" + this.showOutline + ", producer:" + this.edgeProducer.getClass().getName());
    }

    public int getSideLength() {
        return this.sideLength;
    }

    public PuzzleImage getImage() {
        return this.image;
    }

    public int getColumns() {
        return this.columns;
    }

    public int getRows() {
        return this.rows;
    }

    public int getInitialPieces() {
        return this.initialPieces;
    }

    public boolean isAllowTurn() {
        return this.allowTurn;
    }

    public Stroke getOutlineStroke() {
        return this.puzzleOutline;
    }

    public void setShowOutline(boolean bl) {
        this.showOutline = bl;
    }

    public boolean isShowOutline() {
        return this.showOutline;
    }

    public void setHighlight(boolean bl) {
        this.highlight = bl;
    }

    public boolean isHighlight() {
        return this.highlight;
    }

    public boolean isAntiAliasing() {
        return this.antiAliasing;
    }

    public void setAntiAliasing(boolean bl) {
        this.antiAliasing = bl;
    }

    public void setSound(boolean bl) {
        this.sound = bl;
    }

    public boolean isSound() {
        return this.sound;
    }

    public int getShadowLength() {
        return this.shadowLength;
    }

    public void setShowShadow(boolean bl) {
        this.showShadow = bl;
    }

    public boolean isShowShadow() {
        return this.showShadow;
    }

    public void setColumns(int n) {
        this.columns = n;
    }

    public void setRows(int n) {
        this.rows = n;
    }

    public void calcInitialPieces() {
        this.initialPieces = this.rows * this.columns;
    }

    public void calcDeducedAttributes() {
        if (this.image == null) {
            throw new NullPointerException("no image");
        }
        this.columns = this.image.getWidth() / this.sideLength;
        this.rows = this.image.getHeight() / this.sideLength;
        if (this.columns < 1 || this.rows < 1) {
            throw new IllegalArgumentException("posive number expected");
        }
        int n = this.sideLength / 20;
        this.puzzleOutline = new BasicStroke(n, 1, 0, 1.0f, null, 0.0f);
    }

    @Override
    public void restore(Node node) throws LoadGameException {
        Node node2 = StorageUtil.findDirectChildNode(node, "Preferences");
        NamedNodeMap namedNodeMap = node2.getAttributes();
        Node node3 = namedNodeMap.getNamedItem("sideLength");
        this.sideLength = Integer.parseInt(node3.getNodeValue());
        node3 = namedNodeMap.getNamedItem("allowTurn");
        this.allowTurn = Boolean.parseBoolean(node3.getNodeValue());
        node3 = namedNodeMap.getNamedItem("columns");
        this.columns = Integer.parseInt(node3.getNodeValue());
        node3 = namedNodeMap.getNamedItem("rows");
        this.rows = Integer.parseInt(node3.getNodeValue());
        node3 = namedNodeMap.getNamedItem("initialPieces");
        this.initialPieces = Integer.parseInt(node3.getNodeValue());
        node3 = namedNodeMap.getNamedItem("showOutline");
        this.showOutline = Boolean.parseBoolean(node3.getNodeValue());
        node3 = namedNodeMap.getNamedItem("shadowLength");
        this.shadowLength = Integer.parseInt(node3.getNodeValue());
        node3 = namedNodeMap.getNamedItem("showShadow");
        this.showShadow = Boolean.parseBoolean(node3.getNodeValue());
        node3 = namedNodeMap.getNamedItem("sound");
        this.sound = Boolean.parseBoolean(node3.getNodeValue());
        this.image = new PuzzleImage();
        this.image.restore(node2);
    }

    @Override
    public void store(Node node) throws SaveGameException {
        Document document = node.getOwnerDocument();
        Element element = document.createElement("Preferences");
        element.setAttribute("sideLength", "" + this.sideLength);
        element.setAttribute("allowTurn", "" + this.allowTurn);
        element.setAttribute("columns", "" + this.columns);
        element.setAttribute("rows", "" + this.rows);
        element.setAttribute("initialPieces", "" + this.initialPieces);
        element.setAttribute("showOutline", "" + this.showOutline);
        element.setAttribute("shadowLength", "" + this.shadowLength);
        element.setAttribute("showShadow", "" + this.showShadow);
        element.setAttribute("sound", "" + this.sound);
        this.image.store(element);
        node.appendChild(element);
    }
}

