/*
 * Decompiled with CFR 0.152.
 */
import java.util.Date;
import javax.swing.JOptionPane;

final class JetrisGame
implements Runnable {
    Thread game;
    int score = 0;
    int initialSpeed = 500;
    int currentSpeed;
    JetrisBlock block;
    JetrisBlock nextBlock = this.createBlock((byte)Math.rint(Math.random() * 6.0));
    final int DROPSPEED = 5;

    JetrisGame() {
        if (Jetris.getPreviewWindow().isVisible()) {
            Jetris.getPreviewWindow().getPreview().reset();
            this.nextBlock.preview();
            Jetris.getPreviewWindow().getPreview().repaint();
        }
    }

    public JetrisBlock getBlock() {
        return this.block;
    }

    public int getScore() {
        return this.score;
    }

    public void start() {
        if (this.game == null) {
            this.game = new Thread(this);
            this.game.start();
        }
    }

    public void stop() {
        if (this.game != null) {
            this.game = null;
        }
    }

    public void run() {
        while (this.game != null) {
            this.block = this.nextBlock;
            this.currentSpeed = this.initialSpeed;
            if (this.block.isDown()) {
                this.stop();
                continue;
            }
            this.nextBlock = this.createBlock((byte)Math.rint(Math.random() * 6.0));
            if (Jetris.getPreviewWindow().isVisible()) {
                Jetris.getPreviewWindow().getPreview().reset();
                this.nextBlock.preview();
                Jetris.getPreviewWindow().getPreview().repaint();
            }
            while (this.game != null && !this.block.isDown()) {
                this.block.goDown();
                Jetris.getGamePanel().repaint();
                long l = System.currentTimeMillis();
                long l2 = l + (long)this.currentSpeed;
                while (l2 > (l = System.currentTimeMillis())) {
                    try {
                        Thread.sleep(l2 - l);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (this.game == null) continue;
            byte by = Jetris.getGamePanel().deleteCompletedRows(this.block.getBottom(), this.block.getTop());
            byte by2 = 0;
            while (by2 < by) {
                this.score += 10;
                this.initialSpeed = Math.max(5, this.initialSpeed - this.initialSpeed / 50);
                by2 = (byte)(by2 + 1);
            }
            Jetris.getScoreBoard().setScore(++this.score);
        }
        Jetris.getMessageBar().setMessage("Game over");
        Jetris.setGame(null);
        byte by = Jetris.getScoreKeeper().isHighScore(this.score);
        if (by != -1) {
            String string = "You've made it to rank " + (by + 1) + " in the HighScore list! Enter your name ";
            String string2 = JOptionPane.showInputDialog(Jetris.getGameFrame(), string, "Congratulations!", -1);
            Jetris.getScoreKeeper().addHighScore(new JetrisHighScore(this.score, string2, new Date()), by);
        }
    }

    private JetrisBlock createBlock(byte by) {
        switch (by) {
            case 0: {
                return new Block0();
            }
            case 1: {
                return new Block1();
            }
            case 2: {
                return new Block2();
            }
            case 3: {
                return new Block3();
            }
            case 4: {
                return new Block4();
            }
            case 5: {
                return new Block5();
            }
        }
        return new Block6();
    }

    protected void dropBlock() {
        this.currentSpeed = 5;
    }
}

