/*
 * Decompiled with CFR 0.152.
 */
package life.v41d;

import life.v41d.LifeCell;
import life.v41d.LifeCoordinate;

class LifeHash {
    private LifeCell[][] hashTable = new LifeCell[1 << HASHSIZE][1 << HASHSIZE];
    private short keyX;
    private short keyY;
    private static int HASHSIZE = 6;

    LifeHash() {
    }

    private void makeKeys(short s, short s2) {
        this.keyX = (short)(s & (1 << HASHSIZE) - 1);
        this.keyY = (short)(s2 & (1 << HASHSIZE) - 1);
    }

    public void store(LifeCell lifeCell) {
        this.makeKeys(lifeCell.x, lifeCell.y);
        lifeCell.Down = this.hashTable[this.keyX][this.keyY];
        this.hashTable[this.keyX][this.keyY] = lifeCell;
    }

    public LifeCell retrieve(int n, int n2) {
        short s = (short)(n >> 4);
        short s2 = (short)(n2 >> 4);
        this.makeKeys(s, s2);
        LifeCell lifeCell = this.hashTable[this.keyX][this.keyY];
        while (lifeCell != null && (lifeCell.x != s || lifeCell.y != s2)) {
            lifeCell = lifeCell.Down;
        }
        return lifeCell;
    }

    public LifeCell retrieve(LifeCoordinate lifeCoordinate) {
        return this.retrieve(lifeCoordinate.x, lifeCoordinate.y);
    }

    public void delete(LifeCell lifeCell) {
        LifeCell lifeCell2 = null;
        this.makeKeys(lifeCell.x, lifeCell.y);
        LifeCell lifeCell3 = this.hashTable[this.keyX][this.keyY];
        while (lifeCell3 != null && (lifeCell3.x != lifeCell.x || lifeCell3.y != lifeCell.y)) {
            lifeCell2 = lifeCell3;
            lifeCell3 = lifeCell3.Down;
        }
        if (lifeCell3 != null) {
            if (lifeCell2 != null) {
                lifeCell2.Down = lifeCell3.Down;
            } else {
                this.hashTable[this.keyX][this.keyY] = lifeCell3.Down;
            }
            lifeCell3.Down = null;
        }
    }
}

