/*
 * Decompiled with CFR 0.152.
 */
package net.n3.nanoxml;

import java.io.Reader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Stack;
import net.n3.nanoxml.ContentReader;
import net.n3.nanoxml.IXMLEntityResolver;
import net.n3.nanoxml.IXMLReader;
import net.n3.nanoxml.IXMLValidator;
import net.n3.nanoxml.XMLEntityResolver;
import net.n3.nanoxml.XMLUtil;

public class NonValidator
implements IXMLValidator {
    private static final char[] END_OF_CONDSECTION = new char[]{'>', ']', ']'};
    protected IXMLEntityResolver parameterEntityResolver;
    protected int peLevel = 0;
    protected Hashtable<String, Properties> attributeDefaultValues = new Hashtable();
    protected Stack<Properties> currentElements = new Stack();

    public NonValidator() {
        this.parameterEntityResolver = new XMLEntityResolver();
    }

    protected void finalize() throws Throwable {
        this.parameterEntityResolver = null;
        this.attributeDefaultValues.clear();
        this.attributeDefaultValues = null;
        this.currentElements.clear();
        this.currentElements = null;
        super.finalize();
    }

    public void setParameterEntityResolver(IXMLEntityResolver resolver) {
        this.parameterEntityResolver = resolver;
    }

    public IXMLEntityResolver getParameterEntityResolver() {
        return this.parameterEntityResolver;
    }

    public void parseDTD(String publicID, IXMLReader reader, IXMLEntityResolver entityResolver, boolean external) throws Exception {
        XMLUtil.skipWhitespace(reader, '%', null, null);
        while (true) {
            char ch;
            if ((ch = XMLUtil.read(reader, null, '%', this.parameterEntityResolver)) == '<') {
                this.processElement(reader, entityResolver);
            } else {
                if (ch == ']') {
                    return;
                }
                XMLUtil.errorInvalidInput(reader.getSystemID(), reader.getLineNr(), "" + ch);
            }
            do {
                if (!external || this.peLevel != 0 || !reader.atEOFOfCurrentStream()) continue;
                return;
            } while ((ch = reader.read()) == ' ' || ch == '\t' || ch == '\n' || ch == '\r');
            reader.unread(ch);
            XMLUtil.skipWhitespace(reader, '%', null, null);
        }
    }

    protected void processElement(IXMLReader reader, IXMLEntityResolver entityResolver) throws Exception {
        char ch = XMLUtil.read(reader, null, '%', this.parameterEntityResolver);
        if (ch != '!') {
            XMLUtil.skipTag(reader, '%', this.parameterEntityResolver);
            return;
        }
        ch = XMLUtil.read(reader, null, '%', this.parameterEntityResolver);
        switch (ch) {
            case '-': {
                XMLUtil.skipComment(reader, this.parameterEntityResolver);
                break;
            }
            case '[': {
                this.processConditionalSection(reader, entityResolver);
                break;
            }
            case 'E': {
                this.processEntity(reader, entityResolver);
                break;
            }
            case 'A': {
                this.processAttList(reader, entityResolver);
                break;
            }
            default: {
                XMLUtil.skipTag(reader, '%', this.parameterEntityResolver);
            }
        }
    }

    protected void processConditionalSection(IXMLReader reader, IXMLEntityResolver entityResolver) throws Exception {
        int ch2;
        XMLUtil.skipWhitespace(reader, '%', null, null);
        char ch = XMLUtil.read(reader, null, '%', this.parameterEntityResolver);
        if (ch != 'I') {
            XMLUtil.skipTag(reader, '%', this.parameterEntityResolver);
            return;
        }
        ch = XMLUtil.read(reader, null, '%', this.parameterEntityResolver);
        switch (ch) {
            case 'G': {
                this.processIgnoreSection(reader, entityResolver);
                return;
            }
            case 'N': {
                break;
            }
            default: {
                XMLUtil.skipTag(reader, '%', this.parameterEntityResolver);
                return;
            }
        }
        if (!XMLUtil.checkLiteral(reader, '%', this.parameterEntityResolver, "CLUDE")) {
            XMLUtil.skipTag(reader, '%', this.parameterEntityResolver);
            return;
        }
        XMLUtil.skipWhitespace(reader, '%', null, null);
        ch = XMLUtil.read(reader, null, '%', this.parameterEntityResolver);
        if (ch != '[') {
            XMLUtil.skipTag(reader, '%', this.parameterEntityResolver);
            return;
        }
        ContentReader subreader = new ContentReader(reader, this.parameterEntityResolver, '\u0000', END_OF_CONDSECTION, true, "");
        StringBuffer buf = new StringBuffer(1024);
        while ((ch2 = subreader.read()) >= 0) {
            buf.append((char)ch2);
        }
        ((Reader)subreader).close();
        reader.startNewStream(new StringReader(buf.toString()));
    }

    protected void processIgnoreSection(IXMLReader reader, IXMLEntityResolver entityResolver) throws Exception {
        if (!XMLUtil.checkLiteral(reader, '%', this.parameterEntityResolver, "NORE")) {
            XMLUtil.skipTag(reader, '%', this.parameterEntityResolver);
            return;
        }
        XMLUtil.skipWhitespace(reader, '%', null, null);
        char ch = XMLUtil.read(reader, null, '%', this.parameterEntityResolver);
        if (ch != '[') {
            XMLUtil.skipTag(reader, '%', this.parameterEntityResolver);
            return;
        }
        ContentReader subreader = new ContentReader(reader, this.parameterEntityResolver, '\u0000', END_OF_CONDSECTION, true, "");
        ((Reader)subreader).close();
    }

    protected void processAttList(IXMLReader reader, IXMLEntityResolver entityResolver) throws Exception {
        if (!XMLUtil.checkLiteral(reader, '%', this.parameterEntityResolver, "TTLIST")) {
            XMLUtil.skipTag(reader, '%', this.parameterEntityResolver);
            return;
        }
        XMLUtil.skipWhitespace(reader, '%', null, null);
        String elementName = XMLUtil.scanIdentifier(reader, '%', this.parameterEntityResolver);
        XMLUtil.skipWhitespace(reader, '%', null, null);
        char ch = XMLUtil.read(reader, null, '%', this.parameterEntityResolver);
        Properties props = new Properties();
        while (ch != '>') {
            reader.unread(ch);
            String attName = XMLUtil.scanIdentifier(reader, '%', this.parameterEntityResolver);
            XMLUtil.skipWhitespace(reader, '%', null, null);
            ch = XMLUtil.read(reader, null, '%', this.parameterEntityResolver);
            if (ch == '(') {
                while (ch != ')') {
                    ch = XMLUtil.read(reader, null, '%', this.parameterEntityResolver);
                }
            } else {
                reader.unread(ch);
                XMLUtil.scanIdentifier(reader, '%', this.parameterEntityResolver);
            }
            XMLUtil.skipWhitespace(reader, '%', null, null);
            ch = XMLUtil.read(reader, null, '%', this.parameterEntityResolver);
            if (ch == '#') {
                String str = XMLUtil.scanIdentifier(reader, '%', this.parameterEntityResolver);
                XMLUtil.skipWhitespace(reader, '%', null, null);
                if (!"FIXED".equals(str)) {
                    XMLUtil.skipWhitespace(reader, '%', null, null);
                    ch = XMLUtil.read(reader, null, '%', this.parameterEntityResolver);
                    continue;
                }
            } else {
                reader.unread(ch);
            }
            String value = XMLUtil.scanString(reader, '%', false, this.parameterEntityResolver);
            props.put(attName, value);
            XMLUtil.skipWhitespace(reader, '%', null, null);
            ch = XMLUtil.read(reader, null, '%', this.parameterEntityResolver);
        }
        if (!props.isEmpty()) {
            this.attributeDefaultValues.put(elementName, props);
        }
    }

    protected void processEntity(IXMLReader reader, IXMLEntityResolver entityResolver) throws Exception {
        if (!XMLUtil.checkLiteral(reader, '%', this.parameterEntityResolver, "NTITY")) {
            XMLUtil.skipTag(reader, '%', this.parameterEntityResolver);
            return;
        }
        XMLUtil.skipWhitespace(reader, '\u0000', null, null);
        char ch = XMLUtil.read(reader, null, '\u0000', this.parameterEntityResolver);
        if (ch == '%') {
            XMLUtil.skipWhitespace(reader, '%', null, null);
            entityResolver = this.parameterEntityResolver;
        } else {
            reader.unread(ch);
        }
        String key = XMLUtil.scanIdentifier(reader, '%', this.parameterEntityResolver);
        XMLUtil.skipWhitespace(reader, '%', null, null);
        ch = XMLUtil.read(reader, null, '%', this.parameterEntityResolver);
        String systemID = null;
        String publicID = null;
        switch (ch) {
            case 'P': {
                if (!XMLUtil.checkLiteral(reader, '%', this.parameterEntityResolver, "UBLIC")) {
                    XMLUtil.skipTag(reader, '%', this.parameterEntityResolver);
                    return;
                }
                XMLUtil.skipWhitespace(reader, '%', null, null);
                publicID = XMLUtil.scanString(reader, '%', false, this.parameterEntityResolver);
                XMLUtil.skipWhitespace(reader, '%', null, null);
                systemID = XMLUtil.scanString(reader, '%', false, this.parameterEntityResolver);
                XMLUtil.skipWhitespace(reader, '%', null, null);
                XMLUtil.read(reader, null, '%', this.parameterEntityResolver);
                break;
            }
            case 'S': {
                if (!XMLUtil.checkLiteral(reader, '%', this.parameterEntityResolver, "YSTEM")) {
                    XMLUtil.skipTag(reader, '%', this.parameterEntityResolver);
                    return;
                }
                XMLUtil.skipWhitespace(reader, '%', null, null);
                systemID = XMLUtil.scanString(reader, '%', false, this.parameterEntityResolver);
                XMLUtil.skipWhitespace(reader, '%', null, null);
                XMLUtil.read(reader, null, '%', this.parameterEntityResolver);
                break;
            }
            case '\"': 
            case '\'': {
                reader.unread(ch);
                String value = XMLUtil.scanString(reader, '%', false, this.parameterEntityResolver);
                entityResolver.addInternalEntity(key, value);
                XMLUtil.skipWhitespace(reader, '%', null, null);
                XMLUtil.read(reader, null, '%', this.parameterEntityResolver);
                break;
            }
            default: {
                XMLUtil.skipTag(reader, '%', this.parameterEntityResolver);
            }
        }
        if (systemID != null) {
            entityResolver.addExternalEntity(key, publicID, systemID);
        }
    }

    public void elementStarted(String name, String nsPrefix, String nsSystemId, String systemId, int lineNr) {
        Properties attribs = this.attributeDefaultValues.get(name);
        attribs = attribs == null ? new Properties() : (Properties)attribs.clone();
        this.currentElements.push(attribs);
    }

    public void elementEnded(String name, String nsPrefix, String nsSystemId, String systemId, int lineNr) {
    }

    public void elementAttributesProcessed(String name, String nsPrefix, String nsSystemId, Properties extraAttributes, String systemId, int lineNr) {
        Properties props = this.currentElements.pop();
        Enumeration<Object> enumeration = props.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            extraAttributes.put(key, props.get(key));
        }
    }

    public void attributeAdded(String key, String nsPrefix, String nsSystemId, String value, String systemId, int lineNr) {
        Properties props = this.currentElements.peek();
        if (props.containsKey(key)) {
            props.remove(key);
        }
    }

    public void PCDataAdded(String systemId, int lineNr) {
    }
}

