/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;

final class Tile
extends JPanel
implements MouseListener {
    private final Color PURPLE = new Color(154, 154, 206);
    private int row;
    private int col;
    private int count;
    private int state;
    private boolean mine;
    private Color color;
    private FontMetrics fm;
    private final Image FLAG = this.getToolkit().getImage(this.getClass().getClassLoader().getResource("images/flag.gif"));
    private final Image MINE = this.getToolkit().getImage(this.getClass().getClassLoader().getResource("images/mine.gif"));
    private final Image NOMINE = this.getToolkit().getImage(this.getClass().getClassLoader().getResource("images/nomine.gif"));

    Tile(int n, int n2) {
        this.row = n;
        this.col = n2;
        this.setPreferredSize(new Dimension(19, 19));
        this.setFont(this.getFont().deriveFont(1));
        this.fm = this.getFontMetrics(this.getFont());
        this.addMouseListener(this);
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(this.MINE, 0);
        mediaTracker.addImage(this.NOMINE, 1);
        mediaTracker.addImage(this.FLAG, 2);
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.init();
    }

    void setState(int n) {
        this.state = n;
    }

    int getState() {
        return this.state;
    }

    void setMine(boolean bl) {
        this.mine = bl;
    }

    boolean isMine() {
        return this.mine;
    }

    void setCount(int n) {
        this.count = n;
    }

    int getCount() {
        return this.count;
    }

    void setColor(int n) {
        switch (n) {
            case 1: {
                this.color = Color.blue;
                break;
            }
            case 2: {
                this.color = Color.green.darker();
                break;
            }
            case 3: {
                this.color = Color.red;
                break;
            }
            case 4: {
                this.color = Color.cyan.darker();
                break;
            }
            case 5: {
                this.color = Color.magenta;
                break;
            }
            case 6: {
                this.color = Color.blue;
                break;
            }
            case 7: {
                this.color = Color.blue;
                break;
            }
            case 8: {
                this.color = Color.blue;
                break;
            }
        }
    }

    void init() {
        this.count = 0;
        this.mine = false;
        this.state = 10;
    }

    void press() {
        if (this.state == 10) {
            this.state = 11;
            this.repaint();
        } else if (this.state == 20) {
            this.state = 21;
            this.repaint();
        } else if (this.state == 13) {
            this.state = 14;
            this.repaint();
        } else if (this.state == 23) {
            this.state = 24;
            this.repaint();
        }
    }

    void release() {
        if (this.state == 11) {
            this.state = 10;
            this.repaint();
        } else if (this.state == 14) {
            this.state = 13;
            this.repaint();
        }
    }

    void click() {
        if (this.state != 50 && this.state != 12 && this.state != 22) {
            if (!this.mine) {
                this.state = 50;
                this.repaint();
                if (!JMines.isGameOver()) {
                    JMines.getScoreBoard().startClock();
                }
                if (this.count == 0) {
                    JMines.getGamePanel().clickSurroundingTiles(this.row, this.col);
                }
            } else {
                this.state = 52;
                this.repaint();
                if (!JMines.isGameOver()) {
                    if (JMines.isSoundOn()) {
                        JMines.getSoundPlayer().play("sounds/bomb.wav");
                    }
                    JMines.gameOver(false, "Sorry, Game over...");
                }
            }
        }
    }

    void toggleFlag() {
        if (JMines.isSoundOn()) {
            JMines.getSoundPlayer().play("sounds/flag.wav");
        }
        if (this.state == 20) {
            this.state = 22;
            this.repaint();
            JMines.getScoreBoard().setScore(JMines.getGamePanel().getMines() - JMines.getGamePanel().countFlaggedTiles());
        } else if (this.state == 22) {
            this.state = JMines.isMarksOn() ? 23 : 20;
            this.repaint();
            JMines.getScoreBoard().setScore(JMines.getGamePanel().getMines() - JMines.getGamePanel().countFlaggedTiles());
        } else if (this.state == 23) {
            this.state = 20;
            this.repaint();
        }
    }

    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = this.getWidth();
        int n2 = this.getHeight();
        switch (this.state) {
            case 10: {
                graphics2D.setColor(Color.lightGray);
                graphics2D.fill3DRect(0, 0, n, n2, true);
                break;
            }
            case 20: {
                graphics2D.setColor(this.PURPLE);
                graphics2D.fill3DRect(0, 0, n, n2, true);
                break;
            }
            case 11: 
            case 21: {
                graphics2D.setColor(Color.lightGray);
                graphics2D.fill3DRect(0, 0, n, n2, false);
                break;
            }
            case 12: {
                graphics2D.setColor(Color.lightGray);
                graphics2D.fill3DRect(0, 0, n, n2, true);
                graphics2D.drawImage(this.FLAG, (n - this.FLAG.getWidth(this)) / 2, (n2 - this.FLAG.getHeight(this)) / 2, this);
                break;
            }
            case 13: {
                graphics2D.setColor(Color.lightGray);
                graphics2D.fill3DRect(0, 0, n, n2, true);
                graphics2D.setColor(Color.black);
                int n3 = (n - this.fm.stringWidth("?")) / 2;
                int n4 = n2 / 2 + this.fm.getAscent() / 2 - 1;
                graphics2D.drawString("?", n3, n4);
                break;
            }
            case 14: {
                graphics2D.setColor(Color.lightGray);
                graphics2D.fill3DRect(0, 0, n, n2, false);
                graphics2D.setColor(Color.black);
                int n5 = (n - this.fm.stringWidth("?")) / 2;
                int n6 = n2 / 2 + this.fm.getAscent() / 2 - 1;
                graphics2D.drawString("?", n5, n6);
                break;
            }
            case 50: {
                graphics2D.setColor(Color.lightGray);
                graphics2D.fillRect(0, 0, n, n2);
                if (this.count <= 0) break;
                graphics2D.setColor(this.color);
                int n7 = (n - this.fm.stringWidth(String.valueOf(this.count))) / 2;
                int n8 = n2 / 2 + this.fm.getAscent() / 2 - 1;
                graphics2D.drawString(String.valueOf(this.count), n7, n8);
                break;
            }
            case 52: {
                graphics2D.setColor(Color.red);
                graphics2D.fillRect(0, 0, n, n2);
                graphics2D.drawImage(this.MINE, (n - this.MINE.getWidth(this)) / 2, (n2 - this.MINE.getHeight(this)) / 2, this);
                break;
            }
            case 51: {
                graphics2D.setColor(Color.lightGray);
                graphics2D.fillRect(0, 0, n, n2);
                graphics2D.drawImage(this.MINE, (n - this.MINE.getWidth(this)) / 2, (n2 - this.MINE.getHeight(this)) / 2, this);
                break;
            }
            case 53: {
                graphics2D.setColor(Color.lightGray);
                graphics2D.fillRect(0, 0, n, n2);
                graphics2D.drawImage(this.NOMINE, (n - this.NOMINE.getWidth(this)) / 2, (n2 - this.NOMINE.getHeight(this)) / 2, this);
                break;
            }
            case 22: {
                graphics2D.setColor(this.PURPLE);
                graphics2D.fill3DRect(0, 0, n, n2, true);
                graphics2D.drawImage(this.FLAG, (n - this.FLAG.getWidth(this)) / 2, (n2 - this.FLAG.getHeight(this)) / 2, this);
                break;
            }
            case 23: {
                graphics2D.setColor(this.PURPLE);
                graphics2D.fill3DRect(0, 0, n, n2, true);
                graphics2D.setColor(Color.black);
                int n9 = (n - this.fm.stringWidth("?")) / 2;
                int n10 = n2 / 2 + this.fm.getAscent() / 2 - 1;
                graphics2D.drawString("?", n9, n10);
                break;
            }
            case 24: {
                graphics2D.setColor(Color.lightGray);
                graphics2D.fill3DRect(0, 0, n, n2, false);
                graphics2D.setColor(Color.black);
                int n11 = (n - this.fm.stringWidth("?")) / 2;
                int n12 = n2 / 2 + this.fm.getAscent() / 2 - 1;
                graphics2D.drawString("?", n11, n12);
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!JMines.isGameOver()) {
            JMines.getScoreBoard().getButton().setImage(1);
            int n = 1024;
            int n2 = 4096;
            int n3 = 5120;
            if (mouseEvent.getModifiersEx() == n) {
                this.press();
            } else if (mouseEvent.getModifiersEx() == n2) {
                this.toggleFlag();
            } else if (mouseEvent.getModifiersEx() == n3) {
                JMines.getGamePanel().pressSurroundingTiles(this.row, this.col);
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!JMines.isGameOver()) {
            JMines.getScoreBoard().getButton().setImage(0);
            if (JMines.getGamePanel().getActiveTile() == this) {
                if (mouseEvent.getButton() == 1) {
                    if (mouseEvent.getModifiersEx() == 4096) {
                        JMines.getGamePanel().clickSurroundingTiles(this.row, this.col);
                        this.click();
                    } else {
                        this.click();
                    }
                } else if (mouseEvent.getModifiersEx() == 1024) {
                    JMines.getGamePanel().releaseSurroundingTiles(this.row, this.col);
                }
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (!JMines.isGameOver()) {
            JMines.getGamePanel().setActiveTile(this);
            if (this.state == 10) {
                this.state = 20;
                this.repaint();
            } else if (this.state == 12) {
                this.state = 22;
                this.repaint();
            } else if (this.state == 13) {
                this.state = 23;
                this.repaint();
            }
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (!JMines.isGameOver()) {
            int n = 5120;
            if (mouseEvent.getModifiersEx() == n) {
                JMines.getGamePanel().releaseSurroundingTiles(this.row, this.col);
            }
            if (this.state == 20 || this.state == 21) {
                this.state = 10;
                this.repaint();
            } else if (this.state == 23 || this.state == 24) {
                this.state = 13;
                this.repaint();
            } else if (this.state == 22) {
                this.state = 12;
                this.repaint();
            }
        }
    }
}

