/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import javax.swing.JOptionPane;

public class JMines {
    static final String APPLICATION_NAME = "JMines";
    static final String APPLICATION_DESCR = "A MineSweeper clone for Java";
    static final String APPLICATION_VERSION = "1.1";
    static final String APPLICATION_YEAR = "2004";
    static final String APPLICATION_AUTHOR = "Luc Van Bogaert";
    static final String APPLICATION_URL = "htp://www.os2world.com/os2ecs/java_index.html";
    static final String APPLICATION_ICON = "images/jmines.gif";
    static final String APPLICATION_README = "jmines.doc";
    static final String AUTHOR_ICON = "images/author.gif";
    static final int BEGINNER_ROWS = 9;
    static final int BEGINNER_COLS = 9;
    static final int BEGINNER_MINES = 10;
    static final int INTERMEDIATE_ROWS = 16;
    static final int INTERMEDIATE_COLS = 16;
    static final int INTERMEDIATE_MINES = 40;
    static final int EXPERT_ROWS = 16;
    static final int EXPERT_COLS = 30;
    static final int EXPERT_MINES = 99;
    static final int MAX_TIME = 999;
    static final int IDLE = 10;
    static final int PRESSED = 11;
    static final int FLAGGED = 12;
    static final int QUESTIONED = 13;
    static final int QUESTIONED_PRESSED = 14;
    static final int MOUSEOVER = 20;
    static final int MOUSEOVER_PRESSED = 21;
    static final int MOUSEOVER_FLAGGED = 22;
    static final int MOUSEOVER_QUESTIONED = 23;
    static final int MOUSEOVER_QUESTIONED_PRESSED = 24;
    static final int REMOVED = 50;
    static final int REVEALED = 51;
    static final int EXPLODED = 52;
    static final int FLAG_ERROR = 53;
    private static String cfgDirName = ".jmines";
    private static String cfgFileName = "jmines.cfg";
    private static String tmpFileName = "jmines.tmp";
    private static String dmpFileName = "jmines.dmp";
    private static String scoreFileName = "scores.dat";
    private static File cfgDir;
    private static File cfgFile;
    private static File tmpFile;
    private static File dmpFile;
    private static File scoreFile;
    private static MainFrame mainFrame;
    private static ScoreBoard scoreBoard;
    private static GamePanel gamePanel;
    private static Config config;
    private static About about;
    private static BestScores scores;
    private static CustomLevelDialog levelDialog;
    private static StatusBar statusBar;
    private static SoundPlayer soundPlayer;
    private static boolean marksOn;
    private static boolean soundOn;
    private static boolean gameOver;

    public static void main(String[] stringArray) {
        if (!JMines.existConfigFile()) {
            System.err.println("Unable to create configuration file.");
        }
        config = new Config(cfgFile, tmpFile, dmpFile);
        soundOn = config.read("game.sounds", false);
        marksOn = config.read("game.usemarks", true);
        about = new About();
        scores = new BestScores();
        mainFrame = new MainFrame();
        MainMenuBar mainMenuBar = new MainMenuBar();
        mainFrame.setJMenuBar(mainMenuBar);
        scoreBoard = new ScoreBoard();
        mainFrame.getContentPane().add((Component)scoreBoard, "North");
        gamePanel = new GamePanel(config.read("game.level", 0));
        mainFrame.getContentPane().add((Component)gamePanel, "Center");
        statusBar = new StatusBar();
        mainFrame.getContentPane().add((Component)statusBar, "South");
        soundPlayer = new SoundPlayer();
        JMines.startNewGame();
        mainFrame.readBounds();
        mainFrame.setVisible(true);
    }

    static MainFrame getMainFrame() {
        return mainFrame;
    }

    static ScoreBoard getScoreBoard() {
        return scoreBoard;
    }

    static GamePanel getGamePanel() {
        return gamePanel;
    }

    static Config getConfig() {
        return config;
    }

    static About getAbout() {
        return about;
    }

    static BestScores getBestScores() {
        return scores;
    }

    static StatusBar getStatusBar() {
        return statusBar;
    }

    static SoundPlayer getSoundPlayer() {
        return soundPlayer;
    }

    static File getScoreFile() {
        return scoreFile;
    }

    static boolean isSoundOn() {
        return soundOn;
    }

    static void setSoundOn(boolean bl) {
        soundOn = bl;
        config.write("game.sounds", bl);
    }

    static boolean isMarksOn() {
        return marksOn;
    }

    static void setMarksOn(boolean bl) {
        marksOn = bl;
        config.write("game.usemarks", bl);
    }

    static boolean isGameOver() {
        return gameOver;
    }

    static void setCustomLevelDialog(CustomLevelDialog customLevelDialog) {
        levelDialog = customLevelDialog;
    }

    static CustomLevelDialog getCustomLevelDialog() {
        return levelDialog;
    }

    static boolean existConfigFile() {
        boolean bl = false;
        String string = System.getProperty("user.home") + System.getProperty("file.separator") + cfgDirName + System.getProperty("file.separator");
        cfgDir = new File(string);
        cfgFile = new File(string + cfgFileName);
        tmpFile = new File(string + tmpFileName);
        dmpFile = new File(string + dmpFileName);
        scoreFile = new File(string + scoreFileName);
        try {
            if ((cfgDir.exists() || cfgDir.mkdir()) && cfgDir.canWrite()) {
                if (cfgFile.createNewFile()) {
                    String string2 = "# This is a generated file, do not edit.";
                    BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(cfgFile));
                    bufferedWriter.write(string2, 0, string2.length());
                    bufferedWriter.newLine();
                    bufferedWriter.close();
                    System.out.println("Sucesfully created configuration file.");
                }
                bl = true;
            }
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
            return false;
        }
        return bl;
    }

    static void setLevel(int n) {
        mainFrame.getContentPane().remove(gamePanel);
        gamePanel = new GamePanel(n);
        mainFrame.getContentPane().add((Component)gamePanel, "Center");
        mainFrame.validate();
        mainFrame.pack();
        config.write("game.level", n);
    }

    static void startNewGame() {
        gamePanel.initTiles();
        gamePanel.createMines();
        gamePanel.countSurroundingMines();
        gamePanel.startWatcher();
        scoreBoard.initScore();
        scoreBoard.initClock();
        scoreBoard.initButton();
        gameOver = false;
    }

    static void gameOver(boolean bl, String string) {
        scoreBoard.stopClock();
        statusBar.setText(string);
        gamePanel.stopWatcher();
        gameOver = true;
        if (bl) {
            if (soundOn) {
                soundPlayer.play("sounds/win.wav");
            }
            scoreBoard.getButton().setImage(2);
            int n = config.read("game.level", 0);
            int n2 = scoreBoard.getTime();
            if (scores.isBestScore(n, n2)) {
                scores.newScore(n, n2, (String)JOptionPane.showInputDialog(null, "Enter your name:", "This is a Best Score!", 3, null, null, System.getProperty("user.name")));
                scores.setVisible(true);
            }
        } else {
            scoreBoard.getButton().setImage(3);
            gamePanel.revealMines();
            gamePanel.showFlagErrors();
        }
    }

    static void exit() {
        mainFrame.writeLocation();
        mainFrame.writeSize();
        System.exit(0);
    }

    static void setConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
        gridBagConstraints.insets = new Insets(n7, n8, n9, n10);
    }
}

