/*
 * Decompiled with CFR 0.152.
 */
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

final class BestScores
extends JDialog {
    private int x;
    private int y;
    private Score[] score = new Score[3];
    private ScorePanel[] panel = new ScorePanel[3];

    BestScores() {
        this.setTitle("Fastest Mine Sweepers");
        this.setResizable(false);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(gridBagLayout);
        this.setContentPane(jPanel);
        int n = 0;
        while (n < 3) {
            this.panel[n] = new ScorePanel();
            JMines.setConstraints(gridBagConstraints, 0, n, 2, 1, 100, 0, 5, 10, 0, 10);
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 10;
            gridBagLayout.setConstraints(this.panel[n], gridBagConstraints);
            jPanel.add(this.panel[n]);
            ++n;
        }
        if (this.createScoreFile()) {
            this.initScores();
        } else {
            this.readScores();
        }
        this.showScores();
        JButton jButton = new JButton("Clear scores");
        jButton.setToolTipText("Wipe best scores list");
        jButton.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                BestScores.this.initScores();
                BestScores.this.showScores();
                BestScores.this.writeScores();
            }
        });
        JMines.setConstraints(gridBagConstraints, 0, 3, 1, 1, 50, 0, 10, 10, 5, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(jButton, gridBagConstraints);
        jPanel.add(jButton);
        JButton jButton2 = new JButton("Close");
        jButton2.setToolTipText("Close the dialog");
        jButton2.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                BestScores.this.writeLocation();
                BestScores.this.setVisible(false);
            }
        });
        JMines.setConstraints(gridBagConstraints, 1, 3, 1, 1, 50, 0, 10, 0, 5, 10);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(jButton2, gridBagConstraints);
        jPanel.add(jButton2);
        this.addComponentListener(new ComponentAdapter(){

            public void componentMoved(ComponentEvent componentEvent) {
                BestScores.this.x = BestScores.this.getX();
                BestScores.this.y = BestScores.this.getY();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                BestScores.this.writeLocation();
            }
        });
        this.readLocation();
        this.setLocation(this.x, this.y);
        this.pack();
    }

    private boolean createScoreFile() {
        boolean bl = false;
        try {
            if (JMines.getScoreFile().createNewFile()) {
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(JMines.getScoreFile()));
                objectOutputStream.close();
                bl = true;
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException.toString());
            return false;
        }
        return bl;
    }

    private void initScores() {
        int n = 0;
        while (n < 3) {
            this.score[n] = new Score(n, 999, "anonymous");
            ++n;
        }
    }

    private void readScores() {
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(JMines.getScoreFile()));
            int n = 0;
            while (n < 3) {
                try {
                    this.score[n] = (Score)objectInputStream.readObject();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    System.err.println(classNotFoundException.toString());
                }
                ++n;
            }
            objectInputStream.close();
        }
        catch (IOException iOException) {
            System.err.println(iOException.toString());
        }
    }

    private void writeScores() {
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(JMines.getScoreFile()));
            int n = 0;
            while (n < 3) {
                objectOutputStream.writeObject(this.score[n]);
                ++n;
            }
            objectOutputStream.close();
        }
        catch (IOException iOException) {
            System.err.println(iOException.toString());
        }
    }

    private void showScores() {
        int n = 0;
        while (n < 3) {
            this.panel[n].display(this.score[n]);
            ++n;
        }
    }

    void newScore(int n, int n2, String string) {
        this.score[n].setLevel(n);
        this.score[n].setSeconds(n2);
        this.score[n].setName(string);
        this.panel[n].display(this.score[n]);
        this.writeScores();
    }

    boolean isBestScore(int n, int n2) {
        if (n < this.score.length) {
            return n2 < this.score[n].getSeconds();
        }
        return false;
    }

    private void readLocation() {
        this.x = JMines.getConfig().read("score.dialog.xpos", this.x);
        this.y = JMines.getConfig().read("score.dialog.ypos", this.y);
    }

    private void writeLocation() {
        JMines.getConfig().write("score.dialog.xpos", this.x);
        JMines.getConfig().write("score.dialog.ypos", this.y);
    }

    class Score
    implements Serializable {
        private int level;
        private int seconds;
        private String name;

        Score(int n, int n2, String string) {
            this.level = n;
            this.seconds = n2;
            this.name = string;
        }

        int getLevel() {
            return this.level;
        }

        void setLevel(int n) {
            this.level = n;
        }

        int getSeconds() {
            return this.seconds;
        }

        void setSeconds(int n) {
            this.seconds = n;
        }

        String getName() {
            return this.name;
        }

        void setName(String string) {
            this.name = string;
        }
    }

    class ScorePanel
    extends JPanel {
        private JLabel level = new JLabel();
        private JLabel seconds = new JLabel();
        private JLabel name = new JLabel();

        ScorePanel() {
            this.setLayout(new GridLayout(1, 3, 10, 0));
            this.seconds.setHorizontalAlignment(4);
            this.add(this.level);
            this.add(this.seconds);
            this.add(this.name);
        }

        void display(Score score) {
            switch (score.getLevel()) {
                case 0: {
                    this.level.setText("Beginner :");
                    break;
                }
                case 1: {
                    this.level.setText("Intermediate :");
                    break;
                }
                case 2: {
                    this.level.setText("Expert :");
                }
            }
            this.seconds.setText(score.getSeconds() + " seconds");
            this.name.setText("by " + score.getName());
        }
    }
}

