/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;

public class Terrain
implements Serializable {
    public static final int LEVEL_NONE = Integer.MIN_VALUE;
    public static final int WILDCARD = Integer.MAX_VALUE;
    public static final int WOODS = 1;
    public static final int ROUGH = 2;
    public static final int RUBBLE = 3;
    public static final int WATER = 4;
    public static final int PAVEMENT = 5;
    public static final int ROAD = 6;
    public static final int FIRE = 7;
    public static final int SMOKE = 8;
    public static final int SWAMP = 9;
    public static final int BUILDING = 10;
    public static final int BLDG_CF = 11;
    public static final int BLDG_ELEV = 12;
    public static final int BLDG_BASEMENT = 13;
    public static final int BRIDGE = 14;
    public static final int BRIDGE_CF = 15;
    public static final int BRIDGE_ELEV = 16;
    private static final String[] names = new String[]{"none", "woods", "rough", "rubble", "water", "pavement", "road", "fire", "smoke", "swamp", "building", "bldg_cf", "bldg_elev", "bldg_basement", "bridge", "bridge_cf", "bridge_elev"};
    public static final int SIZE = names.length;
    private final int type;
    private int level;
    private boolean exitsSpecified = false;
    private int exits;

    public Terrain(int n, int n2) {
        this(n, n2, false, 0);
    }

    public Terrain(int n, int n2, boolean bl, int n3) {
        this.type = n;
        this.level = n2;
        this.exitsSpecified = bl;
        this.exits = n3;
    }

    public Terrain(Terrain terrain) {
        this.type = terrain.type;
        this.level = terrain.level;
        this.exitsSpecified = terrain.exitsSpecified;
        this.exits = terrain.exits;
    }

    public Terrain(String string) {
        int n = string.indexOf(58);
        int n2 = string.lastIndexOf(58);
        String string2 = string.substring(0, n);
        this.type = Terrain.parse(string2);
        if (n == n2) {
            this.level = Integer.parseInt(string.substring(n + 1));
            this.exitsSpecified = false;
        } else {
            this.level = Integer.parseInt(string.substring(n + 1, n2));
            this.exitsSpecified = true;
            this.exits = Integer.parseInt(string.substring(n2 + 1));
        }
    }

    public int getType() {
        return this.type;
    }

    public int getLevel() {
        return this.level;
    }

    public int getExits() {
        return this.exits;
    }

    public boolean hasExitsSpecified() {
        return this.exitsSpecified;
    }

    public void setExits(int n) {
        this.exits = n;
    }

    public void setExit(int n, boolean bl) {
        int n2 = (int)Math.pow(2.0, n);
        this.exits = bl ? (this.exits |= n2) : (this.exits &= 0x3F ^ n2);
    }

    public static int parse(String string) {
        int n = 0;
        while (n < names.length) {
            if (names[n].equals(string)) {
                return n;
            }
            ++n;
        }
        return 0;
    }

    public static String getName(int n) {
        return names[n];
    }

    public boolean exitsTo(Terrain terrain) {
        if (terrain == null) {
            return false;
        }
        return this.type == terrain.type && this.level == terrain.level;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Terrain terrain = (Terrain)object;
        return this.type == terrain.type && this.level == terrain.level;
    }

    public String toString() {
        return names[this.type] + ":" + this.level + (this.exitsSpecified ? ":" + this.exits : "");
    }
}

