/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Vector;
import megamek.common.BipedMech;
import megamek.common.CriticalSlot;
import megamek.common.Entity;
import megamek.common.EntityLoadingException;
import megamek.common.EquipmentType;
import megamek.common.LocationFullException;
import megamek.common.Mech;
import megamek.common.MechLoader;
import megamek.common.Mounted;
import megamek.common.QuadMech;

public class MtfFile
implements MechLoader {
    String version;
    String name;
    String model;
    String chassisConfig;
    String techBase;
    String techYear;
    String rulesLevel;
    String tonnage;
    String engine;
    String internalType;
    String myomerType;
    String heatSinks;
    String walkMP;
    String jumpMP;
    String armorType;
    String larmArmor;
    String rarmArmor;
    String ltArmor;
    String rtArmor;
    String ctArmor;
    String headArmor;
    String llegArmor;
    String rlegArmor;
    String ltrArmor;
    String rtrArmor;
    String ctrArmor;
    String weaponCount;
    String[] weaponData;
    String[][] critData;
    Hashtable hSharedEquip = new Hashtable();
    Vector vSplitWeapons = new Vector();

    public MtfFile(InputStream inputStream) throws EntityLoadingException {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            this.version = bufferedReader.readLine();
            this.name = bufferedReader.readLine();
            this.model = bufferedReader.readLine();
            bufferedReader.readLine();
            this.chassisConfig = bufferedReader.readLine();
            this.techBase = bufferedReader.readLine();
            this.techYear = bufferedReader.readLine();
            this.rulesLevel = bufferedReader.readLine();
            bufferedReader.readLine();
            this.tonnage = bufferedReader.readLine();
            this.engine = bufferedReader.readLine();
            this.internalType = bufferedReader.readLine();
            this.myomerType = bufferedReader.readLine();
            bufferedReader.readLine();
            this.heatSinks = bufferedReader.readLine();
            this.walkMP = bufferedReader.readLine();
            this.jumpMP = bufferedReader.readLine();
            bufferedReader.readLine();
            this.armorType = bufferedReader.readLine();
            this.larmArmor = bufferedReader.readLine();
            this.rarmArmor = bufferedReader.readLine();
            this.ltArmor = bufferedReader.readLine();
            this.rtArmor = bufferedReader.readLine();
            this.ctArmor = bufferedReader.readLine();
            this.headArmor = bufferedReader.readLine();
            this.llegArmor = bufferedReader.readLine();
            this.rlegArmor = bufferedReader.readLine();
            this.ltrArmor = bufferedReader.readLine();
            this.rtrArmor = bufferedReader.readLine();
            this.ctrArmor = bufferedReader.readLine();
            bufferedReader.readLine();
            this.weaponCount = bufferedReader.readLine();
            int n = 9;
            int n2 = Integer.parseInt(this.weaponCount.substring(8));
            this.weaponData = new String[n2];
            int n3 = 0;
            while (n3 < n2) {
                this.weaponData[n3] = bufferedReader.readLine();
                ++n3;
            }
            this.critData = new String[8][12];
            this.readCrits(bufferedReader, 5);
            this.readCrits(bufferedReader, 4);
            this.readCrits(bufferedReader, 3);
            this.readCrits(bufferedReader, 2);
            this.readCrits(bufferedReader, 1);
            this.readCrits(bufferedReader, 0);
            this.readCrits(bufferedReader, 7);
            this.readCrits(bufferedReader, 6);
            bufferedReader.close();
        }
        catch (IOException iOException) {
            throw new EntityLoadingException("I/O Error reading file");
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new EntityLoadingException("StringIndexOutOfBoundsException reading file (format error)");
        }
        catch (NumberFormatException numberFormatException) {
            throw new EntityLoadingException("NumberFormatException reading file (format error)");
        }
    }

    private void readCrits(BufferedReader bufferedReader, int n) throws IOException {
        bufferedReader.readLine();
        bufferedReader.readLine();
        int n2 = 0;
        while (n2 < 12) {
            this.critData[n][n2] = bufferedReader.readLine();
            ++n2;
        }
    }

    public Entity getEntity() throws EntityLoadingException {
        try {
            Mech mech = this.chassisConfig.indexOf("Quad") != -1 ? new QuadMech() : new BipedMech();
            if (!this.version.trim().equalsIgnoreCase("Version:1.0")) {
                throw new EntityLoadingException("Wrong MTF file version.");
            }
            int n = this.name.indexOf("(");
            if (n == -1) {
                mech.setChassis(this.name.trim());
            } else {
                mech.setChassis(this.name.substring(0, n - 1).trim());
            }
            mech.setModel(this.model.trim());
            mech.setYear(Integer.parseInt(this.techYear.substring(4).trim()));
            if (this.chassisConfig.indexOf("Omni") != -1) {
                mech.setOmni(true);
            }
            boolean bl = "Inner Sphere".equals(this.techBase.substring(9).trim());
            switch (Integer.parseInt(this.rulesLevel.substring(12).trim())) {
                case 1: {
                    mech.setTechLevel(0);
                    break;
                }
                case 2: {
                    mech.setTechLevel(bl ? 1 : 2);
                    break;
                }
                default: {
                    throw new EntityLoadingException("Unsupported tech level");
                }
            }
            mech.weight = Integer.parseInt(this.tonnage.substring(5));
            mech.setOriginalWalkMP(Integer.parseInt(this.walkMP.substring(8)));
            mech.setOriginalJumpMP(Integer.parseInt(this.jumpMP.substring(8)));
            boolean bl2 = this.heatSinks.substring(14).equalsIgnoreCase("Double");
            int n2 = Integer.parseInt(this.heatSinks.substring(11, 14).trim());
            mech.autoSetInternal();
            mech.initializeArmor(Integer.parseInt(this.larmArmor.substring(9)), 5);
            mech.initializeArmor(Integer.parseInt(this.rarmArmor.substring(9)), 4);
            mech.initializeArmor(Integer.parseInt(this.ltArmor.substring(9)), 3);
            mech.initializeArmor(Integer.parseInt(this.rtArmor.substring(9)), 2);
            mech.initializeArmor(Integer.parseInt(this.ctArmor.substring(9)), 1);
            mech.initializeArmor(Integer.parseInt(this.headArmor.substring(9)), 0);
            mech.initializeArmor(Integer.parseInt(this.llegArmor.substring(9)), 7);
            mech.initializeArmor(Integer.parseInt(this.rlegArmor.substring(9)), 6);
            mech.initializeRearArmor(Integer.parseInt(this.ltrArmor.substring(10)), 3);
            mech.initializeRearArmor(Integer.parseInt(this.rtrArmor.substring(10)), 2);
            mech.initializeRearArmor(Integer.parseInt(this.ctrArmor.substring(10)), 1);
            int n3 = mech.locations() - 1;
            while (n3 >= 0) {
                this.parseCrits(mech, n3);
                --n3;
            }
            if (mech.isClan()) {
                mech.addClanCase();
            }
            mech.addEngineSinks(n2 - mech.heatSinks(), bl2);
            return mech;
        }
        catch (NumberFormatException numberFormatException) {
            throw new EntityLoadingException("NumberFormatException parsing file");
        }
        catch (NullPointerException nullPointerException) {
            throw new EntityLoadingException("NullPointerException parsing file");
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new EntityLoadingException("StringIndexOutOfBoundsException parsing file");
        }
    }

    private void parseCrits(Mech mech, int n) throws EntityLoadingException {
        if (!(mech instanceof QuadMech || n != 5 && n != 4)) {
            if (!this.critData[n][3].equals("Hand Actuator")) {
                mech.setCritical(n, 3, null);
            }
            if (!this.critData[n][2].equals("Lower Arm Actuator")) {
                mech.setCritical(n, 2, null);
            }
        }
        int n2 = 0;
        while (n2 < mech.getNumberOfCriticals(n)) {
            if (mech.getCritical(n, n2) == null) {
                String string = this.critData[n][n2];
                boolean bl = false;
                boolean bl2 = false;
                if (string.equalsIgnoreCase("Fusion Engine")) {
                    mech.setCritical(n, n2, new CriticalSlot(0, 3));
                } else {
                    if (string.endsWith("(R)")) {
                        bl = true;
                        string = string.substring(0, string.length() - 3).trim();
                    }
                    if (string.endsWith("(Split)")) {
                        bl2 = true;
                        string = string.substring(0, string.length() - 7).trim();
                    }
                    try {
                        EquipmentType equipmentType = EquipmentType.getByMtfName(string);
                        if (equipmentType != null) {
                            Mounted mounted;
                            if (equipmentType.isSpreadable()) {
                                mounted = (Mounted)this.hSharedEquip.get(equipmentType);
                                if (mounted != null) {
                                    mech.addCritical(n, new CriticalSlot(1, mech.getEquipmentNum(mounted), equipmentType.isHittable()));
                                } else {
                                    mounted = mech.addEquipment(equipmentType, n, bl);
                                    this.hSharedEquip.put(equipmentType, mounted);
                                }
                            } else if (bl2) {
                                mounted = null;
                                boolean bl3 = false;
                                int n3 = 0;
                                int n4 = this.vSplitWeapons.size();
                                while (n3 < n4) {
                                    mounted = (Mounted)this.vSplitWeapons.elementAt(n3);
                                    int n5 = mounted.getLocation();
                                    if ((n5 == n || n == this.getInnerLocation(n5)) && mounted.getType() == equipmentType) {
                                        bl3 = true;
                                        break;
                                    }
                                    ++n3;
                                }
                                if (bl3) {
                                    mounted.setFoundCrits(mounted.getFoundCrits() + 1);
                                    if (mounted.getFoundCrits() >= equipmentType.getCriticals(mech)) {
                                        this.vSplitWeapons.removeElement(mounted);
                                    }
                                    mounted.setLocation(this.mostRestrictiveLoc(n, mounted.getLocation()));
                                } else {
                                    mounted = new Mounted(mech, equipmentType);
                                    mounted.setSplit(true);
                                    mounted.setFoundCrits(1);
                                    mech.addEquipment(mounted, n, bl);
                                    this.vSplitWeapons.addElement(mounted);
                                }
                                mech.addCritical(n, new CriticalSlot(1, mech.getEquipmentNum(mounted), equipmentType.isHittable()));
                            } else {
                                mech.addEquipment(equipmentType, n, bl);
                            }
                        }
                    }
                    catch (LocationFullException locationFullException) {
                        throw new EntityLoadingException(locationFullException.getMessage());
                    }
                }
            }
            ++n2;
        }
    }

    private int getInnerLocation(int n) {
        switch (n) {
            case 2: 
            case 3: {
                return 1;
            }
            case 5: 
            case 7: {
                return 3;
            }
            case 4: 
            case 6: {
                return 2;
            }
        }
        return n;
    }

    private int mostRestrictiveLoc(int n, int n2) {
        if (n == n2) {
            return n;
        }
        if (this.restrictScore(n) >= this.restrictScore(n2)) {
            return n;
        }
        return n2;
    }

    private int restrictScore(int n) {
        switch (n) {
            case 4: 
            case 5: {
                return 0;
            }
            case 2: 
            case 3: {
                return 1;
            }
            case 1: {
                return 2;
            }
        }
        return 3;
    }
}

