/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import megamek.common.Compute;

public class MapSettings
implements Serializable {
    public static final String BOARD_RANDOM = "[RANDOM]";
    public static final String BOARD_SURPRISE = "[SURPRISE]";
    private int boardWidth = 16;
    private int boardHeight = 17;
    private int mapWidth = 1;
    private int mapHeight = 1;
    private Vector boardsSelected = new Vector();
    private Vector boardsAvailable = new Vector();

    public MapSettings() {
        this(16, 17, 1, 1);
    }

    public MapSettings(int n, int n2, int n3, int n4) {
        this.setBoardSize(n, n2);
        this.setMapSize(n3, n4);
    }

    public MapSettings(MapSettings mapSettings) {
        this.boardWidth = mapSettings.getBoardWidth();
        this.boardHeight = mapSettings.getBoardHeight();
        this.mapWidth = mapSettings.getMapWidth();
        this.mapHeight = mapSettings.getMapHeight();
        this.boardsSelected = (Vector)mapSettings.getBoardsSelectedVector().clone();
        this.boardsAvailable = (Vector)mapSettings.getBoardsAvailableVector().clone();
    }

    public int getBoardWidth() {
        return this.boardWidth;
    }

    public int getBoardHeight() {
        return this.boardHeight;
    }

    public void setBoardSize(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException("Total board area must be positive");
        }
        if (this.boardWidth != n || this.boardHeight != n2) {
            this.boardWidth = n;
            this.boardHeight = n2;
            this.boardsAvailable.removeAllElements();
        }
    }

    public int getMapWidth() {
        return this.mapWidth;
    }

    public int getMapHeight() {
        return this.mapHeight;
    }

    public void setMapSize(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException("Total map area must be positive");
        }
        this.mapWidth = n;
        this.mapHeight = n2;
        this.boardsSelected.setSize(n * n2);
    }

    public Enumeration getBoardsSelected() {
        return this.boardsSelected.elements();
    }

    public Vector getBoardsSelectedVector() {
        return this.boardsSelected;
    }

    public void setBoardsSelectedVector(Vector vector) {
        this.boardsSelected = vector;
    }

    public void setNullBoards(String string) {
        int n = 0;
        while (n < this.boardsSelected.size()) {
            if (this.boardsSelected.elementAt(n) == null) {
                this.boardsSelected.setElementAt(string, n);
            }
            ++n;
        }
    }

    public void replaceBoardWithRandom(String string) {
        int n = 0;
        while (n < this.boardsSelected.size()) {
            if (this.boardsSelected.elementAt(n).equals(string)) {
                int n2 = Compute.random.nextInt(this.boardsAvailable.size() - 2) + 2;
                this.boardsSelected.setElementAt(this.boardsAvailable.elementAt(n2), n);
            }
            ++n;
        }
    }

    public void removeUnavailable() {
        int n = 0;
        while (n < this.boardsSelected.size()) {
            if (this.boardsSelected.elementAt(n) == null || this.boardsAvailable.size() == 0 || this.boardsAvailable.indexOf(this.boardsSelected.elementAt(n)) == -1) {
                this.boardsSelected.setElementAt(null, n);
            }
            ++n;
        }
    }

    public Enumeration getBoardsAvailable() {
        return this.boardsAvailable.elements();
    }

    public Vector getBoardsAvailableVector() {
        return this.boardsAvailable;
    }

    public void setBoardsAvailableVector(Vector vector) {
        this.boardsAvailable = vector;
    }

    public Object clone() {
        return new MapSettings(this);
    }
}

