/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import megamek.common.options.GameOption;
import megamek.common.options.OptionGroup;

public class GameOptions
implements Serializable {
    private Vector groups = new Vector();
    private Vector allOptions = new Vector();
    private Hashtable optionsHash = new Hashtable();

    public void initialize() {
        OptionGroup optionGroup = new OptionGroup("Base Options");
        this.addGroup(optionGroup);
        this.addOption(optionGroup, new GameOption("friendly_fire", "Friendly fire", "If checked, the game considers mechs owned by a player, or on the same team as a player, as valid targets.\n\nDefaults to checked, but unchecks when a second player joins the server.", true));
        this.addOption(optionGroup, new GameOption("skip_ineligable_physical", "Skip ineligable during physical", "If checked, the game will skip a unit during the physical phase if no attacks are possible or there are no valid targets.\n\nChecked by default.", true));
        this.addOption(optionGroup, new GameOption("push_off_board", "Allow pushing off the map", "This options allows a mech to be pushed off the map and out of the game by push, charge or DFA attacks.\n\nChecked by default.", true));
        this.addOption(optionGroup, new GameOption("check_victory", "Check for victory", "If checked, the server will enter the victory phase at the end of any turn where victory conditions are met.  Even if unchecked or conditions are not met, server admins can force victory with the /victory command.\n\nDefaults to checked.", true));
        OptionGroup optionGroup2 = new OptionGroup("Optional Rules (Level 2)");
        this.addGroup(optionGroup2);
        this.addOption(optionGroup2, new GameOption("flamer_heat", "Flamers deal heat instead of damage", "If checked, flamers increase the heat of their target by 2 instead of dealing 2 damage.\n\nUnchecked by default.", false));
        this.addOption(optionGroup2, new GameOption("fire", "Fire and smoke", "If checked, fires may be set accidentally or intentionally.\n\nChecked by default.", true));
        OptionGroup optionGroup3 = new OptionGroup("Optional Rules (Level 3)");
        this.addGroup(optionGroup3);
        this.addOption(optionGroup3, new GameOption("double_blind", "Double blind", "If checked, enemy units will only be visible if they are in line of sight of one or more of your units.", false));
        this.addOption(optionGroup3, new GameOption("floating_crits", "Through-armor criticals will 'float'", "If checked, rolls of '2' on hit location will result in a new location being rolled for a critical hit, instead of just hitting the local torso.\n\nUnchecked by default.", false));
        OptionGroup optionGroup4 = new OptionGroup("Optional Rules (unofficial)");
        this.addGroup(optionGroup4);
        this.addOption(optionGroup4, new GameOption("no_tac", "No through-armor criticals", "If checked, rolls of '2' on hit location will only result in a torso hit, and no critical roll.  Only applies to mechs.  Supercedes the floating criticals option.\n\nUnchecked by default.", false));
        this.addOption(optionGroup4, new GameOption("no_immobile_vehicles", "Vehicles not immobilized by crits", "If checked, vehicles with a drive or engine hit will not be counted as 'immobile' for purposes of determining to-hit numbers.\n\nUnchecked by default.", false));
        this.addOption(optionGroup4, new GameOption("inf_move_last", "Infantry move after Meks and Vehicles", "If checked, all Meks and Vehicles will move before the first Infantry platoon.  The move order of Meks and Vehicles ignores the presence of Infantry.\n\nMutually exclusive with \"3 Infantry for every Mek or Vehicle\".\n\nUnchecked by default.", false));
        this.addOption(optionGroup4, new GameOption("inf_move_multi", "3 Infantry for every Mek or Vehicle", "If checked, 3 platoons will have to move in place of a single Mek or Vehicle.  If there are less than 3 platoons remaining, they all must move.  The move order includes the presence of Infantry.\n\nMutually exclusive with \"Infantry move after Meks and Vehicles\".\n\nUnchecked by default.", false));
    }

    private void addGroup(OptionGroup optionGroup) {
        this.groups.addElement(optionGroup);
    }

    public Enumeration groups() {
        return this.groups.elements();
    }

    private void addOption(OptionGroup optionGroup, GameOption gameOption) {
        optionGroup.addOption(gameOption);
        this.allOptions.addElement(gameOption);
        this.optionsHash.put(gameOption.getShortName(), gameOption);
    }

    public GameOption getOption(String string) {
        return (GameOption)this.optionsHash.get(string);
    }

    public boolean booleanOption(String string) {
        return this.getOption(string).booleanValue();
    }

    public int intOption(String string) {
        return this.getOption(string).intValue();
    }

    public float floatOption(String string) {
        return this.getOption(string).floatValue();
    }
}

