/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;
import megamek.common.IdealHex;

public class Coords
implements Serializable {
    public int x;
    public int y;

    public Coords() {
        this(0, 0);
    }

    public Coords(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public Coords(Coords coords) {
        this(coords.x, coords.y);
    }

    public final Coords translated(int n) {
        return new Coords(Coords.xInDir(this.x, this.y, n), Coords.yInDir(this.x, this.y, n));
    }

    public static final int xInDir(int n, int n2, int n3) {
        switch (n3) {
            case 1: 
            case 2: {
                return n + 1;
            }
            case 4: 
            case 5: {
                return n - 1;
            }
        }
        return n;
    }

    public static final int yInDir(int n, int n2, int n3) {
        switch (n3) {
            case 0: {
                return n2 - 1;
            }
            case 1: 
            case 5: {
                return n2 - (n + 1 & 1);
            }
            case 2: 
            case 4: {
                return n2 + (n & 1);
            }
            case 3: {
                return n2 + 1;
            }
        }
        return n2;
    }

    public boolean isXOdd() {
        return (this.x & 1) == 1;
    }

    public int direction(Coords coords) {
        int n = this.degree(coords);
        if (n > 330 || n < 30) {
            return 0;
        }
        if (n >= 30 && n < 90) {
            return 1;
        }
        if (n >= 90 && n <= 150) {
            return 2;
        }
        if (n > 150 && n < 210) {
            return 3;
        }
        if (n >= 210 && n <= 270) {
            return 4;
        }
        if (n > 270 && n < 330) {
            return 5;
        }
        return 0;
    }

    public int direction1(Coords coords) {
        if (this.x < coords.x) {
            if (this.y < coords.y || this.y == coords.y && !this.isXOdd()) {
                return 2;
            }
            return 1;
        }
        if (this.x == coords.x) {
            if (this.y < coords.y) {
                return 3;
            }
            return 0;
        }
        if (this.y < coords.y || this.y == coords.y && !this.isXOdd()) {
            return 4;
        }
        return 5;
    }

    public double radian(Coords coords) {
        IdealHex idealHex = new IdealHex(this);
        IdealHex idealHex2 = new IdealHex(coords);
        double d = Math.atan((idealHex2.cx - idealHex.cx) / (idealHex.cy - idealHex2.cy));
        if (idealHex.cy < idealHex2.cy) {
            d = (d + Math.PI) % (Math.PI * 2);
        }
        if (d < 0.0) {
            d += Math.PI * 2;
        }
        return d;
    }

    public int degree(Coords coords) {
        return (int)Math.round(57.29577951308232 * this.radian(coords));
    }

    public int distance(Coords coords) {
        int n = Math.abs(this.x - coords.x);
        int n2 = n / 2 + (!this.isXOdd() && coords.isXOdd() ? 1 : 0);
        int n3 = this.y - n2;
        int n4 = n3 + n;
        int n5 = 0;
        if (coords.y < n3) {
            n5 = n3 - coords.y;
        }
        if (coords.y > n4) {
            n5 = coords.y - n4;
        }
        return n + n5;
    }

    public int distance1(Coords coords) {
        int n;
        int n2 = Math.abs(this.x - coords.x);
        int n3 = Math.abs(this.y - coords.y);
        if (n3 < (n = n2 / 2 + (this.isXOdd() == coords.isXOdd() ? 0 : 1))) {
            return n2;
        }
        return n2 + n3 - n;
    }

    public int distance2(Coords coords) {
        int n = 2 * this.y - this.x % 2;
        int n2 = 2 * this.x;
        coords.y = 2 * coords.y - coords.x % 2;
        coords.x *= 2;
        int n3 = Math.abs(n2 - coords.x);
        int n4 = Math.abs(n - coords.y) - n3;
        if (n4 <= 0) {
            return n3;
        }
        return n3 + n4;
    }

    public final String getBoardNum() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append((this.x < 9 ? "0" : "") + (this.x + 1));
        stringBuffer.append((this.y < 9 ? "0" : "") + (this.y + 1));
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Coords coords = (Coords)object;
        return coords.x == this.x && coords.y == this.y;
    }

    public String toString() {
        return "Coords (" + this.x + ", " + this.y + "); " + this.getBoardNum();
    }
}

