/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import megamek.common.BoardEvent;
import megamek.common.BoardListener;
import megamek.common.Coords;
import megamek.common.Hex;
import megamek.common.Player;
import megamek.common.Terrain;

public class Board
implements Serializable {
    public static final int BOARD_HEX_CLICK = 1;
    public static final int BOARD_HEX_DOUBLECLICK = 2;
    public static final int BOARD_HEX_DRAG = 3;
    public int width;
    public int height;
    public transient Coords lastCursor;
    public transient Coords highlighted;
    public transient Coords selected;
    public Hex[] data;
    protected transient Vector boardListeners;

    public Board() {
        this(0, 0);
    }

    public Board(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.data = new Hex[n * n2];
        this.lastCursor = null;
        this.highlighted = null;
        this.selected = null;
        this.boardListeners = new Vector();
    }

    public void newData(int n, int n2, Hex[] hexArray) {
        this.width = n;
        this.height = n2;
        this.data = hexArray;
        this.lastCursor = null;
        this.highlighted = null;
        this.selected = null;
        this.initializeAll();
        this.processBoardEvent(new BoardEvent(this, new Coords(), null, 6, 0));
    }

    public void newData(int n, int n2) {
        this.newData(n, n2, new Hex[n * n2]);
    }

    public void combine(int n, int n2, int n3, int n4, Board[] boardArray) {
        int n5 = n * n3;
        int n6 = n2 * n4;
        this.newData(n5, n6);
        int n7 = 0;
        while (n7 < n4) {
            int n8 = 0;
            while (n8 < n3) {
                this.copyBoardInto(n8 * n, n7 * n2, boardArray[n7 * n3 + n8]);
                ++n8;
            }
            ++n7;
        }
    }

    private void copyBoardInto(int n, int n2, Board board) {
        int n3 = 0;
        while (n3 < board.height) {
            int n4 = 0;
            while (n4 < board.width) {
                this.data[(n3 + n2) * this.width + (n4 + n)] = board.data[n3 * board.width + n4];
                ++n4;
            }
            ++n3;
        }
    }

    public Hex getHex(int n, int n2) {
        if (this.contains(n, n2)) {
            return this.data[n2 * this.width + n];
        }
        return null;
    }

    public Hex getHexInDir(Coords coords, int n) {
        return this.getHexInDir(coords.x, coords.y, n);
    }

    public Hex getHexInDir(int n, int n2, int n3) {
        return this.getHex(Coords.xInDir(n, n2, n3), Coords.yInDir(n, n2, n3));
    }

    private void initializeHex(Coords coords) {
        this.initializeHex(coords.x, coords.y);
    }

    private void initializeAll() {
        int n = 0;
        while (n < this.height) {
            int n2 = 0;
            while (n2 < this.width) {
                this.initializeHex(n2, n);
                ++n2;
            }
            ++n;
        }
    }

    public void initializeAround(int n, int n2) {
        this.initializeHex(n, n2);
        int n3 = 0;
        while (n3 < 6) {
            this.initializeInDir(n, n2, n3);
            ++n3;
        }
    }

    private void initializeInDir(int n, int n2, int n3) {
        this.initializeHex(Coords.xInDir(n, n2, n3), Coords.yInDir(n, n2, n3));
    }

    public void initializeHex(int n, int n2) {
        Hex hex = this.getHex(n, n2);
        if (hex == null) {
            return;
        }
        hex.clearExits();
        int n3 = 0;
        while (n3 < 6) {
            Hex hex2 = this.getHexInDir(n, n2, n3);
            hex.setExits(hex2, n3);
            ++n3;
        }
    }

    public boolean contains(int n, int n2) {
        return n >= 0 && n2 >= 0 && n < this.width && n2 < this.height;
    }

    public boolean contains(Coords coords) {
        return this.contains(coords.x, coords.y);
    }

    public Hex getHex(Coords coords) {
        return this.getHex(coords.x, coords.y);
    }

    public void setHex(int n, int n2, Hex hex) {
        this.data[n2 * this.width + n] = hex;
        this.initializeAround(n, n2);
        this.processBoardEvent(new BoardEvent(this, new Coords(n, n2), null, 9, 0));
    }

    public void setHex(Coords coords, Hex hex) {
        this.setHex(coords.x, coords.y, hex);
    }

    public void select(Coords coords) {
        if (coords == null || this.contains(coords)) {
            this.selected = coords;
            this.processBoardEvent(new BoardEvent(this, coords, null, 5, 0));
        }
    }

    public void select(int n, int n2) {
        this.select(new Coords(n, n2));
    }

    public void highlight(Coords coords) {
        if (coords == null || this.contains(coords)) {
            this.highlighted = coords;
            this.processBoardEvent(new BoardEvent(this, coords, null, 4, 0));
        }
    }

    public void highlight(int n, int n2) {
        this.highlight(new Coords(n, n2));
    }

    public void cursor(Coords coords) {
        if (coords == null || this.contains(coords)) {
            if (this.lastCursor == null || coords == null || !coords.equals(this.lastCursor)) {
                this.lastCursor = coords;
                this.processBoardEvent(new BoardEvent(this, coords, null, 3, 0));
            } else {
                this.lastCursor = coords;
            }
        }
    }

    public void cursor(int n, int n2) {
        this.cursor(new Coords(n, n2));
    }

    public void mouseAction(int n, int n2, int n3, int n4) {
        if (this.contains(n, n2)) {
            Coords coords = new Coords(n, n2);
            switch (n3) {
                case 1: {
                    this.processBoardEvent(new BoardEvent(this, coords, null, 0, n4));
                    break;
                }
                case 2: {
                    this.processBoardEvent(new BoardEvent(this, coords, null, 1, n4));
                    break;
                }
                case 3: {
                    this.processBoardEvent(new BoardEvent(this, coords, null, 2, n4));
                }
            }
        }
    }

    public void mouseAction(Coords coords, int n, int n2) {
        this.mouseAction(coords.x, coords.y, n, n2);
    }

    public void addBoardListener(BoardListener boardListener) {
        this.boardListeners.addElement(boardListener);
    }

    public void removeBoardListener(BoardListener boardListener) {
        this.boardListeners.removeElement(boardListener);
    }

    public void processBoardEvent(BoardEvent boardEvent) {
        Enumeration enumeration = this.boardListeners.elements();
        while (enumeration.hasMoreElements()) {
            BoardListener boardListener = (BoardListener)enumeration.nextElement();
            switch (boardEvent.getType()) {
                case 0: 
                case 1: 
                case 2: {
                    boardListener.boardHexMoused(boardEvent);
                    break;
                }
                case 3: {
                    boardListener.boardHexCursor(boardEvent);
                    break;
                }
                case 4: {
                    boardListener.boardHexHighlighted(boardEvent);
                    break;
                }
                case 5: {
                    boardListener.boardHexSelected(boardEvent);
                    break;
                }
                case 9: {
                    boardListener.boardChangedHex(boardEvent);
                    break;
                }
                case 6: {
                    boardListener.boardNewBoard(boardEvent);
                }
            }
        }
    }

    public static boolean boardIsSize(String string, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader("data/boards" + File.separator + string));
            StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
            streamTokenizer.eolIsSignificant(true);
            streamTokenizer.commentChar(35);
            streamTokenizer.quoteChar(34);
            streamTokenizer.wordChars(95, 95);
            while (streamTokenizer.nextToken() != -1) {
                if (streamTokenizer.ttype != -3 || !streamTokenizer.sval.equalsIgnoreCase("size")) continue;
                streamTokenizer.nextToken();
                n3 = (int)streamTokenizer.nval;
                streamTokenizer.nextToken();
                n4 = (int)streamTokenizer.nval;
                break;
            }
            ((Reader)bufferedReader).close();
        }
        catch (IOException iOException) {
            return false;
        }
        return n3 == n && n4 == n2;
    }

    public boolean isLegalDeployment(Coords coords, Player player) {
        if (coords == null || player == null) {
            return false;
        }
        int n = 3;
        int n2 = player.getStartingPos();
        switch (n2) {
            case 0: {
                return true;
            }
            case 1: {
                return coords.x < n && coords.y < this.height / 2 || coords.y < n && coords.x < this.width / 2;
            }
            case 2: {
                return coords.y < n;
            }
            case 3: {
                return coords.x > this.width - n && coords.y < this.height / 2 || coords.y < n && coords.x > this.width / 2;
            }
            case 4: {
                return coords.x >= this.width - n;
            }
            case 5: {
                return coords.x >= this.width - n && coords.y > this.height / 2 || coords.y >= this.height - n && coords.x > this.width / 2;
            }
            case 6: {
                return coords.y >= this.height - n;
            }
            case 7: {
                return coords.x < n && coords.y > this.height / 2 || coords.y >= this.height - n && coords.x < this.width / 2;
            }
            case 8: {
                return coords.x < n;
            }
        }
        return false;
    }

    public void load(String string) {
        try {
            FileInputStream fileInputStream = new FileInputStream(new File("data/boards", string));
            this.load(fileInputStream);
            ((InputStream)fileInputStream).close();
        }
        catch (IOException iOException) {
            System.err.println("error opening file to load board!");
            System.err.println(iOException);
        }
    }

    public void load(InputStream inputStream) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        Hex[] hexArray = new Hex[]{};
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
            streamTokenizer.eolIsSignificant(true);
            streamTokenizer.commentChar(35);
            streamTokenizer.quoteChar(34);
            streamTokenizer.wordChars(95, 95);
            while (streamTokenizer.nextToken() != -1) {
                int n4;
                String[] stringArray;
                if (streamTokenizer.ttype == -3 && streamTokenizer.sval.equalsIgnoreCase("size")) {
                    stringArray = new String[]{"0", "0"};
                    n4 = 0;
                    while (streamTokenizer.nextToken() == -3 || streamTokenizer.ttype == 34 || streamTokenizer.ttype == -2) {
                        String string = stringArray[n4++] = streamTokenizer.ttype == -2 ? (int)streamTokenizer.nval + "" : streamTokenizer.sval;
                    }
                    n = Integer.parseInt(stringArray[0]);
                    n2 = Integer.parseInt(stringArray[1]);
                    hexArray = new Hex[n * n2];
                    n3 = 0;
                    continue;
                }
                if (streamTokenizer.ttype == -3 && streamTokenizer.sval.equalsIgnoreCase("hex")) {
                    stringArray = new String[]{"", "0", "", ""};
                    n4 = 0;
                    while (streamTokenizer.nextToken() == -3 || streamTokenizer.ttype == 34 || streamTokenizer.ttype == -2) {
                        String string = stringArray[n4++] = streamTokenizer.ttype == -2 ? (int)streamTokenizer.nval + "" : streamTokenizer.sval;
                    }
                    int n5 = Integer.parseInt(stringArray[1]);
                    hexArray[this.indexFor((String)stringArray[0], (int)n)] = new Hex(n5, stringArray[2], stringArray[3]);
                    continue;
                }
                if (streamTokenizer.ttype != -3 || !streamTokenizer.sval.equalsIgnoreCase("end")) {
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            System.err.println("i/o error reading board");
            System.err.println(iOException);
        }
        int n6 = 0;
        while (n6 < hexArray.length) {
            if (hexArray[n6] == null) {
                hexArray[n6] = new Hex();
            }
            ++n6;
        }
        if (n > 1 || n2 > 1 || n3 == n * n2) {
            this.newData(n, n2, hexArray);
        } else {
            System.err.println("board data invalid");
        }
    }

    private int indexFor(String string, int n) {
        int n2 = Integer.parseInt(string.substring(0, string.length() - 2)) - 1;
        int n3 = Integer.parseInt(string.substring(string.length() - 2)) - 1;
        return n3 * n + n2;
    }

    public void save(OutputStream outputStream) {
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
            outputStreamWriter.write("size " + this.width + " " + this.height + "\r\n");
            int n = 0;
            while (n < this.data.length) {
                Hex hex = this.data[n];
                boolean bl = true;
                StringBuffer stringBuffer = new StringBuffer("hex ");
                stringBuffer.append(new Coords(n % this.width, n / this.width).getBoardNum());
                stringBuffer.append(" ");
                stringBuffer.append(hex.getElevation());
                stringBuffer.append(" \"");
                int n2 = 0;
                while (n2 < Terrain.SIZE) {
                    Terrain terrain = hex.getTerrain(n2);
                    if (terrain != null) {
                        if (!bl) {
                            stringBuffer.append(";");
                        }
                        stringBuffer.append(terrain.toString());
                        bl = false;
                    }
                    ++n2;
                }
                stringBuffer.append("\" \"");
                if (hex.getTheme() != null) {
                    stringBuffer.append(hex.getTheme());
                }
                stringBuffer.append("\"\r\n");
                outputStreamWriter.write(stringBuffer.toString());
                ++n;
            }
            outputStreamWriter.write("end\r\n");
            ((Writer)outputStreamWriter).flush();
        }
        catch (IOException iOException) {
            System.err.println("i/o error writing board");
            System.err.println(iOException);
        }
    }

    public void save2(OutputStream outputStream) {
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(this);
            objectOutputStream.flush();
        }
        catch (IOException iOException) {
            System.err.println("i/o error writing board");
            System.err.println(iOException);
        }
    }
}

