/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.bot;

import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Vector;
import megamek.client.bot.CEntity;
import megamek.client.bot.Compute;
import megamek.client.bot.TestBot;
import megamek.client.bot.ga.ChromVector;
import megamek.client.bot.ga.Chromosome;
import megamek.client.bot.ga.GA;
import megamek.client.bot.ga.GAException;
import megamek.common.Entity;
import megamek.common.Game;

public class GAAttack
extends GA {
    protected Vector attack;
    protected CEntity attacker;
    protected Game game;
    protected CEntity.Table targets = new CEntity.Table();
    protected Object[] target_array = null;
    protected Vector valid_target_indexes = null;
    protected boolean overheat_eligible = false;
    double[] damages = null;

    public GAAttack(Game game, CEntity cEntity, Vector vector, int n, int n2, boolean bl) throws GAException {
        super(vector.size() + 1, n, 0.7, 5, n2, 0, 0, 0.4, 2, false, false);
        this.attack = vector;
        this.attacker = cEntity;
        this.game = game;
        this.target_array = Compute.vectorToArray(game.getEntitiesVector());
        Vector vector2 = new Vector();
        int n3 = 0;
        while (n3 < this.target_array.length) {
            Entity entity = (Entity)this.target_array[n3];
            if (entity.isEnemyOf(cEntity.entity)) {
                vector2.add((Object)new Integer(n3));
            }
            ++n3;
        }
        this.valid_target_indexes = vector2;
        this.initPopulation();
        if (bl || cEntity.last != null && (!cEntity.last.inDanger || cEntity.last.Doomed)) {
            this.overheat_eligible = true;
        }
    }

    public int[] getResultChromosome() {
        return ((ChromVector)this.chromosomes[this.bestFitnessChromIndex]).genes;
    }

    public double getDamageUtility(CEntity cEntity) {
        if (this.damages == null) {
            this.damages = this.getDamageUtilities();
        }
        int n = 0;
        while (n < this.target_array.length) {
            Entity entity = (Entity)this.target_array[n];
            if (entity.getId() == cEntity.entity.getId()) {
                return this.damages[n];
            }
            ++n;
        }
        return 0.0;
    }

    public double[] getDamageUtilities() {
        return this.getDamageUtilities(this.bestFitnessChromIndex);
    }

    public double[] getDamageUtilities(int n) {
        double d;
        this.targets.clear();
        double[] dArray = new double[this.target_array.length];
        ChromVector chromVector = (ChromVector)this.chromosomes[n];
        int n2 = 0;
        Iterator iterator = this.attack.iterator();
        if (chromVector.genes[this.chromosomeDim - 1] >= this.target_array.length) {
            chromVector.genes[this.chromosomeDim - 1] = (Integer)this.valid_target_indexes.elementAt(0);
        }
        Entity entity = (Entity)this.target_array[chromVector.genes[this.chromosomeDim - 1]];
        boolean bl = false;
        int n3 = 0;
        while (n3 < this.chromosomeDim - 1) {
            TestBot.AttackOption attackOption = (TestBot.AttackOption)((Vector)this.attack.elementAt(n3)).elementAt(chromVector.genes[n3]);
            if (attackOption.target != null) {
                bl = true;
                this.targets.put(attackOption.target);
                d = 1.0;
                if (attackOption.target.entity.getId() == entity.getId()) {
                    int n4 = attackOption.toHit.getSideTable();
                    attackOption.target.possible_damage[n4] = attackOption.target.possible_damage[n4] + d * attackOption.primary_expected;
                } else {
                    int n5 = attackOption.toHit.getSideTable();
                    attackOption.target.possible_damage[n5] = attackOption.target.possible_damage[n5] + d * attackOption.expected;
                }
                n2 += attackOption.heat;
            }
            ++n3;
        }
        int n6 = 0;
        while (n6 < this.target_array.length) {
            d = 0.0;
            Entity entity2 = (Entity)this.target_array[n6];
            CEntity cEntity = null;
            cEntity = (CEntity)this.targets.get(new Integer(entity2.getId()));
            if (cEntity != null) {
                if (cEntity.possible_damage[0] > 0.0) {
                    d += cEntity.getThreatUtility(cEntity.possible_damage[0], 0);
                } else if (cEntity.possible_damage[1] > 0.0) {
                    d += cEntity.getThreatUtility(cEntity.possible_damage[1], 1);
                } else if (cEntity.possible_damage[2] > 0.0) {
                    d += cEntity.getThreatUtility(cEntity.possible_damage[2], 2);
                } else if (cEntity.possible_damage[3] > 0.0) {
                    d += cEntity.getThreatUtility(cEntity.possible_damage[3], 3);
                }
                cEntity.resetPossibleDamage();
            }
            dArray[n6] = d;
            ++n6;
        }
        return dArray;
    }

    protected double getFitness(int n) {
        return this.getFitness((ChromVector)this.chromosomes[n]);
    }

    protected double getFitness(ChromVector chromVector) {
        this.targets.clear();
        int n = 0;
        Iterator iterator = this.attack.iterator();
        Entity entity = null;
        try {
            entity = (Entity)this.target_array[chromVector.genes[this.chromosomeDim - 1]];
        }
        catch (Exception exception) {
            System.out.println(this.chromosomeDim + " " + chromVector.genes.length);
            System.out.println(this.target_array.length);
            entity = (Entity)this.target_array[(Integer)this.valid_target_indexes.get(0)];
        }
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        while (n2 < this.chromosomeDim - 1) {
            int[] nArray = chromVector.genes;
            TestBot.AttackOption attackOption = (TestBot.AttackOption)((Vector)this.attack.elementAt(n2)).elementAt(nArray[n2]);
            if (attackOption.target != null) {
                bl2 = true;
                this.targets.put(attackOption.target);
                double d = 1.0;
                if (attackOption.ammoLeft != -1) {
                    if (this.attacker.overall_armor_percent < 0.5) {
                        d = 1.5;
                    } else if (attackOption.ammoLeft < 12 && this.attacker.overall_armor_percent > 0.75) {
                        d = attackOption.primary_odds < 0.1 ? 0.0 : (attackOption.ammoLeft < 6 && attackOption.primary_odds < 0.25 ? 0.0 : attackOption.primary_odds);
                    }
                }
                if (attackOption.target.entity.getId() == entity.getId()) {
                    bl = true;
                    int n3 = attackOption.toHit.getSideTable();
                    attackOption.target.possible_damage[n3] = attackOption.target.possible_damage[n3] + d * attackOption.primary_expected;
                } else {
                    int n4 = attackOption.toHit.getSideTable();
                    attackOption.target.possible_damage[n4] = attackOption.target.possible_damage[n4] + d * attackOption.expected;
                }
                n += attackOption.heat;
            }
            ++n2;
        }
        double d = 0.0;
        Iterator iterator2 = this.targets.values().iterator();
        while (iterator2.hasNext()) {
            CEntity cEntity = (CEntity)iterator2.next();
            if (cEntity.possible_damage[0] > 0.0) {
                d += cEntity.getThreatUtility(cEntity.possible_damage[0], 0);
            } else if (cEntity.possible_damage[1] > 0.0) {
                d += cEntity.getThreatUtility(cEntity.possible_damage[1], 1);
            } else if (cEntity.possible_damage[2] > 0.0) {
                d += cEntity.getThreatUtility(cEntity.possible_damage[2], 2);
            } else if (cEntity.possible_damage[3] > 0.0) {
                d += cEntity.getThreatUtility(cEntity.possible_damage[3], 3);
            }
            cEntity.resetPossibleDamage();
        }
        int n5 = this.attacker.entity.getHeatCapacityWithWater();
        int n6 = this.attacker.entity.heatBuildup + this.attacker.entity.heat;
        int n7 = n6 + n - n5;
        if (this.attacker.entity.heat > 0 && n7 < 0) {
            d -= (double)(this.attacker.bv / 1000 * n7);
            if (this.attacker.entity.heat > 4) {
                d *= 1.2;
            }
            if (this.attacker.entity.heat > 7) {
                d += (double)(this.attacker.bv / 50);
            }
            if (this.attacker.entity.heat > 12) {
                d += (double)(this.attacker.bv / 20);
            }
            if (this.attacker.entity.heat > 16) {
                d += (double)(this.attacker.bv / 10);
            }
        } else if (n7 > 0) {
            if (n7 > 4) {
                d *= this.overheat_eligible && this.attacker.jumpMP > 2 ? 0.9 : 0.85;
            }
            if (n7 > 7) {
                double d2;
                double d3 = this.overheat_eligible ? (double)(this.attacker.jumpMP > 2 ? 0 : 10) : (d2 = 40.0);
                d = this.attacker.overheat > 1 ? (d -= (double)this.attacker.bv / d2) : (d -= (double)this.attacker.bv / (d2 + 10.0));
            }
            if (n7 > 12) {
                d -= (double)(this.attacker.bv / (this.overheat_eligible ? 45 : 30));
            }
            if (n7 > 16) {
                d -= (double)(this.attacker.bv / 5);
            }
            d -= (double)(n7 / 100);
        }
        return d;
    }

    protected void doRandomMutation(int n) {
        Object object;
        int n2;
        ChromVector chromVector = (ChromVector)this.chromosomes[n];
        int n3 = megamek.common.Compute.random.nextInt(chromVector.genes.length - 1);
        CEntity cEntity = null;
        boolean bl = false;
        if (n3 % 2 == 1) {
            int n4 = n3;
            chromVector.genes[n4] = chromVector.genes[n4] - 1;
            if (chromVector.genes[n3] < 0) {
                chromVector.genes[n3] = ((Vector)this.attack.elementAt(n3)).size() - 1;
            }
            return;
        }
        int n5 = 0;
        while (n5 < chromVector.genes.length - 1 && !bl) {
            n2 = (n5 + n3) % (chromVector.genes.length - 1);
            object = (TestBot.AttackOption)((Vector)this.attack.elementAt(n2)).elementAt(chromVector.genes[n2]);
            if (object.target != null) {
                cEntity = object.target;
                bl = true;
            }
            ++n5;
        }
        if (cEntity == null) {
            chromVector.genes[n3] = megamek.common.Compute.random.nextInt(((Vector)this.attack.elementAt(n3)).size() - 1);
            TestBot.AttackOption attackOption = (TestBot.AttackOption)((Vector)this.attack.elementAt(n3)).elementAt(chromVector.genes[n3]);
            if (attackOption.target != null) {
                chromVector.genes[chromVector.genes.length - 1] = attackOption.target.enemy_num;
            }
        } else {
            n2 = 0;
            while (n2 < chromVector.genes.length - 1) {
                object = ((Vector)this.attack.elementAt(n2)).toArray();
                if (chromVector.genes[n2] != ((Object[])object).length - 1) {
                    bl = false;
                    int n6 = 0;
                    while (n6 < ((Object[])object).length - 1 && !bl) {
                        TestBot.AttackOption attackOption = (TestBot.AttackOption)object[n6];
                        if (attackOption.target.enemy_num == cEntity.enemy_num) {
                            chromVector.genes[n2] = n6;
                            bl = true;
                        }
                        ++n6;
                    }
                }
                ++n2;
            }
            ((ChromVector)this.chromosomes[0]).genes[this.chromosomeDim - 1] = cEntity.enemy_num;
        }
    }

    protected void doUniformCrossover(Chromosome chromosome, Chromosome chromosome2) {
        int n = 0;
        ChromVector chromVector = (ChromVector)chromosome;
        ChromVector chromVector2 = (ChromVector)chromosome2;
        int n2 = 0;
        while (n2 < this.chromosomeDim) {
            if (megamek.common.Compute.random.nextInt(2) == 1) {
                n = chromVector.genes[n2];
                chromVector.genes[n2] = chromVector2.genes[n2];
                chromVector2.genes[n2] = n;
            }
            ++n2;
        }
    }

    protected void initPopulation() {
        int n = 0;
        while (n < this.chromosomeDim - 1) {
            ((ChromVector)this.chromosomes[0]).genes[n] = 0;
            ++n;
        }
        TestBot.AttackOption attackOption = (TestBot.AttackOption)((Vector)this.attack.elementAt(0)).elementAt(0);
        ((ChromVector)this.chromosomes[0]).genes[this.chromosomeDim - 1] = attackOption.target.enemy_num;
        int n2 = 1;
        while (n2 < this.populationDim) {
            ChromVector chromVector = (ChromVector)this.chromosomes[n2];
            int n3 = 0;
            while (n3 < this.chromosomeDim - 1) {
                chromVector.genes[n3] = megamek.common.Compute.random.nextInt(((Vector)this.attack.elementAt(n3)).size());
                if (n2 <= this.attack.size()) {
                    chromVector.genes[n3] = n3 + 1 == n2 ? 0 : ((Vector)this.attack.elementAt(n3)).size() - 1;
                }
                ++n3;
            }
            chromVector.genes[this.chromosomeDim - 1] = (Integer)this.valid_target_indexes.elementAt(megamek.common.Compute.random.nextInt(this.valid_target_indexes.size()));
            this.chromosomes[n2].fitness = this.getFitness(n2);
            ++n2;
        }
    }

    protected Chromosome getNewChrom(int n) {
        return new ChromVector(n);
    }
}

