/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.bot;

import com.sun.java.util.collections.Arrays;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Comparator;
import com.sun.java.util.collections.Hashtable;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Vector;
import java.util.Enumeration;
import megamek.client.bot.Compute;
import megamek.client.bot.EntityState;
import megamek.client.bot.Strategy;
import megamek.client.bot.TestBot;
import megamek.common.AmmoType;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.Game;
import megamek.common.Hex;
import megamek.common.Mounted;
import megamek.common.MovementData;
import megamek.common.Tank;
import megamek.common.ToHitData;
import megamek.common.WeaponType;

public class CEntity {
    public static Game game;
    public static TestBot tb;
    public static final int MAX_RANGE = 24;
    public static final int OVERHEAT_NONE = 0;
    public static final int OVERHEAT_LOW = 1;
    public static final int OVERHEAT_HIGH = 2;
    public static final int RANGE_SHORT = 0;
    public static final int RANGE_MEDIUM = 1;
    public static final int RANGE_LONG = 2;
    public static final int RANGE_ALL = 3;
    public static final int FIRST_ARC = 0;
    public static final int LAST_PRIMARY_ARC = 3;
    public static final int LAST_ARC = 4;
    public static final int SIDE_FRONT = 0;
    public static final int SIDE_REAR = 1;
    public static final int SIDE_LEFT = 2;
    public static final int SIDE_RIGHT = 3;
    public static final int TT = 4;
    public static final int LEFT_LEG = 0;
    public static final int RIGHT_LEG = 1;
    Entity entity;
    EntityState old = null;
    Vector moves = null;
    EntityState.Table run_walk_moves = null;
    EntityState.Table jump_hexes = null;
    public int runMP;
    public int jumpMP;
    boolean moved = false;
    boolean isPhysicalTarget = false;
    int gunnery = 4;
    int piloting = 5;
    int overheat = 0;
    int Range = 3;
    int long_range = 0;
    double[] RangeDamages = new double[4];
    double base_psr_odds = 1.0;
    boolean hasTakenDamage = false;
    public Strategy strategy = new Strategy();
    double[] armor_health = new double[]{0.0, 0.0, 0.0, 0.0};
    double[] armor_percent = new double[]{0.0, 0.0, 0.0, 0.0};
    double avg_armor = 0.0;
    double avg_iarmor = 0.0;
    double[] expected_damage = new double[]{0.0, 0.0, 0.0, 0.0};
    double[] possible_damage = new double[]{0.0, 0.0, 0.0, 0.0};
    double[] leg_health = new double[]{0.0, 0.0};
    double overall_armor_percent = 0.0;
    double[][] damages = new double[6][25];
    int bv;
    int enemy_num;
    boolean engaged = false;
    EntityState last;
    int[] MinRanges = new int[7];
    int MechsMoved = 1;
    Vector CounterMoves;
    boolean refresh = true;

    public CEntity(Entity entity) {
        this.entity = entity;
        this.reset();
    }

    public boolean canMove() {
        return !(!this.entity.isSelectable() || this.entity.isProne() && this.base_psr_odds < 0.2 || this.entity.isImmobile());
    }

    public void reset() {
        int n = 0;
        while (n <= 4) {
            int n2 = 1;
            while (n2 <= 24) {
                this.damages[n][n2] = 0.0;
                ++n2;
            }
            ++n;
        }
        this.characterize();
        this.resetPossibleDamage();
        this.moves = null;
        this.jump_hexes = null;
        this.run_walk_moves = null;
        this.hasTakenDamage = false;
        this.expected_damage = new double[]{0.0, 0.0, 0.0, 0.0};
        this.refresh = true;
        this.engaged = false;
        this.moved = false;
        this.isPhysicalTarget = false;
    }

    public void refresh() {
        this.entity = game.getEntity(this.entity.getId());
        if (this.refresh && !this.entity.isSelectable()) {
            int n = 0;
            while (n <= 4) {
                int n2 = 1;
                while (n2 <= 24) {
                    this.damages[n][n2] = 0.0;
                    ++n2;
                }
                ++n;
            }
            this.characterize();
            this.resetPossibleDamage();
            this.jump_hexes = null;
            this.run_walk_moves = null;
            this.refresh = false;
        }
    }

    public void resetPossibleDamage() {
        int n = 0;
        while (n < this.possible_damage.length) {
            this.possible_damage[n] = 0.0;
            ++n;
        }
    }

    public void characterize() {
        int n;
        int n2;
        int n3;
        this.entity = game.getEntity(this.entity.getId());
        this.old = new EntityState(this);
        this.bv = this.entity.calculateBattleValue();
        this.gunnery = this.entity.getCrew().getGunnery();
        this.piloting = this.entity.getCrew().getGunnery();
        this.runMP = this.entity.getRunMP();
        this.jumpMP = this.entity.getJumpMP();
        this.overall_armor_percent = this.entity.getArmorRemainingPercent();
        this.base_psr_odds = megamek.common.Compute.oddsAbove(megamek.common.Compute.getBasePilotingRoll(game, this.entity.getId()).getValue()) / 100.0;
        double d = 0.9;
        if (this.entity.heat > 7) {
            d = 0.8;
        }
        if (this.entity.heat > 12) {
            d = 0.5;
        }
        if (this.entity.heat > 16) {
            d = 0.35;
        }
        int n4 = this.entity.getHeatCapacity();
        int n5 = 0;
        Enumeration enumeration = this.entity.getWeapons();
        int n6 = 0;
        this.MinRanges = new int[7];
        while (enumeration.hasMoreElements()) {
            AmmoType ammoType;
            ++n6;
            Mounted mounted = (Mounted)enumeration.nextElement();
            n3 = this.entity.getWeaponArc(this.entity.getEquipmentNum(mounted));
            WeaponType weaponType = (WeaponType)mounted.getType();
            boolean bl = weaponType.getAmmoType() != -1;
            Mounted mounted2 = bl ? mounted.getLinked() : null;
            AmmoType ammoType2 = ammoType = mounted2 == null ? null : (AmmoType)mounted2.getType();
            if (mounted.isDestroyed() || bl && (mounted2 == null || mounted2.getShotsLeft() == 0)) continue;
            n5 += weaponType.getHeat();
            n2 = weaponType.getMinimumRange();
            int n7 = weaponType.getShortRange();
            n = weaponType.getMediumRange();
            int n8 = weaponType.getLongRange();
            double d2 = Compute.getExpectedDamage(weaponType);
            double d3 = 0.0;
            double d4 = 0.0;
            int n9 = 1;
            while (n9 <= n8 && n9 <= 24) {
                if (n9 <= n2) {
                    if (n9 < 7) {
                        int n10 = n9;
                        this.MinRanges[n10] = this.MinRanges[n10] + (1 + n2 - n9);
                    }
                    d3 = megamek.common.Compute.oddsAbove(this.gunnery + 1 + n2 - n9) / 100.0;
                } else if (n9 <= n7) {
                    d3 = megamek.common.Compute.oddsAbove(this.gunnery) / 100.0;
                } else if (n9 <= n) {
                    d3 = megamek.common.Compute.oddsAbove(this.gunnery + 2) / 100.0;
                } else if (n9 <= n8) {
                    d3 = megamek.common.Compute.oddsAbove(this.gunnery + 4) / 100.0;
                }
                this.addDamage(n3, this.entity.isSecondaryArcWeapon(this.entity.getEquipmentNum(mounted)), n9, d2 * d3 * (weaponType.getHeat() > 0 ? d : 1.0));
                this.long_range = Math.max(this.long_range, n9);
                ++n9;
            }
        }
        int n11 = 1;
        while (n11 < this.MinRanges.length) {
            if (n6 > 0) {
                this.MinRanges[n11] = (int)Math.round((double)this.MinRanges[n11] / (double)n6);
            }
            ++n11;
        }
        n3 = n5 - n4;
        if (n3 < 8 && n3 > 3) {
            this.overheat = 1;
        } else if (n3 > 12) {
            this.overheat = 2;
        }
        double d5 = 1.0;
        int n12 = 0;
        while (n12 <= 3) {
            int n13 = 0;
            n2 = 0;
            int[] nArray = null;
            n = 0;
            if (this.entity instanceof Tank) {
                switch (n12) {
                    case 0: {
                        nArray = this.getArmorValues(1, false);
                        n13 += 2 * nArray[0];
                        n2 += 2 * nArray[1];
                        break;
                    }
                    case 1: {
                        nArray = this.getArmorValues(4, false);
                        n13 += 2 * nArray[0];
                        n2 += 2 * nArray[1];
                        break;
                    }
                    case 3: {
                        nArray = this.getArmorValues(2, false);
                        n13 += 2 * nArray[0];
                        n2 += 2 * nArray[1];
                        break;
                    }
                    case 2: {
                        nArray = this.getArmorValues(3, false);
                        n13 += 2 * nArray[0];
                        n2 += 2 * nArray[1];
                    }
                }
            } else {
                switch (n12) {
                    case 1: {
                        n = 1;
                    }
                    case 0: {
                        nArray = this.getArmorValues(1, n != 0);
                        n13 += 2 * nArray[0];
                        n2 += 2 * nArray[1];
                        nArray = this.getArmorValues(4, n != 0);
                        n13 += 2 * nArray[0];
                        n2 += 2 * nArray[1];
                        nArray = this.getArmorValues(6, n != 0);
                        n13 += nArray[0];
                        n2 += nArray[1];
                        nArray = this.getArmorValues(2, n != 0);
                        n13 += nArray[0];
                        n2 += nArray[1];
                        nArray = this.getArmorValues(3, n != 0);
                        n13 += nArray[0];
                        n2 += nArray[1];
                        nArray = this.getArmorValues(7, n != 0);
                        n13 += nArray[0];
                        n2 += nArray[1];
                        nArray = this.getArmorValues(5, n != 0);
                        n13 += 2 * nArray[0];
                        n2 += 2 * nArray[1];
                        nArray = this.getArmorValues(0, n != 0);
                        n13 += nArray[0];
                        n2 += nArray[1];
                        break;
                    }
                    case 2: {
                        nArray = this.getArmorValues(1, n != 0);
                        n13 += nArray[0];
                        n2 += nArray[1];
                        nArray = this.getArmorValues(4, n != 0);
                        n13 += nArray[0];
                        n2 += nArray[1];
                        nArray = this.getArmorValues(6, n != 0);
                        this.leg_health[1] = nArray[0] / this.entity.getOArmor(6);
                        n13 += nArray[0];
                        n2 += nArray[1];
                        nArray = this.getArmorValues(2, n != 0);
                        n13 += nArray[0];
                        n2 += nArray[1];
                        nArray = this.getArmorValues(3, n != 0);
                        n13 += 2 * nArray[0];
                        n2 += 2 * nArray[1];
                        nArray = this.getArmorValues(7, n != 0);
                        this.leg_health[0] = nArray[0] / this.entity.getOArmor(7);
                        n13 += 2 * nArray[0];
                        n2 += 2 * nArray[1];
                        nArray = this.getArmorValues(5, n != 0);
                        n13 += 2 * nArray[0];
                        n2 += 2 * nArray[1];
                        nArray = this.getArmorValues(0, n != 0);
                        n13 += nArray[0];
                        n2 += nArray[1];
                        break;
                    }
                    case 3: {
                        nArray = this.getArmorValues(1, n != 0);
                        n13 += nArray[0];
                        n2 += nArray[1];
                        nArray = this.getArmorValues(4, n != 0);
                        n13 += 2 * nArray[0];
                        n2 += 2 * nArray[1];
                        nArray = this.getArmorValues(6, n != 0);
                        n13 += 2 * nArray[0];
                        n2 += 2 * nArray[1];
                        nArray = this.getArmorValues(2, n != 0);
                        n13 += 2 * nArray[0];
                        n2 += 2 * nArray[1];
                        nArray = this.getArmorValues(3, n != 0);
                        n13 += nArray[0];
                        n2 += nArray[1];
                        nArray = this.getArmorValues(7, n != 0);
                        n13 += nArray[0];
                        n2 += nArray[1];
                        nArray = this.getArmorValues(5, n != 0);
                        n13 += nArray[0];
                        n2 += nArray[1];
                        nArray = this.getArmorValues(0, n != 0);
                        n13 += nArray[0];
                        n2 += nArray[1];
                    }
                }
            }
            this.armor_health[n12] = (double)n13 * (double)n2 / 242.0;
            if (this.armor_health[n12] > d5) {
                d5 = this.armor_health[n12];
            }
            this.avg_armor = (this.armor_health[0] + this.armor_health[1] + this.armor_health[2] + this.armor_health[3]) / 4.0;
            this.avg_iarmor = this.entity.getTotalInternal() / 5;
            ++n12;
        }
        int n14 = 0;
        while (n14 <= 3) {
            this.armor_percent[n14] = this.armor_health[n14] / d5;
            ++n14;
        }
        this.computeRange();
    }

    protected void addDamage(int n, boolean bl, int n2, double d) {
        double[] dArray = this.damages[Compute.firingArcToHitArc(n)];
        int n3 = n2;
        dArray[n3] = dArray[n3] + d;
        if (n != 4 && n != 0) {
            double[] dArray2 = this.damages[0];
            int n4 = n2;
            dArray2[n4] = dArray2[n4] + d;
            if (!bl) {
                return;
            }
            double[] dArray3 = this.damages[4];
            int n5 = n2;
            dArray3[n5] = dArray3[n5] + d;
            return;
        }
        if (n == 0) {
            int n6 = 0;
            while (n6 <= 4) {
                double[] dArray4 = this.damages[n6];
                int n7 = n2;
                dArray4[n7] = dArray4[n7] + d;
                ++n6;
            }
            return;
        }
    }

    protected void computeRange() {
        double[] dArray = new double[3];
        this.RangeDamages[3] = 0.0;
        int n = 0;
        while (n < 3) {
            int n2 = 1 + 6 * n;
            while (n2 < 8 + 6 * n) {
                int n3 = n;
                dArray[n3] = dArray[n3] + this.damages[0][n2];
                ++n2;
            }
            int n4 = n;
            dArray[n4] = dArray[n4] / 8.0;
            this.RangeDamages[n] = dArray[n];
            this.RangeDamages[3] = this.RangeDamages[3] + dArray[n];
            ++n;
        }
        this.RangeDamages[3] = this.RangeDamages[3] / 3.0;
        this.Range = dArray[0] > 2.5 * dArray[1] ? 0 : (dArray[1] > 2.5 * dArray[2] ? 1 : (dArray[2] > 0.25 * dArray[0] ? 2 : 3));
    }

    protected int[] getArmorValues(int n, boolean bl) {
        int[] nArray = new int[2];
        double d = 0.0;
        nArray[0] = this.entity.getArmor(n, bl);
        d = nArray[0] / this.entity.getOArmor(n, bl);
        nArray[1] = d < 0.25 ? 0 : (d < 0.6 ? 1 : 2);
        return nArray;
    }

    public double getThreatUtility(double d, int n) {
        double d2 = d;
        double d3 = d;
        if (this.armor_percent[n] < 0.75) {
            d2 *= 1.1;
        } else if (this.armor_percent[n] < 0.5) {
            d2 *= 1.3;
        } else if (this.armor_percent[n] < 0.25) {
            d2 *= 1.5;
        }
        if (d3 + this.expected_damage[n] > this.armor_health[n]) {
            if ((d3 + this.expected_damage[0] + this.expected_damage[1] + this.expected_damage[2] + this.expected_damage[3] > 3.0 * (this.avg_armor + this.avg_iarmor) || this.entity.isProne() && this.base_psr_odds < 0.1 && !this.entity.isImmobile()) && CEntity.tb.NumFriends <= CEntity.tb.NumEnemies) {
                if (CEntity.tb.NumEnemies == 1) {
                    return d3 *= 2.0;
                }
                if (this.entity.isEnemyOf((Entity)tb.getEntitiesOwned().elementAt(0))) {
                    return Math.sqrt(d3) * this.strategy.target;
                }
            }
            d3 *= 1.5;
        } else if (this.expected_damage[n] > 0.0) {
            d3 *= 1.3;
        } else if (this.hasTakenDamage) {
            d3 *= 1.1;
        }
        return Math.max(d2, d3) * this.strategy.target;
    }

    public Integer getKey() {
        return new Integer(this.entity.getId());
    }

    public Vector getAllMoves() {
        Object object;
        EntityState entityState;
        this.run_walk_moves = null;
        Vector vector = this.calculateRunWalkOptions();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            entityState = (EntityState)iterator.next();
            if (entityState.isMoveLegal()) continue;
            iterator.remove();
        }
        this.jump_hexes = null;
        entityState = this.calculateJumpOptions();
        iterator = entityState.iterator();
        while (iterator.hasNext()) {
            object = (EntityState)iterator.next();
            if (((EntityState)object).isMoveLegal()) continue;
            iterator.remove();
        }
        object = entityState.toArray();
        int n = 0;
        while (n < ((Object)object).length) {
            EntityState entityState2 = new EntityState((EntityState)object[n]);
            if (!entityState2.isPhysical) {
                int n2 = 0;
                while (n2 < 6) {
                    entityState2.addStep(4);
                    entityState.add(entityState2);
                    entityState2 = new EntityState(entityState2);
                    ++n2;
                }
            }
            ++n;
        }
        vector.addAll((Collection)entityState);
        return vector;
    }

    protected Vector calculateRunWalkOptions() {
        Vector vector;
        if (this.run_walk_moves != null) {
            Vector vector2 = new Vector();
            Iterator iterator = this.run_walk_moves.values().iterator();
            while (iterator.hasNext()) {
                vector2.add((Object)new EntityState((EntityState)iterator.next()));
            }
            return vector2;
        }
        Entity entity = this.entity;
        EntityState entityState = null;
        EntityState.Table table = new EntityState.Table();
        EntityState.Table table2 = new EntityState.Table();
        EntityState entityState2 = new EntityState(this.old);
        table.put(entityState2);
        table2.put(entityState2);
        if (entity.isProne()) {
            entityState = new EntityState(entityState2);
            entityState.addStep(3);
            table2.put(entityState);
            entityState = new EntityState(entityState2);
            entityState.addStep(4);
            table2.put(entityState);
            if (this.base_psr_odds < 0.25) {
                table.clear();
            } else {
                entityState = new EntityState(entityState2);
                entityState.addStep(5);
                if (entityState.isStepLegal()) {
                    table.put(entityState);
                    table2.put(entityState);
                    int n = 0;
                    while (n < 5) {
                        entityState = new EntityState(entityState);
                        entityState.addStep(4);
                        table2.put(entityState);
                        table.put(entityState);
                        ++n;
                    }
                }
            }
        }
        while (table.size() > 0) {
            EntityState entityState3 = table.extractMin();
            vector = new Vector();
            if (entityState3.firstStep || entityState3.getLastStep().getType() != 2) {
                entityState = new EntityState(entityState3);
                entityState.addStep(1);
                vector.add((Object)entityState);
            }
            if (entityState3.firstStep || entityState3.getLastStep().getType() != 4) {
                entityState = new EntityState(entityState3);
                entityState.addStep(3);
                vector.add((Object)entityState);
            }
            if (entityState3.firstStep || entityState3.getLastStep().getType() != 3) {
                entityState = new EntityState(entityState3);
                entityState.addStep(4);
                vector.add((Object)entityState);
            }
            if (entityState3.firstStep || entityState3.getLastStep().getType() != 1 && entityState3.overallMoveType != 2) {
                entityState = new EntityState(entityState3);
                entityState.addStep(2);
                vector.add((Object)entityState);
            }
            int n = 0;
            while (n < vector.size()) {
                entityState = (EntityState)vector.elementAt(n);
                if (entityState.changeToPhysical()) {
                    table2.put(entityState);
                } else if (entityState.isStepLegal()) {
                    if (table2.get(entityState) == null) {
                        table2.put(entityState);
                        table.put(entityState);
                    } else if (entityState.mpUsed < table2.get((EntityState)entityState).mpUsed) {
                        table.update(entityState);
                        table2.update(entityState);
                    }
                }
                ++n;
            }
        }
        Iterator iterator = table2.values().iterator();
        vector = new Vector();
        while (iterator.hasNext()) {
            entityState = (EntityState)iterator.next();
            if (this.entity.heat > 4) {
                entityState.movement_threat += (double)(this.bv / 1000 * entityState.getMovementheatBuildup());
                if (this.entity.heat > 7) {
                    entityState.movement_threat += (double)(this.bv / 500 * entityState.getMovementheatBuildup());
                }
                if (this.entity.heat > 12) {
                    entityState.movement_threat += (double)(this.bv / 100 * entityState.getMovementheatBuildup());
                }
            }
            vector.add((Object)new EntityState(entityState));
        }
        this.run_walk_moves = table2;
        return vector;
    }

    protected Vector calculateJumpOptions() {
        Object object;
        EntityState.Table table;
        if (this.jump_hexes != null) {
            Vector vector = new Vector();
            Iterator iterator = this.jump_hexes.values().iterator();
            while (iterator.hasNext()) {
                vector.add((Object)new EntityState((EntityState)iterator.next()));
            }
            return vector;
        }
        Entity entity = this.entity;
        Vector vector = new Vector();
        EntityState.Table table2 = new EntityState.Table();
        this.jump_hexes = table = new EntityState.Table();
        if (entity.getJumpMP() == 0) {
            return vector;
        }
        EntityState entityState = new EntityState(this);
        EntityState entityState2 = null;
        entityState.addStep(7);
        if (!entityState.isStepLegal()) {
            return vector;
        }
        table2.put(entityState);
        table.put(entityState);
        if (this.entity.getDestroyedCriticals(0, 4, 1) > 0 || this.entity.hasLegActuatorCrit()) {
            if (this.base_psr_odds > 0.2) {
                double d = 1.0;
                if (this.base_psr_odds < 0.5) {
                    d = 3.0;
                }
                entityState.movement_threat += d * 0.1 * (double)this.entity.getWeight() * (1.0 - 0.0 * this.base_psr_odds);
                entityState.tv.add((Object)(d * 0.1 * (double)this.entity.getWeight() * (1.0 - 0.0 * this.base_psr_odds) + " Jump Threat"));
            } else {
                table2.clear();
                table.clear();
            }
        }
        while (table2.size() > 0) {
            EntityState entityState3 = table2.extractMin();
            if (entityState3.entity.getJumpMP() <= entityState3.mpUsed) continue;
            object = new Vector();
            object.add((Object)new EntityState(entityState3));
            int n = 0;
            while (n < 5) {
                entityState2 = new EntityState((EntityState)object.elementAt(n));
                entityState2.addStep(4);
                object.add((Object)entityState2);
                ++n;
            }
            int n2 = 0;
            while (n2 < 6) {
                entityState2 = (EntityState)object.elementAt(n2);
                entityState2.addStep(1);
                if (entityState2.changeToPhysical()) {
                    table.put(entityState2);
                } else if (entityState2.isStepLegal()) {
                    if (table.get(entityState2) == null) {
                        table.put(entityState2);
                        table2.put(entityState2);
                    } else if (entityState2.mpUsed < table.get((EntityState)entityState2).mpUsed) {
                        table2.update(entityState2);
                        table.update(entityState2);
                    }
                }
                ++n2;
            }
        }
        table.remove(this.old);
        Iterator iterator = table.values().iterator();
        while (iterator.hasNext()) {
            entityState2 = (EntityState)iterator.next();
            if (this.entity.heat > 4) {
                entityState2.movement_threat += (double)(this.bv / 1000 * entityState2.getMovementheatBuildup());
                if (this.entity.heat > 7) {
                    entityState2.movement_threat += (double)(this.bv / 500 * entityState2.getMovementheatBuildup());
                }
                if (this.entity.heat > 12) {
                    entityState2.movement_threat += (double)(this.bv / 100 * entityState2.getMovementheatBuildup());
                }
            }
            if (((Hex)(object = CEntity.game.board.getHex(entityState2.curPos))).contains(4) && ((Hex)object).surface() - ((Hex)object).floor() > 0) {
                entityState2.movement_threat += this.getThreatUtility(0.2 * (double)this.entity.getWeight() * (1.0 - this.base_psr_odds), 1);
                entityState2.tv.add((Object)(this.getThreatUtility(0.2 * (double)this.entity.getWeight() * (1.0 - this.base_psr_odds), 1) + " Spec Jump Threat \n"));
            }
            vector.add((Object)new EntityState(entityState2));
        }
        this.jump_hexes = table;
        return vector;
    }

    public Vector calculateCounterMoves() {
        int n;
        EntityState entityState;
        if (this.moves == null) {
            this.moves = this.calculateRunWalkOptions();
            this.moves.addAll((Collection)this.calculateJumpOptions());
        } else if (this.MechsMoved == CEntity.tb.my_mechs_moved) {
            return this.CounterMoves;
        }
        this.MechsMoved = CEntity.tb.my_mechs_moved;
        Object[] objectArray = this.moves.toArray();
        Object[] objectArray2 = Compute.vectorToArray(game.getValidTargets(this.entity));
        CEntity cEntity = this;
        int n2 = 0;
        while (n2 < objectArray.length) {
            entityState = (EntityState)objectArray[n2];
            entityState.setState();
            entityState.damages = new double[objectArray2.length];
            entityState.threats = new double[objectArray2.length];
            entityState.max_threats = new double[objectArray2.length];
            entityState.min_damages = new double[objectArray2.length];
            n = 0;
            while (n < objectArray2.length) {
                double d;
                int n3;
                Entity entity = (Entity)objectArray2[n];
                CEntity cEntity2 = TestBot.enemies.get(entity);
                int n4 = Compute.getThreatHitArc(cEntity2.old.curPos, cEntity2.old.curFacing, entityState.curPos);
                int n5 = Compute.getThreatHitArc(entityState.curPos, entityState.curFacing, cEntity2.old.curPos);
                int[] nArray = entityState.getModifiers(cEntity2.entity);
                if (!cEntity2.entity.isImmobile() && nArray[1] != Integer.MAX_VALUE) {
                    cEntity.engaged = true;
                    n3 = nArray[1];
                    d = entityState.getMaxModifiedDamage(cEntity2.old, TestBot.enemies.get(entity), n3, nArray[3]);
                    if (entity.isSelectable()) {
                        cEntity2.old.curFacing = (cEntity2.old.curFacing + 1) % 6;
                        d = Math.max(entityState.getMaxModifiedDamage(cEntity2.old, TestBot.enemies.get(entity), n3 + 1, nArray[3]), d);
                        cEntity2.old.curFacing = (cEntity2.old.curFacing + 4) % 6;
                        d = Math.max(entityState.getMaxModifiedDamage(cEntity2.old, TestBot.enemies.get(entity), n3 + 1, nArray[3]), d);
                        cEntity2.old.curFacing = (cEntity2.old.curFacing + 1) % 6;
                    }
                    d = cEntity.getThreatUtility(d, n5);
                    if (cEntity2.entity.isProne()) {
                        d *= 0.6;
                    }
                    entityState.threats[n] = d;
                    entityState.max_threats[n] = d;
                    entityState.threat += d;
                }
                if (Compute.getThreatHitArc(entityState.curPos, entityState.curFacing, cEntity2.entity.getPosition()) != 0) {
                    n3 = Compute.getFiringAngle(entityState.curPos, entityState.curFacing, cEntity2.entity.getPosition());
                    entityState.movement_threat += (double)(cEntity2.bv / 500) * (1.0 - (double)Math.abs(180 - n3) / 180.0);
                }
                if (!entityState.isPhysical) {
                    if (nArray[0] != Integer.MAX_VALUE) {
                        cEntity.engaged = true;
                        double d2 = cEntity2.old.getMaxModifiedDamage(entityState, cEntity, nArray[0], nArray[2]);
                        entityState.damages[n] = d2 = cEntity2.getThreatUtility(d2, n4);
                        entityState.min_damages[n] = d2;
                        entityState.damage = Math.max(d2, entityState.damage);
                    }
                } else {
                    try {
                        if (entityState.PhysicalTarget.entity.getId() == cEntity2.entity.getId()) {
                            if (!entityState.PhysicalTarget.isPhysicalTarget) {
                                ToHitData toHitData = null;
                                d = 0.0;
                                double d3 = 0.0;
                                if (entityState.isJumping) {
                                    toHitData = megamek.common.Compute.toHitDfa(game, entityState.entity.getId(), entityState.PhysicalTarget.entity.getId(), entityState.curPos);
                                    d3 = 2 * megamek.common.Compute.getDfaDamageFor(entityState.entity);
                                    d = entityState.centity.getThreatUtility(megamek.common.Compute.getDfaDamageTakenBy(entityState.entity), 1) * megamek.common.Compute.oddsAbove(toHitData.getValue()) / 100.0;
                                    d += entityState.centity.getThreatUtility(0.1 * (double)cEntity.entity.getWeight(), 1) * (1.0 - cEntity.base_psr_odds);
                                } else {
                                    cEntity.old.setState();
                                    MovementData movementData = entityState.getMovementData();
                                    toHitData = megamek.common.Compute.toHitCharge(game, entityState.entity.getId(), entityState.PhysicalTarget.entity.getId(), movementData);
                                    d3 = megamek.common.Compute.getChargeDamageFor(entityState.entity, movementData.getHexesMoved());
                                    d = entityState.centity.getThreatUtility(megamek.common.Compute.getChargeDamageTakenBy(entityState.entity, entityState.PhysicalTarget.entity), 0) * (1.0 - megamek.common.Compute.oddsAbove(toHitData.getValue()) / 100.0);
                                    entityState.setState();
                                }
                                entityState.damages[n] = d3 = Math.sqrt(entityState.PhysicalTarget.bv / cEntity.bv) * entityState.PhysicalTarget.getThreatUtility(d3, toHitData.getSideTable()) * megamek.common.Compute.oddsAbove(toHitData.getValue()) / 100.0;
                                entityState.min_damages[n] = d3;
                                entityState.damage = d3;
                                entityState.threat += d;
                            } else {
                                entityState.threat += 2.147483647E9;
                            }
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        entityState.threat += 2.147483647E9;
                    }
                }
                ++n;
            }
            cEntity.old.setState();
            ++n2;
        }
        Arrays.sort((Object[])objectArray);
        Arrays.sort((Object[])objectArray, (Comparator)new Comparator(){

            public int compare(Object object, Object object2) {
                if (((EntityState)object).damage - 0.5 * ((EntityState)object).getUtility() > ((EntityState)object2).damage - 0.5 * ((EntityState)object2).getUtility()) {
                    return -1;
                }
                return 1;
            }
        });
        entityState = new Vector();
        n = 0;
        while (n < objectArray.length) {
            entityState.add(objectArray[n]);
            ++n;
        }
        this.CounterMoves = entityState;
        return entityState;
    }

    public Vector findMoves(Coords coords) {
        Object object;
        if (this.moves == null) {
            this.calculateCounterMoves();
        }
        String string = coords.toString();
        Vector vector = new Vector();
        if (this.jump_hexes != null && (object = this.jump_hexes.get(string)) != null) {
            vector.add(object);
        }
        if (this.run_walk_moves != null) {
            int n = 0;
            while (n < 6) {
                object = this.run_walk_moves.get(string + " " + n);
                if (object != null) {
                    vector.add(object);
                }
                ++n;
            }
        }
        return vector;
    }

    public double getModifiedDamage(int n, int n2, int n3) {
        if (n2 > 24) {
            return 0.0;
        }
        double d = this.damages[n][n2];
        int n4 = this.gunnery;
        int n5 = 0;
        n5 = n2 < 7 ? this.MinRanges[n2] : (n2 < 13 ? 2 : (n2 < 24 ? 4 : 20));
        if (n4 + n5 + n3 > TestBot.Ignore) {
            return 0.0;
        }
        if (n4 + n5 + n3 == TestBot.Ignore) {
            d *= 0.5;
        }
        return d / megamek.common.Compute.oddsAbove(n4 + n5) * megamek.common.Compute.oddsAbove(n5 + n3 + n4);
    }

    static class Table
    extends Hashtable {
        Table() {
        }

        public void put(CEntity cEntity) {
            this.put(cEntity.getKey(), cEntity);
        }

        public CEntity get(Entity entity) {
            CEntity cEntity = null;
            cEntity = (CEntity)super.get((Object)new Integer(entity.getId()));
            if (cEntity == null) {
                cEntity = new CEntity(entity);
                this.put(cEntity);
            }
            cEntity.refresh();
            return cEntity;
        }

        public CEntity remove(CEntity cEntity) {
            return (CEntity)super.remove((Object)cEntity.getKey());
        }
    }
}

