/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.bot;

import java.awt.Frame;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import megamek.client.AlertDialog;
import megamek.client.Client;
import megamek.client.DeploymentDisplay;
import megamek.client.FiringDisplay;
import megamek.client.GameEvent;
import megamek.client.MovementDisplay;
import megamek.client.PhysicalDisplay;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.Game;
import megamek.common.Hex;
import megamek.common.Infantry;
import megamek.common.Mounted;
import megamek.common.MovementData;
import megamek.common.ToHitData;
import megamek.common.WeaponType;
import megamek.common.actions.AbstractAttackAction;
import megamek.common.actions.KickAttackAction;
import megamek.common.actions.PunchAttackAction;
import megamek.common.actions.WeaponAttackAction;

public class BotClient
extends Client {
    protected int turnInfMoved = 0;

    public BotClient(Frame frame, String string) {
        super(frame, string);
    }

    public BotClient(String string) {
        super(string);
    }

    protected void changePhase(int n) {
        super.changePhase(n);
        switch (n) {
            case 1: {
                this.notifyOfBot();
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                this.sendReady(true);
            }
        }
    }

    private void notifyOfBot() {
        new AlertDialog(this.frame, "Please read the ai-readme.txt", "The bot does not work with all units or game options.  Please read the ai-readme.txt file before using the bot.").show();
        this.sendChat("Hi, I'm a bot client!");
    }

    protected void processGameEvent(GameEvent gameEvent) {
        super.processGameEvent(gameEvent);
        switch (gameEvent.getType()) {
            case 3: {
                break;
            }
            case 2: {
                break;
            }
            case 4: {
                this.turnInfMoved = 0;
                break;
            }
            case 5: {
                if (!this.isMyTurn()) break;
                this.calculateMyTurn();
                break;
            }
            case 6: {
                break;
            }
        }
    }

    protected void calculateMyTurn() {
        if (this.curPanel instanceof MovementDisplay) {
            this.calculateMoveTurn();
        } else if (this.curPanel instanceof FiringDisplay) {
            this.calculateFiringTurn();
        } else if (this.curPanel instanceof PhysicalDisplay) {
            this.calculatePhysicalTurn();
        } else if (this.curPanel instanceof DeploymentDisplay) {
            this.calculateDeployment();
        }
    }

    private void calculateDeployment() {
        int n = this.game.getFirstEntityNum(this.getLocalPlayer());
        Coords coords = this.getStartingCoords(this.getLocalPlayer().getStartingPos());
        Coords coords2 = this.getCoordsAround(coords);
        Coords coords3 = new Coords(this.game.board.width / 2, this.game.board.height / 2);
        int n2 = this.getLocalPlayer().getStartingPos() != 0 ? coords2.direction(coords3) : coords3.direction(coords2);
        this.deploy(n, coords2, n2);
        this.sendReady(true);
    }

    private Coords getCoordsAround(Coords coords) {
        if (this.game.board.contains(coords) && this.game.getFirstEntity(coords) == null) {
            return coords;
        }
        int n = 0;
        while (n < 6) {
            Coords coords2 = coords.translated(n);
            if (this.game.board.contains(coords2) && this.game.getFirstEntity(coords2) == null) {
                return coords2;
            }
            ++n;
        }
        return this.getCoordsAround(coords.translated(Compute.random.nextInt(6)));
    }

    private Coords getStartingCoords(int n) {
        switch (n) {
            default: {
                return new Coords(this.game.board.width / 2, this.game.board.height / 2);
            }
            case 1: {
                return new Coords(1, 1);
            }
            case 2: {
                return new Coords(this.game.board.width / 2, 1);
            }
            case 3: {
                return new Coords(this.game.board.width - 2, 1);
            }
            case 4: {
                return new Coords(this.game.board.width - 2, this.game.board.height / 2);
            }
            case 5: {
                return new Coords(this.game.board.width - 2, this.game.board.height - 2);
            }
            case 6: {
                return new Coords(this.game.board.width / 2, this.game.board.height - 2);
            }
            case 7: {
                return new Coords(1, this.game.board.height - 2);
            }
            case 8: 
        }
        return new Coords(1, this.game.board.height / 2);
    }

    public void calculatePhysicalTurn() {
        int n;
        int n2 = n = this.game.getFirstEntityNum(this.getLocalPlayer());
        do {
            Entity entity;
            PhysicalOption physicalOption;
            if ((physicalOption = this.getBestPhysical(entity = this.game.getEntity(n))) == null) continue;
            Vector<AbstractAttackAction> vector = new Vector<AbstractAttackAction>();
            vector.addElement(physicalOption.toAction(this.game, n));
            this.sendAttackData(n, vector);
            this.sendEntityReady(n);
            this.sendReady(true);
            return;
        } while ((n = this.game.getNextEntityNum(this.getLocalPlayer(), n)) != -1 && n != n2);
    }

    public PhysicalOption getBestPhysical(Entity entity) {
        boolean bl = false;
        if (entity instanceof Infantry) {
            return null;
        }
        if (entity.isCharging() || entity.isMakingDfa()) {
            return null;
        }
        PhysicalOption physicalOption = null;
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            PhysicalOption physicalOption2;
            Entity entity2 = (Entity)enumeration.nextElement();
            if (entity2.equals(entity) || !entity2.isEnemyOf(entity) || (physicalOption2 = this.getBestPhysicalAttack(this.game.getEntityID(entity), this.game.getEntityID(entity2))) == null) continue;
            if (physicalOption == null) {
                physicalOption = physicalOption2;
                continue;
            }
            if (!(physicalOption2.expectedDmg > physicalOption.expectedDmg)) continue;
            physicalOption = physicalOption2;
        }
        return physicalOption;
    }

    protected PhysicalOption getBestPhysicalAttack(int n, int n2) {
        Hex hex;
        double d;
        int n3;
        Entity entity = this.game.getEntity(n2);
        Entity entity2 = this.game.getEntity(n);
        double d2 = 0.0;
        int n4 = 1;
        if (entity2 instanceof Infantry) {
            return null;
        }
        ToHitData toHitData = Compute.toHitPunch(this.game, n, n2, 1);
        if (toHitData.getValue() != Integer.MAX_VALUE) {
            n3 = Compute.getPunchDamageFor(entity2, 1);
            d2 = Compute.oddsAbove(toHitData.getValue()) / 100.0 * (double)n3;
        }
        if ((toHitData = Compute.toHitPunch(this.game, n, n2, 2)).getValue() != Integer.MAX_VALUE) {
            n3 = Compute.getPunchDamageFor(entity2, 2);
            d = Compute.oddsAbove(toHitData.getValue()) / 100.0 * (double)n3;
            if (d > 0.0 && d2 > 0.0) {
                n4 = 3;
                d2 += d;
            } else {
                n4 = 2;
                d2 = d;
            }
        }
        if ((toHitData = Compute.toHitKick(this.game, n, n2, 1)).getValue() != Integer.MAX_VALUE) {
            n3 = Compute.getKickDamageFor(entity2, 1);
            d = Compute.oddsAbove(toHitData.getValue()) / 100.0 * (double)n3;
            if (d > d2) {
                n4 = 4;
                d2 = d;
            }
        }
        if ((toHitData = Compute.toHitKick(this.game, n, n2, 2)).getValue() != Integer.MAX_VALUE) {
            n3 = Compute.getKickDamageFor(entity2, 2);
            d = Compute.oddsAbove(toHitData.getValue()) / 100.0 * (double)n3;
            if (d > d2) {
                n4 = 5;
                d2 = d;
            }
        }
        if (entity instanceof Infantry && !(hex = this.game.getBoard().getHex(entity.getPosition())).contains(1) && !hex.contains(10)) {
            d2 *= 2.0;
        }
        if (d2 > 0.0) {
            return new PhysicalOption(entity, d2, n4);
        }
        return null;
    }

    public void calculateMoveTurn() {
        int n;
        int n2 = n = this.game.getFirstEntityNum(this.getLocalPlayer());
        boolean bl = this.game.getOptions().booleanOption("inf_move_last");
        boolean bl2 = this.game.getOptions().booleanOption("inf_move_multi");
        MoveOption moveOption = null;
        int n3 = -1;
        do {
            if (bl2 && this.turnInfMoved % 3 > 0 && !(this.game.getEntity(n) instanceof Infantry)) {
                if (this.game.hasInfantry(this.local_pn)) {
                    n = this.game.getNextEntityNum(this.getLocalPlayer(), n);
                    continue;
                }
                this.turnInfMoved = 0;
            } else if (bl && this.turnInfMoved == 0 && this.game.getEntity(n) instanceof Infantry) {
                int n4 = this.game.getNextEntityNum(this.getLocalPlayer(), n);
                while (n4 != n) {
                    if (!(this.game.getEntity(n4) instanceof Infantry)) {
                        n = n4;
                        break;
                    }
                    n4 = this.game.getNextEntityNum(this.getLocalPlayer(), n4);
                }
            }
            MoveOption moveOption2 = this.calculateBestMove(n);
            this.sendChat("Could move " + this.game.getEntity(n).getShortName() + " with " + moveOption2.moves + ": dmg " + moveOption2.damagePotential + ", threat " + moveOption2.threat);
            if (moveOption == null) {
                moveOption = moveOption2;
                n3 = n;
            } else if (Math.abs(moveOption2.value()) < Math.abs(moveOption.value())) {
                moveOption = moveOption2;
                n3 = n;
            }
            n = this.game.getNextEntityNum(this.getLocalPlayer(), n);
        } while (n != -1 && n != n2);
        if (this.game.getEntity(n3) instanceof Infantry) {
            ++this.turnInfMoved;
        }
        this.sendChat("Move " + this.game.getEntity(n3).getShortName() + ": " + moveOption.moves);
        this.moveEntity(n3, moveOption.moves);
        this.sendReady(true);
    }

    protected MoveOption calculateBestMove(int n) {
        Vector vector = this.calculateMoveOptions(n);
        MoveOption moveOption = null;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            MoveOption moveOption2 = (MoveOption)enumeration.nextElement();
            if (moveOption == null) {
                moveOption = moveOption2;
                continue;
            }
            if (!(moveOption2.damagePotential - moveOption2.threat > moveOption.damagePotential - moveOption.threat)) continue;
            moveOption = moveOption2;
        }
        return moveOption;
    }

    protected Vector calculateMoveOptions(int n) {
        Vector vector = new Vector();
        MoveOption moveOption = new MoveOption();
        this.calculateRunWalkMoveOptions(n, vector, moveOption, this.game.getEntity((int)n).mpUsed);
        return vector;
    }

    protected void calculateRunWalkMoveOptions(int n, Vector vector, MoveOption moveOption, int n2) {
        Entity entity = this.game.getEntity(n);
        if (vector.size() > 0 && vector.size() % 200 == 0) {
            this.sendChat("... thinking about my move...");
        }
        entity.moved = n2 >= entity.getRunMP() ? 2 : (n2 > 0 ? 1 : 0);
        moveOption.threat = this.calculateThreat(n);
        moveOption.damagePotential = this.calculateDamagePotential(n);
        vector.addElement(moveOption);
        if (n2 == 0) {
            ++entity.heatBuildup;
        }
        if (n2 < entity.getRunMP()) {
            if (entity.isProne()) {
                MoveOption moveOption2 = new MoveOption(moveOption);
                moveOption2.moves.addStep(5);
                int n3 = entity.getWalkMP() == 1 ? 1 : 2;
                entity.setProne(false);
                this.calculateRunWalkMoveOptions(n, vector, moveOption2, n2 + n3);
                entity.setProne(true);
            } else {
                MoveOption moveOption3;
                int n4;
                Coords coords = entity.getPosition().translated(entity.getFacing());
                if (this.game.board.getHex(coords) != null && n2 + (n4 = Compute.getMovementCostFor(this.game, n, entity.getPosition(), coords, 1)) <= entity.getRunMP() && this.game.getFirstEntity(coords) == null) {
                    moveOption3 = new MoveOption(moveOption);
                    moveOption3.moves.addStep(1);
                    if (n2 <= entity.getWalkMP() && n2 + n4 > entity.getWalkMP()) {
                        ++entity.heatBuildup;
                    }
                    Coords coords2 = entity.getPosition();
                    entity.setPosition(coords);
                    this.calculateRunWalkMoveOptions(n, vector, moveOption3, n2 + n4);
                    entity.setPosition(coords2);
                    if (n2 <= entity.getWalkMP() && n2 + n4 > entity.getWalkMP()) {
                        --entity.heatBuildup;
                    }
                }
                n4 = entity.getFacing();
                moveOption3 = new MoveOption(moveOption);
                entity.setFacing(MovementData.getAdjustedFacing(n4, 3));
                moveOption3.moves.addStep(3);
                this.calculateRunWalkMoveOptions(n, vector, moveOption3, n2 + 1);
                moveOption3 = new MoveOption(moveOption);
                entity.setFacing(MovementData.getAdjustedFacing(n4, 4));
                moveOption3.moves.addStep(4);
                this.calculateRunWalkMoveOptions(n, vector, moveOption3, n2 + 1);
                entity.setFacing(n4);
            }
        }
        if (n2 == 0) {
            --entity.heatBuildup;
        }
    }

    protected double calculateThreat(int n) {
        double d = 0.0;
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            if (!entity.getOwner().isEnemyOf(this.game.getPlayer(this.local_pn))) continue;
            d += this.calculateOneThreat(this.game.getEntityID(entity), n);
        }
        return d;
    }

    protected double calculateOneThreat(int n, int n2) {
        double d = 0.0;
        return d += this.calculateOneWeaponThreat(n, n2);
    }

    protected double calculateOneWeaponThreat(int n, int n2) {
        Entity entity = this.game.getEntity(n);
        Entity entity2 = this.game.getEntity(n2);
        int n3 = entity.getFirstWeapon();
        if (n3 == -1) {
            return 0.0;
        }
        int n4 = n3;
        double d = 0.0;
        do {
            double d2;
            Serializable serializable;
            Mounted mounted = entity.getEquipment(n4);
            ToHitData toHitData = Compute.toHitWeapon(this.game, n, n2, n4, new Vector(0));
            if (toHitData.getValue() == Integer.MAX_VALUE) continue;
            double d3 = Compute.oddsAbove(toHitData.getValue()) / 100.0;
            if (entity instanceof Infantry) {
                serializable = (Infantry)entity;
                d2 = ((Infantry)serializable).getDamage(((Infantry)serializable).getShootingStrength());
            } else {
                d2 = this.getExpectedDamage((WeaponType)mounted.getType());
            }
            if (entity2 instanceof Infantry && !((Hex)(serializable = this.game.getBoard().getHex(entity2.getPosition()))).contains(1) && !((Hex)serializable).contains(10)) {
                d2 *= 2.0;
            }
            d += d3 * d2;
        } while ((n4 = entity.getNextWeapon(n4)) != n3);
        return d;
    }

    public void calculateFiringTurn() {
        Object object;
        int n = this.game.getFirstEntityNum(this.getLocalPlayer());
        Entity entity = this.game.getEntity(n);
        boolean bl = this.game.getOptions().booleanOption("inf_move_last");
        boolean bl2 = this.game.getOptions().booleanOption("inf_move_multi");
        if (bl2 && this.turnInfMoved % 3 > 0 && !(entity instanceof Infantry)) {
            if (this.game.hasInfantry(this.local_pn)) {
                while (!(entity instanceof Infantry)) {
                    n = this.game.getNextEntityNum(this.getLocalPlayer(), n);
                    entity = this.game.getEntity(n);
                }
            } else {
                this.turnInfMoved = 0;
            }
        }
        Vector<FiringOption> vector = new Vector<FiringOption>();
        Enumeration enumeration = entity.getWeapons();
        while (enumeration.hasMoreElements()) {
            object = (Mounted)enumeration.nextElement();
            FiringOption firingOption = this.calculateOneWeaponDamagePotential(n, (Mounted)object);
            if (firingOption == null) continue;
            vector.addElement(firingOption);
        }
        object = new FiringOption[vector.size()];
        vector.copyInto((Object[])object);
        this.sortFiringOptions((FiringOption[])object);
        int n2 = entity.getHeatCapacityWithWater();
        int n3 = entity.heatBuildup;
        int n4 = 5;
        Vector<WeaponAttackAction> vector2 = new Vector<WeaponAttackAction>();
        int n5 = 0;
        while (n5 < ((Object[])object).length) {
            if (n3 + ((WeaponType)((FiringOption)object[n5]).weapon.getType()).getHeat() - n2 <= n4) {
                vector2.addElement(new WeaponAttackAction(n, this.game.getEntityID(((FiringOption)object[n5]).target), entity.getEquipmentNum(((FiringOption)object[n5]).weapon)));
                n3 += ((WeaponType)((FiringOption)object[n5]).weapon.getType()).getHeat();
            }
            ++n5;
        }
        this.sendAttackData(n, vector2);
        this.sendEntityReady(n);
        this.sendReady(true);
    }

    protected void sortFiringOptions(FiringOption[] firingOptionArray) {
        int n = 0;
        while (n < firingOptionArray.length) {
            int n2 = n + 1;
            while (n2 < firingOptionArray.length) {
                if (firingOptionArray[n2].value < firingOptionArray[n].value) {
                    FiringOption firingOption = firingOptionArray[n];
                    firingOptionArray[n] = firingOptionArray[n2];
                    firingOptionArray[n2] = firingOption;
                }
                ++n2;
            }
            ++n;
        }
    }

    protected double calculateDamagePotential(int n) {
        double d = 0.0;
        Entity entity = this.game.getEntity(n);
        entity.setSecondaryFacing(entity.getFacing());
        Enumeration enumeration = entity.getWeapons();
        while (enumeration.hasMoreElements()) {
            Mounted mounted = (Mounted)enumeration.nextElement();
            FiringOption firingOption = this.calculateOneWeaponDamagePotential(n, mounted);
            if (firingOption == null) continue;
            d += firingOption.value;
        }
        return d;
    }

    protected FiringOption calculateOneWeaponDamagePotential(int n, Mounted mounted) {
        Entity entity = this.game.getEntity(n);
        int n2 = entity.getEquipmentNum(mounted);
        Entity entity2 = null;
        double d = 0.0;
        Enumeration enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            double d2;
            Serializable serializable;
            ToHitData toHitData;
            Entity entity3 = (Entity)enumeration.nextElement();
            if (!entity3.getOwner().isEnemyOf(this.game.getPlayer(this.local_pn)) || (toHitData = Compute.toHitWeapon(this.game, n, this.game.getEntityID(entity3), n2, new Vector(0))).getValue() == Integer.MAX_VALUE) continue;
            double d3 = Compute.oddsAbove(toHitData.getValue()) / 100.0;
            if (entity instanceof Infantry) {
                serializable = (Infantry)entity;
                d2 = ((Infantry)serializable).getDamage(((Infantry)serializable).getShootingStrength());
            } else {
                d2 = this.getExpectedDamage((WeaponType)mounted.getType());
            }
            if (entity3 instanceof Infantry && !((Hex)(serializable = this.game.getBoard().getHex(entity3.getPosition()))).contains(1) && !((Hex)serializable).contains(10)) {
                d2 *= 2.0;
            }
            if (!((d2 = d3 * d2) > d)) continue;
            entity2 = entity3;
            d = d2;
        }
        if (entity2 == null) {
            return null;
        }
        return new FiringOption(entity2, d, mounted);
    }

    protected double getExpectedDamage(WeaponType weaponType) {
        if (weaponType.getDamage() != -2) {
            return weaponType.getDamage();
        }
        if (weaponType.getAmmoType() == 9) {
            switch (weaponType.getRackSize()) {
                case 2: {
                    return 2.83332;
                }
                case 4: {
                    return 5.27776;
                }
                case 6: {
                    return 8.0;
                }
            }
        } else {
            switch (weaponType.getRackSize()) {
                case 5: {
                    return 3.16666;
                }
                case 10: {
                    return 6.30555;
                }
                case 15: {
                    return 9.5;
                }
                case 20: {
                    return 12.69444;
                }
            }
        }
        return 0.0;
    }

    public static class PhysicalOption {
        public static final int PUNCH_LEFT = 1;
        public static final int PUNCH_RIGHT = 2;
        public static final int PUNCH_BOTH = 3;
        public static final int KICK_LEFT = 4;
        public static final int KICK_RIGHT = 5;
        public Entity target;
        public double expectedDmg;
        public int type;

        public PhysicalOption(Entity entity, double d, int n) {
            this.target = entity;
            this.expectedDmg = d;
            this.type = n;
        }

        public AbstractAttackAction toAction(Game game, int n) {
            switch (this.type) {
                case 1: {
                    return new PunchAttackAction(n, game.getEntityID(this.target), 1);
                }
                case 2: {
                    return new PunchAttackAction(n, game.getEntityID(this.target), 2);
                }
                case 3: {
                    return new PunchAttackAction(n, game.getEntityID(this.target), 0);
                }
                case 4: {
                    return new KickAttackAction(n, game.getEntityID(this.target), 1);
                }
                case 5: {
                    return new KickAttackAction(n, game.getEntityID(this.target), 2);
                }
            }
            return null;
        }
    }

    public static class FiringOption {
        public Entity target;
        public double value;
        public Mounted weapon;

        public FiringOption(Entity entity, double d, Mounted mounted) {
            this.target = entity;
            this.value = d;
            this.weapon = mounted;
        }
    }

    public static class MoveOption {
        public MovementData moves;
        public double threat;
        public double damagePotential;

        public MoveOption() {
            this.moves = new MovementData();
        }

        public MoveOption(MoveOption moveOption) {
            this.moves = new MovementData(moveOption.moves);
        }

        public double value() {
            return this.damagePotential - this.threat;
        }
    }
}

