/*
 * Decompiled with CFR 0.152.
 */
package megamek.client;

import java.awt.Button;
import java.awt.Choice;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Vector;
import megamek.client.Client;
import megamek.common.AmmoType;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.Mounted;
import megamek.common.WeaponType;

class WeaponPanel
extends Panel
implements ItemListener {
    public List weaponList;
    public Choice m_chAmmo;
    public Panel displayP;
    public Panel rangeP;
    public Panel targetP;
    public Panel buttonP;
    public Label wAmmo;
    public Label wNameL;
    public Label wHeatL;
    public Label wDamL;
    public Label wMinL;
    public Label wShortL;
    public Label wMedL;
    public Label wLongL;
    public Label wNameR;
    public Label wHeatR;
    public Label wDamR;
    public Label wMinR;
    public Label wShortR;
    public Label wMedR;
    public Label wLongR;
    public Label wTargetL;
    public Label wRangeL;
    public Label wToHitL;
    public Label wTargetR;
    public Label wRangeR;
    public Label wToHitR;
    public TextArea toHitText;
    public Button ammoB;
    private Vector weapons;
    private Vector vAmmo;
    private Entity entity;
    private Client client;

    public WeaponPanel(Client client) {
        super(new GridBagLayout());
        this.client = client;
        this.weaponList = new List(4, false);
        this.weaponList.addItemListener(this);
        this.wAmmo = new Label("Ammo", 0);
        this.m_chAmmo = new Choice();
        this.m_chAmmo.addItemListener(this);
        Panel panel = new Panel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        ((GridBagLayout)panel.getLayout()).setConstraints(this.wAmmo, gridBagConstraints);
        panel.add(this.wAmmo);
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        ((GridBagLayout)panel.getLayout()).setConstraints(this.m_chAmmo, gridBagConstraints);
        panel.add(this.m_chAmmo);
        this.wNameL = new Label("Name", 0);
        this.wHeatL = new Label("Heat", 1);
        this.wDamL = new Label("Damage", 1);
        this.wNameR = new Label("", 0);
        this.wHeatR = new Label("--", 1);
        this.wDamR = new Label("--", 1);
        this.displayP = new Panel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        ((GridBagLayout)this.displayP.getLayout()).setConstraints(this.wNameL, gridBagConstraints);
        this.displayP.add(this.wNameL);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        ((GridBagLayout)this.displayP.getLayout()).setConstraints(this.wHeatL, gridBagConstraints);
        this.displayP.add(this.wHeatL);
        gridBagConstraints.gridwidth = 0;
        ((GridBagLayout)this.displayP.getLayout()).setConstraints(this.wDamL, gridBagConstraints);
        this.displayP.add(this.wDamL);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        ((GridBagLayout)this.displayP.getLayout()).setConstraints(this.wNameR, gridBagConstraints);
        this.displayP.add(this.wNameR);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        ((GridBagLayout)this.displayP.getLayout()).setConstraints(this.wHeatR, gridBagConstraints);
        this.displayP.add(this.wHeatR);
        gridBagConstraints.gridwidth = 0;
        ((GridBagLayout)this.displayP.getLayout()).setConstraints(this.wDamR, gridBagConstraints);
        this.displayP.add(this.wDamR);
        this.wMinL = new Label("Min", 1);
        this.wShortL = new Label("Short", 1);
        this.wMedL = new Label("Med", 1);
        this.wLongL = new Label("Long", 1);
        this.wMinR = new Label("---", 1);
        this.wShortR = new Label("---", 1);
        this.wMedR = new Label("---", 1);
        this.wLongR = new Label("---", 1);
        this.rangeP = new Panel(new GridLayout(2, 4));
        this.rangeP.add(this.wMinL);
        this.rangeP.add(this.wShortL);
        this.rangeP.add(this.wMedL);
        this.rangeP.add(this.wLongL);
        this.rangeP.add(this.wMinR);
        this.rangeP.add(this.wShortR);
        this.rangeP.add(this.wMedR);
        this.rangeP.add(this.wLongR);
        this.wTargetL = new Label("Target:");
        this.wRangeL = new Label("Range:");
        this.wToHitL = new Label("To Hit:");
        this.wTargetR = new Label("---");
        this.wRangeR = new Label("---");
        this.wToHitR = new Label("---");
        this.targetP = new Panel(new GridLayout(3, 2));
        this.targetP.add(this.wTargetL);
        this.targetP.add(this.wTargetR);
        this.targetP.add(this.wRangeL);
        this.targetP.add(this.wRangeR);
        this.targetP.add(this.wToHitL);
        this.targetP.add(this.wToHitR);
        this.toHitText = new TextArea("", 4, 20, 1);
        this.toHitText.setEditable(false);
        this.ammoB = new Button("Change Ammo");
        this.ammoB.setEnabled(false);
        this.buttonP = new Panel();
        this.buttonP.add(this.ammoB);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        ((GridBagLayout)this.getLayout()).setConstraints(this.weaponList, gridBagConstraints);
        this.add(this.weaponList);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        ((GridBagLayout)this.getLayout()).setConstraints(panel, gridBagConstraints);
        this.add(panel);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        ((GridBagLayout)this.getLayout()).setConstraints(this.displayP, gridBagConstraints);
        this.add(this.displayP);
        ((GridBagLayout)this.getLayout()).setConstraints(this.rangeP, gridBagConstraints);
        this.add(this.rangeP);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        ((GridBagLayout)this.getLayout()).setConstraints(this.targetP, gridBagConstraints);
        this.add(this.targetP);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        ((GridBagLayout)this.getLayout()).setConstraints(this.toHitText, gridBagConstraints);
        this.add(this.toHitText);
    }

    public void displayMech(Entity entity) {
        this.weapons = entity.getWeaponList();
        this.entity = entity;
        this.weaponList.removeAll();
        this.m_chAmmo.removeAll();
        this.m_chAmmo.setEnabled(false);
        int n = 0;
        while (n < this.weapons.size()) {
            Mounted mounted = (Mounted)this.weapons.elementAt(n);
            WeaponType weaponType = (WeaponType)mounted.getType();
            String string = mounted.getDesc() + " [" + entity.getLocationAbbr(mounted.getLocation()) + "]";
            if (weaponType.getAmmoType() != -1) {
                int n2 = 0;
                if (mounted.getLinked() != null && !mounted.getLinked().isDumping()) {
                    n2 = mounted.getLinked().getShotsLeft();
                }
                EquipmentType equipmentType = mounted.getLinked() == null ? null : mounted.getLinked().getType();
                int n3 = this.entity.getTotalAmmoOfType(equipmentType);
                string = string + " (" + n2 + "/" + n3 + ")";
                if (weaponType.hasModes()) {
                    string = string + " " + mounted.curMode();
                }
            }
            this.weaponList.add(string);
            ++n;
        }
    }

    public void selectWeapon(int n) {
        if (n == -1) {
            this.weaponList.select(-1);
            return;
        }
        int n2 = this.weapons.indexOf(this.entity.getEquipment(n));
        this.weaponList.select(n2);
        this.displaySelected();
    }

    public int getSelectedWeaponNum() {
        int n = this.weaponList.getSelectedIndex();
        if (n == -1) {
            return -1;
        }
        return this.entity.getEquipmentNum((Mounted)this.weapons.elementAt(n));
    }

    public void displaySelected() {
        if (this.weaponList.getSelectedIndex() == -1) {
            this.m_chAmmo.removeAll();
            this.m_chAmmo.setEnabled(false);
            this.wNameR.setText("");
            this.wHeatR.setText("--");
            this.wDamR.setText("--");
            this.wMinR.setText("---");
            this.wShortR.setText("---");
            this.wMedR.setText("---");
            this.wLongR.setText("---");
            return;
        }
        Mounted mounted = (Mounted)this.weapons.elementAt(this.weaponList.getSelectedIndex());
        WeaponType weaponType = (WeaponType)mounted.getType();
        this.wNameR.setText(mounted.getDesc());
        this.wHeatR.setText(weaponType.getHeat() + "");
        if (weaponType.getDamage() == -2) {
            this.wDamR.setText("Missile");
        } else if (weaponType.getDamage() == -3) {
            this.wDamR.setText("Variable");
        } else {
            this.wDamR.setText(new Integer(weaponType.getDamage()).toString());
        }
        if (weaponType.getMinimumRange() > 0) {
            this.wMinR.setText(Integer.toString(weaponType.getMinimumRange()));
        } else {
            this.wMinR.setText("---");
        }
        if (weaponType.getShortRange() > 1) {
            this.wShortR.setText("1 - " + weaponType.getShortRange());
        } else {
            this.wShortR.setText("" + weaponType.getShortRange());
        }
        if (weaponType.getMediumRange() - weaponType.getShortRange() > 1) {
            this.wMedR.setText(weaponType.getShortRange() + 1 + " - " + weaponType.getMediumRange());
        } else {
            this.wMedR.setText("" + weaponType.getMediumRange());
        }
        if (weaponType.getLongRange() - weaponType.getMediumRange() > 1) {
            this.wLongR.setText(weaponType.getMediumRange() + 1 + " - " + weaponType.getLongRange());
        } else {
            this.wLongR.setText("" + weaponType.getLongRange());
        }
        boolean bl = this.client.getLocalPlayer() == this.entity.getOwner();
        this.m_chAmmo.removeAll();
        if (weaponType.getAmmoType() == -1 || !bl) {
            this.m_chAmmo.setEnabled(false);
        } else {
            this.m_chAmmo.setEnabled(true);
            this.vAmmo = new Vector();
            int n = -1;
            int n2 = 0;
            Enumeration enumeration = this.entity.getAmmo();
            while (enumeration.hasMoreElements()) {
                Mounted mounted2 = (Mounted)enumeration.nextElement();
                AmmoType ammoType = (AmmoType)mounted2.getType();
                if (mounted2.isDestroyed() || mounted2.getShotsLeft() <= 0 || mounted2.isDumping() || ammoType.getAmmoType() != weaponType.getAmmoType() || ammoType.getRackSize() != weaponType.getRackSize()) continue;
                this.vAmmo.addElement(mounted2);
                if (mounted.getLinked() == mounted2) {
                    n = n2;
                }
                ++n2;
            }
            int n3 = 0;
            int n4 = this.vAmmo.size();
            while (n3 < n4) {
                this.m_chAmmo.add(this.formatAmmo((Mounted)this.vAmmo.elementAt(n3)));
                ++n3;
            }
            if (n == -1) {
                this.m_chAmmo.setEnabled(false);
            } else {
                this.m_chAmmo.select(n);
            }
        }
    }

    private String formatAmmo(Mounted mounted) {
        StringBuffer stringBuffer = new StringBuffer(64);
        int n = mounted.getDesc().indexOf("Ammo");
        stringBuffer.append("[").append(this.entity.getLocationAbbr(mounted.getLocation())).append("] ");
        if (n == -1) {
            stringBuffer.append(mounted.getDesc());
        } else {
            stringBuffer.append(mounted.getDesc().substring(0, n));
            stringBuffer.append(mounted.getDesc().substring(n + 4));
        }
        return stringBuffer.toString();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getItemSelectable() == this.weaponList) {
            this.displaySelected();
        } else if (itemEvent.getItemSelectable() == this.m_chAmmo) {
            int n = this.weaponList.getSelectedIndex();
            if (n == -1) {
                return;
            }
            Mounted mounted = (Mounted)this.weapons.elementAt(n);
            Mounted mounted2 = (Mounted)this.vAmmo.elementAt(this.m_chAmmo.getSelectedIndex());
            this.entity.loadWeapon(mounted, mounted2);
        }
    }
}

