/*
 * Decompiled with CFR 0.152.
 */
package megamek.client;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import megamek.client.BoardView1;
import megamek.client.Client;
import megamek.client.GameEvent;
import megamek.client.GameListener;
import megamek.common.BoardEvent;
import megamek.common.BoardListener;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.Game;
import megamek.common.Hex;
import megamek.common.Terrain;

public class MiniMap
extends Canvas
implements BoardListener,
MouseListener,
ComponentListener,
GameListener {
    private static final Color[] m_terrainColors = new Color[Terrain.SIZE];
    private Image m_mapImage;
    private BoardView1 m_bview;
    private Game m_game;
    private Dialog m_dialog;
    private int m_nPixWidth = 2;
    private int m_nPixHeight = 2;

    public MiniMap(Dialog dialog, Client client, BoardView1 boardView1) {
        this.m_game = client.game;
        this.m_bview = boardView1;
        this.m_dialog = dialog;
        this.initializeColors();
        this.m_game.board.addBoardListener(this);
        client.addGameListener(this);
        this.addMouseListener(this);
        this.addComponentListener(this);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        if (this.m_mapImage != null) {
            graphics.drawImage(this.m_mapImage, 0, 0, this);
        }
    }

    private void initializeColors() {
        MiniMap.m_terrainColors[0] = Color.orange.darker();
        MiniMap.m_terrainColors[1] = Color.green;
        MiniMap.m_terrainColors[2] = Color.yellow;
        MiniMap.m_terrainColors[3] = Color.orange.darker().darker();
        MiniMap.m_terrainColors[4] = Color.blue;
        MiniMap.m_terrainColors[5] = Color.gray;
        MiniMap.m_terrainColors[6] = Color.orange;
        MiniMap.m_terrainColors[7] = Color.red;
        MiniMap.m_terrainColors[8] = Color.darkGray;
        MiniMap.m_terrainColors[9] = Color.green.darker();
        MiniMap.m_terrainColors[10] = Color.white;
        MiniMap.m_terrainColors[14] = Color.darkGray;
    }

    private void initializeMap() {
        this.m_dialog.show();
        this.m_nPixWidth = this.getSize().width / this.m_game.board.width;
        this.m_nPixHeight = this.getSize().height / this.m_game.board.height;
        this.m_mapImage = this.createImage(Math.max(1, this.getSize().width), Math.max(1, this.getSize().height));
        this.drawMap();
    }

    private void drawMap() {
        if (this.m_mapImage == null) {
            return;
        }
        Graphics graphics = this.m_mapImage.getGraphics();
        int n = 0;
        while (n < this.m_game.board.width) {
            int n2 = 0;
            while (n2 < this.m_game.board.height) {
                graphics.setColor(this.terrainColor(this.m_game.board.getHex(n, n2)));
                this.paintCoord(graphics, n, n2, false);
                ++n2;
            }
            ++n;
        }
        Enumeration enumeration = this.m_game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            if (entity.getPosition() == null) continue;
            graphics.setColor(entity.getOwner().getColor());
            this.paintCoord(graphics, entity.getPosition().x, entity.getPosition().y, true);
        }
        this.repaint();
    }

    private void paintCoord(Graphics graphics, int n, int n2, boolean bl) {
        int n3 = n * this.m_nPixWidth;
        int n4 = n2 * this.m_nPixHeight;
        if (n % 2 == 1) {
            n4 += this.m_nPixHeight / 2;
        }
        graphics.fillRect(n3, n4, this.m_nPixWidth, this.m_nPixHeight);
        if (bl) {
            Color color = graphics.getColor();
            graphics.setColor(Color.white);
            graphics.drawRect(n3, n4, this.m_nPixWidth, this.m_nPixHeight);
            graphics.setColor(color);
        }
    }

    private Color terrainColor(Hex hex) {
        int n = m_terrainColors.length - 1;
        while (n >= 0) {
            if (hex.getTerrain(n) != null && m_terrainColors[n] != null) {
                return m_terrainColors[n];
            }
            --n;
        }
        return m_terrainColors[0];
    }

    private Coords translateCoords(int n, int n2) {
        int n3 = n / this.m_nPixWidth;
        int n4 = n2 / this.m_nPixHeight;
        if (n3 >= this.m_game.board.width) {
            n3 = this.m_game.board.width - 1;
        }
        if (n4 >= this.m_game.board.height) {
            n4 = this.m_game.board.height - 1;
        }
        return new Coords(n3, n4);
    }

    public void gamePlayerChat(GameEvent gameEvent) {
    }

    public void gamePlayerStatusChange(GameEvent gameEvent) {
    }

    public void gameTurnChange(GameEvent gameEvent) {
        this.drawMap();
    }

    public void gamePhaseChange(GameEvent gameEvent) {
        this.drawMap();
    }

    public void gameNewEntities(GameEvent gameEvent) {
    }

    public void gameNewSettings(GameEvent gameEvent) {
    }

    public void boardHexMoused(BoardEvent boardEvent) {
    }

    public void boardHexCursor(BoardEvent boardEvent) {
    }

    public void boardHexHighlighted(BoardEvent boardEvent) {
    }

    public void boardHexSelected(BoardEvent boardEvent) {
    }

    public void boardNewBoard(BoardEvent boardEvent) {
        this.initializeMap();
    }

    public void boardChangedHex(BoardEvent boardEvent) {
        this.drawMap();
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.m_bview.centerOnHex(this.translateCoords(mouseEvent.getX(), mouseEvent.getY()));
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.initializeMap();
    }
}

