/*
 * Decompiled with CFR 0.152.
 */
package megamek.client;

import com.sun.java.util.collections.HashMap;
import java.awt.Component;
import java.awt.Image;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import megamek.common.Entity;
import megamek.common.Infantry;
import megamek.common.Tank;

public class MechTileset {
    private String LIGHT_STRING = "default_light";
    private String MEDIUM_STRING = "default_medium";
    private String HEAVY_STRING = "default_heavy";
    private String ASSAULT_STRING = "default_assault";
    private String QUAD_STRING = "default_quad";
    private String TANK_STRING = "default_tank";
    private String INF_STRING = "default_infantry";
    private MechEntry default_light;
    private MechEntry default_medium;
    private MechEntry default_heavy;
    private MechEntry default_assault;
    private MechEntry default_quad;
    private MechEntry default_tank;
    private MechEntry default_inf;
    private HashMap exact = new HashMap();
    private HashMap chassis = new HashMap();

    public Image imageFor(Entity entity, Component component) {
        MechEntry mechEntry = this.entryFor(entity);
        if (mechEntry.getImage() == null) {
            mechEntry.loadImage(component);
        }
        return mechEntry.getImage();
    }

    private MechEntry entryFor(Entity entity) {
        if (this.exact.containsKey((Object)entity.getShortName())) {
            return (MechEntry)this.exact.get((Object)entity.getShortName());
        }
        if (this.chassis.containsKey((Object)entity.getChassis())) {
            return (MechEntry)this.chassis.get((Object)entity.getChassis());
        }
        return this.genericFor(entity);
    }

    public MechEntry genericFor(Entity entity) {
        if (entity.entityIsQuad()) {
            return this.default_quad;
        }
        if (entity instanceof Tank) {
            return this.default_tank;
        }
        if (entity instanceof Infantry) {
            return this.default_inf;
        }
        if (entity.getWeight() <= 35.0f) {
            return this.default_light;
        }
        if (entity.getWeight() <= 55.0f) {
            return this.default_medium;
        }
        if (entity.getWeight() <= 75.0f) {
            return this.default_heavy;
        }
        if (entity.getWeight() <= 100.0f) {
            return this.default_assault;
        }
        throw new IndexOutOfBoundsException("can't find an image for that mech");
    }

    public void loadFromFile(String string) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader("data/mex/" + string));
            StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
            streamTokenizer.eolIsSignificant(true);
            streamTokenizer.commentChar(35);
            streamTokenizer.quoteChar(34);
            streamTokenizer.wordChars(95, 95);
            while (streamTokenizer.nextToken() != -1) {
                String string2 = null;
                String string3 = null;
                if (streamTokenizer.ttype == -3 && streamTokenizer.sval.equalsIgnoreCase("chassis")) {
                    streamTokenizer.nextToken();
                    string2 = streamTokenizer.sval;
                    streamTokenizer.nextToken();
                    string3 = streamTokenizer.sval;
                    this.chassis.put((Object)string2, (Object)new MechEntry(string2, string3));
                    continue;
                }
                if (streamTokenizer.ttype != -3 || !streamTokenizer.sval.equalsIgnoreCase("exact")) continue;
                streamTokenizer.nextToken();
                string2 = streamTokenizer.sval;
                streamTokenizer.nextToken();
                string3 = streamTokenizer.sval;
                this.exact.put((Object)string2, (Object)new MechEntry(string2, string3));
            }
            ((Reader)bufferedReader).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.default_light = (MechEntry)this.exact.get((Object)this.LIGHT_STRING);
        this.default_medium = (MechEntry)this.exact.get((Object)this.MEDIUM_STRING);
        this.default_heavy = (MechEntry)this.exact.get((Object)this.HEAVY_STRING);
        this.default_assault = (MechEntry)this.exact.get((Object)this.ASSAULT_STRING);
        this.default_quad = (MechEntry)this.exact.get((Object)this.QUAD_STRING);
        this.default_tank = (MechEntry)this.exact.get((Object)this.TANK_STRING);
        this.default_inf = (MechEntry)this.exact.get((Object)this.INF_STRING);
    }

    private class MechEntry {
        private String name;
        private String imageFile;
        private Image image;

        public MechEntry(String string, String string2) {
            this.name = string;
            this.imageFile = string2;
            this.image = null;
        }

        public String getName() {
            return this.name;
        }

        public Image getImage() {
            return this.image;
        }

        public void loadImage(Component component) {
            this.image = component.getToolkit().getImage("data/mex/" + this.imageFile);
        }
    }
}

