/*
 * Decompiled with CFR 0.152.
 */
package megamek.client;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;
import megamek.client.Client;
import megamek.common.GameOptions;
import megamek.common.options.GameOption;
import megamek.common.options.OptionGroup;

public class GameOptionsDialog
extends Dialog
implements ActionListener {
    private Client client;
    private GameOptions options;
    private Vector optionComps = new Vector();
    private Panel panOptions = new Panel();
    private ScrollPane scrOptions = new ScrollPane();
    private TextArea texDesc = new TextArea("Mouse over an option to see a description.", 3, 35, 1);
    private Panel panPassword = new Panel();
    private Label labPass = new Label("Password:");
    private TextField texPass = new TextField(15);
    private Panel panButtons = new Panel();
    private Button butOkay = new Button("Okay");
    private Button butCancel = new Button("Cancel");

    public GameOptionsDialog(Client client) {
        super(client.frame, "View/Edit Game Options...", true);
        this.client = client;
        this.options = client.game.getOptions();
        this.scrOptions.add(this.panOptions);
        this.texDesc.setEditable(false);
        this.setupButtons();
        this.setupPassword();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.scrOptions, gridBagConstraints);
        this.add(this.scrOptions);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(this.texDesc, gridBagConstraints);
        this.add(this.texDesc);
        gridBagLayout.setConstraints(this.panPassword, gridBagConstraints);
        this.add(this.panPassword);
        gridBagLayout.setConstraints(this.panButtons, gridBagConstraints);
        this.add(this.panButtons);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ((Component)GameOptionsDialog.this).setVisible(false);
            }
        });
        this.pack();
        ((Component)this).setSize(this.getSize().width, Math.max(this.getSize().height, 400));
        this.setResizable(false);
        ((Component)this).setLocation(client.frame.getLocation().x + client.frame.getSize().width / 2 - this.getSize().width / 2, client.frame.getLocation().y + client.frame.getSize().height / 2 - this.getSize().height / 2);
    }

    public void update(GameOptions gameOptions) {
        this.options = gameOptions;
        this.refreshOptions();
    }

    public void send() {
        Vector<GameOption> vector = new Vector<GameOption>();
        Enumeration enumeration = this.optionComps.elements();
        while (enumeration.hasMoreElements()) {
            OptionComponent optionComponent = (OptionComponent)enumeration.nextElement();
            if (!optionComponent.hasChanged()) continue;
            vector.addElement(optionComponent.changedOption());
        }
        if (vector.size() > 0) {
            this.client.sendGameOptions(this.texPass.getText(), vector);
        }
    }

    private void refreshOptions() {
        this.panOptions.removeAll();
        this.optionComps = new Vector();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.panOptions.setLayout(gridBagLayout);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 1, 0, 0);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        Enumeration enumeration = this.options.groups();
        while (enumeration.hasMoreElements()) {
            OptionGroup optionGroup = (OptionGroup)enumeration.nextElement();
            this.addGroup(optionGroup, gridBagLayout, gridBagConstraints);
            Enumeration enumeration2 = optionGroup.options();
            while (enumeration2.hasMoreElements()) {
                GameOption gameOption = (GameOption)enumeration2.nextElement();
                this.addOption(gameOption, gridBagLayout, gridBagConstraints);
            }
        }
        this.validate();
    }

    private void addGroup(OptionGroup optionGroup, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        Label label = new Label(optionGroup.getName());
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.panOptions.add(label);
    }

    private void addOption(GameOption gameOption, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        OptionComponent optionComponent = new OptionComponent(gameOption);
        gridBagLayout.setConstraints(optionComponent, gridBagConstraints);
        this.panOptions.add(optionComponent);
        this.optionComps.addElement(optionComponent);
    }

    private void showDescFor(GameOption gameOption) {
        this.texDesc.setText(gameOption.getDesc());
    }

    private void setupButtons() {
        this.butOkay.addActionListener(this);
        this.butCancel.addActionListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.panButtons.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.butOkay, gridBagConstraints);
        this.panButtons.add(this.butOkay);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.butCancel, gridBagConstraints);
        this.panButtons.add(this.butCancel);
    }

    private void setupPassword() {
        this.panPassword.setLayout(new BorderLayout());
        this.panPassword.add((Component)this.labPass, "West");
        this.panPassword.add((Component)this.texPass, "Center");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.butOkay) {
            this.send();
        }
        ((Component)this).setVisible(false);
    }

    private class OptionComponent
    extends Panel
    implements MouseListener {
        GameOption option;
        private Checkbox checkbox;
        private TextField textField;
        private Label label;

        public OptionComponent(GameOption gameOption) {
            this.option = gameOption;
            this.addMouseListener(this);
            this.setLayout(new BorderLayout());
            switch (gameOption.getType()) {
                case 0: {
                    this.checkbox = new Checkbox(gameOption.getFullName(), gameOption.booleanValue());
                    this.checkbox.addMouseListener(this);
                    this.add((Component)this.checkbox, "Center");
                    break;
                }
                default: {
                    this.textField = new TextField(gameOption.stringValue(), 2);
                    this.textField.addMouseListener(this);
                    this.add((Component)this.textField, "West");
                    this.label = new Label(gameOption.getFullName());
                    this.label.addMouseListener(this);
                    this.add((Component)this.label, "Center");
                }
            }
        }

        public boolean hasChanged() {
            return !this.option.getValue().equals(this.getValue());
        }

        private Object getValue() {
            switch (this.option.getType()) {
                case 0: {
                    return new Boolean(this.checkbox.getState());
                }
                case 1: {
                    return Integer.valueOf(this.textField.getText());
                }
                case 2: {
                    return Float.valueOf(this.textField.getText());
                }
            }
            return null;
        }

        public GameOption changedOption() {
            return new GameOption(this.option.getShortName(), "", "", this.option.getType(), this.getValue());
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            GameOptionsDialog.this.showDescFor(this.option);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }
    }
}

