/*
 * Decompiled with CFR 0.152.
 */
package megamek.client;

import java.awt.Button;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import megamek.client.AbstractPhaseDisplay;
import megamek.client.Client;
import megamek.client.GameEvent;
import megamek.client.GameListener;
import megamek.common.BoardEvent;
import megamek.common.BoardListener;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.Player;

public class DeploymentDisplay
extends AbstractPhaseDisplay
implements BoardListener,
ActionListener,
KeyListener,
ComponentListener,
MouseListener,
GameListener {
    public Client client;
    private Label statusL;
    private Panel panButtons;
    private Button butNext;
    private Button butTurn;
    private Button butSpace;
    private Button butDone;
    private int cen;
    private boolean turnMode = false;

    public DeploymentDisplay(Client client) {
        this.client = client;
        client.addGameListener(this);
        client.game.board.addBoardListener(this);
        this.statusL = new Label("Waiting to begin Deployment phase...", 1);
        this.butTurn = new Button("Turn");
        this.butTurn.addActionListener(this);
        this.butTurn.setEnabled(false);
        this.butSpace = new Button(".");
        this.butSpace.setEnabled(false);
        this.butNext = new Button("Next Unit");
        this.butNext.addActionListener(this);
        this.butNext.setEnabled(true);
        this.butDone = new Button("Deploy");
        this.butDone.addActionListener(this);
        this.butDone.setEnabled(false);
        this.panButtons = new Panel();
        this.panButtons.setLayout(new GridLayout(2, 2));
        this.panButtons.add(this.butTurn);
        this.panButtons.add(this.butNext);
        this.panButtons.add(this.butSpace);
        this.panButtons.add(this.butDone);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.gridwidth = 0;
        this.addBag(client.bv, gridBagLayout, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        this.addBag(this.statusL, gridBagLayout, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.addBag(client.cb.getComponent(), gridBagLayout, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addBag(this.panButtons, gridBagLayout, gridBagConstraints);
        this.addKeyListener(this);
        client.mechD.addMouseListener(this);
        client.frame.addComponentListener(this);
    }

    private void addBag(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
        component.addKeyListener(this);
    }

    public void selectEntity(int n) {
        if (this.client.game.getEntity(n) == null) {
            System.err.println("DeploymentDisplay: tried to select non-existant entity: " + n);
            System.err.println("DeploymentDisplay: sending ready signal...");
            this.client.sendReady(true);
            return;
        }
        this.cen = n;
        this.butTurn.setEnabled(true);
        this.butDone.setEnabled(false);
        this.client.game.board.select(null);
        this.client.game.board.cursor(null);
        this.client.mechD.displayEntity(this.ce());
        this.client.mechD.showPanel("movement");
    }

    private void beginMyTurn() {
        this.moveMechDisplay();
        ((Component)this.client.mechW).setVisible(true);
        this.selectEntity(this.client.getFirstEntityNum());
        this.butNext.setEnabled(true);
        Player player = this.client.getLocalPlayer();
        if (player.getStartingPos() != 0) {
            this.client.bv.markDeploymentHexesFor(player);
            this.client.bv.repaint(100L);
        }
    }

    private void endMyTurn() {
        this.disableButtons();
        this.cen = -1;
        this.client.game.board.select(null);
        this.client.game.board.highlight(null);
        this.client.game.board.cursor(null);
        ((Component)this.client.mechW).setVisible(false);
        this.client.bv.markDeploymentHexesFor(null);
        this.client.bv.repaint(100L);
    }

    private void disableButtons() {
        this.butTurn.setEnabled(false);
        this.butNext.setEnabled(false);
        this.butDone.setEnabled(false);
    }

    private void deploy() {
        this.disableButtons();
        this.client.deploy(this.cen, this.ce().getPosition(), this.ce().getFacing());
        this.client.sendReady(true);
    }

    private Entity ce() {
        return this.client.game.getEntity(this.cen);
    }

    private void moveMechDisplay() {
        if (!this.client.bv.isShowing()) {
            return;
        }
        ((Component)this.client.mechW).setLocation(this.client.bv.getLocationOnScreen().x + this.client.bv.getSize().width - this.client.mechD.getSize().width - 20, this.client.bv.getLocationOnScreen().y + 20);
    }

    public void boardHexMoused(BoardEvent boardEvent) {
        if (boardEvent.getType() != 2) {
            return;
        }
        if (!this.client.isMyTurn() || this.ce() == null || (boardEvent.getModifiers() & 0x10) == 0) {
            return;
        }
        boolean bl = (boardEvent.getModifiers() & 1) != 0;
        this.client.game.board.select(boardEvent.getCoords());
        Coords coords = boardEvent.getCoords();
        if (this.ce().getPosition() != null && (bl || this.turnMode)) {
            this.ce().setFacing(this.ce().getPosition().direction(coords));
            this.ce().setSecondaryFacing(this.ce().getFacing());
            this.client.bv.redrawEntity(this.ce());
            this.turnMode = false;
        } else {
            if (!this.client.game.board.isLegalDeployment(coords, this.ce().getOwner())) {
                return;
            }
            if (this.client.game.getFirstEntity(coords) != null) {
                return;
            }
            this.ce().setPosition(coords);
            this.client.bv.redrawEntity(this.ce());
            this.butDone.setEnabled(true);
        }
    }

    public void gameTurnChange(GameEvent gameEvent) {
        this.endMyTurn();
        if (this.client.isMyTurn()) {
            this.beginMyTurn();
            this.statusL.setText("It's your turn to deploy.");
        } else {
            this.statusL.setText("It's " + gameEvent.getPlayer().getName() + "'s turn to deploy.");
        }
    }

    public void gamePhaseChange(GameEvent gameEvent) {
        if (this.client.game.phase != 12) {
            if (this.client.isMyTurn()) {
                this.endMyTurn();
            }
            this.client.removeGameListener(this);
            this.client.game.board.removeBoardListener(this);
            this.client.bv.removeKeyListener(this);
            this.client.cb.getComponent().removeKeyListener(this);
            this.client.mechD.removeMouseListener(this);
            this.client.frame.removeComponentListener(this);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.client.isMyTurn()) {
            return;
        }
        if (actionEvent.getSource() == this.butDone) {
            this.deploy();
        } else if (actionEvent.getSource() == this.butNext) {
            this.ce().setPosition(null);
            this.client.bv.redrawEntity(this.ce());
            this.selectEntity(this.client.getNextEntityNum(this.cen));
        } else if (actionEvent.getSource() == this.butTurn) {
            this.turnMode = true;
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
        ((Component)this.client.mechW).setVisible(false);
    }

    public void componentMoved(ComponentEvent componentEvent) {
        this.moveMechDisplay();
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.moveMechDisplay();
    }

    public void componentShown(ComponentEvent componentEvent) {
        ((Component)this.client.mechW).setVisible(false);
        this.moveMechDisplay();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }
}

