/*
 * Decompiled with CFR 0.152.
 */
package megamek.client;

import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import megamek.client.AlertDialog;
import megamek.client.Client;
import megamek.common.Entity;
import megamek.common.Pilot;

public class CustomMechDialog
extends Dialog
implements ActionListener {
    private Label labInstructions = new Label("Edit your pilot's stats here.");
    private Label labName = new Label("Name: ", 2);
    private TextField fldName = new TextField(20);
    private Label labGunnery = new Label("Gunnery: ", 2);
    private TextField fldGunnery = new TextField(3);
    private Label labPiloting = new Label("Piloting: ", 2);
    private TextField fldPiloting = new TextField(3);
    private Label labC3 = new Label("C3 Network: ", 2);
    private Choice choC3 = new Choice();
    private int[] entityCorrespondance;
    private Panel panButtons = new Panel();
    private Button butOkay = new Button("Okay");
    private Button butCancel = new Button("Cancel");
    private Entity entity;
    private boolean okay = false;
    private Client client;

    public CustomMechDialog(Client client, Entity entity, boolean bl) {
        super(client.frame, "Customize pilot/mech stats...", true);
        this.entity = entity;
        this.client = client;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.labName, gridBagConstraints);
        this.add(this.labName);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.fldName, gridBagConstraints);
        this.add(this.fldName);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.labGunnery, gridBagConstraints);
        this.add(this.labGunnery);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.fldGunnery, gridBagConstraints);
        this.add(this.fldGunnery);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.labPiloting, gridBagConstraints);
        this.add(this.labPiloting);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.fldPiloting, gridBagConstraints);
        this.add(this.fldPiloting);
        if (entity.hasC3() || entity.hasC3i()) {
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(this.labC3, gridBagConstraints);
            this.add(this.labC3);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.choC3, gridBagConstraints);
            this.add(this.choC3);
            this.refreshC3();
        }
        this.setupButtons();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.panButtons, gridBagConstraints);
        this.add(this.panButtons);
        this.fldName.setText(entity.getCrew().getName());
        this.fldGunnery.setText(new Integer(entity.getCrew().getGunnery()).toString());
        this.fldPiloting.setText(new Integer(entity.getCrew().getPiloting()).toString());
        if (!bl) {
            this.fldName.setEnabled(false);
            this.fldGunnery.setEnabled(false);
            this.fldPiloting.setEnabled(false);
            this.choC3.setEnabled(false);
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ((Component)CustomMechDialog.this).setVisible(false);
            }
        });
        this.pack();
        this.setResizable(false);
        ((Component)this).setLocation(client.frame.getLocation().x + client.frame.getSize().width / 2 - this.getSize().width / 2, client.frame.getLocation().y + client.frame.getSize().height / 2 - this.getSize().height / 2);
    }

    private void setupButtons() {
        this.butOkay.addActionListener(this);
        this.butCancel.addActionListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.panButtons.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.butOkay, gridBagConstraints);
        this.panButtons.add(this.butOkay);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.butCancel, gridBagConstraints);
        this.panButtons.add(this.butCancel);
    }

    public boolean isOkay() {
        return this.okay;
    }

    private void refreshC3() {
        this.choC3.removeAll();
        int n = 0;
        this.entityCorrespondance = new int[this.client.game.getNoOfEntities() + 2];
        if (this.entity.hasC3i()) {
            this.choC3.add("Create new network (6 free)");
            if (this.entity.getC3Master() == null) {
                this.choC3.select(n);
            }
            this.entityCorrespondance[n++] = this.entity.getId();
        } else if (this.entity.hasC3M()) {
            int n2 = this.entity.calculateFreeC3Nodes();
            this.choC3.add("Set as company-level master (" + n2 + " free)");
            if (this.entity.C3MasterIs(this.entity)) {
                this.choC3.select(n);
            }
            this.entityCorrespondance[n++] = this.entity.getId();
            this.choC3.add("Set as independant master (" + n2 + " free)");
            if (this.entity.getC3Master() == null) {
                this.choC3.select(n);
            }
            this.entityCorrespondance[n++] = -1;
        }
        Enumeration enumeration = this.client.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            if (this.entity.isEnemyOf(entity) || this.entity.equals(entity)) continue;
            int n3 = entity.calculateFreeC3Nodes();
            if (this.entity.C3MasterIs(entity) && !this.entity.equals(entity)) {
                ++n3;
            }
            if (this.entity.hasC3i() && (this.entity.onSameC3NetworkAs(entity) || this.entity.equals(entity))) {
                ++n3;
            }
            if (this.entity.hasC3i() != entity.hasC3i()) {
                n3 = 0;
            }
            if (n3 <= 0) continue;
            if (entity.hasC3i()) {
                if (this.entity.onSameC3NetworkAs(entity)) {
                    this.choC3.add("Join " + entity.getDisplayName() + " [netid " + entity.getC3NetID() + ": " + (n3 - 1) + " free]");
                    this.choC3.select(n);
                } else {
                    this.choC3.add("Join " + entity.getDisplayName() + " (netid " + entity.getC3NetID() + ": " + n3 + " free)");
                }
                this.entityCorrespondance[n++] = entity.getId();
                continue;
            }
            if (entity.C3MasterIs(entity) != this.entity.hasC3M()) continue;
            if (this.entity.C3MasterIs(entity)) {
                this.choC3.add("Connect to " + entity.getDisplayName() + " [" + (n3 - 1) + " free]");
                this.choC3.select(n);
                this.entityCorrespondance[n++] = entity.getId();
                continue;
            }
            this.choC3.add("Connect to " + entity.getDisplayName() + " (" + n3 + " free)");
            this.entityCorrespondance[n++] = entity.getId();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.butOkay) {
            int n;
            int n2;
            String string = this.fldName.getText();
            try {
                n2 = Integer.parseInt(this.fldGunnery.getText());
                n = Integer.parseInt(this.fldPiloting.getText());
            }
            catch (NumberFormatException numberFormatException) {
                new AlertDialog(this.client.frame, "Number Format Error", "Please enter valid numbers for the skill values.").show();
                return;
            }
            if (n2 < 0 || n2 > 7 || n < 0 || n > 7) {
                new AlertDialog(this.client.frame, "Number Format Error", "Please enter values between 0 and 7 for the skill values.").show();
                return;
            }
            this.entity.setCrew(new Pilot(string, n2, n));
            if (this.entity.hasC3() && this.choC3.getSelectedIndex() > -1) {
                this.entity.setC3Master(this.client.getEntity(this.entityCorrespondance[this.choC3.getSelectedIndex()]));
            } else if (this.entity.hasC3i() && this.choC3.getSelectedIndex() > -1) {
                this.entity.setC3NetID(this.client.getEntity(this.entityCorrespondance[this.choC3.getSelectedIndex()]));
            }
            this.okay = true;
        }
        ((Component)this).setVisible(false);
    }
}

