/*
 * Decompiled with CFR 0.152.
 */
package ReversiMonitor;

import Common.boardInfo;
import Common.generalPlayer;
import Common.loc;
import ReversiMonitor.minimax;

public class computerPlayer
extends generalPlayer {
    static int[][] heuristic = new int[][]{{9, 2, 7, 8, 8, 7, 2, 9}, {2, 1, 3, 4, 4, 3, 1, 2}, {7, 3, 6, 5, 5, 6, 3, 7}, {8, 4, 5, 1, 1, 5, 4, 8}, {8, 4, 5, 1, 1, 5, 4, 8}, {7, 3, 6, 5, 5, 6, 3, 7}, {2, 1, 3, 4, 4, 3, 1, 2}, {9, 2, 7, 8, 8, 7, 2, 9}};
    static int heuristicSum = 300;

    public loc getMove(boardInfo b) {
        loc move = new loc(-1, -1);
        if (b.moveCount < 50) {
            String poss = b.getPossibleMoves();
            String[] pl = poss.split(",");
            move.set(pl[0]);
            if (pl.length > 1) {
                minimax alg = new minimax(5 + (b.moveCount > 43 ? b.moveCount - 43 : 0), b.turn, b, pl);
                alg.run();
                float max = -1000.0f;
                int i = 0;
                while (i < alg.moves.length) {
                    if (alg.moves[i] > max) {
                        max = alg.moves[i];
                        move.set(pl[i]);
                    }
                    ++i;
                }
            }
        } else {
            String poss = b.getPossibleMoves();
            String[] pl = poss.split(",");
            move.set(pl[0]);
            if (pl.length > 1) {
                minimax alg = new minimax(10, b.turn, b, pl);
                alg.run();
                float max = -1000.0f;
                int i = 0;
                while (i < alg.moves.length) {
                    if (alg.moves[i] > max) {
                        max = alg.moves[i];
                        move.set(pl[i]);
                    }
                    ++i;
                }
            }
        }
        System.out.println(" => Selected Move for " + b.getTurnString() + " : " + move.getStandardForm());
        return move;
    }

    public String identify() throws Exception {
        return this.getClass().getName();
    }
}

