/*
 * Decompiled with CFR 0.152.
 */
package jchessboard;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.Timer;
import jchessboard.JChessBoard;
import jchessboard.Move;
import jchessboard.VirtualBoard;

class VisualBoard
extends JLayeredPane {
    private static final int FIELDSIZE = 40;
    private static final int MAX = 280;
    private static final int rankLabelWidth = 15;
    private static final int rankLabelHeight = 40;
    private static final int fileLabelWidth = 40;
    private static final int fileLabelHeight = 15;
    private FigureList[] allLists = new FigureList[13];
    private boolean reverseBoard = false;
    private boolean isLocked = false;
    private JLabel[][] background = new JLabel[8][8];
    private JLayeredPane boardPane = new JLayeredPane();
    private JLabel[] rankLabel = new JLabel[16];
    private JLabel[] fileLabel = new JLabel[16];
    protected VirtualBoard virtualBoard = null;
    private boolean isEditorBoard = false;
    private HashMap icons = new HashMap();
    private ActionListener listener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            VisualBoard.this.restoreBackground();
        }
    };
    private Timer restoreBackgroundTimer = new Timer(500, this.listener);
    private JChessBoard jcb;
    static /* synthetic */ Class class$jchessboard$VisualBoard;

    public static String getVersion() {
        return "$Id: VisualBoard.java,v 1.30 2004/12/26 23:12:14 cdivossen Exp $";
    }

    public byte selectPromotion() {
        Object[] objectArray = new Object[4];
        if (this.virtualBoard.isWhiteTurn()) {
            objectArray[0] = (ImageIcon)this.icons.get(new Integer(2));
            objectArray[1] = (ImageIcon)this.icons.get(new Integer(3));
            objectArray[2] = (ImageIcon)this.icons.get(new Integer(4));
            objectArray[3] = (ImageIcon)this.icons.get(new Integer(5));
        } else {
            objectArray[0] = (ImageIcon)this.icons.get(new Integer(8));
            objectArray[1] = (ImageIcon)this.icons.get(new Integer(9));
            objectArray[2] = (ImageIcon)this.icons.get(new Integer(10));
            objectArray[3] = (ImageIcon)this.icons.get(new Integer(11));
        }
        int n = JOptionPane.showOptionDialog(null, "Promote pawn to:", "", 1, 3, null, objectArray, objectArray[0]);
        if (n == 0) {
            return 2;
        }
        if (n == 1) {
            return 3;
        }
        if (n == 2) {
            return 4;
        }
        if (n == 3) {
            return 5;
        }
        return 0;
    }

    public void setLocked(boolean bl) {
        this.isLocked = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        VisualBoard visualBoard = this;
        synchronized (visualBoard) {
            this.virtualBoard = this.jcb.getCurrentVirtualBoard();
            this.redraw();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redraw() {
        this.restoreBackground();
        for (int i = 1; i < this.allLists.length; ++i) {
            this.allLists[i].rewind();
        }
        VirtualBoard virtualBoard = this.virtualBoard;
        synchronized (virtualBoard) {
            int n;
            for (n = 0; n < 8; ++n) {
                for (int i = 0; i < 8; ++i) {
                    int n2 = this.virtualBoard.field[(n << 3) + i];
                    if (n2 == 0) continue;
                    VisualFigure visualFigure = this.allLists[n2].getFigure();
                    this.boardPane.add(visualFigure, new Integer(2), 0);
                    visualFigure.setField(n, i);
                }
            }
            for (n = 1; n < this.allLists.length; ++n) {
                this.allLists[n].hideRest();
            }
        }
    }

    public boolean reverseBoard() {
        return this.reverseBoard;
    }

    public void setReverseBoard(boolean bl) {
        this.reverseBoard = bl;
        this.updateLabels();
        this.redraw();
    }

    public void updateLabels() {
        if (!this.reverseBoard) {
            for (int i = 0; i < 8; ++i) {
                this.rankLabel[i].setText("" + (8 - i));
                this.rankLabel[i + 8].setText("" + (8 - i));
                this.fileLabel[i].setText("" + (char)(97 + i));
                this.fileLabel[i + 8].setText("" + (char)(97 + i));
            }
        } else {
            for (int i = 0; i < 8; ++i) {
                this.rankLabel[7 - i].setText("" + (8 - i));
                this.rankLabel[15 - i].setText("" + (8 - i));
                this.fileLabel[7 - i].setText("" + (char)(97 + i));
                this.fileLabel[15 - i].setText("" + (char)(97 + i));
            }
        }
    }

    public void restoreBackground() {
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                if ((i + j & 1) == 1) {
                    this.background[i][j].setBackground(this.jcb.settings.boardColor1);
                    continue;
                }
                this.background[i][j].setBackground(this.jcb.settings.boardColor2);
            }
        }
    }

    public void showMove(Move move, int n) {
        if (this.reverseBoard) {
            this.background[move.fromRank()][7 - move.fromFile()].setBackground(this.jcb.settings.boardHighlightColor);
            this.background[move.toRank()][7 - move.toFile()].setBackground(this.jcb.settings.boardHighlightColor);
        } else {
            this.background[7 - move.fromRank()][move.fromFile()].setBackground(this.jcb.settings.boardHighlightColor);
            this.background[7 - move.toRank()][move.toFile()].setBackground(this.jcb.settings.boardHighlightColor);
        }
        this.restoreBackgroundTimer.setRepeats(false);
        this.restoreBackgroundTimer.setDelay(n);
        this.restoreBackgroundTimer.restart();
    }

    private void loadIcon(int n, String string) {
        ImageIcon imageIcon;
        String string2 = "/images/" + string;
        URL uRL = (class$jchessboard$VisualBoard == null ? (class$jchessboard$VisualBoard = VisualBoard.class$("jchessboard.VisualBoard")) : class$jchessboard$VisualBoard).getResource(string2);
        ImageIcon imageIcon2 = imageIcon = uRL != null ? new ImageIcon(uRL) : new ImageIcon("null");
        if (imageIcon == null) {
            System.out.println("Could not load image from jar file: " + string + "\n");
            System.exit(-1);
        }
        this.icons.put(new Integer(n), imageIcon);
    }

    private void initialize() {
        Serializable serializable;
        int n;
        this.loadIcon(1, "WK.gif");
        this.loadIcon(2, "WQ.gif");
        this.loadIcon(3, "WR.gif");
        this.loadIcon(4, "WB.gif");
        this.loadIcon(5, "WN.gif");
        this.loadIcon(6, "WP.gif");
        this.loadIcon(7, "BK.gif");
        this.loadIcon(8, "BQ.gif");
        this.loadIcon(9, "BR.gif");
        this.loadIcon(10, "BB.gif");
        this.loadIcon(11, "BN.gif");
        this.loadIcon(12, "BP.gif");
        this.virtualBoard = this.jcb.getCurrentVirtualBoard();
        for (n = 1; n < 13; ++n) {
            this.allLists[n] = new FigureList(n);
        }
        this.setLayout(null);
        this.setBackground(this.jcb.settings.boardBackgroundColor);
        this.setOpaque(true);
        this.add(this.boardPane);
        this.boardPane.setBounds(15, 15, 320, 320);
        for (n = 0; n < 8; ++n) {
            this.rankLabel[n] = new JLabel("" + (8 - n), 0);
            this.add(this.rankLabel[n]);
            this.rankLabel[n].setBounds(0, 15 + n * 40, 15, 40);
            this.rankLabel[n].setForeground(this.jcb.settings.boardLabelColor);
            this.rankLabel[n + 8] = new JLabel("" + (8 - n), 0);
            this.add(this.rankLabel[n + 8]);
            this.rankLabel[n + 8].setBounds(335, 15 + n * 40, 15, 40);
            this.rankLabel[n + 8].setForeground(this.jcb.settings.boardLabelColor);
            this.fileLabel[n] = new JLabel("" + (char)(97 + n), 0);
            this.add(this.fileLabel[n]);
            this.fileLabel[n].setBounds(15 + n * 40, 335, 40, 15);
            this.fileLabel[n].setForeground(this.jcb.settings.boardLabelColor);
            this.fileLabel[n + 8] = new JLabel("" + (char)(97 + n), 0);
            this.add(this.fileLabel[n + 8]);
            this.fileLabel[n + 8].setBounds(15 + n * 40, 0, 40, 15);
            this.fileLabel[n + 8].setForeground(this.jcb.settings.boardLabelColor);
        }
        for (n = 0; n < 8; ++n) {
            for (int i = 0; i < 8; ++i) {
                serializable = new JLabel();
                ((JComponent)serializable).setOpaque(true);
                ((Component)serializable).setBounds(n * 40, i * 40, 40, 40);
                this.boardPane.add((Component)serializable, new Integer(1), 0);
                this.background[i][n] = serializable;
            }
        }
        ImageIcon imageIcon = new ImageIcon((class$jchessboard$VisualBoard == null ? (class$jchessboard$VisualBoard = VisualBoard.class$("jchessboard.VisualBoard")) : class$jchessboard$VisualBoard).getResource("/images/reverse.png"));
        JButton jButton = new JButton(imageIcon);
        this.add(jButton);
        jButton.setForeground(this.jcb.settings.boardLabelColor);
        jButton.setBackground(this.jcb.settings.boardBackgroundColor);
        jButton.setBorder(null);
        jButton.setOpaque(true);
        jButton.setBounds(0, 0, 15, 15);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VisualBoard.this.setReverseBoard(!VisualBoard.this.reverseBoard());
                VisualBoard.this.jcb.updateMenu();
            }
        });
        if (this.isEditorBoard) {
            serializable = new JLabel();
            ((JComponent)serializable).setBackground(new Color(150, 150, 150));
            ((JComponent)serializable).setOpaque(true);
            ((Component)serializable).setBounds(350, 0, 80, 240);
            this.add((Component)serializable, new Integer(1));
            VisualPoolFigure visualPoolFigure = new VisualPoolFigure(1, 350, 0);
            this.add((Component)visualPoolFigure, new Integer(10));
            visualPoolFigure = new VisualPoolFigure(2, 350, 40);
            this.add((Component)visualPoolFigure, new Integer(10));
            visualPoolFigure = new VisualPoolFigure(3, 350, 80);
            this.add((Component)visualPoolFigure, new Integer(10));
            visualPoolFigure = new VisualPoolFigure(4, 350, 120);
            this.add((Component)visualPoolFigure, new Integer(10));
            visualPoolFigure = new VisualPoolFigure(5, 350, 160);
            this.add((Component)visualPoolFigure, new Integer(10));
            visualPoolFigure = new VisualPoolFigure(6, 350, 200);
            this.add((Component)visualPoolFigure, new Integer(10));
            visualPoolFigure = new VisualPoolFigure(7, 390, 0);
            this.add((Component)visualPoolFigure, new Integer(10));
            visualPoolFigure = new VisualPoolFigure(8, 390, 40);
            this.add((Component)visualPoolFigure, new Integer(10));
            visualPoolFigure = new VisualPoolFigure(9, 390, 80);
            this.add((Component)visualPoolFigure, new Integer(10));
            visualPoolFigure = new VisualPoolFigure(10, 390, 120);
            this.add((Component)visualPoolFigure, new Integer(10));
            visualPoolFigure = new VisualPoolFigure(11, 390, 160);
            this.add((Component)visualPoolFigure, new Integer(10));
            visualPoolFigure = new VisualPoolFigure(12, 390, 200);
            this.add((Component)visualPoolFigure, new Integer(10));
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridLayout(3, 1));
            JLabel jLabel = new JLabel("Turn:");
            jPanel.add(jLabel);
            JRadioButton jRadioButton = new JRadioButton("White");
            jRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    VisualBoard.this.virtualBoard.isWhiteTurn = true;
                }
            });
            jRadioButton.setSelected(this.virtualBoard.isWhiteTurn);
            JRadioButton jRadioButton2 = new JRadioButton("Black");
            jRadioButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    VisualBoard.this.virtualBoard.isWhiteTurn = false;
                }
            });
            jRadioButton2.setSelected(!this.virtualBoard.isWhiteTurn);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(jRadioButton);
            buttonGroup.add(jRadioButton2);
            jPanel.add(jRadioButton);
            jPanel.add(jRadioButton2);
            this.add(jPanel);
            jPanel.setBounds(350, 240, 80, 110);
        }
        this.update();
        serializable = null;
        serializable = this.isEditorBoard ? new Dimension(430, 350) : new Dimension(350, 350);
        this.setPreferredSize((Dimension)serializable);
        this.setMinimumSize((Dimension)serializable);
        if (this.isEditorBoard) {
            this.setMaximumSize((Dimension)serializable);
        }
    }

    public VisualBoard(JChessBoard jChessBoard) {
        this.jcb = jChessBoard;
        this.initialize();
    }

    public VisualBoard(JChessBoard jChessBoard, boolean bl) {
        this.jcb = jChessBoard;
        this.isEditorBoard = bl;
        this.initialize();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class FigureList {
        private ArrayList list = new ArrayList(8);
        private int type;
        private ImageIcon icon;
        private int index = 0;

        public VisualFigure getFigure() {
            VisualFigure visualFigure;
            if (this.index >= this.list.size()) {
                if (VisualBoard.this.isEditorBoard) {
                    this.list.add(new VisualEditorFigure(this.type));
                } else {
                    this.list.add(new VisualFigure(this.type));
                }
                visualFigure = (VisualFigure)this.list.get(this.index);
            } else {
                visualFigure = (VisualFigure)this.list.get(this.index);
            }
            if (!visualFigure.isVisible()) {
                visualFigure.setVisible(true);
            }
            ++this.index;
            return visualFigure;
        }

        public void rewind() {
            this.index = 0;
        }

        public void hideRest() {
            if (this.list.size() > 0) {
                while (this.index < this.list.size()) {
                    ((VisualFigure)this.list.get(this.index)).setVisible(false);
                    ++this.index;
                }
            }
        }

        public FigureList(int n) {
            this.type = n;
        }
    }

    class VisualPoolFigure
    extends VisualFigure {
        public int basePosX;
        public int basePosY;

        public VisualPoolFigure(int n, int n2, int n3) {
            super(n);
            this.basePosX = n2;
            this.basePosY = n3;
            this.setLocation(this.basePosX, this.basePosY);
        }

        public int getRank() {
            if (VisualBoard.this.reverseBoard) {
                return (this.getLocation().y - 15 + 20) / 40;
            }
            return 7 - (this.getLocation().y - 15 + 20) / 40;
        }

        public int getFile() {
            if (VisualBoard.this.reverseBoard) {
                return 7 - (this.getLocation().x - 15 + 20) / 40;
            }
            return (this.getLocation().x - 15 + 20) / 40;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (VisualBoard.this.isLocked) {
                return;
            }
            this.rank = this.getRank();
            this.file = this.getFile();
            this.mousePressedX = mouseEvent.getX();
            this.mousePressedY = mouseEvent.getY();
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (VisualBoard.this.isLocked) {
                return;
            }
            int n = this.getLocation().x + mouseEvent.getX() - this.mousePressedX;
            int n2 = this.getLocation().y + mouseEvent.getY() - this.mousePressedY;
            this.setLocation(n, n2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseReleased(MouseEvent mouseEvent) {
            if (VisualBoard.this.isLocked) {
                return;
            }
            VirtualBoard virtualBoard = VisualBoard.this.virtualBoard;
            synchronized (virtualBoard) {
                int n = this.getRank();
                int n2 = this.getFile();
                if (n2 >= 0 && n2 < 8 && n >= 0 && n < 8) {
                    VisualBoard.this.virtualBoard.field[(n << 3) + n2] = this.type;
                }
                if (this.type == 1) {
                    VisualBoard.this.virtualBoard.whiteKingPos = (n << 3) + n2;
                }
                if (this.type == 7) {
                    VisualBoard.this.virtualBoard.blackKingPos = (n << 3) + n2;
                }
                VisualBoard.this.redraw();
            }
            this.setLocation(this.basePosX, this.basePosY);
        }
    }

    class VisualEditorFigure
    extends VisualFigure {
        public VisualEditorFigure(int n) {
            super(n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mousePressed(MouseEvent mouseEvent) {
            if (VisualBoard.this.isLocked) {
                return;
            }
            this.rank = this.getRank();
            this.file = this.getFile();
            this.mousePressedX = mouseEvent.getX();
            this.mousePressedY = mouseEvent.getY();
            VirtualBoard virtualBoard = VisualBoard.this.virtualBoard;
            synchronized (virtualBoard) {
                if (VisualBoard.this.virtualBoard.field[(this.rank << 3) + this.file] == 0) {
                    VisualBoard.this.redraw();
                    return;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseReleased(MouseEvent mouseEvent) {
            if (VisualBoard.this.isLocked) {
                return;
            }
            VirtualBoard virtualBoard = VisualBoard.this.virtualBoard;
            synchronized (virtualBoard) {
                int n = this.getRank();
                int n2 = this.getFile();
                VisualBoard.this.boardPane.setLayer(this, 2, 0);
                if (this.rank != n || this.file != n2) {
                    VisualBoard.this.virtualBoard.field[(this.rank << 3) + this.file] = 0;
                    VisualBoard.this.virtualBoard.field[(n << 3) + n2] = this.type;
                    if (this.type == 1) {
                        VisualBoard.this.virtualBoard.whiteKingPos = (n << 3) + n2;
                    }
                    if (this.type == 7) {
                        VisualBoard.this.virtualBoard.blackKingPos = (n << 3) + n2;
                    }
                }
                VisualBoard.this.redraw();
            }
        }
    }

    class VisualFigure
    extends JLabel
    implements MouseListener,
    MouseMotionListener {
        int rank;
        int file;
        int mousePressedX;
        int mousePressedY;
        boolean isWhiteFigure;
        int type;

        public VisualFigure(int n) {
            super((ImageIcon)VisualBoard.this.icons.get(new Integer(n)));
            this.type = n;
            this.isWhiteFigure = this.type < 7;
            this.setSize(this.getIcon().getIconWidth(), this.getIcon().getIconHeight());
            this.addMouseMotionListener(this);
            this.addMouseListener(this);
        }

        public int getRank() {
            if (VisualBoard.this.reverseBoard) {
                return (this.getLocation().y + 20) / 40;
            }
            return 7 - (this.getLocation().y + 20) / 40;
        }

        public int getFile() {
            if (VisualBoard.this.reverseBoard) {
                return 7 - (this.getLocation().x + 20) / 40;
            }
            return (this.getLocation().x + 20) / 40;
        }

        public void setField(int n, int n2) {
            if (VisualBoard.this.reverseBoard) {
                this.setLocation((7 - n2) * 40, n * 40);
            } else {
                this.setLocation(n2 * 40, (7 - n) * 40);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mousePressed(MouseEvent mouseEvent) {
            if (VisualBoard.this.isLocked) {
                return;
            }
            this.rank = this.getRank();
            this.file = this.getFile();
            this.mousePressedX = mouseEvent.getX();
            this.mousePressedY = mouseEvent.getY();
            VirtualBoard virtualBoard = VisualBoard.this.virtualBoard;
            synchronized (virtualBoard) {
                if (VisualBoard.this.virtualBoard.field[(this.rank << 3) + this.file] == 0) {
                    VisualBoard.this.update();
                    return;
                }
                if (((VisualBoard)VisualBoard.this).jcb.settings.showPossibleMoves) {
                    for (int i = 0; i < 8; ++i) {
                        for (int j = 0; j < 8; ++j) {
                            if (!VisualBoard.this.virtualBoard.isPossibleMove(new Move(this.rank, this.file, i, j))) continue;
                            if (VisualBoard.this.reverseBoard) {
                                VisualBoard.this.background[i][7 - j].setBackground(((VisualBoard)VisualBoard.this).jcb.settings.boardHighlightColor);
                                continue;
                            }
                            VisualBoard.this.background[7 - i][j].setBackground(((VisualBoard)VisualBoard.this).jcb.settings.boardHighlightColor);
                        }
                    }
                }
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            int n;
            if (VisualBoard.this.isLocked) {
                return;
            }
            int n2 = this.getLocation().x + mouseEvent.getX() - this.mousePressedX;
            if (n2 > 280) {
                n2 = 280;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            if ((n = this.getLocation().y + mouseEvent.getY() - this.mousePressedY) > 280) {
                n = 280;
            }
            if (n < 0) {
                n = 0;
            }
            this.setLocation(n2, n);
            VisualBoard.this.boardPane.setLayer(this, 10, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseReleased(MouseEvent mouseEvent) {
            if (VisualBoard.this.isLocked) {
                return;
            }
            VirtualBoard virtualBoard = VisualBoard.this.virtualBoard;
            synchronized (virtualBoard) {
                int n = this.getRank();
                int n2 = this.getFile();
                VisualBoard.this.boardPane.setLayer(this, 2, 0);
                if (this.rank != n || this.file != n2) {
                    Move move = new Move(this.rank, this.file, n, n2);
                    if (VisualBoard.this.virtualBoard.isPossibleMove(move)) {
                        if (VisualBoard.this.virtualBoard.field[move.fromField()] == 6 && move.toRank() == 7 || VisualBoard.this.virtualBoard.field[move.fromField()] == 12 && move.toRank() == 0) {
                            move.setPawnPromotion(VisualBoard.this.selectPromotion());
                        }
                        JChessBoard jChessBoard = VisualBoard.this.jcb;
                        synchronized (jChessBoard) {
                            VisualBoard.this.jcb.makeUsersMove(move);
                        }
                    } else {
                        VisualBoard.this.update();
                    }
                } else {
                    VisualBoard.this.update();
                }
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }
    }
}

