/*
 * Decompiled with CFR 0.152.
 */
package jchessboard;

public class Move {
    private int from;
    private int to;
    private boolean malformedString = false;
    private int pawnPromotion = 0;

    public static String getVersion() {
        return "$Id: Move.java,v 1.8 2004/12/19 22:31:14 cdivossen Exp $";
    }

    public String toString() {
        String string = "" + (char)(97 + (this.from & 7)) + "" + ((this.from >> 3) + 1) + (char)(97 + (this.to & 7)) + "" + ((this.to >> 3) + 1);
        if (this.pawnPromotion != 0) {
            if (this.pawnPromotion == 2) {
                string = string + "Q";
            } else if (this.pawnPromotion == 3) {
                string = string + "R";
            } else if (this.pawnPromotion == 4) {
                string = string + "B";
            } else if (this.pawnPromotion == 5) {
                string = string + "N";
            }
        }
        return string;
    }

    public boolean isValid() {
        return !this.malformedString && this.from > 0 && this.from < 64 && this.to > 0 && this.to < 64 && (this.pawnPromotion == 0 || this.pawnPromotion == 2 || this.pawnPromotion == 3 || this.pawnPromotion == 4 || this.pawnPromotion == 5);
    }

    public int fromField() {
        return this.from;
    }

    public int toField() {
        return this.to;
    }

    public int fromFile() {
        return this.from & 7;
    }

    public int fromRank() {
        return this.from >> 3;
    }

    public int toFile() {
        return this.to & 7;
    }

    public int toRank() {
        return this.to >> 3;
    }

    public int pawnPromotion() {
        return this.pawnPromotion;
    }

    public void setPawnPromotion(int n) {
        this.pawnPromotion = n;
    }

    public int hashCode() {
        return this.from | this.to << 6;
    }

    public boolean equals(Move move) {
        return move.fromField() == this.from && move.toField() == this.to && move.pawnPromotion() == this.pawnPromotion && move.isValid() == this.isValid();
    }

    public Move(String string) {
        if (string.length() == 4 || string.length() == 5) {
            this.from = string.charAt(0) - 97 + (Character.getNumericValue(string.charAt(1)) - 1 << 3);
            this.to = string.charAt(2) - 97 + (Character.getNumericValue(string.charAt(3)) - 1 << 3);
            if (string.length() == 5) {
                if (string.substring(4, 5).equals("Q")) {
                    this.pawnPromotion = 2;
                } else if (string.substring(4, 5).equals("R")) {
                    this.pawnPromotion = 3;
                } else if (string.substring(4, 5).equals("B")) {
                    this.pawnPromotion = 4;
                } else if (string.substring(4, 5).equals("N")) {
                    this.pawnPromotion = 5;
                } else {
                    this.malformedString = true;
                }
            }
        } else {
            this.malformedString = true;
        }
    }

    public Move(int n, int n2) {
        this.from = n;
        this.to = n2;
    }

    public Move(int n, int n2, int n3) {
        this.from = n;
        this.to = n2;
        this.pawnPromotion = n3;
    }

    public Move(int n, int n2, int n3, int n4) {
        this.from = (n << 3) + n2;
        this.to = (n3 << 3) + n4;
    }
}

