/*
 * Decompiled with CFR 0.152.
 */
package jchessboard;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import jchessboard.BoardConnector;

class ConnectionListener
implements Runnable {
    private Socket so;
    private ServerSocket serverso;
    boolean isEnabled = false;
    private Thread thisThread;
    private int port;
    private JCheckBox enableCheckBox;
    private JTextField portField;
    private JLabel portLabel;

    public static String getVersion() {
        return "$Id: ConnectionListener.java,v 1.14 2004/11/26 00:05:34 cdivossen Exp $";
    }

    public void run() {
        try {
            this.serverso = new ServerSocket(this.port);
            while (this.isEnabled) {
                this.so = this.serverso.accept();
                new BoardConnector(null, this.so);
            }
            this.serverso.close();
        }
        catch (IOException iOException) {
            this.isEnabled = false;
            JOptionPane.showMessageDialog(null, iOException.toString(), "IOException in ConnectionListener", 0);
        }
    }

    public void shutdown() {
        this.isEnabled = false;
    }

    public void showSettingsPane() {
        Object[] objectArray = new Object[3];
        this.enableCheckBox = new JCheckBox("Enable server");
        this.enableCheckBox.setSelected(this.isEnabled);
        objectArray[0] = this.enableCheckBox;
        this.portLabel = new JLabel("Port: ");
        this.portLabel.setEnabled(this.enableCheckBox.isSelected());
        objectArray[1] = this.portLabel;
        this.portField = new JTextField(Integer.toString(this.port), 5);
        this.portField.setEnabled(this.enableCheckBox.isSelected());
        this.enableCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectionListener.this.portField.setEnabled(ConnectionListener.this.enableCheckBox.isSelected());
                ConnectionListener.this.portLabel.setEnabled(ConnectionListener.this.enableCheckBox.isSelected());
            }
        });
        objectArray[2] = this.portField;
        Object[] objectArray2 = new Object[]{"OK", "Cancel"};
        int n = JOptionPane.showOptionDialog(null, objectArray, "Server settings.", 0, 3, null, objectArray2, objectArray2[0]);
        if (n == 0) {
            if (this.enableCheckBox.isSelected()) {
                try {
                    int n2 = Integer.parseInt(this.portField.getText());
                    if (n2 > 65535 || n2 <= 0) {
                        throw new NumberFormatException();
                    }
                    this.setPort(n2);
                    this.setEnabled(true);
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(null, "Illegal port: " + this.portField.getText(), "Illegal port", 0);
                }
            } else {
                this.setEnabled(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnabled(boolean bl) {
        ConnectionListener connectionListener = this;
        synchronized (connectionListener) {
            if (bl == this.isEnabled) {
                return;
            }
            if (bl && !this.isEnabled) {
                this.isEnabled = true;
                this.thisThread = new Thread(this);
                this.thisThread.setDaemon(true);
                this.thisThread.start();
            }
            if (!bl && this.isEnabled) {
                this.isEnabled = false;
                try {
                    if (this.serverso != null) {
                        this.so = new Socket("localhost", this.port);
                        this.so.close();
                    }
                    this.thisThread.join();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public int getPort() {
        return this.port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPort(int n) {
        if (n == this.port) {
            return;
        }
        ConnectionListener connectionListener = this;
        synchronized (connectionListener) {
            boolean bl = this.isEnabled;
            this.setEnabled(false);
            this.port = n;
            this.setEnabled(bl);
        }
    }
}

