/*
 * Decompiled with CFR 0.152.
 */
package jchessboard;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.Iterator;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import jchessboard.JChessBoard;

class BoardConnector
implements Runnable {
    private Socket so;
    private BufferedReader fromOther;
    private BufferedWriter toOther;
    private String otherHostname = "";
    private boolean isEnabled = false;
    private boolean isServer;
    private JChessBoard jcb;
    private Thread thisThread;
    private int port;

    public static String getVersion() {
        return "$Id: BoardConnector.java,v 1.52 2004/12/26 23:12:14 cdivossen Exp $";
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void sendString(String string) {
        if (this.isEnabled) {
            try {
                this.toOther.write(string + "\n");
                this.toOther.flush();
            }
            catch (IOException iOException) {
                this.isEnabled = false;
                this.jcb.connectionClosed();
                JOptionPane.showMessageDialog(null, "The connection was lost!\n" + iOException.toString(), "IOException in outOfSync", 0);
            }
        }
    }

    public void run() {
        this.isEnabled = this.isServer ? this.serverHandshake() : this.clientHandshake();
        try {
            boolean bl = false;
            while (this.isEnabled && !bl) {
                final String string = this.fromOther.readLine();
                if (string == null) continue;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ((BoardConnector)BoardConnector.this).jcb.protocol.handleInput(string);
                    }
                });
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.isEnabled = false;
        try {
            if (this.so != null) {
                this.so.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void shutdown() {
        this.isEnabled = false;
        this.thisThread.interrupt();
    }

    public void closeConnection() {
        try {
            if (this.so != null) {
                this.toOther.write("quit\n");
                this.toOther.flush();
                this.toOther.close();
                this.fromOther.close();
                if (this.so != null) {
                    this.so.close();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.isEnabled = false;
        this.thisThread.interrupt();
        if (this.thisThread != Thread.currentThread()) {
            try {
                this.thisThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public String getOtherHostName() {
        if (this.otherHostname != null) {
            return this.otherHostname;
        }
        return "";
    }

    public boolean serverHandshake() {
        boolean bl = false;
        try {
            this.toOther.write(BoardConnector.getVersion() + "\n");
            this.toOther.flush();
            String string = this.fromOther.readLine();
            if (string != null && string.equals(BoardConnector.getVersion())) {
                final BoardConnector boardConnector = this;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Object[] objectArray = new Object[]{"Accept", "Reject"};
                        Object[] objectArray2 = new Object[2];
                        objectArray2[0] = "Incoming game request from " + boardConnector.getOtherHostName() + ".";
                        JCheckBox jCheckBox = new JCheckBox("New window");
                        JChessBoard jChessBoard = null;
                        Iterator iterator = JChessBoard.windowList.iterator();
                        while (iterator.hasNext() && jChessBoard == null) {
                            JChessBoard jChessBoard2 = (JChessBoard)iterator.next();
                            if (jChessBoard2.getBoardConnector() != null) continue;
                            jChessBoard = jChessBoard2;
                        }
                        if (jChessBoard != null) {
                            jCheckBox.setEnabled(true);
                            jCheckBox.setSelected(false);
                            jChessBoard.showMessage("Incoming connection...");
                        } else {
                            jCheckBox.setEnabled(false);
                            jCheckBox.setSelected(true);
                        }
                        objectArray2[1] = jCheckBox;
                        int n = JOptionPane.showOptionDialog(jChessBoard, objectArray2, "Game request", 0, 3, null, objectArray, objectArray[0]);
                        if (n == 0) {
                            if (jCheckBox.isSelected()) {
                                if (jChessBoard != null) {
                                    jChessBoard.showMessage("Not connected.");
                                    jChessBoard.prepareMove();
                                }
                                jChessBoard = new JChessBoard("");
                                jChessBoard.gameTable.clear();
                            }
                            jChessBoard.setBoardConnector(boardConnector);
                            BoardConnector.this.jcb = jChessBoard;
                            BoardConnector.this.jcb.connectionEstablished();
                            ((BoardConnector)BoardConnector.this).jcb.protocol.sendWelcome();
                        } else {
                            boardConnector.sendString("Go away!");
                            boardConnector.closeConnection();
                            if (jChessBoard != null) {
                                jChessBoard.showMessage("Connection rejected.");
                                jChessBoard.connectionIndicator.setNoConnection();
                            }
                        }
                    }
                });
                bl = true;
            } else {
                bl = false;
            }
        }
        catch (IOException iOException) {
            bl = false;
        }
        return bl;
    }

    public boolean clientHandshake() {
        boolean bl = false;
        String string = null;
        try {
            string = this.fromOther.readLine();
            if (string != null) {
                if (string.equals(BoardConnector.getVersion())) {
                    this.toOther.write(BoardConnector.getVersion() + "\n");
                    this.toOther.flush();
                    bl = true;
                } else {
                    this.closeConnection();
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        catch (IOException iOException) {
            bl = false;
        }
        return bl;
    }

    public BoardConnector(JChessBoard jChessBoard, Socket socket) {
        this.jcb = jChessBoard;
        this.so = socket;
        try {
            this.fromOther = new BufferedReader(new InputStreamReader(this.so.getInputStream()));
            this.toOther = new BufferedWriter(new OutputStreamWriter(this.so.getOutputStream()));
            this.otherHostname = this.so.getInetAddress().getHostName();
            this.isServer = true;
            this.isEnabled = true;
            this.thisThread = new Thread(this);
            this.thisThread.start();
        }
        catch (Exception exception) {
            this.isEnabled = false;
        }
    }

    public BoardConnector(JChessBoard jChessBoard, String string, int n) {
        this.port = n;
        this.otherHostname = string;
        try {
            jChessBoard.connectionIndicator.setWaiting();
            this.so = new Socket(this.otherHostname, this.port);
            this.fromOther = new BufferedReader(new InputStreamReader(this.so.getInputStream()));
            this.toOther = new BufferedWriter(new OutputStreamWriter(this.so.getOutputStream()));
            this.jcb = jChessBoard;
            this.isServer = false;
            this.isEnabled = true;
            this.thisThread = new Thread(this);
            this.thisThread.start();
        }
        catch (Exception exception) {
            jChessBoard.showMessage("Could not connect to \"" + string + "\": " + exception.getMessage());
            jChessBoard.connectionIndicator.setNoConnection();
            this.isEnabled = false;
        }
    }
}

