/*
 * Decompiled with CFR 0.152.
 */
package jchessboard;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import javax.swing.SwingUtilities;
import jchessboard.JChessBoard;
import jchessboard.Move;
import jchessboard.VirtualBoard;

class AI
implements Runnable {
    private static final int EM = 0;
    private static final int WK = 1;
    private static final int WQ = 2;
    private static final int WR = 3;
    private static final int WB = 4;
    private static final int WN = 5;
    private static final int WP = 6;
    private static final int BK = 7;
    private static final int BQ = 8;
    private static final int BR = 9;
    private static final int BB = 10;
    private static final int BN = 11;
    private static final int BP = 12;
    private static final int[] figureScore = new int[]{0, 20000, 900, 500, 350, 300, 100, -20000, -900, -500, -350, -300, -100};
    private boolean isEnabled = true;
    private Thread aiThread;
    private JChessBoard jcb;
    private int maxDepth = 9;
    private int minDepth = 3;
    private Random random = new Random();
    private int evalCounter;
    private int posCounter;
    private int getAllMovesCounter;
    private int getCapturingMovesCounter;
    private int qSearchCounter;
    private static int TRANSTABLESIZE = 8192;
    private static long[][] hashBase = new long[13][64];
    private TransTableEntry[] transTable;
    private int[][][] histHeu;
    private int[] killer1from = new int[20];
    private int[] killer1to = new int[20];
    private int[] killer1value = new int[20];
    private int[] killer2from = new int[20];
    private int[] killer2to = new int[20];
    private int[] killer2value = new int[20];
    private long startTime;
    private long endTime;
    private long timeout = 15000L;
    private int movesMade = 0;
    private static boolean firstAI = true;
    private int transTableHits;
    private int transTableMiss;
    private int transTableFaults;
    private static String[] prefix = new String[]{"          0 ", "        1 ", "      2 ", "    3 ", "  4 ", "5 "};
    private List visitedPositions;

    public static String getVersion() {
        return "$Id: AI.java,v 1.37 2004/12/26 23:12:14 cdivossen Exp $";
    }

    public void prepareMove() {
        this.aiThread.interrupt();
    }

    public void prepareMove(long l) {
        this.timeout = l;
        this.aiThread.interrupt();
    }

    public int getHash(VirtualBoard virtualBoard) {
        int n = 0;
        for (int i = 0; i < 64; ++i) {
            if (virtualBoard.field[i] == 0) continue;
            n = (int)((long)n ^ hashBase[virtualBoard.field[i]][i]);
        }
        return n;
    }

    public void newGame() {
        this.movesMade = 0;
    }

    public static int evaluateMaterial(VirtualBoard virtualBoard) {
        int n = 0;
        for (int i = 0; i < 64; ++i) {
            n += figureScore[virtualBoard.field[i]];
        }
        return virtualBoard.isWhiteTurn ? n : -n;
    }

    private static int countWhiteAttackedFields(VirtualBoard virtualBoard) {
        int n = 0;
        long l = virtualBoard.getWhiteAttackBoard();
        for (int i = 0; i < 64; ++i) {
            if ((l & 1L << i) == 0L) continue;
            ++n;
        }
        return n;
    }

    private static int countWhiteAttackedCenterFields(VirtualBoard virtualBoard) {
        int n = 0;
        long l = virtualBoard.getWhiteAttackBoard();
        if ((l & 0x4000000L) != 0L) {
            ++n;
        }
        if ((l & 0x8000000L) != 0L) {
            ++n;
        }
        if ((l & 0x10000000L) != 0L) {
            ++n;
        }
        if ((l & 0x20000000L) != 0L) {
            ++n;
        }
        if ((l & 0x400000000L) != 0L) {
            ++n;
        }
        if ((l & 0x800000000L) != 0L) {
            ++n;
        }
        if ((l & 0x1000000000L) != 0L) {
            ++n;
        }
        if ((l & 0x2000000000L) != 0L) {
            ++n;
        }
        return n;
    }

    private static int countBlackAttackedFields(VirtualBoard virtualBoard) {
        int n = 0;
        long l = virtualBoard.getBlackAttackBoard();
        for (int i = 0; i < 64; ++i) {
            if ((l & 1L << i) == 0L) continue;
            ++n;
        }
        return n;
    }

    private static int countBlackAttackedCenterFields(VirtualBoard virtualBoard) {
        int n = 0;
        long l = virtualBoard.getBlackAttackBoard();
        if ((l & 0x4000000L) != 0L) {
            ++n;
        }
        if ((l & 0x8000000L) != 0L) {
            ++n;
        }
        if ((l & 0x10000000L) != 0L) {
            ++n;
        }
        if ((l & 0x20000000L) != 0L) {
            ++n;
        }
        if ((l & 0x400000000L) != 0L) {
            ++n;
        }
        if ((l & 0x800000000L) != 0L) {
            ++n;
        }
        if ((l & 0x1000000000L) != 0L) {
            ++n;
        }
        if ((l & 0x2000000000L) != 0L) {
            ++n;
        }
        return n;
    }

    public static int evaluate(VirtualBoard virtualBoard) {
        int n;
        int n2 = 0;
        int n3 = 0;
        if (virtualBoard.blackKingPos == 64) {
            return virtualBoard.isWhiteTurn ? 20001 : -20001;
        }
        if (virtualBoard.whiteKingPos == 64) {
            return !virtualBoard.isWhiteTurn ? 20001 : -20001;
        }
        for (n = 0; n < 64; ++n) {
            if (virtualBoard.field[n] == 0) continue;
            n2 += figureScore[virtualBoard.field[n]];
            ++n3;
        }
        n2 += AI.countWhiteAttackedFields(virtualBoard) * 2;
        n2 -= AI.countBlackAttackedFields(virtualBoard) * 2;
        if (n3 > 12) {
            n2 += AI.countWhiteAttackedCenterFields(virtualBoard) * 2;
            n2 -= AI.countBlackAttackedCenterFields(virtualBoard) * 2;
        }
        if (virtualBoard.isWhiteTurn) {
            if (virtualBoard.isAttackedByBlack(virtualBoard.whiteKingPos)) {
                n2 -= 20;
            } else if (virtualBoard.isAttackedByWhite(virtualBoard.blackKingPos)) {
                n2 += 20;
            }
        }
        if (virtualBoard.whiteKingHasMoved) {
            n2 -= 10;
        } else {
            if (virtualBoard.leftWhiteRookHasMoved) {
                n2 -= 5;
            }
            if (virtualBoard.rightWhiteRookHasMoved) {
                n2 -= 5;
            }
        }
        if (virtualBoard.blackKingHasMoved) {
            n2 += 10;
        } else {
            if (virtualBoard.leftBlackRookHasMoved) {
                n2 += 5;
            }
            if (virtualBoard.rightBlackRookHasMoved) {
                n2 += 5;
            }
        }
        for (n = 48; n < 56; ++n) {
            if (virtualBoard.field[n] != 6) continue;
            n2 += 20;
        }
        for (n = 40; n < 48; ++n) {
            if (virtualBoard.field[n] != 6) continue;
            n2 += 10;
        }
        for (n = 8; n < 16; ++n) {
            if (virtualBoard.field[n] != 12) continue;
            n2 -= 20;
        }
        for (n = 16; n < 24; ++n) {
            if (virtualBoard.field[n] != 12) continue;
            n2 -= 10;
        }
        return virtualBoard.isWhiteTurn ? n2 : -n2;
    }

    public int alphabeta(VirtualBoard virtualBoard, int n, int n2, int n3, int n4, int n5) {
        VirtualBoard virtualBoard2;
        int n6;
        if (n2 == 0) {
            ++this.evalCounter;
            return AI.evaluate(virtualBoard);
        }
        if (System.currentTimeMillis() >= this.endTime || !this.isEnabled) {
            return Integer.MIN_VALUE;
        }
        Object var9_7 = null;
        int n7 = -10000000;
        int n8 = this.getHash(virtualBoard);
        TransTableEntry transTableEntry = this.transTable[n8];
        if (transTableEntry.isSet) {
            if (transTableEntry.virtualBoard.equals(virtualBoard) && transTableEntry.depth >= n2) {
                ++this.transTableHits;
                return transTableEntry.score;
            }
        } else {
            ++this.transTableMiss;
        }
        n7 = -10000000;
        VirtualBoard virtualBoard3 = null;
        ++this.getAllMovesCounter;
        List list = virtualBoard.getAllMoves();
        if (n3 > 0) {
            virtualBoard3 = virtualBoard;
            ++this.evalCounter;
            n7 = AI.evaluate(virtualBoard);
            if (n3 > 1) {
                return n7;
            }
        }
        if (list.size() == 0) {
            if (virtualBoard.isWhiteTurn) {
                if (virtualBoard.isAttackedByBlack(virtualBoard.whiteKingPos)) {
                    return -20001 - n2 * 100;
                }
                return 10001;
            }
            if (virtualBoard.isAttackedByWhite(virtualBoard.blackKingPos)) {
                return -20001 - n2 * 100;
            }
            return 10001;
        }
        Vector<VirtualBoard> vector = new Vector<VirtualBoard>();
        for (n6 = 0; n6 < list.size(); ++n6) {
            Move move = (Move)list.get(n6);
            virtualBoard2 = virtualBoard.clonedBoard();
            virtualBoard2.makeAnyMove(move);
            if (n2 > 1) {
                virtualBoard2.score = -AI.evaluateMaterial(virtualBoard2);
                if (virtualBoard2.lastFrom == this.killer1from[n2] && virtualBoard2.lastTo == this.killer1to[n2]) {
                    virtualBoard2.score += 500;
                } else if (virtualBoard2.lastFrom == this.killer2from[n2] && virtualBoard2.lastTo == this.killer2to[n2]) {
                    virtualBoard2.score += 450;
                }
                virtualBoard2.score += this.histHeu[virtualBoard2.lastFrom][virtualBoard2.lastTo][n + 1] * 10;
            }
            vector.add(virtualBoard2);
        }
        if (n2 > 1) {
            Collections.sort(vector, new Comparator(){

                public int compare(Object object, Object object2) {
                    return ((VirtualBoard)object).score - ((VirtualBoard)object2).score;
                }
            });
        }
        for (n6 = vector.size() - 1; n6 >= 0; --n6) {
            virtualBoard2 = (VirtualBoard)vector.get(n6);
            boolean bl = false;
            if (virtualBoard.field[virtualBoard2.lastTo] != 0) {
                bl = true;
            }
            int n9 = -10000000;
            if (bl && n2 == 1) {
                ++this.qSearchCounter;
                n9 = -this.alphabeta(virtualBoard2, n + 1, 1, n3 + 1, -n5, -n4);
            } else {
                n9 = -this.alphabeta(virtualBoard2, n + 1, n2 - 1, 0, -n5, -n4);
            }
            if (n9 > n7) {
                n7 = n9;
                virtualBoard3 = virtualBoard2;
            }
            if (n7 > n4) {
                n4 = n7;
            }
            if (n4 < n5) continue;
            if (n9 > this.killer1value[n2]) {
                this.killer2from[n2] = this.killer1from[n2];
                this.killer2to[n2] = this.killer1to[n2];
                this.killer2value[n2] = this.killer1value[n2];
                this.killer1from[n2] = virtualBoard3.lastFrom;
                this.killer1to[n2] = virtualBoard3.lastTo;
                this.killer1value[n2] = n9;
            }
            if (!this.transTable[n8].isSet || this.transTable[n8].depth < n2) {
                this.transTable[n8].set(virtualBoard, n7, n2, virtualBoard3.lastFrom, virtualBoard3.lastTo);
            }
            int[] nArray = this.histHeu[virtualBoard3.lastFrom][virtualBoard3.lastTo];
            int n10 = n;
            nArray[n10] = nArray[n10] + 1;
            return n4;
        }
        if (virtualBoard3 != null) {
            if (!this.transTable[n8].isSet || this.transTable[n8].depth < n2) {
                this.transTable[n8].set(virtualBoard, n7, n2, virtualBoard3.lastFrom, virtualBoard3.lastTo);
            }
            if (n7 > this.killer1value[n2]) {
                this.killer2from[n2] = this.killer1from[n2];
                this.killer2to[n2] = this.killer1to[n2];
                this.killer2value[n2] = this.killer1value[n2];
                this.killer1from[n2] = virtualBoard3.lastFrom;
                this.killer1to[n2] = virtualBoard3.lastTo;
                this.killer1value[n2] = n7;
            }
            int[] nArray = this.histHeu[virtualBoard3.lastFrom][virtualBoard3.lastTo];
            int n11 = n;
            nArray[n11] = nArray[n11] + 1;
        }
        return n7;
    }

    public void work() {
        VirtualBoard virtualBoard = this.jcb.getCurrentVirtualBoard();
        if (!virtualBoard.gameIsFinished()) {
            int n;
            int n2;
            this.startTime = System.currentTimeMillis();
            this.endTime = this.startTime + this.timeout;
            this.visitedPositions = this.jcb.history.getAllBoards();
            this.evalCounter = 0;
            this.posCounter = 0;
            this.getAllMovesCounter = 0;
            this.getCapturingMovesCounter = 0;
            this.qSearchCounter = 0;
            this.transTableHits = 0;
            this.transTableMiss = 0;
            this.transTableFaults = 0;
            for (n2 = 0; n2 < TRANSTABLESIZE; ++n2) {
                this.transTable[n2].clear();
            }
            for (n2 = 0; n2 < 20; ++n2) {
                this.killer1from[n2] = 64;
                this.killer1to[n2] = 64;
                this.killer1value[n2] = -1000000;
                this.killer2from[n2] = 64;
                this.killer2to[n2] = 64;
                this.killer2value[n2] = -1000000;
            }
            this.histHeu = new int[64][64][20];
            this.maxDepth = 20;
            n2 = 2;
            int n3 = 0;
            long l = 500L;
            long l2 = 0L;
            Move move = null;
            List list = virtualBoard.getAllMoves();
            final HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
            for (n = 0; n < list.size(); ++n) {
                hashMap.put(list.get(n), new Integer(Integer.MIN_VALUE));
            }
            if (list.size() == 1) {
                move = (Move)list.get(0);
                n2 = this.maxDepth;
            } else {
                block3: do {
                    System.out.println("\nDepth: " + n2);
                    this.jcb.showMessage("Depth " + n2 + "...", "small");
                    n = n3;
                    Collections.sort(list, new Comparator(){

                        public int compare(Object object, Object object2) {
                            Move move = (Move)object;
                            Move move2 = (Move)object2;
                            return (Integer)hashMap.get(move) - (Integer)hashMap.get(move2);
                        }
                    });
                    int n4 = -100000000;
                    int n5 = -100000000;
                    for (int i = list.size() - 1; i >= 0; --i) {
                        int n6;
                        Move move2 = (Move)list.get(i);
                        VirtualBoard virtualBoard2 = virtualBoard.clonedBoard();
                        virtualBoard2.makeAnyMove(move2);
                        boolean bl = false;
                        for (n6 = 0; n6 < this.visitedPositions.size(); ++n6) {
                            if (!((VirtualBoard)this.visitedPositions.get(n6)).isEqualPosition(virtualBoard2)) continue;
                            bl = true;
                        }
                        if (bl) {
                            n6 = -30000;
                        } else {
                            n6 = -this.alphabeta(virtualBoard2, n3 + 1, n2 - 1, 0, -10000000, -n5);
                            if (System.currentTimeMillis() >= this.endTime || !this.isEnabled) {
                                n6 = Integer.MIN_VALUE;
                                System.out.print("TIMEOUT");
                                continue block3;
                            }
                        }
                        if (n6 > n4) {
                            n4 = n6;
                            move = move2;
                        }
                        if (n4 > n5) {
                            n5 = n4;
                        }
                        hashMap.put(move2, new Integer(n6));
                        System.out.print(move2 + ":" + n6 + " ");
                    }
                } while ((l2 = System.currentTimeMillis()) < this.endTime && (++n2 <= this.maxDepth || l2 - this.startTime < l) && l2 - this.startTime < this.endTime - l2);
            }
            this.jcb.showMessage(this.evalCounter + " evalutaions, " + this.getAllMovesCounter + " getAllMoves, " + this.qSearchCounter + " quiescence searches, " + (System.currentTimeMillis() - this.startTime) + " ms", "small");
            final Move move3 = move;
            if (this.isEnabled) {
                if (virtualBoard.equals(this.jcb.getCurrentVirtualBoard())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            JChessBoard jChessBoard = AI.this.jcb;
                            synchronized (jChessBoard) {
                                AI.this.jcb.makeAIsMove(move3);
                            }
                        }
                    });
                } else {
                    this.jcb.showMessage("AI: Who changed the board?!");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.transTable = new TransTableEntry[TRANSTABLESIZE];
        this.histHeu = new int[20][64][64];
        for (int i = 0; i < TRANSTABLESIZE; ++i) {
            this.transTable[i] = new TransTableEntry();
        }
        this.newGame();
        this.jcb.showMessage("AI is ready.");
        while (this.isEnabled) {
            try {
                AI aI = this;
                synchronized (aI) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.isEnabled) continue;
            this.work();
        }
    }

    public void perfTest() {
        int n;
        VirtualBoard virtualBoard = new VirtualBoard();
        virtualBoard.init();
        for (int i = 0; i < 1000; ++i) {
            AI.evaluate(virtualBoard);
        }
        long l = System.currentTimeMillis();
        for (int i = 0; i < 1000; ++i) {
            AI.evaluate(virtualBoard);
        }
        long l2 = System.currentTimeMillis();
        this.jcb.showMessage(1000000L / (l2 - l) + " evaluations/sec.");
        for (n = 0; n < 1000; ++n) {
            virtualBoard.getAllMoves();
        }
        l = System.currentTimeMillis();
        for (n = 0; n < 1000; ++n) {
            virtualBoard.getAllMoves();
        }
        l2 = System.currentTimeMillis();
        this.jcb.showMessage(1000000L / (l2 - l) + " getAllMoves/sec");
    }

    public void shutdown() {
        this.isEnabled = false;
        this.aiThread.interrupt();
        try {
            this.aiThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public AI(JChessBoard jChessBoard) {
        this.jcb = jChessBoard;
        if (firstAI) {
            for (int i = 0; i < 13; ++i) {
                for (int j = 0; j < 64; ++j) {
                    AI.hashBase[i][j] = this.random.nextInt(TRANSTABLESIZE - 1);
                }
            }
            firstAI = false;
        }
        this.aiThread = new Thread(this);
        this.aiThread.start();
    }

    class TransTableEntry {
        int depth = 0;
        int bestFrom = 64;
        int bestTo = 64;
        boolean isSet = false;
        public VirtualBoard virtualBoard;
        int score = 0;
        boolean isWhiteTurn;

        public void set(VirtualBoard virtualBoard, int n, int n2, int n3, int n4) {
            this.virtualBoard = virtualBoard.clonedBoard();
            this.score = n;
            this.depth = n2;
            this.bestFrom = n3;
            this.bestTo = n4;
            this.isSet = true;
            this.isWhiteTurn = virtualBoard.isWhiteTurn;
        }

        public void clear() {
            this.virtualBoard = null;
            this.depth = 0;
            this.bestFrom = 64;
            this.bestTo = 64;
            this.isSet = false;
            this.score = 0;
        }
    }
}

