/*
 * Decompiled with CFR 0.152.
 */
package net.yura.lobby.mini;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Queue;
import java.util.UUID;
import java.util.Vector;
import java.util.logging.Logger;
import javax.microedition.lcdui.Display;
import javax.microedition.midlet.MIDlet;
import net.yura.domination.engine.RiskUtil;
import net.yura.lobby.client.Connection;
import net.yura.lobby.client.LobbyClient;
import net.yura.lobby.client.LobbyCom;
import net.yura.lobby.mini.GameRenderer;
import net.yura.lobby.mini.MiniLobbyGame;
import net.yura.lobby.model.Game;
import net.yura.lobby.model.GameType;
import net.yura.lobby.model.Player;
import net.yura.mobile.gui.ActionListener;
import net.yura.mobile.gui.DesktopPane;
import net.yura.mobile.gui.Midlet;
import net.yura.mobile.gui.cellrenderer.ListCellRenderer;
import net.yura.mobile.gui.components.Button;
import net.yura.mobile.gui.components.ComboBox;
import net.yura.mobile.gui.components.Component;
import net.yura.mobile.gui.components.OptionPane;
import net.yura.mobile.gui.components.Panel;
import net.yura.mobile.gui.components.ScrollPane;
import net.yura.mobile.gui.components.TextField;
import net.yura.mobile.gui.components.Window;
import net.yura.mobile.gui.layout.XULLoader;
import net.yura.mobile.util.Option;
import net.yura.mobile.util.Url;
import net.yura.swingme.core.ViewChooser;

public class MiniLobbyClient
implements LobbyClient,
ActionListener {
    private static final Logger logger = Logger.getLogger(MiniLobbyClient.class.getName());
    public static final String LOBBY_SERVER = "lobby.yura.net";
    public static final String EXTRA_GAME_ID = "net.yura.domination.GAME_ID";
    public static final String EXTRA_GAME_OPTIONS = "net.yura.domination.GAME_OPTIONS";
    XULLoader loader;
    net.yura.mobile.gui.components.List list;
    Window adminPopup;
    public final Connection mycom;
    final MiniLobbyGame game;
    String myusername;
    int playerType;
    GameType theGameType;
    int openGameId = -1;
    private final Queue<String> chatMessages = new LinkedList<String>();
    private net.yura.mobile.util.Properties resBundle;
    ActionListener closeListener;
    private List games = Collections.synchronizedList(new ArrayList());

    public MiniLobbyClient(MiniLobbyGame lobbyGame) {
        this.game = lobbyGame;
        this.game.addLobbyGameMoveListener(this);
        this.resBundle = this.game.getProperties();
        try {
            this.loader = XULLoader.load((InputStream)Midlet.getResourceAsStream((String)"/ms_lobby.xml"), (ActionListener)this, (net.yura.mobile.util.Properties)this.resBundle);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.list = (net.yura.mobile.gui.components.List)this.loader.find("ResultList");
        GameRenderer r = new GameRenderer(this);
        this.list.setCellRenderer((ListCellRenderer)r);
        this.list.setFixedCellHeight(Math.max(XULLoader.adjustSizeToDensity((int)50), r.getFixedCellHeight()));
        this.list.setFixedCellWidth(10);
        ComboBox box = (ComboBox)this.loader.find("listView");
        ViewChooser viewChooser = new ViewChooser(box.getItems().toArray(new Option[box.getItemCount()]));
        this.loader.swapComponent("listView", (Component)viewChooser);
        viewChooser.addActionListener(this);
        viewChooser.setActionCommand("filter");
        viewChooser.setStretchCombo(true);
        viewChooser.setName(null);
        this.adminPopup = this.list.getPopupMenu();
        this.list.setPopupMenu(null);
        String uuid = MiniLobbyClient.getMyUUID();
        this.mycom = new LobbyCom(uuid, lobbyGame.getAppName(), lobbyGame.getAppVersion());
        this.mycom.addEventListener((LobbyClient)this);
    }

    public void connect(String server) {
        this.mycom.connect(server, 1964);
    }

    public void setPlayGamesSingedIn(boolean signedIn, String id, String idToken, String email) {
        Button joinPrivate = (Button)this.loader.find("joinPrivate");
        if (joinPrivate != null) {
            joinPrivate.setVisible(!signedIn);
            Panel root = this.getRoot();
            root.revalidate();
            root.repaint();
        }
        this.mycom.setEmail(email);
        this.mycom.setGoogleIdToken(idToken);
    }

    public void removeBackButton() {
        Button button = (Button)this.loader.find("BackButton");
        button.setMnemonic(0);
        button.setVisible(false);
    }

    public void addCloseListener(ActionListener al) {
        this.closeListener = al;
    }

    public void destroy() {
        this.mycom.disconnect();
        this.game.lobbyShutdown();
    }

    public static String getMyUUID() {
        Properties prop = new Properties();
        File lobbySettingsFile = new File(System.getProperty("user.home"), ".lobby");
        try {
            prop.load(new FileInputStream(lobbySettingsFile));
        }
        catch (Exception exception) {
            // empty catch block
        }
        String uuid = prop.getProperty("uuid");
        if (uuid != null) {
            return uuid;
        }
        uuid = UUID.randomUUID().toString();
        prop.setProperty("uuid", uuid);
        try {
            prop.store(new FileOutputStream(lobbySettingsFile), "yura.net Lobby");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return uuid;
    }

    public Panel getRoot() {
        return (Panel)this.loader.getRoot();
    }

    public String getTitle() {
        return this.resBundle.getProperty("lobby.windowtitle");
    }

    public void actionPerformed(String actionCommand) {
        if ("listSelect".equals(actionCommand)) {
            final Game game = (Game)this.list.getSelectedValue();
            if (game != null) {
                int state = game.getState(this.whoAmI());
                switch (state) {
                    case 1: {
                        if (game.getMaxPlayers() == game.getNumOfPlayers() + 1) {
                            OptionPane.showConfirmDialog((ActionListener)new ActionListener(){

                                public void actionPerformed(String actionCommand) {
                                    if ("ok".equals(actionCommand)) {
                                        MiniLobbyClient.this.mycom.joinGame(game.getId());
                                    }
                                }
                            }, (Object)"This game will start if you join!", (String)"Are you sure?", (int)2);
                            break;
                        }
                        this.mycom.joinGame(game.getId());
                        break;
                    }
                    case 2: {
                        this.mycom.leaveGame(game.getId());
                        break;
                    }
                    case 3: 
                    case 4: {
                        this.playGame(game);
                    }
                }
            }
        } else if ("create".equals(actionCommand)) {
            if (this.theGameType != null) {
                this.game.openGameSetup(this.theGameType);
            } else {
                logger.info("GameType is null, can not openGameSetup");
            }
        } else if ("setnick".equals(actionCommand)) {
            if (this.myusername != null) {
                final TextField saveText = new TextField();
                saveText.setText(this.myusername);
                OptionPane.showOptionDialog((ActionListener)new ActionListener(){

                    public void actionPerformed(String actionCommand) {
                        if ("ok".equals(actionCommand)) {
                            MiniLobbyClient.this.mycom.setNick(saveText.getText());
                        }
                    }
                }, (Object)saveText, (String)this.resBundle.getProperty("lobby.set-nick"), (int)2, (int)3, null, null, null);
            } else {
                logger.info("current username is null, can not set nick dialog");
            }
        } else if ("close".equals(actionCommand)) {
            this.destroy();
            if (this.closeListener != null) {
                this.closeListener.actionPerformed("close");
            } else {
                this.getRoot().getWindow().setVisible(false);
            }
        } else if ("filter".equals(actionCommand)) {
            this.filter(false);
        } else if (!"login".equals(actionCommand) && !"register".equals(actionCommand)) {
            if ("joinPrivate".equals(actionCommand)) {
                this.game.joinPrivateGame();
            } else if ("renameGame".equals(actionCommand)) {
                if (this.playerType >= 3) {
                    final Game game = (Game)this.list.getSelectedValue();
                    final TextField saveText = new TextField();
                    saveText.setText(game.getName());
                    OptionPane.showOptionDialog((ActionListener)new ActionListener(){

                        public void actionPerformed(String actionCommand) {
                            if ("ok".equals(actionCommand)) {
                                String newName = saveText.getText();
                                if (!game.getName().equals(newName)) {
                                    game.setName(newName);
                                    MiniLobbyClient.this.mycom.createNewGame(game);
                                }
                            }
                        }
                    }, (Object)saveText, (String)"Rename Game", (int)2, (int)3, null, null, null);
                } else {
                    logger.warning(actionCommand + "called when we are " + this.playerType + " " + this.myusername);
                }
            } else if ("renameGame2".equals(actionCommand)) {
                if (this.playerType >= 3) {
                    Game game = (Game)this.list.getSelectedValue();
                    game.setName("game");
                    this.mycom.createNewGame(game);
                } else {
                    logger.warning(actionCommand + "called when we are " + this.playerType + " " + this.myusername);
                }
            } else if ("delGame".equals(actionCommand)) {
                Game game = (Game)this.list.getSelectedValue();
                if (this.playerType >= 3 && game.getNumOfPlayers() < game.getMaxPlayers()) {
                    this.mycom.delGame(game.getId());
                } else {
                    logger.warning(actionCommand + "called when we are " + this.playerType + " " + this.myusername);
                }
            } else {
                OptionPane.showMessageDialog(null, (Object)("unknown command: " + actionCommand), null, (int)1);
            }
        }
    }

    public void playGame(Game game) {
        if (this.openGameId == game.getId()) {
            return;
        }
        if (this.openGameId != -1) {
            this.closeGame();
        }
        this.openGameId = game.getId();
        this.game.prepareAndOpenGame(game);
    }

    public void sendGameMessage(String messagefromgui) {
        this.mycom.sendGameMessage(this.openGameId, (Object)messagefromgui);
    }

    public void sendChatMessage() {
        final TextField chatText = new TextField();
        StringBuilder messages = new StringBuilder();
        for (String message : this.chatMessages) {
            messages.append(message);
            messages.append('\n');
        }
        OptionPane.showOptionDialog((ActionListener)new ActionListener(){

            public void actionPerformed(String actionCommand) {
                String message = chatText.getText();
                if ("ok".equals(actionCommand) && !"".equals(message.trim())) {
                    MiniLobbyClient.this.sendChatMessage(message);
                }
            }
        }, (Object)new Object[]{messages.toString(), chatText}, (String)"Chat", (int)2, (int)3, null, null, null);
    }

    public void sendChatMessage(String message) {
        this.mycom.sendChat(this.openGameId, message);
    }

    public void closeGame() {
        this.mycom.closeGame(this.openGameId);
        this.openGameId = -1;
        this.chatMessages.clear();
    }

    public void createNewGame(Game game) {
        game.setType(this.theGameType);
        this.mycom.createNewGame(game);
    }

    public ClassLoader getClassLoader(GameType gameType) {
        return this.getClass().getClassLoader();
    }

    public void connected() {
        if (Midlet.getPlatform() == 10) {
            Midlet.openURL((String)"nativeNoResult://net.yura.domination.android.GCMActivity");
        }
        this.mycom.getGameTypes();
    }

    public void disconnected() {
        logger.info("disconnected openGame=" + this.openGameId);
        if (this.openGameId != -1) {
            this.game.disconnected();
            this.openGameId = -1;
            this.chatMessages.clear();
        }
    }

    public void connecting(String message) {
        logger.info(message);
    }

    public void error(String error) {
        logger.info(error);
        OptionPane.showMessageDialog(null, (Object)error, (String)"Lobby Error", (int)0);
    }

    public void setUsername(String name, int type) {
        this.myusername = name;
        this.playerType = type;
        this.list.setPopupMenu(this.playerType >= 3 ? this.adminPopup : null);
        MiniLobbyClient.toast("You are logged in as: " + name);
        this.game.connected(name);
    }

    public String whoAmI() {
        return this.myusername;
    }

    public void addGameType(List gametypes) {
        for (int c = 0; c < gametypes.size(); ++c) {
            GameType gametype = (GameType)gametypes.get(c);
            if (this.game.isMyGameType(gametype)) {
                this.theGameType = gametype;
                this.games.clear();
                this.filter(false);
                this.mycom.getGames(gametype);
                continue;
            }
            logger.info("ignore GameType: " + gametype);
        }
    }

    public void addOrUpdateGame(Game game) {
        int index = Collections.binarySearch(this.games, game);
        if (index >= 0) {
            this.games.set(index, game);
            if (this.whoAmI().equals(game.getWhosTurn())) {
                MiniLobbyClient.notify(game, this.openGameId == game.getId());
            }
        } else {
            this.games.add(-index - 1, game);
        }
        this.filter(true);
        if (index < 0 && game.hasPlayer(this.whoAmI())) {
            this.list.ensureIndexIsVisible(-index - 1);
        }
    }

    public Game findGame(int id) {
        Game g = new Game();
        g.setId(id);
        int index = Collections.binarySearch(this.games, g);
        return index >= 0 ? (Game)this.games.get(index) : null;
    }

    public void resign() {
        this.mycom.leaveGame(this.openGameId);
    }

    public void removeGame(int gameid) {
        Game found = null;
        for (int c = 0; c < this.games.size(); ++c) {
            Game game = (Game)this.games.get(c);
            if (gameid != game.getId()) continue;
            this.games.remove(c);
            found = game;
            break;
        }
        if (found != null) {
            this.filter(true);
        }
    }

    void filter(boolean update) {
        ViewChooser box = (ViewChooser)this.loader.find("listView");
        List newGameList = this.filter(this.games, box.getSelectedItem().getKey());
        Object selected = this.list.getSelectedValue();
        int visIndex = this.list.getFirstVisibleIndex();
        Object visItem = visIndex >= 0 && visIndex < this.list.getSize() ? this.list.getElementAt(visIndex) : null;
        this.list.setListData(RiskUtil.asVector(newGameList));
        if (update) {
            int newIndex;
            if (selected != null && (newIndex = Collections.binarySearch(newGameList, selected)) >= 0) {
                this.list.setSelectedIndex(newIndex);
            }
            if (visItem != null) {
                Component view = ((ScrollPane)DesktopPane.getAncestorOfClass(ScrollPane.class, (Component)this.list)).getView();
                int newIndex2 = Collections.binarySearch(newGameList, visItem);
                if (newIndex2 > visIndex) {
                    view.setLocation(view.getX(), view.getY() - this.list.getFixedCellHeight());
                } else if (newIndex2 < visIndex) {
                    view.setLocation(view.getX(), view.getY() + this.list.getFixedCellHeight());
                }
            }
        } else {
            this.list.setSelectedIndex(-1);
            if (this.list.getSize() > 0) {
                this.list.ensureIndexIsVisible(0);
            }
        }
        this.getRoot().revalidate();
        this.getRoot().repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List filter(List list, String filter) {
        List list2 = list;
        synchronized (list2) {
            if ("all".equals(filter)) {
                return new Vector(list);
            }
            Vector<Game> result = new Vector<Game>();
            for (int c = 0; c < list.size(); ++c) {
                Game game = (Game)list.get(c);
                if ("my".equals(filter)) {
                    if (!game.hasPlayer(this.myusername)) continue;
                    result.add(game);
                    continue;
                }
                if ("open".equals(filter)) {
                    if (game.getNumOfPlayers() >= game.getMaxPlayers()) continue;
                    result.add(game);
                    continue;
                }
                if (!"running".equals(filter) || game.getNumOfPlayers() != game.getMaxPlayers()) continue;
                result.add(game);
            }
            return result;
        }
    }

    public void gameStarted(int id) {
        this.game.gameStarted(id);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void messageForGame(int gameid, Object message) {
        if (gameid == this.openGameId) {
            if (message instanceof String) {
                String string = (String)message;
                if (string.equals("LOBBY_GAMEOVER")) return;
                this.game.stringForGame(string);
                return;
            } else {
                if (!(message instanceof byte[])) throw new RuntimeException("unknown object " + message);
                try {
                    ByteArrayInputStream in = new ByteArrayInputStream((byte[])message);
                    ObjectInputStream oin = new ObjectInputStream(in);
                    Object object = oin.readObject();
                    this.game.objectForGame(object);
                    return;
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        } else {
            logger.info("we got a message for game " + gameid + " but our game is " + this.openGameId);
        }
    }

    public void renamePlayer(String oldname, String newname, int newtype) {
    }

    public void incomingChat(String fromwho, String message) {
        MiniLobbyClient.showMessage(fromwho, message);
    }

    public void incomingChat(int roomid, String fromwho, String message) {
        if (this.openGameId == roomid) {
            if (fromwho != null) {
                if (this.chatMessages.size() >= 4) {
                    this.chatMessages.remove();
                }
                this.chatMessages.add(fromwho + ": " + message);
            }
            MiniLobbyClient.showMessage(fromwho, message);
        }
    }

    public void addPlayer(Player player) {
    }

    public void removePlayer(String player) {
    }

    public void addPlayer(int roomid, Player player) {
    }

    public void removePlayer(int roomid, String player) {
    }

    public void privateMessage(String fromwho, String message) {
    }

    public void setUserInfo(String user, List info) {
    }

    static void showMessage(String fromwho, String message) {
        if (fromwho != null) {
            MiniLobbyClient.toast(fromwho + ": " + message);
        } else {
            MiniLobbyClient.toast(message);
        }
    }

    static void notify(Game game, boolean onlyBackground) {
        String title = game.getType().getName();
        String message = "It is your go: " + game.getName();
        int gameId = game.getId();
        String options = game.getOptions();
        String icon = "icon";
        Midlet.openURL((String)("notify://dummyServer?title=" + Url.encode((String)title) + "&message=" + Url.encode((String)message) + "&icon=" + Url.encode((String)icon) + "&onlyBackground=" + onlyBackground + "&" + Url.encode((String)EXTRA_GAME_ID) + "=" + Url.encode((String)String.valueOf(gameId)) + "&" + Url.encode((String)EXTRA_GAME_OPTIONS) + "=" + Url.encode((String)options)));
    }

    static void toast(String message) {
        if (Display.getDisplay((MIDlet)Midlet.getMidlet()).getCurrent() != null) {
            if (Midlet.getPlatform() == 10) {
                Midlet.openURL((String)("toast://show?message=" + Url.encode((String)message)));
            } else {
                DesktopPane.getDesktopPane().toast(message);
            }
        }
    }
}

