/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.ui.swinggui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import net.yura.domination.engine.Risk;
import net.yura.domination.engine.RiskUIUtil;
import net.yura.domination.engine.SwingMEWrapper;
import net.yura.domination.engine.translation.TranslationBundle;
import net.yura.domination.ui.swinggui.SwingGUITab;
import net.yura.lobby.mini.MiniLobbyClient;
import net.yura.lobby.model.Game;
import net.yura.me4se.ME4SEPanel;
import net.yura.mobile.gui.components.Label;

public class LobbyTab
extends ME4SEPanel
implements SwingGUITab,
ActionListener {
    ResourceBundle resb = TranslationBundle.getBundle();
    MiniLobbyClient mlc;
    Risk risk;
    JToolBar toolbar;
    JButton start;
    JButton start2;
    JButton stop;
    JButton open;

    public LobbyTab(Risk myrisk) {
        this.getApplicationManager().applet = RiskUIUtil.applet;
        this.risk = myrisk;
        this.toolbar = new JToolBar();
        this.toolbar.setRollover(true);
        this.toolbar.setFloatable(false);
        this.start = new JButton("Start Lobby");
        this.start.setActionCommand("start");
        this.start.addActionListener(this);
        this.toolbar.add(this.start);
        this.start2 = new JButton("Connect to Server");
        this.start2.setActionCommand("start2");
        this.start2.addActionListener(this);
        this.toolbar.add(this.start2);
        this.stop = new JButton("Stop Lobby");
        this.stop.setActionCommand("stop");
        this.stop.addActionListener(this);
        this.toolbar.add(this.stop);
        this.open = new JButton("Open Game");
        this.open.setActionCommand("open");
        this.open.addActionListener(this);
        this.open.setEnabled(false);
        this.toolbar.add(this.open);
        this.updateButton();
        this.add((net.yura.mobile.gui.components.Component)new Label("click start in the toolbar"));
    }

    public void actionPerformed(ActionEvent e) {
        block13: {
            String action = e.getActionCommand();
            if ("start".equals(action)) {
                this.createLobby("lobby.yura.net");
                this.updateButton();
            } else if ("start2".equals(action)) {
                String server = JOptionPane.showInputDialog((Component)((Object)this), "Server:", "localhost");
                if (server != null) {
                    this.createLobby(server);
                    this.updateButton();
                }
            } else if ("stop".equals(action)) {
                this.closeLobby();
                this.updateButton();
            } else if ("open".equals(action)) {
                String input = JOptionPane.showInputDialog((Component)((Object)this), (Object)"game id:");
                if (input != null) {
                    try {
                        int id = Integer.parseInt(input);
                        Game game = this.mlc.findGame(id);
                        if (game != null) {
                            this.mlc.playGame(game);
                            break block13;
                        }
                        JOptionPane.showMessageDialog((Component)((Object)this), "game " + id + " not found");
                    }
                    catch (NumberFormatException ex) {
                        JOptionPane.showMessageDialog((Component)((Object)this), input + " not a number");
                    }
                }
            } else {
                throw new RuntimeException("unknown action " + action);
            }
        }
    }

    private void updateButton() {
        this.start.setEnabled(this.mlc == null);
        this.start2.setEnabled(this.mlc == null);
        this.stop.setEnabled(this.mlc != null);
        this.open.setEnabled(this.mlc != null);
    }

    public JToolBar getToolBar() {
        return this.toolbar;
    }

    public JMenu getMenu() {
        return null;
    }

    public String getName() {
        return this.resb.getString("swing.tab.online");
    }

    void createLobby(String server) {
        this.mlc = SwingMEWrapper.makeMiniLobbyClient(server, this.risk, SwingUtilities.getWindowAncestor((Component)((Object)this)));
        this.mlc.removeBackButton();
        this.add((net.yura.mobile.gui.components.Component)this.mlc.getRoot());
    }

    void closeLobby() {
        this.mlc.destroy();
        this.mlc = null;
        this.add((net.yura.mobile.gui.components.Component)new Label("no lobby"));
    }
}

