/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.lobby.mini;

import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import net.yura.domination.engine.OnlineRisk;
import net.yura.domination.engine.OnlineUtil;
import net.yura.domination.engine.Risk;
import net.yura.domination.engine.RiskUtil;
import net.yura.domination.engine.core.Player;
import net.yura.domination.engine.core.RiskGame;
import net.yura.domination.engine.translation.TranslationBundle;
import net.yura.domination.mapstore.GetMap;
import net.yura.domination.mapstore.MapChooser;
import net.yura.domination.mapstore.MapServerClient;
import net.yura.domination.mapstore.MapServerListener;
import net.yura.domination.mapstore.MapUpdateService;
import net.yura.lobby.mini.MiniLobbyClient;
import net.yura.lobby.mini.MiniLobbyGame;
import net.yura.lobby.model.Game;
import net.yura.lobby.model.GameType;
import net.yura.mobile.gui.Icon;
import net.yura.mobile.util.Properties;
import net.yura.swingme.core.CoreUtil;

public abstract class MiniLobbyRisk
implements MiniLobbyGame,
OnlineRisk {
    private static final Logger logger = Logger.getLogger(MiniLobbyRisk.class.getName());
    private Risk myrisk;
    protected MiniLobbyClient lobby;
    private boolean openGame;
    WeakHashMap mapping = new WeakHashMap();
    MapServerClient mapServerClient;

    public MiniLobbyRisk(Risk risk) {
        this.myrisk = risk;
    }

    public void addLobbyGameMoveListener(MiniLobbyClient lgl) {
        this.lobby = lgl;
    }

    public Properties getProperties() {
        return CoreUtil.wrap(TranslationBundle.getBundle());
    }

    public boolean isMyGameType(GameType gametype) {
        return RiskUtil.GAME_NAME.equals(gametype.getName());
    }

    public void prepareAndOpenGame(final Game game) {
        final String mapUID = OnlineUtil.getMapNameFromLobbyStartGameOption(game.getOptions());
        if (MapChooser.haveLocalMap(mapUID) && !MapUpdateService.getInstance().contains(mapUID)) {
            this.lobby.mycom.playGame(game.getId());
        } else {
            GetMap.getMap(mapUID, new Observer(){

                public void update(Observable observable, Object data) {
                    if (data == RiskUtil.SUCCESS) {
                        MiniLobbyRisk.this.lobby.mycom.playGame(game.getId());
                    } else {
                        MiniLobbyRisk.this.lobby.error("map download failed " + mapUID);
                    }
                }
            });
        }
    }

    public void objectForGame(Object object) {
        if (object instanceof RiskGame) {
            RiskGame thegame = (RiskGame)object;
            Player player = thegame.getPlayer(this.lobby.whoAmI());
            String address = player == null ? "_watch_" : player.getAddress();
            this.myrisk.setOnlinePlay(this);
            this.myrisk.setAddress(address);
            this.myrisk.setGame(thegame);
            this.openGame = true;
        } else if (object instanceof Map) {
            Map map = (Map)object;
            String command = (String)map.get("command");
            if ("game".equals(command)) {
                String address = (String)map.get("playerId");
                RiskGame thegame = (RiskGame)map.get("game");
                this.myrisk.setOnlinePlay(this);
                this.myrisk.setAddress(address);
                this.myrisk.setGame(thegame);
                this.openGame = true;
            } else {
                System.out.println("unknown command " + command + " " + map);
            }
        } else {
            System.out.println("unknown object " + object);
        }
    }

    public void stringForGame(String message) {
        if (this.openGame) {
            this.myrisk.parserFromNetwork(message);
        } else {
            logger.info("GAME NOT OPEN SO IGNORING: " + message);
        }
    }

    public void disconnected() {
        this.myrisk.disconnected();
    }

    public void connected(String username) {
    }

    public void joinPrivateGame() {
    }

    public void gameStarted(int id) {
    }

    public Icon getIconForGame(Game game) {
        String mapUID = OnlineUtil.getMapNameFromLobbyStartGameOption(game.getOptions());
        this.mapping.put(game, mapUID);
        if (MapChooser.haveLocalMap(mapUID)) {
            return MapChooser.getLocalIconForMap(MapChooser.createMap(mapUID));
        }
        if (this.mapServerClient == null) {
            this.mapServerClient = new MapServerClient(new MapServerListener(){

                public void gotResultCategories(String url, List categories) {
                }

                public void gotResultMaps(String url, List maps) {
                    if (maps.size() != 1) {
                        logger.warning("no map found on MapServer for " + url);
                        return;
                    }
                    net.yura.domination.mapstore.Map map = (net.yura.domination.mapstore.Map)maps.get(0);
                    String mapUIDkey = MapChooser.getFileUID(map.getMapUrl());
                    boolean fromCache = MapChooser.getRemoteImage(mapUIDkey, MapChooser.getURL(url, map.getPreviewUrl()), MiniLobbyRisk.this.mapServerClient);
                    if (fromCache) {
                        this.publishImg(mapUIDkey);
                    }
                }

                public void onXMLError(String string) {
                    logger.info("ERROR " + string);
                }

                public void downloadFinished(String mapUID) {
                }

                public void onDownloadError(String string) {
                }

                public void publishImg(Object key) {
                    MiniLobbyRisk.this.lobby.getRoot().repaint();
                }
            });
            this.mapServerClient.start();
        }
        return MapChooser.getRemoteIconForMap(mapUID, this.mapServerClient);
    }

    public void lobbyShutdown() {
        if (this.mapServerClient != null) {
            this.mapServerClient.kill();
            this.mapServerClient = null;
        }
    }

    public String getGameDescription(Game game) {
        return OnlineUtil.getGameDescriptionFromLobbyStartGameOption(game.getOptions());
    }

    public void sendUserCommand(String messagefromgui) {
        this.lobby.sendGameMessage(messagefromgui);
    }

    public void sendGameCommand(String mtemp) {
        logger.info("ignore GameCommand " + mtemp);
    }

    public void closeGame() {
        this.openGame = false;
        this.lobby.closeGame();
    }

    public void playerRenamed(String oldName, String newName, String newAddress, int newType) {
        if (oldName.equals(this.lobby.whoAmI())) {
            this.myrisk.setAddress("_watch_");
        }
        if (newName.equals(this.lobby.whoAmI())) {
            this.myrisk.setAddress(newAddress);
        }
    }
}

