/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.lobby.client;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import net.yura.domination.engine.RiskUtil;
import net.yura.domination.mapstore.MapChooser;
import net.yura.domination.mapstore.MapUpdateService;
import net.yura.swing.GraphicsUtil;

public class RiskMap {
    private static final Logger logger = Logger.getLogger(RiskMap.class.getName());
    private static ExecutorService executor = Executors.newFixedThreadPool(4);
    private static Map<String, RiskMap> mapUIDToIcon = new WeakHashMap<String, RiskMap>();
    private Map<Long, Icon> iconMap = new HashMap<Long, Icon>();
    private List<Component> components = new ArrayList<Component>();
    private Image image;
    private String mapUID;
    private net.yura.domination.mapstore.Map map;
    private AtomicBoolean requestMade = new AtomicBoolean();
    private String[] missions;

    private RiskMap(String mapUID) {
        this.mapUID = mapUID;
    }

    public net.yura.domination.mapstore.Map getMap() {
        return this.map;
    }

    public Icon getIcon(int w, int h, Component comp) {
        List<Component> comps;
        final int width = GraphicsUtil.scale(w);
        final int height = GraphicsUtil.scale(h);
        long id = ByteBuffer.allocate(8).putInt(width).putInt(height).getLong(0);
        Icon icon = this.iconMap.get(id);
        if (icon == null) {
            icon = new Icon(){

                public void paintIcon(Component c, Graphics g, int x, int y) {
                    if (RiskMap.this.image == null) {
                        if (!RiskMap.this.requestMade.getAndSet(true)) {
                            executor.submit(new Runnable(){

                                public void run() {
                                    try {
                                        if (RiskMap.this.isLocalMap()) {
                                            RiskMap.this.map = MapChooser.createMap(RiskMap.this.mapUID);
                                            net.yura.mobile.gui.Icon icon = MapChooser.getLocalIconForMap(RiskMap.this.map);
                                            javax.microedition.lcdui.Image img = icon.getImage();
                                            RiskMap.this.setImage(img._image);
                                        } else {
                                            RiskMap.this.map = MapUpdateService.getOnlineMap(RiskMap.this.mapUID);
                                            if (RiskMap.this.map != null) {
                                                RiskMap.this.setImage(ImageIO.read(new URL(new URL(MapChooser.MAP_PAGE), RiskMap.this.map.getPreviewUrl())));
                                            } else {
                                                logger.log(Level.INFO, "no online map found " + RiskMap.this.mapUID);
                                            }
                                        }
                                    }
                                    catch (Throwable ex) {
                                        logger.log(Level.WARNING, "failed to get " + RiskMap.this.mapUID, ex);
                                    }
                                }
                            });
                        }
                    } else {
                        g.drawImage(RiskMap.this.image, x, y, width, height, c);
                    }
                }

                public int getIconWidth() {
                    return width;
                }

                public int getIconHeight() {
                    return height;
                }
            };
            this.iconMap.put(id, icon);
        }
        if ((comps = this.components) != null) {
            comps.add(comp);
        }
        return icon;
    }

    public boolean isLocalMap() {
        return MapChooser.haveLocalMap(this.mapUID) && !MapUpdateService.getInstance().contains(this.mapUID);
    }

    private void setImage(Image icon) {
        this.image = icon;
        for (int c = 0; c < this.components.size(); ++c) {
            this.components.get(c).repaint();
        }
        this.components = null;
    }

    public String toString() {
        return this.map == null ? this.mapUID : this.map.getName();
    }

    public String getID() {
        return this.mapUID;
    }

    public String[] getMissions() {
        if (this.missions != null) {
            return this.missions;
        }
        Map mapinfo = RiskUtil.loadInfo(this.mapUID, false);
        String cardsFile = (String)mapinfo.get("crd");
        if (cardsFile != null) {
            Map cardsinfo = RiskUtil.loadInfo(cardsFile, true);
            this.missions = (String[])cardsinfo.get("missions");
        } else {
            logger.warning("no crd file in " + this.mapUID);
            this.missions = new String[0];
        }
        return this.missions;
    }

    public static RiskMap getMapIcon(String mapUID) {
        RiskMap icon = mapUIDToIcon.get(mapUID);
        if (icon == null) {
            icon = new RiskMap(mapUID);
            mapUIDToIcon.put(mapUID, icon);
        }
        return icon;
    }
}

