/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.lobby.client;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.HashSet;
import java.util.Observable;
import java.util.Observer;
import java.util.ResourceBundle;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.yura.domination.engine.OnlineUtil;
import net.yura.domination.engine.RiskUtil;
import net.yura.domination.engine.translation.TranslationBundle;
import net.yura.domination.lobby.client.RiskMap;
import net.yura.domination.mapstore.GetMap;
import net.yura.domination.mapstore.Map;
import net.yura.domination.ui.flashgui.NewGameFrame;
import net.yura.lobby.model.Game;
import net.yura.swing.GraphicsUtil;
import net.yura.swing.ImageIcon;
import net.yura.swing.SpriteIcon;

public class GameSetupPanel
extends JPanel
implements ActionListener {
    private BufferedImage newgame;
    private BufferedImage game2;
    private BufferedImage card;
    private JLabel mapPic;
    private JPanel mapsMissions;
    private JButton start;
    private JButton cancel;
    private JRadioButton domination;
    private JRadioButton capital;
    private JRadioButton mission;
    private JRadioButton fixed;
    private JRadioButton increasing;
    private JRadioButton italian;
    private JCheckBox AutoPlaceAll;
    private JCheckBox recycle;
    private ResourceBundle resb;
    private String options;
    private JList list;
    private JDialog dialog;
    private RiskMap riskmap;
    private JSpinner human;
    private JSpinner aieasy;
    private JSpinner aiaverage;
    private JSpinner aihard;
    private JTextField gamename;
    private Set<RiskMap> downloading = Collections.synchronizedSet(new HashSet());
    private JComboBox timeout;
    private String newGameOptions;

    public GameSetupPanel() {
        this.resb = TranslationBundle.getBundle();
        this.setLayout(null);
        Dimension d = GraphicsUtil.newDimension(700, 600);
        this.setPreferredSize(d);
        this.setMinimumSize(d);
        this.setMaximumSize(d);
        try {
            this.newgame = ImageIO.read(NewGameFrame.class.getResource("newgame.jpg"));
            this.game2 = ImageIO.read(this.getClass().getResource("game2.jpg"));
            this.card = this.game2.getSubimage(0, 247, 23, 35);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        this.mapPic = new JLabel();
        GraphicsUtil.setBounds(this.mapPic, 51, 51, 203, 127);
        this.add(this.mapPic);
        this.mapsMissions = new JPanel();
        this.mapsMissions.setOpaque(false);
        this.mapsMissions.setLayout(new BoxLayout(this.mapsMissions, 1));
        JScrollPane sp2 = new JScrollPane(this.mapsMissions);
        GraphicsUtil.setBounds(sp2, 340, 51, 309, 200);
        sp2.setBorder(null);
        sp2.setOpaque(false);
        sp2.getViewport().setOpaque(false);
        this.add(sp2);
        this.list = new JList();
        this.list.setCellRenderer(new RiskMapListCellRenderer());
        this.list.setFixedCellWidth(10);
        this.list.setSelectionMode(0);
        JScrollPane scrollPane = new JScrollPane(this.list);
        GraphicsUtil.setBounds(scrollPane, 54, 192, 200, 260);
        scrollPane.setBorder(null);
        this.list.setOpaque(false);
        scrollPane.setOpaque(false);
        scrollPane.getViewport().setOpaque(false);
        this.add(scrollPane);
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                final RiskMap it = (RiskMap)GameSetupPanel.this.list.getSelectedValue();
                if (it != null) {
                    if (!it.isLocalMap()) {
                        int result;
                        GameSetupPanel.this.list.setSelectedValue(GameSetupPanel.this.riskmap, false);
                        if (GameSetupPanel.this.downloading.contains(it)) {
                            return;
                        }
                        String[] message = new String[]{"Do you want to Download", "map: " + it.toString()};
                        Map map = it.getMap();
                        if (map != null) {
                            message = new String[]{message[0], message[1], "By: " + map.getAuthorName(), "Downloads: " + map.getNumberOfDownloads(), "Version: " + map.getVersion(), map.getDescription()};
                        }
                        if ((result = JOptionPane.showInternalConfirmDialog(GameSetupPanel.this, message, "Download?", 2, 3, it.getIcon(203, 127, GameSetupPanel.this))) == 0) {
                            GameSetupPanel.this.downloading.add(it);
                            GetMap.getMap(it.getID(), new Observer(){

                                public void update(Observable o, Object result) {
                                    GameSetupPanel.this.downloading.remove(it);
                                    if (result == RiskUtil.SUCCESS) {
                                        GameSetupPanel.this.list.setSelectedValue(it, true);
                                    }
                                }
                            });
                        }
                    } else {
                        GameSetupPanel.this.riskmap = it;
                        GameSetupPanel.this.mapPic.setIcon(GameSetupPanel.this.riskmap.getIcon(203, 127, GameSetupPanel.this.mapPic));
                        GameSetupPanel.this.mapsMissions.removeAll();
                        String[] missions = GameSetupPanel.this.riskmap.getMissions();
                        for (int c = 0; c < missions.length; ++c) {
                            GameSetupPanel.this.mapsMissions.add(GameSetupPanel.this.makeNewMission(missions[c]));
                            GameSetupPanel.this.mapsMissions.add(Box.createVerticalStrut(3));
                        }
                        if (missions.length == 0) {
                            GameSetupPanel.this.mapsMissions.add(new JLabel(" No missions for this map."));
                            if (GameSetupPanel.this.mission.isSelected()) {
                                GameSetupPanel.this.domination.setSelected(true);
                                GameSetupPanel.this.AutoPlaceAll.setEnabled(true);
                            }
                        }
                        GameSetupPanel.this.mission.setEnabled(missions.length != 0);
                        GameSetupPanel.this.mapsMissions.revalidate();
                    }
                }
            }
        });
        this.human = new JSpinner(new SpinnerNumberModel(2, 1, 6, 1));
        this.aiaverage = new JSpinner(new SpinnerNumberModel(0, 0, 6, 1));
        this.aieasy = new JSpinner(new SpinnerNumberModel(2, 0, 6, 1));
        this.aihard = new JSpinner(new SpinnerNumberModel(2, 0, 6, 1));
        this.dontStretch(this.human);
        this.dontStretch(this.aiaverage);
        this.dontStretch(this.aieasy);
        this.dontStretch(this.aihard);
        JPanel playernum = new JPanel(new GridBagLayout());
        GraphicsUtil.setBounds(playernum, 320, 280, 350, 60);
        playernum.setOpaque(false);
        this.add(playernum);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 0, 0, 5);
        playernum.add((Component)this.newShrinkJLabel(this.resb.getString("newgame.player.type.human")), gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 0, 0, 0);
        playernum.add((Component)this.human, gbc);
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 15, 0, 5);
        playernum.add((Component)this.newShrinkJLabel(this.resb.getString("newgame.player.type.easyai")), gbc);
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 0, 0, 0);
        playernum.add((Component)this.aieasy, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = new Insets(5, 0, 0, 5);
        playernum.add((Component)this.newShrinkJLabel(this.resb.getString("newgame.player.type.averageai")), gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.insets = new Insets(5, 0, 0, 0);
        playernum.add((Component)this.aiaverage, gbc);
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.insets = new Insets(5, 15, 0, 5);
        playernum.add((Component)this.newShrinkJLabel(this.resb.getString("newgame.player.type.hardai")), gbc);
        gbc.gridx = 3;
        gbc.gridy = 1;
        gbc.insets = new Insets(5, 0, 0, 0);
        playernum.add((Component)this.aihard, gbc);
        ButtonGroup GameTypeButtonGroup = new ButtonGroup();
        ButtonGroup CardTypeButtonGroup = new ButtonGroup();
        int bw1 = 119;
        int bw2 = 180;
        int bh = 25;
        this.domination = new JRadioButton(this.resb.getString("newgame.mode.domination"), true);
        NewGameFrame.sortOutButton(this.domination);
        GraphicsUtil.setBounds(this.domination, 380, 370, bw1, bh);
        this.domination.addActionListener(this);
        this.capital = new JRadioButton(this.resb.getString("newgame.mode.capital"));
        NewGameFrame.sortOutButton(this.capital);
        GraphicsUtil.setBounds(this.capital, 380, 390, bw1, bh);
        this.capital.addActionListener(this);
        this.mission = new JRadioButton(this.resb.getString("newgame.mode.mission"));
        NewGameFrame.sortOutButton(this.mission);
        GraphicsUtil.setBounds(this.mission, 380, 410, bw1, bh);
        this.mission.addActionListener(this);
        this.increasing = new JRadioButton(this.resb.getString("newgame.cardmode.increasing"), true);
        NewGameFrame.sortOutButton(this.increasing);
        GraphicsUtil.setBounds(this.increasing, 500, 370, bw2, bh);
        this.fixed = new JRadioButton(this.resb.getString("newgame.cardmode.fixed"));
        NewGameFrame.sortOutButton(this.fixed);
        GraphicsUtil.setBounds(this.fixed, 500, 390, bw2, bh);
        this.italian = new JRadioButton(this.resb.getString("newgame.cardmode.italianlike"));
        NewGameFrame.sortOutButton(this.italian);
        GraphicsUtil.setBounds(this.italian, 500, 410, bw2, bh);
        GameTypeButtonGroup.add(this.domination);
        GameTypeButtonGroup.add(this.capital);
        GameTypeButtonGroup.add(this.mission);
        CardTypeButtonGroup.add(this.fixed);
        CardTypeButtonGroup.add(this.increasing);
        CardTypeButtonGroup.add(this.italian);
        this.add(this.domination);
        this.add(this.capital);
        this.add(this.mission);
        this.add(this.fixed);
        this.add(this.increasing);
        this.add(this.italian);
        this.AutoPlaceAll = new JCheckBox(this.resb.getString("newgame.autoplace"));
        NewGameFrame.sortOutButton(this.AutoPlaceAll);
        GraphicsUtil.setBounds(this.AutoPlaceAll, 380, 440, bw1, bh);
        this.recycle = new JCheckBox(this.resb.getString("newgame.recycle"));
        NewGameFrame.sortOutButton(this.recycle);
        GraphicsUtil.setBounds(this.recycle, 500, 440, bw2, bh);
        this.add(this.AutoPlaceAll);
        this.add(this.recycle);
        int w = 115;
        int h = 31;
        this.cancel = new JButton(this.resb.getString("newgame.cancel"));
        NewGameFrame.sortOutButton(this.cancel, this.newgame.getSubimage(41, 528, w, h), this.newgame.getSubimage(700, 233, w, h), this.newgame.getSubimage(700, 264, w, h));
        this.cancel.addActionListener(this);
        GraphicsUtil.setBounds(this.cancel, 41, 528, 115, 31);
        Box bottompanel = Box.createHorizontalBox();
        bottompanel.setOpaque(false);
        bottompanel.add(new JLabel(this.resb.getString("newgame.label.name")));
        this.gamename = new JTextField();
        this.dontStretch(this.gamename);
        bottompanel.add(this.gamename);
        bottompanel.add(Box.createHorizontalStrut(10));
        bottompanel.add(new JLabel(this.resb.getString("newgame.label.timeout")));
        int hour = 3600;
        Timeout[] timeouts = new Timeout[]{new Timeout("10sec", 10), new Timeout("20sec", 20), new Timeout("30sec", 30), new Timeout("1min", 60), new Timeout("5min", 300), new Timeout("10min", 600), new Timeout("20min", 1200), new Timeout("30min", 1800), new Timeout("1hour", hour), new Timeout("2hours", hour * 2), new Timeout("6hours", hour * 6), new Timeout("12hours", hour * 12), new Timeout("24hours", hour * 24)};
        this.timeout = new JComboBox<Timeout>(timeouts);
        this.dontStretch(this.timeout);
        this.timeout.setSelectedIndex(3);
        bottompanel.add(this.timeout);
        GraphicsUtil.setBounds(bottompanel, 170, 504, 360, 80);
        this.add(bottompanel);
        this.start = new JButton(this.resb.getString("newgame.startgame"));
        NewGameFrame.sortOutButton(this.start, this.newgame.getSubimage(544, 528, w, h), this.newgame.getSubimage(700, 295, w, h), this.newgame.getSubimage(700, 326, w, h));
        this.start.addActionListener(this);
        GraphicsUtil.setBounds(this.start, 544, 528, 115, 31);
        this.add(this.cancel);
        this.add(this.start);
        this.list.setFixedCellHeight(GraphicsUtil.scale(33));
    }

    private JLabel newShrinkJLabel(String text) {
        JLabel label = new JLabel(text);
        label.setHorizontalAlignment(11);
        return label;
    }

    private void dontStretch(JComponent comp) {
        comp.setMaximumSize(new Dimension(comp.getMaximumSize().width, comp.getPreferredSize().height));
    }

    public Game showDialog(Window parent, String serveroptions, String defaultGameName) {
        this.gamename.setText(defaultGameName);
        if (this.dialog == null) {
            this.dialog = GameSetupPanel.newJDialog(parent, "Game Options", true);
            this.dialog.setContentPane(this);
            this.dialog.setResizable(false);
            this.dialog.pack();
        }
        if (serveroptions != null && !serveroptions.equals(this.newGameOptions)) {
            this.newGameOptions = serveroptions;
            String[] split = this.newGameOptions.split(",");
            RiskMap[] maps = new RiskMap[split.length];
            for (int c = 0; c < maps.length; ++c) {
                maps[c] = RiskMap.getMapIcon(GameSetupPanel.decode(split[c]));
            }
            this.list.setListData(maps);
            this.list.setSelectedIndex(0);
        }
        this.reset();
        this.dialog.setVisible(true);
        String op = this.getOptions();
        if (op != null) {
            return new Game(this.getGameName(), op, this.getNumberOfHumanPlayers(), ((Timeout)this.timeout.getSelectedItem()).getTime());
        }
        return null;
    }

    static JDialog newJDialog(Window parent, String title, boolean modal) {
        if (parent instanceof Frame) {
            return new JDialog((Frame)parent, title, modal);
        }
        return new JDialog((Dialog)parent, title, modal);
    }

    private static String decode(String text) {
        try {
            return URLDecoder.decode(text, "UTF-8");
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public JList getList() {
        return this.list;
    }

    public JPanel makeNewMission(String a) {
        JPanel mission = new JPanel(){

            public void paintComponent(Graphics g) {
                g.setColor(new Color(255, 255, 255, 100));
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        };
        mission.setOpaque(false);
        mission.setLayout(new BorderLayout());
        JLabel cl = new JLabel(new ImageIcon(this.card));
        cl.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
        mission.add((Component)cl, "West");
        JTextArea text = new JTextArea(a);
        text.setLineWrap(true);
        text.setWrapStyleWord(true);
        text.setEditable(false);
        text.setOpaque(false);
        mission.add(text);
        return mission;
    }

    public String getOptions() {
        return this.options;
    }

    public String getGameName() {
        return this.gamename.getText();
    }

    public int getNumberOfHumanPlayers() {
        return (Integer)this.human.getValue();
    }

    public void paintComponent(Graphics g) {
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        GraphicsUtil.drawImage(g, this.newgame, 0, 0, this);
        GraphicsUtil.drawImage(g, this.game2.getSubimage(0, 0, 223, 155), 41, 185, this);
        GraphicsUtil.drawImage(g, this.game2.getSubimage(25, 155, 169, 127), 391, 325, this);
        g.setColor(Color.black);
        GraphicsUtil.drawString(g, this.resb.getString("newgame.label.map"), 55, 40);
        GraphicsUtil.drawString(g, "Missions:", 350, 40);
        GraphicsUtil.drawString(g, "Number of Players", 440, 275);
        GraphicsUtil.drawString(g, this.resb.getString("newgame.label.gametype"), 400, 365);
        GraphicsUtil.drawString(g, this.resb.getString("newgame.label.cardsoptions"), 515, 365);
    }

    public void reset() {
        this.options = null;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.start) {
            int d;
            int c;
            int b;
            int a = (Integer)this.human.getValue();
            int sum = a + (b = ((Integer)this.aieasy.getValue()).intValue()) + (c = ((Integer)this.aiaverage.getValue()).intValue()) + (d = ((Integer)this.aihard.getValue()).intValue());
            if (sum >= 2 && sum <= 6) {
                int gameMode = this.domination.isSelected() ? 0 : (this.capital.isSelected() ? 2 : 3);
                int cardsMode = this.increasing.isSelected() ? 0 : (this.fixed.isSelected() ? 1 : 2);
                this.options = OnlineUtil.createGameString(b, c, d, gameMode, cardsMode, this.AutoPlaceAll.isSelected(), this.recycle.isSelected(), this.riskmap.getID());
                this.dialog.setVisible(false);
            } else {
                JOptionPane.showMessageDialog(this, this.resb.getString("newgame.error.numberofplayers"), this.resb.getString("newgame.error.title"), 0);
            }
        } else if (e.getSource() == this.cancel) {
            this.dialog.setVisible(false);
        } else if (e.getSource() == this.mission) {
            this.AutoPlaceAll.setEnabled(false);
        } else if (e.getSource() == this.domination) {
            this.AutoPlaceAll.setEnabled(true);
        } else if (e.getSource() == this.capital) {
            this.AutoPlaceAll.setEnabled(true);
        }
    }

    class RiskMapListCellRenderer
    extends DefaultListCellRenderer {
        private final Icon downloadIcon = new ImageIcon(this.getClass().getResource("/ms_download.png"));
        private final Icon downloadingIcon = new SpriteIcon(this.getClass().getResource("/ms_strip.png"), 1, 8);
        private JComponent component;
        private RiskMap map;

        RiskMapListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component retValue = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.setBackground(isSelected ? new Color(255, 255, 255, 100) : new Color(0, 0, 0, 0));
            this.component = list;
            if (value instanceof RiskMap) {
                this.map = (RiskMap)value;
                this.setIcon(this.map.getIcon(50, 31, list));
            }
            return retValue;
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (GameSetupPanel.this.downloading.contains(this.map)) {
                int x = this.getWidth() - this.downloadingIcon.getIconWidth() - 5;
                int y = (this.getHeight() - this.downloadingIcon.getIconHeight()) / 2;
                g.setColor(Color.WHITE);
                g.fillOval(x, y, this.downloadingIcon.getIconWidth(), this.downloadingIcon.getIconHeight());
                this.downloadingIcon.paintIcon(this.component, g, x, y);
            } else if (!this.map.isLocalMap()) {
                this.downloadIcon.paintIcon(this.component, g, this.getWidth() - this.downloadIcon.getIconWidth() - 5, (this.getHeight() - this.downloadIcon.getIconHeight()) / 2);
            }
        }
    }

    class Timeout {
        String name;
        int time;

        Timeout(String name, int time) {
            this.name = GameSetupPanel.this.resb.getString("newgame.timeout." + name);
            this.time = time;
        }

        int getTime() {
            return this.time;
        }

        public String toString() {
            return this.name;
        }
    }
}

