/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.engine;

import net.yura.domination.engine.RiskUtil;

public class OnlineUtil {
    public static String getDefaultOnlineGameName(String username) {
        return "Cadet Game";
    }

    public static String createGameString(int easyAI, int averageAI, int hardAI, int gameMode, int cardsMode, boolean AutoPlaceAll, boolean recycle, String mapFile) {
        String players = averageAI + "\n" + easyAI + "\n" + hardAI + "\n";
        String type = "";
        switch (gameMode) {
            case 0: {
                type = "domination";
                break;
            }
            case 2: {
                type = "capital";
                break;
            }
            case 3: {
                type = "mission";
            }
        }
        switch (cardsMode) {
            case 0: {
                type = type + " increasing";
                break;
            }
            case 1: {
                type = type + " fixed";
                break;
            }
            case 2: {
                type = type + " italianlike";
            }
        }
        if (AutoPlaceAll) {
            type = type + " autoplaceall";
        }
        if (recycle) {
            type = type + " recycle";
        }
        return players + "choosemap " + mapFile + "\nstartgame " + type;
    }

    public static String getMapNameFromLobbyStartGameOption(String options) {
        String[] lines = options.split(RiskUtil.quote("\n"));
        String choosemap = lines[3];
        return choosemap.substring("choosemap ".length()).intern();
    }

    public static String getGameDescriptionFromLobbyStartGameOption(String options) {
        String[] lines = options.split(RiskUtil.quote("\n"));
        int aiTotal = 0;
        for (int c = 0; c < 3; ++c) {
            aiTotal += Integer.parseInt(lines[c]);
        }
        String aiInfo = aiTotal == 0 ? "0" : lines[1] + "," + lines[0] + "," + lines[2];
        return "AI:" + aiInfo + " " + lines[4].substring("startgame ".length());
    }
}

