/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.awt.Color;
import java.awt.Rectangle;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.midlet.ApplicationManager;
import org.me4se.impl.Log;
import org.me4se.scm.ScmComponent;

class ScmCanvas
extends ScmComponent {
    Canvas canvas;
    boolean first = true;
    int keyCode;
    final Object repaintLock = new Object();
    boolean repaintPending;
    public static final int DRAGGED = 0;
    public static final int PRESSED = 1;
    public static final int RELEASED = 2;
    int pointx;
    int pointy;

    ScmCanvas(Canvas canvas) {
        this.canvas = canvas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(java.awt.Graphics g) {
        try {
            Object object = this.repaintLock;
            synchronized (object) {
                Graphics mg = new Graphics(this.canvas, null, g);
                if (mg != null) {
                    this.repaintPending = false;
                    Log.log(1, "ScmCanvas.paint() entering");
                    if (this.canvas.oldW != this.canvas.getWidth() || this.canvas.oldH != this.canvas.getHeight()) {
                        try {
                            this.canvas.sizeChanged(this.canvas.getWidth(), this.canvas.getHeight());
                            this.canvas.oldW = this.canvas.getWidth();
                            this.canvas.oldH = this.canvas.getHeight();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    Rectangle clip = g.getClipBounds();
                    mg.clipRect(clip.x, clip.y, clip.width, clip.height);
                    this.canvas.paint(mg);
                    Log.log(1, "ScmCanvas.paint() left");
                    if (this.canvas.videoFrameImage != null) {
                        mg.drawImage(this.canvas.videoFrameImage, this.canvas.videoFrameX, this.canvas.videoFrameY, 20);
                    }
                } else {
                    this.repaint();
                }
                if (this.pointx != 0 && this.pointy != 0) {
                    g.setColor(Color.RED);
                    this.drawPoint(g, this.pointx, this.pointy);
                    this.drawPoint(g, this.getWidth() - this.pointx, this.getHeight() - this.pointy);
                }
                this.repaintLock.notify();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void drawPoint(java.awt.Graphics g, int x, int y) {
        g.drawLine(x, y + 5, x, y - 5);
        g.drawLine(x + 5, y, x - 5, y);
    }

    public boolean mouseDragged(int x, int y, int modifiers) {
        if (this.canvas.hasPointerEvents) {
            this.canvas.pointerDragged(x, y);
        }
        if (this.pointx != 0 || this.pointy != 0) {
            this.pointx = x;
            this.pointy = y;
            this.repaint();
            this.canvas.multitouchEvent(new int[]{0, 0}, new int[]{x, this.getWidth() - x}, new int[]{y, this.getHeight() - y});
        }
        return true;
    }

    public boolean mousePressed(int button, int x, int y, int modifiers) {
        if (button != 1 && button != 3) {
            return false;
        }
        if (button == 3) {
            this.canvas.keyPressed(-51);
        }
        this.canvas.pointerPressed(x, y);
        if ((modifiers & 8) == 8) {
            this.pointx = x;
            this.pointy = y;
            this.repaint();
            this.canvas.multitouchEvent(new int[]{1, 1}, new int[]{x, this.getWidth() - x}, new int[]{y, this.getHeight() - y});
        }
        return true;
    }

    public boolean mouseReleased(int button, int x, int y, int modifiers) {
        if (button != 1 && button != 3) {
            return false;
        }
        if (this.pointx != 0 || this.pointy != 0) {
            this.pointx = 0;
            this.pointy = 0;
            this.repaint();
            this.canvas.multitouchEvent(new int[]{2, 2}, new int[]{x, this.getWidth() - x}, new int[]{y, this.getHeight() - y});
        }
        this.canvas.pointerReleased(x, y);
        if (button == 3) {
            this.canvas.keyReleased(-51);
        }
        return true;
    }

    public boolean mouseMoved(int x, int y, int modifiers) {
        this.canvas.pointerMoved(x, y);
        return true;
    }

    public boolean keyPressed(String code) {
        Log.log(2, "ScmCanvas.keyPressed() entering; key: " + code);
        int kc = ApplicationManager.getInstance().getDeviceKeyCode(code);
        ApplicationManager.getInstance().keyStates |= this.getKeyFlag(kc);
        this.canvas.keyPressed(kc);
        Log.log(2, "ScmCanvas.keyPressed() leaving");
        return true;
    }

    public boolean keyRepeated(String code) {
        Log.log(2, "ScmCanvas.keyRepeated() entering; key: " + code);
        this.canvas.keyRepeated(ApplicationManager.getInstance().getDeviceKeyCode(code));
        Log.log(2, "ScmCanvas.keyRepeated() leaving");
        return true;
    }

    int getKeyFlag(int code) {
        switch (this.canvas.getGameAction(code)) {
            case 1: {
                return 2;
            }
            case 6: {
                return 64;
            }
            case 2: {
                return 4;
            }
            case 5: {
                return 32;
            }
            case 8: {
                return 256;
            }
            case 9: {
                return 512;
            }
            case 10: {
                return 1024;
            }
            case 11: {
                return 2048;
            }
            case 12: {
                return 4096;
            }
        }
        return 0;
    }

    public boolean keyReleased(String code) {
        Log.log(2, "ScmCanvas.keyReleased() entering; key: " + code);
        int kc = ApplicationManager.getInstance().getDeviceKeyCode(code);
        ApplicationManager.getInstance().keyStates &= ~this.getKeyFlag(kc);
        this.canvas.keyReleased(kc);
        Log.log(2, "ScmCanvas.keyReleased() leaving");
        return true;
    }
}

