/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.yura.mobile.io.UTF8InputStreamReader;
import net.yura.mobile.io.XMLUtil;
import net.yura.mobile.io.json.JSONTokener;
import net.yura.mobile.io.json.JSONWriter;
import net.yura.mobile.util.SystemUtil;

public class JSONUtil {
    public void save(OutputStream out, Object obj) throws IOException {
        OutputStreamWriter w = new OutputStreamWriter(out);
        JSONWriter writer = new JSONWriter(w);
        this.saveObject(writer, obj);
        w.flush();
    }

    public Object load(InputStream in) throws IOException {
        JSONTokener tokener = new JSONTokener(new UTF8InputStreamReader(in));
        return this.readObject(tokener);
    }

    protected void saveObject(JSONWriter serializer, Object object) throws IOException {
        if (object == null) {
            serializer.nullValue();
        } else if (object instanceof String) {
            serializer.value((String)object);
        } else if (object instanceof Boolean) {
            serializer.value((Boolean)object);
        } else if (object instanceof Hashtable) {
            this.saveHashtable(serializer, (Hashtable)object);
        } else if (object instanceof Object[]) {
            this.saveArray(serializer, (Object[])object);
        } else if (object instanceof Double) {
            serializer.value((Double)object);
        } else if (object instanceof Long) {
            serializer.value((Long)object);
        } else if (object instanceof Character) {
            serializer.value(((Character)object).charValue());
        } else {
            serializer.object();
            serializer.key("class");
            serializer.value(XMLUtil.getObjectType(object));
            serializer.key("value");
            if (object instanceof Integer) {
                serializer.value(((Integer)object).longValue());
            } else if (object instanceof Float) {
                serializer.value(((Float)object).doubleValue());
            } else if (object instanceof Byte) {
                serializer.value(((Byte)object).byteValue());
            } else if (object instanceof Short) {
                serializer.value(((Short)object).shortValue());
            } else if (object instanceof Vector) {
                this.saveVector(serializer, (Vector)object);
            } else {
                throw new IOException("unknown object " + object);
            }
            serializer.endObject();
        }
    }

    protected Object readObject(JSONTokener x) throws IOException {
        Object result;
        char c = x.nextClean();
        x.back();
        switch (c) {
            case '\"': {
                result = x.nextString();
                break;
            }
            case '\'': {
                String string = x.nextString();
                if (string.length() == 1) {
                    result = new Character(string.charAt(0));
                    break;
                }
                result = string;
                break;
            }
            case '{': {
                Hashtable map = this.readHashtable(x);
                Object objClass = map.get("class");
                if (objClass instanceof String) {
                    map.remove("class");
                    result = this.readObject((String)objClass, map);
                    break;
                }
                result = map;
                break;
            }
            case '[': {
                Vector vector = this.readVector(x);
                Object[] array = new Object[vector.size()];
                vector.copyInto(array);
                result = array;
                break;
            }
            case '(': {
                result = this.readVector(x);
                break;
            }
            default: {
                String s = x.nextSimple();
                result = s.equalsIgnoreCase("true") ? Boolean.TRUE : (s.equalsIgnoreCase("false") ? Boolean.FALSE : (s.equalsIgnoreCase("null") ? null : (s.indexOf(46) >= 0 ? (Number)Double.valueOf(s) : (Number)new Long(Long.parseLong(s)))));
            }
        }
        return result;
    }

    protected Object readObject(String name, Hashtable map) {
        Object value = map.get("value");
        if ("Hashtable".equals(name)) {
            Object[] array = (Object[])value;
            Hashtable<Object, Object> object = new Hashtable<Object, Object>();
            for (int c = 0; c < array.length; ++c) {
                Object key = array[c++];
                object.put(key, array[c]);
            }
            return object;
        }
        if ("Vector".equals(name)) {
            return SystemUtil.asList((Object[])value);
        }
        if ("Integer".equals(name)) {
            return new Integer((int)((Long)value).longValue());
        }
        if ("Float".equals(name)) {
            return new Float(((Double)value).floatValue());
        }
        if ("Short".equals(name)) {
            return new Short((short)((Long)value).longValue());
        }
        if ("Character".equals(name)) {
            return new Character(((String)value).charAt(0));
        }
        if ("Byte".equals(name)) {
            return new Byte((byte)((Long)value).longValue());
        }
        System.err.println("dont know how to decode " + name + " " + map);
        map.put("class", name);
        return map;
    }

    protected void saveHashtable(JSONWriter serializer, Hashtable hashtable) throws IOException {
        Object key;
        boolean keyObject = false;
        Enumeration enu = hashtable.keys();
        while (enu.hasMoreElements()) {
            key = enu.nextElement();
            if (key instanceof String) continue;
            keyObject = true;
            break;
        }
        if (keyObject) {
            serializer.object();
            serializer.key("class");
            serializer.value("Hashtable");
            serializer.key("value");
            serializer.array();
            enu = hashtable.keys();
            while (enu.hasMoreElements()) {
                key = enu.nextElement();
                Object obj = hashtable.get(key);
                this.saveObject(serializer, key);
                this.saveObject(serializer, obj);
            }
            serializer.endArray();
            serializer.endObject();
        } else {
            serializer.object();
            enu = hashtable.keys();
            while (enu.hasMoreElements()) {
                key = (String)enu.nextElement();
                Object obj = hashtable.get(key);
                serializer.key((String)key);
                this.saveObject(serializer, obj);
            }
            serializer.endObject();
        }
    }

    protected void saveVector(JSONWriter serializer, Vector object) throws IOException {
        serializer.array();
        for (int c = 0; c < object.size(); ++c) {
            this.saveObject(serializer, object.elementAt(c));
        }
        serializer.endArray();
    }

    protected void saveArray(JSONWriter serializer, Object[] object) throws IOException {
        serializer.array();
        for (int c = 0; c < object.length; ++c) {
            this.saveObject(serializer, object[c]);
        }
        serializer.endArray();
    }

    protected Vector readVector(JSONTokener x) throws IOException {
        Vector<Object> vector = new Vector<Object>();
        x.startArray();
        if (x.nextClean() == ']') {
            return vector;
        }
        x.back();
        do {
            if (x.nextClean() == ',') {
                x.back();
                vector.addElement(null);
                continue;
            }
            x.back();
            vector.addElement(this.readObject(x));
        } while (!x.endArray());
        return vector;
    }

    protected Hashtable readHashtable(JSONTokener x) throws IOException {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        x.startObject();
        if (x.nextClean() == '}') {
            return hashtable;
        }
        x.back();
        boolean end = false;
        while (!end) {
            String key = x.nextKey();
            Object obj = this.readObject(x);
            if (obj != null) {
                hashtable.put(key, obj);
            }
            end = x.endObject();
        }
        return hashtable;
    }

    protected Object getObjetById(Object id, Class clas) {
        throw new RuntimeException();
    }

    protected Object getObjectId(Object object) {
        throw new RuntimeException();
    }
}

