/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.gui.components;

import java.util.Vector;
import net.yura.mobile.gui.ChangeListener;
import net.yura.mobile.gui.Icon;
import net.yura.mobile.gui.celleditor.DefaultCellEditor;
import net.yura.mobile.gui.cellrenderer.ListCellRenderer;
import net.yura.mobile.gui.components.Component;
import net.yura.mobile.gui.components.Label;
import net.yura.mobile.gui.components.List;
import net.yura.mobile.gui.components.Panel;
import net.yura.mobile.gui.components.ScrollPane;
import net.yura.mobile.gui.layout.BorderLayout;
import net.yura.mobile.util.Option;

public class TabbedPane
extends Panel
implements ChangeListener {
    private List tabList;
    private Vector tabs;
    private Panel tabBar;
    private Panel tabContent;
    private int tabPosition;
    private Label tabLabel;

    public TabbedPane() {
        this(16);
    }

    public TabbedPane(int a) {
        BorderLayout l = new BorderLayout();
        this.setLayout(l);
        this.setName("TabbedPane");
        this.tabLabel = new Label();
        this.tabLabel.setMargin(1);
        this.tabList = new List(new DefaultCellEditor(this.tabLabel));
        this.tabs = new Vector();
        this.tabList.addListSelectionListener(this);
        ScrollPane scroll = new ScrollPane(this.tabList, 1);
        this.tabContent = new Panel(l);
        this.tabBar = new Panel(l);
        this.tabBar.add(scroll);
        this.tabList.setName("TabList");
        scroll.setName("TabScroll");
        this.setTabPlacement(a);
    }

    public void setTabPlacement(int a) {
        this.tabPosition = a;
        this.tabList.setLayoutOrientation(a == 16 || a == 32 ? 3 : 0);
        String n = "TabRenderer";
        switch (a) {
            case 16: {
                n = n + "Top";
                break;
            }
            case 32: {
                n = n + "Bottom";
                break;
            }
            case 8: {
                n = n + "Right";
                break;
            }
            case 4: {
                n = n + "Left";
            }
        }
        this.tabLabel.setName(n);
        this.tabBar.setName("Tab" + (a == 16 ? "Top" : (a == 4 ? "Left" : (a == 8 ? "Right" : "Bottom"))));
        this.tabContent.setName("TabContent" + (a == 16 ? "Bottom" : (a == 4 ? "Right" : (a == 8 ? "Left" : "Top"))));
        super.removeAll();
        if (this.tabPosition == 16 || this.tabPosition == 4) {
            super.add((Component)this.tabBar, this.tabPosition);
        }
        super.add(this.tabContent);
        if (this.tabPosition == 32 || this.tabPosition == 8) {
            super.add((Component)this.tabBar, this.tabPosition);
        }
    }

    public void setTabRenderer(ListCellRenderer lcr) {
        this.tabList.setCellRenderer(lcr);
    }

    public void add(Component p) {
        this.addTab(p.getName(), p);
    }

    public void addTab(String title, Component component) {
        this.addTab(title, null, component);
    }

    public void addTab(String title, Icon icon, Component component) {
        this.addTab(title, icon, component, null);
    }

    public void addTab(String title, Icon icon, Component component, String tip) {
        this.tabList.addElement(new Option(null, title, icon, tip));
        this.tabs.addElement(component);
        if (this.tabList.getSelectedIndex() == -1) {
            this.setSelectedIndex(0);
        }
    }

    public void removeTabAt(int a) {
        if (this.tabs.size() == 1 && a == 0) {
            this.removeAll();
        } else {
            if (this.tabList.getSelectedIndex() == a) {
                if (this.tabs.size() - 1 == this.tabList.getSelectedIndex()) {
                    this.setSelectedIndex(this.tabList.getSelectedIndex() - 1);
                } else {
                    this.setSelectedIndex(this.tabList.getSelectedIndex() + 1);
                }
            }
            this.tabList.removeElementAt(a);
            this.tabs.removeElementAt(a);
        }
    }

    public void insertTab(String title, Icon icon, Component component, String tip, int index) {
        this.tabList.getItems().insertElementAt(new Option(null, title, icon, tip), index);
        this.tabs.insertElementAt(component, index);
        this.setSelectedIndex(index);
    }

    public Component getComponentAt(int index) {
        return (Component)this.tabs.elementAt(index);
    }

    protected void workoutMinimumSize() {
        for (int i = 0; i < this.tabs.size(); ++i) {
            Component component = (Component)this.tabs.elementAt(i);
            component.workoutPreferredSize();
            if (component.getWidthWithBorder() > this.tabContent.getPreferredWidth()) {
                this.tabContent.setPreferredSize(component.getWidthWithBorder(), this.tabContent.getPreferredHeight());
            }
            if (component.getHeightWithBorder() <= this.tabContent.getPreferredHeight()) continue;
            this.tabContent.setPreferredSize(this.tabContent.getPreferredWidth(), component.getHeightWithBorder());
        }
        super.workoutMinimumSize();
    }

    public void changeEvent(Component source, int num) {
        int old;
        int n = old = this.tabContent.getComponentCount() == 1 ? this.tabs.indexOf(this.tabContent.getComponents().elementAt(0)) : -1;
        if (num < 0 && old >= 0) {
            this.tabList.setSelectedIndex(old);
        } else if (num != old) {
            Component thetabtoAdd = (Component)this.tabs.elementAt(num);
            this.tabContent.removeAll();
            this.tabContent.add(thetabtoAdd);
            if (this.getWindow() != null) {
                this.tabContent.revalidate();
                this.tabContent.repaint();
            }
        }
    }

    public void removeAll() {
        if (this.tabList.getSelectedIndex() != -1) {
            this.tabContent.removeAll();
            this.tabs.removeAllElements();
            this.tabList.setListData(new Vector());
        }
    }

    public void setSelectedIndex(int a) {
        this.tabList.setSelectedIndex(a);
    }

    public void setSelectedComponent(Component c) {
        this.setSelectedIndex(this.tabs.indexOf(c));
    }

    public int getSelectedIndex() {
        return this.tabList.getSelectedIndex();
    }

    public int getTabCount() {
        return this.tabList.getItems().size();
    }

    public Component getSelectedComponent() {
        return this.getComponentAt(this.getSelectedIndex());
    }

    public void setSelectable(boolean a) {
        this.tabList.setFocusable(a);
    }
}

