/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.gui;

import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import net.yura.mobile.gui.Graphics2D;
import net.yura.mobile.gui.Icon;
import net.yura.mobile.gui.KeyEvent;
import net.yura.mobile.gui.KeyListener;
import net.yura.mobile.gui.Midlet;
import net.yura.mobile.gui.border.Border;
import net.yura.mobile.gui.cellrenderer.ListCellRenderer;
import net.yura.mobile.gui.cellrenderer.MenuItemRenderer;
import net.yura.mobile.gui.components.Button;
import net.yura.mobile.gui.components.Component;
import net.yura.mobile.gui.components.Frame;
import net.yura.mobile.gui.components.Menu;
import net.yura.mobile.gui.components.MenuBar;
import net.yura.mobile.gui.components.Panel;
import net.yura.mobile.gui.components.ScrollPane;
import net.yura.mobile.gui.components.TextComponent;
import net.yura.mobile.gui.components.ToolTip;
import net.yura.mobile.gui.components.Window;
import net.yura.mobile.gui.plaf.LookAndFeel;
import net.yura.mobile.gui.plaf.Style;
import net.yura.mobile.logging.Logger;
import net.yura.mobile.util.QueueProcessorThread;
import net.yura.mobile.util.SystemUtil;

public class DesktopPane
extends Canvas
implements Runnable {
    private static Vector keylisteners = new Vector();
    private static DesktopPane desktop;
    private Hashtable UIManager;
    public static final boolean debug = false;
    public boolean SOFT_KEYS;
    public boolean VERY_BIG_SCREEN;
    public boolean MAX_CLOSE_BUTTONS;
    public boolean IPHONE_SCROLL;
    public boolean QWERTY_KAYPAD;
    public boolean USE_SOFT_KEY_CLEAR;
    public boolean HIDDEN_MENU;
    public boolean HIDDEN_BACK;
    public boolean GRID_MENU;
    protected Midlet midlet;
    private LookAndFeel theme;
    public int defaultSpace;
    private int menuHeight;
    private final Vector windows = new Vector();
    private final Object uiLock = this.windows;
    private ToolTip tooltip;
    private ToolTip indicator;
    private final Vector repaintComponent = new Vector();
    private final Vector revalidateComponents1 = new Vector();
    private final Vector revalidateComponents2 = new Vector();
    private final Vector revalidateComponents3 = new Vector();
    private Thread animationThread;
    private Component currentAnimatedComponent;
    private Component nextAnimatedComponent;
    private Image splash;
    private int background;
    private Object fade;
    private boolean paintdone;
    private boolean fullrepaint;
    private boolean killflag;
    private boolean wideScreen;
    private boolean sideSoftKeys;
    private byte[] message;
    public int inaccuracy;
    private Component focusedComponent;
    private long lastWait;
    private ListCellRenderer softkeyRenderer;
    private Graphics2D graphics;
    private String mem;
    static Thread dummyThread;
    private int validating = 0;
    private KeyEvent keypad;
    private final int[] directions = new int[]{5, 6, 2, 1};
    public static final int DRAGGED = 0;
    public static final int PRESSED = 1;
    public static final int RELEASED = 2;
    public static final int CANCEL = 3;
    private Component pointerComponent;
    private ScrollPane pointerScrollPane;
    private int pointerFirstX;
    private int pointerFirstY;
    private long pointerFristTime;
    private int oldw;
    private int oldh;
    boolean sizeChanged;

    public static void addKeyPressListener(KeyListener listener) {
        keylisteners.addElement(listener);
    }

    public void notifyKeyListeners(KeyEvent event) {
        for (int i = 0; i < keylisteners.size(); ++i) {
            KeyListener listener = (KeyListener)keylisteners.elementAt(i);
            listener.keyPressedEvent(event);
        }
    }

    public static DesktopPane getDesktopPane() {
        return desktop;
    }

    public static Component getAncestorOfClass(Class c, Component p) {
        while (p != null) {
            if (c.isInstance(p)) {
                return p;
            }
            p = p.getParent();
        }
        return null;
    }

    public static void invokeLater(Runnable runner) {
        Display.getDisplay((MIDlet)Midlet.getMidlet()).callSerially(runner);
    }

    public static void updateComponentTreeUI(Component com) {
        int c;
        Vector v;
        if (com instanceof MenuBar) {
            v = ((MenuBar)com).getItems();
            for (c = 0; c < v.size(); ++c) {
                DesktopPane.updateComponentTreeUI((Component)v.elementAt(c));
            }
        }
        if (com instanceof Panel) {
            v = ((Panel)com).getComponents();
            for (c = 0; c < v.size(); ++c) {
                DesktopPane.updateComponentTreeUI((Component)v.elementAt(c));
            }
        }
        com.updateUI();
        Window popup = com.getPopupMenu();
        if (popup != null) {
            DesktopPane.updateComponentTreeUI(popup);
        }
    }

    public static Object get(Object key) {
        return DesktopPane.getDesktopPane().UIManager.get(key);
    }

    public static void put(Object key, Object value) {
        DesktopPane.getDesktopPane().UIManager.put(key, value);
    }

    public DesktopPane(Midlet m, int back, Image sph) {
        this.SOFT_KEYS = Midlet.getPlatform() != 8 && Midlet.getPlatform() != 10 && Midlet.getPlatform() != 11;
        this.HIDDEN_MENU = Midlet.getPlatform() == 10 || Midlet.getPlatform() == 11;
        this.HIDDEN_BACK = Midlet.getPlatform() == 10 || Midlet.getPlatform() == 11;
        this.VERY_BIG_SCREEN = Midlet.getPlatform() == 8;
        this.MAX_CLOSE_BUTTONS = Midlet.getPlatform() == 8;
        this.IPHONE_SCROLL = Midlet.getPlatform() != 8;
        this.QWERTY_KAYPAD = Midlet.getPlatform() == 8 || Midlet.getPlatform() == 10 || Midlet.getPlatform() == 11 && !KeyEvent.BLACKBERRY_ITUT;
        this.USE_SOFT_KEY_CLEAR = Midlet.getPlatform() == 1;
        this.GRID_MENU = Midlet.getPlatform() == 10;
        desktop = this;
        this.background = back;
        this.splash = sph;
        this.setFullScreenMode(true);
        this.midlet = m;
        this.keypad = new KeyEvent(this);
        this.UIManager = new Hashtable();
        this.UIManager.put("clearText", "Clear");
        this.UIManager.put("selectText", "Select");
        this.UIManager.put("cancelText", "Cancel");
        this.UIManager.put("okText", "OK");
        this.UIManager.put("menuText", "Menu");
        this.UIManager.put("showText", "Show");
        this.UIManager.put("allText", "All");
        this.UIManager.put("newText", "New");
        this.UIManager.put("viewText", "View");
        this.UIManager.put("listText", "List");
        this.UIManager.put("gridText", "Grid");
        this.UIManager.put("backText", "Back");
        this.UIManager.put("closeText", "Close");
        this.UIManager.put("exitText", "Exit");
        this.UIManager.put("yesText", "Yes");
        this.UIManager.put("noText", "No");
        this.UIManager.put("cutText", "Cut");
        this.UIManager.put("copyText", "Copy");
        this.UIManager.put("pasteText", "Paste");
        this.UIManager.put("deleteText", "Delete");
        this.UIManager.put("selectAllText", "Select All");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void run() {
        try {
            this.midlet.initialize(this);
        }
        catch (Throwable th) {
            Logger.warn("Error in initialize", th);
        }
        if (QueueProcessorThread.CHANGE_PRIORITY) {
            Thread.currentThread().setPriority(10);
        }
        while (true) {
            try {
                while (true) {
                    if (this.killflag) {
                        return;
                    }
                    Object th = this.uiLock;
                    synchronized (th) {
                        this.currentAnimatedComponent = this.nextAnimatedComponent;
                        this.nextAnimatedComponent = null;
                        if (this.currentAnimatedComponent == null) {
                            try {
                                this.uiLock.wait();
                            }
                            catch (InterruptedException e) {
                                Logger.info(null, e);
                            }
                            continue;
                        }
                        this.lastWait = System.currentTimeMillis();
                        try {
                            this.currentAnimatedComponent.run();
                        }
                        catch (InterruptedException e) {
                            Logger.debug("Interrupted during animation (this is ok)");
                        }
                    }
                }
            }
            catch (Throwable th) {
                Logger.warn("Error in animation", th);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void animateComponent(Component com) {
        Object object = this.uiLock;
        synchronized (object) {
            this.currentAnimatedComponent = null;
            this.nextAnimatedComponent = com;
            if (Thread.currentThread() == this.animationThread) {
                return;
            }
            this.uiLock.notify();
        }
    }

    public void aniWait(Component component, int a) throws InterruptedException {
        long time = System.currentTimeMillis();
        long wait = Math.min((long)a, Math.max(0L, (long)a - (time - this.lastWait)));
        if (wait > 0L) {
            this.uiLock.wait(wait);
        }
        this.lastWait = time + wait;
        if (this.currentAnimatedComponent != component) {
            throw new InterruptedException();
        }
    }

    void kill() {
        this.killflag = true;
        this.animateComponent(null);
        if (desktop == this) {
            desktop = null;
        }
    }

    public void setLookAndFeel(LookAndFeel a) {
        Window dummy;
        desktop = this;
        this.theme = a;
        Style clear = new Style();
        this.theme.setStyleFor("WindowControlPanel", clear);
        this.theme.setStyleFor("TabList", clear);
        Style clear2 = this.theme.getStyle("ScrollPane");
        if (clear2 == null) {
            clear2 = this.theme.getStyle("");
        }
        clear2 = new Style(clear2);
        clear2.addBackground(0, 0);
        this.theme.setStyleFor("TabScroll", clear2);
        if (this.defaultSpace == 0) {
            int maxSize = Math.max(this.getWidth(), this.getHeight());
            this.defaultSpace = maxSize <= 128 ? 3 : (maxSize <= 208 ? 5 : 7);
        }
        MenuItemRenderer m = new MenuItemRenderer();
        m.setName("SoftkeyRenderer");
        this.softkeyRenderer = m;
        Component c = this.softkeyRenderer.getListCellRendererComponent(null, new Button("test"), 0, false, false);
        c.workoutPreferredSize();
        this.menuHeight = c.getHeightWithBorder();
        this.inaccuracy = this.theme.getStyle("").getFont(0).getHeight();
        if (this.tooltip == null) {
            dummy = new Window();
            dummy.setDesktopPane(this);
            this.tooltip = new ToolTip();
            this.indicator = new ToolTip();
            dummy.add(this.tooltip);
            dummy.add(this.indicator);
        } else {
            dummy = this.tooltip.getWindow();
            DesktopPane.updateComponentTreeUI(dummy);
        }
        this.fade = DesktopPane.getDefaultTheme(dummy).getProperty("dim", 0);
    }

    public static Style getDefaultTheme(Component comp) {
        return DesktopPane.getDefaultTheme(comp.getName());
    }

    public static Style getDefaultTheme(String compName) {
        Style style = DesktopPane.desktop.theme.getStyle(compName);
        if (style == null) {
            style = DesktopPane.desktop.theme.getStyle("");
        }
        return style;
    }

    public LookAndFeel getLookAndFeel() {
        return this.theme;
    }

    public ListCellRenderer getSoftkeyRenderer() {
        return this.softkeyRenderer;
    }

    public int getMenuHeight() {
        return this.SOFT_KEYS ? this.menuHeight : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paint(Graphics gtmp) {
        boolean doFullRepaint = this.fullrepaint;
        this.fullrepaint = false;
        if (!this.paintdone) {
            if (QueueProcessorThread.CHANGE_PRIORITY) {
                Thread.currentThread().setPriority(10);
            }
            if (this.background != 0) {
                gtmp.setColor(this.background);
                gtmp.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            if (this.splash != null) {
                gtmp.drawImage(this.splash, (this.getWidth() - this.splash.getWidth()) / 2, (this.getHeight() - this.splash.getHeight()) / 2, 20);
                this.splash = null;
            } else if (this.background != 0) {
                gtmp.setColor(-65536);
                gtmp.drawString("yura.net mobile Loading...", 0, 0, 20);
            }
            this.oldw = this.getWidth();
            this.oldh = this.getHeight();
            this.wideScreen = this.oldw > this.oldh;
            this.animationThread = new Thread((Runnable)this, "SwingME-Animation-One");
            this.animationThread.start();
            this.paintdone = true;
            this.graphics = new Graphics2D(gtmp);
            return;
        }
        try {
            int clipx = gtmp.getClipX();
            int clipy = gtmp.getClipY();
            int clipw = gtmp.getClipWidth();
            int cliph = gtmp.getClipHeight();
            Object object = this.uiLock;
            synchronized (object) {
                boolean fullPaint;
                Vector repaintComponent2 = new Vector(this.repaintComponent.size());
                SystemUtil.addAll(repaintComponent2, this.repaintComponent);
                this.repaintComponent.removeAllElements();
                this.validating = 1;
                this.validateComponents(this.revalidateComponents1);
                this.validating = 2;
                this.validateComponents(this.revalidateComponents2);
                this.validating = 3;
                this.validateComponents(this.revalidateComponents3);
                this.validating = 0;
                for (int c = 0; c < this.revalidateComponents1.size(); ++c) {
                    Window w1 = ((Component)this.revalidateComponents1.elementAt(c)).getWindow();
                    if (w1 == null) continue;
                    w1.setupFocusedComponent();
                }
                this.revalidateComponents1.removeAllElements();
                this.revalidateComponents2.removeAllElements();
                this.revalidateComponents3.removeAllElements();
                Window currentWindow = this.getSelectedFrame();
                Component currentFocusedComponent = null;
                if (currentWindow != null) {
                    currentFocusedComponent = currentWindow.getMostRecentFocusOwner();
                }
                if (this.focusedComponent != currentFocusedComponent) {
                    if (this.focusedComponent != null) {
                        this.focusedComponent.focusLost();
                        this.focusedComponent = null;
                    }
                    if (currentFocusedComponent != null) {
                        this.focusedComponent = currentFocusedComponent;
                        this.focusedComponent.focusGained();
                    }
                }
                if (this.sizeChanged) {
                    if (currentWindow != null && this.focusedComponent != null) {
                        this.focusedComponent.makeVisible();
                    }
                    this.sizeChanged = false;
                }
                boolean bl = fullPaint = clipx <= 0 && clipy <= 0 && clipw >= this.getWidth() && cliph >= this.getHeight();
                if (!this.repaintComponent.isEmpty() || this.fullrepaint) {
                    if (fullPaint) {
                        this.repaintComponent.removeAllElements();
                        this.fullrepaint = false;
                    } else {
                        for (int c = 0; c < repaintComponent2.size(); ++c) {
                            this.repaintComponent((Component)repaintComponent2.elementAt(c));
                        }
                        if (doFullRepaint) {
                            this.fullrepaint = true;
                        }
                        this.repaint(clipx, clipy, clipw, cliph);
                        this.bbfix();
                        return;
                    }
                }
                if (fullPaint) {
                    doFullRepaint = true;
                } else if (repaintComponent2.isEmpty()) {
                    doFullRepaint = true;
                }
                this.graphics.setGraphics(gtmp);
                if (!doFullRepaint && !repaintComponent2.isEmpty()) {
                    int c;
                    for (c = 0; c < repaintComponent2.size(); ++c) {
                        if (((Component)repaintComponent2.elementAt(c)).getWindow() == currentWindow) continue;
                        doFullRepaint = true;
                        break;
                    }
                    if (!doFullRepaint) {
                        for (c = 0; c < repaintComponent2.size(); ++c) {
                            this.paintComponent(this.graphics, (Component)repaintComponent2.elementAt(c));
                        }
                    }
                }
                if (doFullRepaint) {
                    int c;
                    int startC = 0;
                    for (c = this.windows.size() - 1; c >= 0; --c) {
                        Object w = this.windows.elementAt(c);
                        if (!(w instanceof Frame) || !((Frame)w).isMaximum() || !((Window)w).isOpaque()) continue;
                        startC = c;
                        break;
                    }
                    for (c = startC; c < this.windows.size(); ++c) {
                        this.paintComponent(this.graphics, (Window)this.windows.elementAt(c));
                        if (c != this.windows.size() - 2 || this.fade == null) continue;
                        int w = this.getWidth();
                        int h = this.getHeight();
                        if (this.fade instanceof Icon) {
                            Image i = ((Icon)this.fade).getImage();
                            this.graphics.drawImage(i, 0, 0, i.getWidth(), i.getHeight(), 0, 0, w, h);
                            continue;
                        }
                        this.graphics.setColor((Integer)this.fade);
                        this.graphics.fillRect(0, 0, w, h);
                    }
                    if (this.tooltip != null && this.tooltip.isShowing()) {
                        this.paintComponent(this.graphics, this.tooltip);
                    }
                    if (this.indicator != null && this.indicator.isShowing()) {
                        this.paintComponent(this.graphics, this.indicator);
                    }
                }
            }
            if (this.mem != null) {
                Font font = gtmp.getFont();
                gtmp.setColor(-1);
                gtmp.fillRect((this.getWidth() - (font.stringWidth(this.mem) + 10)) / 2, 0, font.stringWidth(this.mem) + 10, font.getHeight() + 10);
                gtmp.setColor(-16777216);
                gtmp.drawString(this.mem, (this.getWidth() - (font.stringWidth(this.mem) + 10)) / 2 + 5, 5, 20);
            }
            if (this.message != null) {
                String m = new String(this.message);
                Font font = gtmp.getFont();
                gtmp.setColor(-16777216);
                gtmp.fillRect((this.getWidth() - (font.stringWidth(m) + 10)) / 2, (this.getHeight() - (font.getHeight() + 10)) / 2, font.stringWidth(m) + 10, font.getHeight() + 10);
                gtmp.setColor(-65536);
                gtmp.drawString(m, (this.getWidth() - (font.stringWidth(m) + 10)) / 2 + 5, (this.getHeight() - (font.getHeight() + 10)) / 2 + 5, 20);
            }
            this.bbfix();
        }
        catch (Throwable th) {
            Logger.warn("Error in paint", th);
        }
    }

    private void bbfix() {
        if (Midlet.getPlatform() == 11 && (this.fullrepaint || !this.repaintComponent.isEmpty())) {
            DesktopPane.invokeLater(dummyThread);
        }
    }

    public void setDimImage(Icon a) {
        this.fade = a;
    }

    private void paintComponent(Graphics2D g, Component com) {
        int[] a = g.getClip();
        int ax = a[0];
        int ay = a[1];
        int aw = a[2];
        int ah = a[3];
        Component p = com.getParent();
        if (p != null) {
            p.computeVisibleRect(a);
        }
        g.clipRect(a[0], a[1], a[2], a[3]);
        int x = com.getXOnScreen();
        int y = com.getYOnScreen();
        g.translate(x, y);
        com.paint(g);
        g.translate(-x, -y);
        g.setClip(ax, ay, aw, ah);
    }

    private void validateComponents(Vector v) {
        for (int c = 0; c < v.size(); ++c) {
            Component panel = (Component)v.elementAt(c);
            try {
                panel.validate();
                continue;
            }
            catch (RuntimeException ex) {
                Logger.warn("Error in validate of: " + panel);
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repaintComponent(Component rc) {
        Component p;
        Window myWindow = rc.getWindow();
        if (myWindow == null || !rc.isShowing()) {
            return;
        }
        for (p = rc; p != null && !p.isOpaque(); p = p.getParent()) {
        }
        Object object = this.uiLock;
        synchronized (object) {
            if (p == null) {
                this.fullrepaint = true;
            } else {
                DesktopPane.addToComponentVector(p, this.repaintComponent);
            }
        }
        int xs = rc.getXOnScreen();
        int ys = rc.getYOnScreen();
        int[] v = rc.getVisibleRect();
        this.repaint(xs + v[0], ys + v[1], v[2], v[3]);
    }

    public void repaintHole(Component rc) {
        Border insets = rc.getInsets();
        this.invalidate(rc.getXOnScreen() - insets.getLeft(), rc.getYOnScreen() - insets.getTop(), rc.getWidthWithBorder(), rc.getHeightWithBorder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate(int x, int y, int width, int height) {
        Object object = this.uiLock;
        synchronized (object) {
            this.fullrepaint = true;
        }
        this.repaint(x, y, width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revalidateComponent(Component rc) {
        if (rc.getWidth() == 0 || rc.getHeight() == 0) {
            Logger.info("revalidate called on a component with 0 width and 0 height, this means nothing will happen to it");
        }
        Object object = this.uiLock;
        synchronized (object) {
            if (this.validating != 0) {
                Logger.warn("##### calling revalidate from inside the ui thread during a revalidate, this is odd!!! and may break things");
                Logger.dumpStack();
            }
            DesktopPane.addToComponentVector(rc, this.revalidateComponents1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mySizeChanged(Component aThis) {
        Component p = DesktopPane.getAncestorOfClass(ScrollPane.class, aThis);
        if (p == null) {
            p = aThis.getWindow();
        }
        if (p == null) {
            return;
        }
        DesktopPane dp = aThis.getDesktopPane();
        Object object = dp.uiLock;
        synchronized (object) {
            switch (dp.validating) {
                case 0: {
                    DesktopPane.addToComponentVector(p, dp.revalidateComponents1);
                    p.repaint();
                    break;
                }
                case 1: {
                    Logger.debug("thats some complex layout");
                    DesktopPane.addToComponentVector(p, dp.revalidateComponents2);
                    break;
                }
                case 2: {
                    Logger.debug("thats some CRAZY SHIT COMPLEX LAYOUT");
                    DesktopPane.addToComponentVector(p, dp.revalidateComponents3);
                    break;
                }
                default: {
                    Logger.info("asking for revalidate 4th time: " + p);
                    Logger.dumpStack();
                }
            }
        }
    }

    public static boolean myLastRevalidate(Component rc) {
        Vector vec;
        DesktopPane dp = rc.getDesktopPane();
        switch (dp.validating) {
            case 0: {
                vec = dp.revalidateComponents1;
                break;
            }
            case 1: {
                vec = dp.revalidateComponents2;
                break;
            }
            case 2: {
                vec = dp.revalidateComponents3;
                break;
            }
            default: {
                return true;
            }
        }
        for (Component c1 = rc; c1 != null; c1 = c1.getParent()) {
            if (!vec.contains(c1)) continue;
            Logger.info("component found! myLastRevalidate returning false");
            return false;
        }
        return true;
    }

    private static void addToComponentVector(Component rc, Vector vec) {
        if (rc.getWindow() == null) {
            return;
        }
        boolean found = false;
        for (Component c1 = rc; c1 != null; c1 = c1.getParent()) {
            if (!vec.contains(c1)) continue;
            found = true;
            break;
        }
        if (!found) {
            vec.addElement(rc);
            block1: for (int i = 0; i < vec.size(); ++i) {
                Component c2 = (Component)vec.elementAt(i);
                while (c2 != null) {
                    if ((c2 = c2.getParent()) != rc) continue;
                    vec.removeElementAt(i);
                    --i;
                    continue block1;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Window w) {
        Object object = this.uiLock;
        synchronized (object) {
            if (w != null && !this.windows.contains(w)) {
                w.setDesktopPane(this);
                this.windows.addElement(w);
                if (w instanceof Frame && ((Frame)w).isMaximum()) {
                    ((Frame)w).setMaximum(true);
                }
                this.pointerComponent = null;
                DesktopPane.windowChanged();
            } else {
                Logger.warn("trying to set a window visible when it already is visible or null: " + w);
                Logger.dumpStack();
            }
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Window w) {
        Object object = this.uiLock;
        synchronized (object) {
            if (this.windows.contains(w)) {
                this.windows.removeElement(w);
                this.pointerComponent = null;
                DesktopPane.windowChanged();
            } else {
                Logger.warn("cant remove, this window is not visible or null: " + w);
                Logger.dumpStack();
            }
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedFrame(Window w) {
        Window old = null;
        Object object = this.uiLock;
        synchronized (object) {
            if (w != null && this.windows.contains(w)) {
                old = this.getSelectedFrame();
                if (old == w) {
                    return;
                }
                this.windows.removeElement(w);
                this.windows.addElement(w);
                this.pointerComponent = null;
                DesktopPane.windowChanged();
            } else {
                Logger.warn("cant setSelected, this window is not visible or null: " + w);
                Logger.dumpStack();
            }
        }
        this.repaint();
    }

    private static void windowChanged() {
        TextComponent.closeNativeEditor();
    }

    public Vector getAllFrames() {
        return this.windows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Window getSelectedFrame() {
        Vector vector = this.windows;
        synchronized (vector) {
            return this.windows.isEmpty() ? null : (Window)this.windows.lastElement();
        }
    }

    public void keyPressed(int keyCode) {
        this.keypad.keyPressed(keyCode);
        this.passKeyEvent(this.keypad);
    }

    public void keyReleased(int keyCode) {
        this.keypad.keyReleased(keyCode);
        this.passKeyEvent(this.keypad);
    }

    public void keyRepeated(int keyCode) {
        this.keypad.keyRepeated(keyCode);
        this.passKeyEvent(this.keypad);
    }

    private void passKeyEvent(KeyEvent keyevent) {
        this.notifyKeyListeners(keyevent);
        try {
            if (keyevent.isDownKey(42)) {
                this.mem = (Runtime.getRuntime().freeMemory() >> 10) + "K/" + (Runtime.getRuntime().totalMemory() >> 10) + "K";
                this.repaint();
            } else {
                this.mem = null;
            }
            if (keyevent.isDownKey(57) && keyevent.isDownKey(56) && keyevent.isDownKey(55) && keyevent.isDownKey(50)) {
                this.message = new byte[]{121, 117, 114, 97, 46, 110, 101, 116};
                this.repaint();
            } else if (keyevent.isDownKey(52) && keyevent.isDownKey(50) && keyevent.isDownKey(54) && keyevent.isDownKey(51)) {
                this.message = new byte[]{84, 72, 69, 32, 71, 65, 77, 69};
                this.repaint();
            } else {
                this.message = null;
            }
            Window currentWindow = this.getSelectedFrame();
            if (currentWindow != null) {
                Button mneonicButton = null;
                int key = keyevent.getJustPressedKey();
                if (key != 0) {
                    if (key == -12 || key == -11) {
                        if (Midlet.getPlatform() != 2 && (mneonicButton = currentWindow.findMnemonicButton(key)) == null) {
                            if (key == -12) {
                                key = -6;
                            } else if (key == -11) {
                                key = -7;
                            }
                            mneonicButton = currentWindow.findMnemonicButton(key);
                        }
                    } else {
                        mneonicButton = currentWindow.findMnemonicButton(key);
                        if (mneonicButton == null && (key == -6 || key == -7)) {
                            if (key == -6) {
                                key = -12;
                            } else if (key == -7) {
                                key = -11;
                            }
                            mneonicButton = currentWindow.findMnemonicButton(key);
                        }
                    }
                }
                if (mneonicButton != null) {
                    mneonicButton.fireActionPerformed();
                } else {
                    boolean consumed = false;
                    if (this.focusedComponent != null) {
                        consumed = this.focusedComponent.processKeyEvent(keyevent);
                    }
                    if (!consumed) {
                        consumed = currentWindow.processKeyEvent(keyevent);
                    }
                    if (!consumed) {
                        consumed = this.keyEvent(keyevent);
                    }
                    if (!consumed && keyevent.getJustReleasedKey() == 0) {
                        int d = -1;
                        for (int c = 0; c < this.directions.length; ++c) {
                            if (!keyevent.isDownAction(this.directions[c])) continue;
                            d = this.directions[c];
                            break;
                        }
                        if (d != -1) {
                            if (this.focusedComponent != null) {
                                this.focusedComponent.transferFocus(d);
                            } else {
                                currentWindow.passScrollUpDown(d);
                            }
                        }
                    }
                }
            }
            this.showHideToolTip(keyevent.justReleasedAction(5) || keyevent.justReleasedAction(6) || keyevent.justReleasedAction(2) || keyevent.justReleasedAction(1), this.focusedComponent);
        }
        catch (Throwable th) {
            Logger.warn("Error in KeyEvent: " + keyevent, th);
        }
    }

    public boolean keyEvent(KeyEvent kypd) {
        return false;
    }

    public void pointerDragged(int x, int y) {
        this.pointerEvent(0, x, y);
    }

    public void pointerPressed(int x, int y) {
        if (x < 0 && y < 0) {
            return;
        }
        this.pointerEvent(1, x, y);
    }

    public void pointerReleased(int x, int y) {
        this.pointerEvent(2, x, y);
    }

    public void pointerMoved(int x, int y) {
    }

    public void multitouchEvent(int[] type, int[] x, int[] y) {
        if (this.pointerComponent != null) {
            int pcX = this.pointerComponent.getXOnScreen();
            int pcY = this.pointerComponent.getYOnScreen();
            for (int c = 0; c < type.length; ++c) {
                x[c] = x[c] - pcX;
                y[c] = y[c] - pcY;
            }
            this.pointerComponent.processMultitouchEvent(type, x, y);
        }
    }

    public static boolean isAccurate(int oldx, int x, int inaccuracy) {
        return Math.abs(oldx - x) <= inaccuracy;
    }

    private void pointerEvent(int type, int x, int y) {
        try {
            Window currentWindow = this.getSelectedFrame();
            if (currentWindow != null) {
                Component pc;
                if (type == 1) {
                    this.pointerComponent = currentWindow.getComponentAt(x - currentWindow.getX(), y - currentWindow.getY());
                    if (this.IPHONE_SCROLL) {
                        this.pointerScrollPane = null;
                        ScrollPane sp = (ScrollPane)DesktopPane.getAncestorOfClass(ScrollPane.class, this.pointerComponent);
                        if (sp != null) {
                            this.pointerScrollPane = sp;
                            if (this.pointerComponent == sp) {
                                this.pointerComponent = null;
                            }
                        }
                    }
                    this.pointerFirstX = x;
                    this.pointerFirstY = y;
                    this.pointerFristTime = System.currentTimeMillis();
                }
                if (this.pointerComponent != null && type == 0 && this.pointerScrollPane != null) {
                    if (this.pointerComponent.consumesMotionEvents()) {
                        this.pointerScrollPane = null;
                    } else if (!DesktopPane.isAccurate(this.pointerFirstX, x, this.inaccuracy) || !DesktopPane.isAccurate(this.pointerFirstY, y, this.inaccuracy)) {
                        this.pointerComponent.processMouseEvent(3, x, y, this.keypad);
                        this.pointerComponent = null;
                        currentWindow.setNothingFocused();
                    }
                }
                if (type == 2) {
                    Window popup;
                    long time = System.currentTimeMillis();
                    if ((this.keypad.isDownKey(-51) || time - this.pointerFristTime > 1000L && DesktopPane.isAccurate(this.pointerFirstX, x, this.inaccuracy) && DesktopPane.isAccurate(this.pointerFirstY, y, this.inaccuracy)) && this.pointerComponent != null && (popup = this.pointerComponent.getPopupMenu()) != null && !popup.isVisible()) {
                        popup.show(this.pointerComponent, x, y);
                        type = 3;
                    }
                }
                if ((pc = this.pointerComponent) != null) {
                    int pcX = x - pc.getXOnScreen();
                    int pcY = y - pc.getYOnScreen();
                    pc.processMouseEvent(type, pcX, pcY, this.keypad);
                }
                if (this.pointerScrollPane != null && (type == 1 || type == 2 || type == 0 && this.pointerComponent == null)) {
                    int spX = x - this.pointerScrollPane.getXOnScreen();
                    int spY = y - this.pointerScrollPane.getYOnScreen();
                    this.pointerScrollPane.processMouseEvent(type, spX, spY, this.keypad);
                }
                if (this.keypad.isDownAction(8)) {
                    this.multitouchEvent(new int[]{type, type}, new int[]{x, 2 * this.pointerFirstX - x - 100}, new int[]{y, 2 * this.pointerFirstY - y - 100});
                }
                if (type == 2 || type == 3) {
                    currentWindow.setNothingFocused();
                    this.pointerScrollPane = null;
                    this.pointerComponent = null;
                }
            }
            this.showHideToolTip(type == 1, this.pointerComponent);
        }
        catch (Throwable th) {
            Logger.warn("Exception in pointerEvent", th);
        }
    }

    public void toast(String text) {
        ToolTip toast = this.indicator;
        toast.setText(text);
        toast.workoutPreferredSize();
        toast.setLocation((this.getWidth() - toast.getWidth()) / 2, this.getHeight() - toast.getHeight() * 3);
        toast.setShowing(true);
        toast.repaint();
        this.animateComponent(toast);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showHideToolTip(boolean show, Component comp) {
        if (show && comp != null && comp.getToolTipText() != null) {
            int left;
            this.tooltip.setText(comp.getToolTipText());
            this.tooltip.workoutPreferredSize();
            int x = comp.getToolTipLocationX() + comp.getXOnScreen();
            int y = comp.getToolTipLocationY() + comp.getYOnScreen();
            int w = this.tooltip.getWidthWithBorder();
            int h = this.tooltip.getHeightWithBorder();
            Border offset = this.tooltip.getBorder();
            int top = offset == null ? 0 : offset.getTop();
            int n = left = offset == null ? 0 : offset.getLeft();
            if (x - left < 0) {
                x = left;
            } else if (x - left + w > this.getWidth()) {
                x = this.getWidth() - w + left;
            }
            if (y - top < 0) {
                y = top;
            } else if (y - top + h > this.getHeight()) {
                y = this.getHeight() - h + top;
            }
            this.tooltip.setLocation(x, y);
            this.animateComponent(this.tooltip);
        } else if (this.tooltip != null) {
            Object object = this.uiLock;
            synchronized (object) {
                if (this.tooltip.isWaiting() && this.nextAnimatedComponent == null || this.nextAnimatedComponent == this.tooltip) {
                    this.animateComponent(null);
                }
            }
        }
    }

    public void setIndicatorText(String txt) {
        if (this.indicator.isShowing()) {
            this.repaintHole(this.indicator);
        }
        this.indicator.setText(txt);
        this.indicator.workoutPreferredSize();
        this.indicator.setShowing(txt != null && !this.QWERTY_KAYPAD);
        this.setupIndicatorPosition();
        this.indicator.repaint();
    }

    private void setupIndicatorPosition() {
        if (this.indicator != null) {
            int w = this.indicator.getWidthWithBorder();
            int h = this.indicator.getHeightWithBorder();
            if (this.sideSoftKeys) {
                this.indicator.setBoundsWithBorder(0, this.getHeight() - h, w, h);
            } else {
                this.indicator.setBoundsWithBorder(Midlet.getPlatform() == 3 ? 0 : this.getWidth() - w, 0, w, h);
            }
        }
    }

    protected void sizeChanged(int w, int h) {
        Logger.debug("sizeChanged!! " + this.paintdone + " w=" + w + " h=" + h);
        this.sizeChangedImpl();
        this.repaint();
    }

    private void sizeChangedImpl() {
        int w = super.getWidth();
        int h = super.getHeight();
        if (this.oldw == w && this.oldh == h) {
            return;
        }
        boolean old = this.wideScreen;
        boolean bl = this.wideScreen = w > h;
        if (old != this.wideScreen && this.oldw == h && this.oldh == w) {
            this.sideSoftKeys = this.wideScreen;
        }
        if (this.currentAnimatedComponent instanceof Menu) {
            this.animateComponent(null);
        }
        Vector win = this.getAllFrames();
        for (int c = 0; c < win.size(); ++c) {
            Window window = (Window)win.elementAt(c);
            if (window == null) continue;
            if (window instanceof Frame && ((Frame)window).isMaximum()) {
                ((Frame)window).setMaximum(true);
                continue;
            }
            if (DesktopPane.isAccurate(window.getX(), this.oldw - window.getWidth() - window.getX(), 1) && DesktopPane.isAccurate(window.getY(), this.oldh - window.getHeight() - window.getY(), 1)) {
                window.setLocationRelativeTo(null);
                continue;
            }
            window.makeVisible();
            if (window.snap == 0) continue;
            Menu.setupSize(window);
            boolean left = (window.snap & 4) != 0;
            boolean top = (window.snap & 0x10) != 0;
            boolean right = (window.snap & 8) != 0;
            boolean bottom = (window.snap & 0x20) != 0;
            Border insets = window.getInsets();
            if (top && bottom) {
                window.setBoundsWithBorder(window.getXWithBorder(), 0, window.getWidthWithBorder(), h);
            } else if (top || bottom) {
                window.setLocation(window.getX(), top ? insets.getTop() : h - window.getHeight() - insets.getBottom());
            }
            if (left && right) {
                window.setBoundsWithBorder(0, window.getYWithBorder(), w, window.getHeightWithBorder());
                continue;
            }
            if (!left && !right) continue;
            window.setLocation(left ? insets.getLeft() : w - window.getWidth() - insets.getRight(), window.getY());
        }
        this.oldw = w;
        this.oldh = h;
        if (!this.paintdone) {
            return;
        }
        this.setupIndicatorPosition();
        this.sizeChanged = true;
        this.pointerComponent = null;
        this.pointerScrollPane = null;
    }

    public void showNotify() {
        Logger.debug("showNotify");
        desktop = this;
        this.keypad.clear();
        this.sizeChangedImpl();
        this.repaint();
    }

    protected void hideNotify() {
        Logger.debug("hideNotify");
        this.keypad.clear();
    }

    public boolean isSideSoftKeys() {
        return this.sideSoftKeys;
    }

    public String toString() {
        return "DesktopPane" + this.windows;
    }

    static {
        if (Midlet.getPlatform() == 11) {
            dummyThread = new Thread();
        }
    }
}

