/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import java.util.Iterator;
import mikera.tyrant.AI;
import mikera.tyrant.BaseObject;
import mikera.tyrant.Coin;
import mikera.tyrant.Game;
import mikera.tyrant.Hero;
import mikera.tyrant.Item;
import mikera.tyrant.LevelMap;
import mikera.tyrant.Lib;
import mikera.tyrant.Map;
import mikera.tyrant.Poison;
import mikera.tyrant.RPG;
import mikera.tyrant.Skill;
import mikera.tyrant.Spell;
import mikera.tyrant.Thing;

public class Wish {
    private static String lastWish = "beefcake";

    public static boolean doPray(int n) {
        String string = Game.getLine("What do you pray for? ");
        if ((string = string.trim()).equals("") || string.equals("ESC")) {
            Game.message("");
            return false;
        }
        return Wish.makeWish(string, n);
    }

    public static void doWish() {
        String string = Game.getLine("What do you wish for? ");
        if ((string = string.trim()).equals("ESC")) {
            Game.message("");
            return;
        }
        if (string.equals("")) {
            string = lastWish;
        }
        Wish.makeWish(string, 100);
        lastWish = string;
    }

    public static boolean makeWish(String string, int n) {
        Thing thing;
        Thing thing2 = Game.hero();
        Map map = thing2.getMap();
        if (Game.isDebug() && Wish.makeDebugWish(string)) {
            return true;
        }
        if (Wish.makeSpecialWish(string, n)) {
            return true;
        }
        if (Skill.isSkillIgnoreCase(string)) {
            string = Skill.ensureCase(string);
            int n2 = 1;
            n2 = thing2.getFlag(string) || n >= 100 ? 1 : 2;
            if (n < 100 && thing2.getStat("SkillPoints") < n2) {
                Game.message("You must gain more experience before you can learn the art of " + string);
                return false;
            }
            thing2.incStat("SkillPoints", -n2);
            Game.message("You feel more knowledgeable about " + string);
            thing2.incStat(string, 1);
            return true;
        }
        if (n < 100 && string.equals("wishing well")) {
            Game.message("You hear a booming voice:");
            Game.message("\"Nice try... but no cigar\"");
            string = "carrot";
        }
        if ((thing = Lib.create(string)) == null || thing.name().equals("strange rock")) {
            thing = Lib.createIgnoreCase(string);
        }
        if (thing == null) {
            Game.message("You feel that you have asked for the impossible");
            return false;
        }
        if (thing.getFlag("IsArtifact") && n < 100) {
            Game.message("You hear a booming voice:");
            Game.message("\"Ha Ha. Very funny!\"");
            return false;
        }
        if (!thing.name().equals("strange rock") && thing.getStat("Frequency") <= 0 && n < 100) {
            Game.message("You hear a booming voice:");
            Game.message("\"Can't you do anything for yourself?\"");
            return false;
        }
        if (n < thing.getStat("Level")) {
            Game.message("You feel that you have asked for too much");
            return false;
        }
        if (thing.getFlag("IsAlteration")) {
            Game.warn("alteration: " + thing.name());
            Thing[] thingArray = thing2.getFlaggedContents(thing.getString("AlterationType"));
            for (int i = 0; i < thingArray.length; ++i) {
                thingArray[i].addThing(thing.cloneType());
            }
            return true;
        }
        if (thing.getFlag("IsEffect")) {
            thing2.addAttribute(thing);
            return true;
        }
        if (thing.getFlag("IsSpell")) {
            if (!Spell.canLearn(thing2, thing.name())) {
                Game.message("You cannot comprehend what you have wished for!");
                return false;
            }
            Spell.learn(thing2, thing.getString("Name"));
            return true;
        }
        if (map.addBlockingThing(thing, thing2.x - 1, thing2.y - 1, thing2.x + 1, thing2.y + 1)) {
            Game.message(thing.getAName() + " appears");
        } else {
            Game.message(thing.getAName() + " appears momentarily but fades away");
        }
        return true;
    }

    private static boolean makeDebugWish(String string) {
        Thing thing = Game.hero();
        if (string.startsWith("lots of ")) {
            string = string.substring(8);
            Game.message("Yahoo!");
            Map map = thing.getMap();
            for (int i = thing.x - 7; i <= thing.x + 7; ++i) {
                for (int j = thing.y - 7; j <= thing.y + 7; ++j) {
                    if (map.isBlocked(i, j)) continue;
                    map.addThing(Lib.create(string), i, j);
                }
            }
            return true;
        }
        if ((string = string.toLowerCase()).equals("eth")) {
            thing.set("IsEthereal", 1);
            return true;
        }
        if (string.equals("tv")) {
            Game.message("You can see through everything!");
            thing.set("TrueView", 120);
            return true;
        }
        if (string.equals("digging")) {
            Game.message("Do you dig it?");
            thing.set("Digging", 1);
            return true;
        }
        if (string.equals("skills")) {
            Game.message("You feel seriously multi-talented.");
            String[] stringArray = Skill.fullList();
            for (int i = 0; i < stringArray.length; ++i) {
                thing.incStat(stringArray[i], 1);
            }
            return true;
        }
        if (string.equals("error")) {
            throw new Error("Error wished for!");
        }
        if (string.equals("victory")) {
            Game.over = true;
            return true;
        }
        if (string.equals("luck")) {
            thing.incStat("Luck", 50);
            return true;
        }
        if (string.equals("stuff")) {
            Game.message("Let battle commence");
            Map map = thing.getMap();
            for (int i = thing.x - 7; i <= thing.x + 7; ++i) {
                for (int j = thing.y - 7; j <= thing.y + 7; ++j) {
                    if (map.isBlocked(i, j)) continue;
                    map.addThing(Lib.createItem(thing.getLevel()), i, j);
                }
            }
            return true;
        }
        if (string.equals("weapons")) {
            Game.message("Let's go to work!");
            Map map = thing.getMap();
            for (int i = thing.x - 7; i <= thing.x + 7; ++i) {
                for (int j = thing.y - 7; j <= thing.y + 7; ++j) {
                    if (map.isBlocked(i, j)) continue;
                    map.addThing(Lib.createType("IsWeapon", thing.getLevel()), i, j);
                }
            }
            return true;
        }
        if (string.equals("artifacts")) {
            Game.message("Whoopee!!!");
            Map map = thing.getMap();
            for (int i = thing.x - 5; i <= thing.x + 5; ++i) {
                for (int j = thing.y - 5; j <= thing.y + 5; ++j) {
                    if (map.isBlocked(i, j)) continue;
                    map.addThing(Lib.createArtifact(RPG.d(50)), i, j);
                }
            }
            return true;
        }
        if (string.matches("x\\d+")) {
            int n = Integer.parseInt(string.substring(1));
            Game.message("You feel masses of ancient knowledge fill your mind");
            while (thing.getLevel() < 50 && thing.getLevel() < n) {
                Hero.gainExperience(Hero.calcXPRequirement(thing.getLevel() + 1));
            }
            return true;
        }
        if (string.equals("x") || string.equals("xp") || string.equals("exp") || string.equals("experience") || string.equals("training")) {
            Game.message("You feel ancient knowledge fill your mind");
            Hero.gainExperience(Hero.calcXPRequirement(Game.hero().getLevel() + 1));
            return true;
        }
        if (string.equals("all")) {
            Game.message("Everything in the library added to your inventory");
            Thing thing2 = Game.hero();
            Iterator iterator = Lib.instance().getAll().iterator();
            while (iterator.hasNext()) {
                BaseObject baseObject = (BaseObject)iterator.next();
                String string2 = (String)baseObject.get("Name");
                if (string2.startsWith("base ") || baseObject.get("IsItem") == null) continue;
                Thing thing3 = Lib.create(string2);
                thing2.addThing(thing3);
            }
            return true;
        }
        if (string.equals("identify")) {
            Game.message("You know a lot.");
            Thing thing4 = Game.hero();
            for (int i = 0; i < thing4.invCount(); ++i) {
                Thing thing5 = thing4.getInventory()[i];
                Item.identify(thing5);
            }
            return true;
        }
        return false;
    }

    private static boolean makeSpecialWish(String string, int n) {
        string = string.toLowerCase();
        Thing thing = Game.hero();
        String string2 = null;
        if (string.equalsIgnoreCase("sk") || string.equals("skill")) {
            string2 = "SK";
        }
        if (string.equalsIgnoreCase("st") || string.equals("strength")) {
            string2 = "ST";
        }
        if (string.equalsIgnoreCase("ag") || string.equals("agility")) {
            string2 = "AG";
        }
        if (string.equalsIgnoreCase("tg") || string.equals("toughness")) {
            string2 = "TG";
        }
        if (string.equalsIgnoreCase("in") || string.equals("intelligence")) {
            string2 = "IN";
        }
        if (string.equalsIgnoreCase("wp") || string.equals("willpower")) {
            string2 = "WP";
        }
        if (string.equalsIgnoreCase("ch") || string.equals("charisma")) {
            string2 = "CH";
        }
        if (string.equalsIgnoreCase("cr") || string.equals("craft")) {
            string2 = "CR";
        }
        if (string2 != null) {
            Game.message("You feel your talents increasing");
            thing.incStat(string2, RPG.d(3));
            return true;
        }
        if (string.equals("immortality")) {
            Game.message("You feel that you will be remembered for all time");
            return true;
        }
        if (string.equals("mortality")) {
            Game.message("You feel rather vulnerable");
            thing.set("IsImmortal", -100);
            return true;
        }
        if (string.equals("friend") || string.equals("friends")) {
            Game.message("And you shall have a friend!");
            Thing thing2 = Lib.create("[IsBeing]", thing.getLevel());
            thing.getMap().addThing(thing2, thing.x - 1, thing.y - 1, thing.x + 1, thing.y + 1);
            AI.setFollower(thing2, thing);
            return true;
        }
        if (string.equals("death")) {
            Game.message("You feel your spirit being released from your body");
            thing.set("IsImmortal", -100);
            thing.die();
            return true;
        }
        if (string.equals("hunger") || string.equals("hungry")) {
            Game.message("You suddenly feel hungry");
            thing.set("Hunger", thing.getStat("HungerThreshold") + 1);
            return true;
        }
        if (string.equals("map")) {
            Game.message("You know this place like the back of your hand");
            LevelMap.reveal(thing.getMap());
            return true;
        }
        if (string.equals("charging")) {
            Game.message("You feel a great surge of power");
            Spell.rechargeSpells(thing, 1000000);
            return true;
        }
        if (string.equals("foes")) {
            Game.message("Let battle commence");
            Map map = thing.getMap();
            for (int i = thing.x - 7; i <= thing.x + 7; ++i) {
                for (int j = thing.y - 7; j <= thing.y + 7; ++j) {
                    if (map.isBlocked(i, j)) continue;
                    map.addThing(Lib.create("[IsMonster]"), i, j);
                }
            }
            return true;
        }
        if (string.equals("action")) {
            Game.message("You feel very excited");
            Map map = thing.getMap();
            map.incStat("Level", 6);
            map.incStat("WanderingRate", map.width * map.height);
            return true;
        }
        if (string.equals("identification") || string.equals("id") || string.equals("ident")) {
            Game.message("You feel suddenly knowledgable about your posessions");
            Thing[] thingArray = thing.getFlaggedContents("IsItem");
            for (int i = 0; i < thingArray.length; ++i) {
                Item.fullIdentify(thingArray[i]);
            }
            return true;
        }
        if (string.equals("speed")) {
            thing.incStat("MoveSpeed", RPG.d(20));
            Game.message("You feel like running very fast");
            return true;
        }
        if (string.equals("aggression") || string.equals("ferocity")) {
            thing.incStat("AttackSpeed", RPG.d(15));
            Game.message("You feel more aggressive");
            return true;
        }
        if (string.equals("recharging")) {
            Game.message("You feel a surge of power around your posessions");
            Thing[] thingArray = thing.getFlaggedContents("IsWand");
            for (int i = 0; i < thingArray.length; ++i) {
                thingArray[i].incStat("Charges", 5);
            }
            return true;
        }
        if (string.equals("cash") || string.equals("money") || string.equals("wealth")) {
            Game.message("Your purse feels heavier");
            Coin.addMoney(thing, 10 * n * RPG.d(2, 300));
            return true;
        }
        if (string.equals("heal") || string.equals("hps")) {
            Game.message("Your body is surrounded by healing energies");
            thing.set("HPS", thing.getStat("HPSMAX"));
            return true;
        }
        if (string.equals("health") || string.equals("cure") || string.equals("curing") || string.equals("cure poison")) {
            Game.message("Your body is surrounded by curing energies");
            Poison.cure(thing, 1000000);
            return true;
        }
        return false;
    }
}

