/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import mikera.tyrant.AI;
import mikera.tyrant.Door;
import mikera.tyrant.Fire;
import mikera.tyrant.Food;
import mikera.tyrant.Game;
import mikera.tyrant.Lib;
import mikera.tyrant.Map;
import mikera.tyrant.Maze;
import mikera.tyrant.Point;
import mikera.tyrant.Portal;
import mikera.tyrant.RPG;
import mikera.tyrant.Scroll;
import mikera.tyrant.Secret;
import mikera.tyrant.Thing;

public class Town {
    public static final int[] OUTER = new int[]{0, 1, 2, 7, 14};
    public static final int[] INNER = new int[]{4, 15, 5, 3, 24};
    public static int[][][] towns = new int[][][]{new int[][]{{11, 22, 16, -2, -1}, {-2, 9, 6, 13, -2}, {-2, 8, -2, 15, -1}}, new int[][]{{8, -1, -2, -1, 7}, {9, 13, 6, -2, -1}, {17, 19, 12, -2, 14}}, new int[][]{{-1, 17, 19, -2, 13}, {-1, -2, 9, 6, 13}}, new int[][]{{-1, 12, -2}, {13, 6, 13}, {-2, 12, -1}}, new int[][]{{-1, -2, 14}, {-2, 6, -2}, {7, -2, -1}}};

    public static Map createTown(int n, int n2) {
        Map map = new Map(n, n2);
        map.set("Level", 3);
        map.set("IsHostile", 0);
        map.set("WanderingRate", 5);
        map.set("EnterMessageFirst", "This seems like a peaceful little village");
        int[][] nArray = towns[RPG.r(towns.length)];
        map.setSize(16 * nArray[0].length, 16 * nArray.length);
        Town.buildTown(map, nArray);
        map.addThing(Lib.createType("IsWanderer", Game.level()));
        return map;
    }

    private static void buildTown(Map map, int[][] nArray) {
        map.setTheme("village");
        map.set("Description", "Small Town");
        map.set("WallTile", RPG.pick(new int[]{10, 30, 6}));
        map.fillArea(0, 0, map.width - 1, map.height - 1, map.floor());
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[i].length; ++j) {
                Town.buildArea(map, j * 16, i * 16, nArray[i][j]);
            }
        }
        Town.addTownies(map);
        map.setEntrance(Portal.create());
        Point point = map.findFreeSquare(0, 0, map.width - 1, 0);
        map.addThing(map.getEntrance(), point.x, point.y);
    }

    public static void buildTemple(Map map, int n, int n2) {
        int n3 = RPG.d(2, 3);
        int n4 = RPG.d(2, 3);
        int n5 = n + 8;
        int n6 = n2 + 3;
        int n7 = n2 + 12;
        map.fillArea(n5 - n3, n6, n5 + n4, n7, 5);
        map.fillBorder(n5 - n3, n6, n5 + n4, n7, 6);
        map.fillBorder(n5 - n3 + 1, n6 + 1, n5 + n4 - 1, n6 + 1, 17);
        map.fillArea(n5, n7, n5, n7, 5);
        map.addThing(Lib.create("ornate door"), n5, n7);
        map.addThing(Lib.create("blank sign"), n5 + 1, n7 + 1);
        int n8 = n2 + 7;
        Thing thing = Lib.create("healer");
        AI.setGuard(thing, map, n5 - 1, n8 - 1, n5 + 1, n8 + 1);
        map.addThing(thing, n5, n8, n5, n8);
        for (int i = n5 - n3 + 1; i <= n5 + n4 - 1; ++i) {
            map.addThing(Town.stockingPoint(thing, "IsPotion", 10), i, n6 + 2);
        }
        map.addThing(Lib.create("well"), n5, n8);
        map.rotateArea(n, n2, 16, RPG.r(4));
    }

    public static void buildWaterGarden(Map map, int n, int n2) {
        map.fillArea(n + 1, n2 + 1, n + 13, n2 + 13, 17);
        map.fillArea(n + 3, n2 + 3, n + 11, n2 + 11, map.floor());
        map.fillArea(n + 1, n2 + 6, n + 13, n2 + 8, map.floor());
        map.fillArea(n + 6, n2 + 1, n + 8, n2 + 13, map.floor());
        switch (RPG.d(4)) {
            case 1: {
                String string = RPG.pick(new String[]{"red apple tree", "potted flower", "potted plant", "plant"});
                for (int i = 5; i <= 9; i += 2) {
                    for (int j = 5; j <= 9; j += 2) {
                        map.addThing(string, n + i, n2 + j);
                    }
                }
                break;
            }
            case 2: {
                for (int i = 5; i <= 9; i += 2) {
                    for (int j = 5; j <= 9; j += 2) {
                        map.setTile(n + i, n2 + j, 17);
                    }
                }
                break;
            }
            case 3: {
                Town.addRoom(map, n + 5, n2 + 5, n + 9, n2 + 9, 0, -1);
                Thing thing = Lib.create("teacher");
                map.addThing(thing, n + 7, n2 + 7);
                AI.setGuard(thing, map, n + 7, n2 + 7);
                break;
            }
            case 4: {
                map.addThing("fountain", n + 7, n2 + 7);
            }
        }
    }

    private static void buildArea(Map map, int n, int n2, int n3) {
        if (n3 == -1) {
            n3 = RPG.pick(OUTER);
        }
        if (n3 == -2) {
            n3 = RPG.pick(INNER);
        }
        switch (n3) {
            case 0: {
                for (int i = 0; i < 20; ++i) {
                    map.addThing(Lib.create("tree"), n, n2, n + 15, n2 + 15);
                }
                switch (RPG.d(4)) {
                    case 1: {
                        map.addThing(Lib.createType("IsWell", map.getLevel()), n, n2, n + 15, n2 + 15);
                        break;
                    }
                    case 2: {
                        map.addThing(Lib.createType("IsGravestone", map.getLevel()), n, n2, n + 15, n2 + 15);
                        break;
                    }
                    default: {
                        map.clearArea(n + 5, n2 + 5, n + 10, n2 + 9);
                        map.fillArea(n + 5, n2 + 5, n + 10, n2 + 9, 30);
                        map.fillArea(n + 6, n2 + 6, n + 9, n2 + 8, 31);
                        map.setTile(n + 5, n2 + 7, 31);
                        map.addThing(Door.createDoor(5), n + 5, n2 + 7);
                        map.addThing(Lib.createType("IsEquipment", 5), n + 5, n2 + 7);
                    }
                }
                map.addThing(Lib.create("ranger"), n, n2, n + 15, n2 + 15);
                break;
            }
            case 3: {
                int n4 = RPG.r(3) + 3;
                int n5 = RPG.r(3) + 3;
                int n6 = n + 1 + RPG.r(14 - n4);
                int n7 = n2 + 1 + RPG.r(14 - n5);
                int n8 = RPG.r(2) * 2 - 1;
                int n9 = RPG.r(2) * 2 - 1;
                if (RPG.d(2) == 1) {
                    n8 = 0;
                } else {
                    n9 = 0;
                }
                Town.addRoom(map, n6, n7, n6 + n4, n7 + n5, n8, n9);
                break;
            }
            case 4: {
                Town.addRoom(map, n + 8 - RPG.d(2, 3), n2 + 8 - RPG.d(2, 3), n + 8, n2 + 8, 0, -1);
                Town.addRoom(map, n + 8 - RPG.d(2, 3), n2 + 8, n + 8, n2 + 8 + RPG.d(2, 3), 0, 1);
                Town.addRoom(map, n + 8, n2 + 8 - RPG.d(2, 3), n + 8 + RPG.d(2, 3), n2 + 8, 0, -1);
                Town.addRoom(map, n + 8, n2 + 8, n + 8 + RPG.d(2, 3), n2 + 8 + RPG.d(2, 3), 0, 1);
                break;
            }
            case 5: {
                Town.buildTemple(map, n, n2);
                break;
            }
            case 6: {
                Town.addShop(map, n, n2, n + RPG.d(3, 2), n2 + RPG.d(3, 2), 1, 0, 4);
                Town.addShop(map, n + 15 - RPG.d(3, 2), n2, n + 15, n2 + RPG.d(3, 2), 0, 1, 0);
                Town.addShop(map, n, n2 + 15 - RPG.d(3, 2), n + RPG.d(3, 2), n2 + 15, 0, -1, 2);
                Town.addShop(map, n + 15 - RPG.d(3, 2), n2 + 15 - RPG.d(3, 2), n + 15, n2 + 15, -1, 0, 3);
                break;
            }
            case 7: {
                map.setTile(n + 8, n2 + 8, 25);
                map.fractalize(n + 4, n2 + 4, n + 11, n2 + 11, 4);
                for (int i = 0; i < 10; ++i) {
                    map.addThing(Lib.create("bush"), n, n2, n + 15, n2 + 15);
                }
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                map.makeRandomPath(n + 8, n2, n + 8, n2 + 15, n, n2, n + 15, n2 + 15, 17, false);
                map.spreadTiles(n, n2, n + 15, n2 + 15, 17, map.floor());
                if ((n3 & 1) == 1) {
                    map.replaceTiles(n, n2 + 7, n + 15, n2 + 7 + RPG.r(3), 17, 5);
                }
                if ((n3 & 2) <= 0) break;
                map.rotateArea(n, n2, 16, 1);
                break;
            }
            case 12: 
            case 13: {
                int n10 = 7 - RPG.d(3);
                int n11 = 7 + RPG.d(3);
                Town.addFeature(map, n, n2 + RPG.r(2), n + n10, n2 + 5 + RPG.r(3), 0, 1, 0);
                Town.addFeature(map, n + n10, n2 + RPG.r(2), n + n11, n2 + 5 + RPG.r(3), 0, 1, 0);
                Town.addFeature(map, n + n11, n2 + RPG.r(2), n + 14, n2 + 5 + RPG.r(3), 0, 1, 0);
                n10 = 8 - RPG.d(4);
                n11 = 8 + RPG.d(4);
                Town.addFeature(map, n, n2 + 9 + RPG.r(3), n + n10, n2 + 14 - RPG.r(2), 0, -1, 0);
                Town.addFeature(map, n + n10, n2 + 9 + RPG.r(3), n + n11, n2 + 14 - RPG.r(2), 0, -1, 0);
                Town.addFeature(map, n + n11, n2 + 9 + RPG.r(3), n + 14, n2 + 14 - RPG.r(2), 0, -1, 0);
                if (n3 != 12) break;
                map.rotateArea(n, n2, 16, 1);
                break;
            }
            case 14: {
                boolean bl = false;
                Thing thing = null;
                if (RPG.r(3) == 2) {
                    bl = true;
                } else {
                    thing = Lib.createType("IsFruitTree", 1);
                }
                for (int i = 0; i < 20; ++i) {
                    int n12;
                    int n13 = n + 1 + RPG.r(14);
                    if (map.isBlocked(n13, n12 = n2 + 1 + RPG.r(14))) continue;
                    if (bl) {
                        map.addThing(Lib.create("[IsFruitTree]"), n13, n12);
                        continue;
                    }
                    map.addThing(thing.cloneType(), n13, n12);
                }
                break;
            }
            case 15: {
                Town.addShop(map, n + 5, n2 + 5, n + 10, n2 + 10, 0, -1, 5);
                map.rotateArea(n, n2, 16, RPG.r(4));
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                map.makeRandomPath(n + 8, n2, n, n2 + 8, n, n2, n + 15, n2 + 15, 17, false);
                map.spreadTiles(n, n2, n + 15, n2 + 15, 17, map.floor());
                map.rotateArea(n, n2, 16, n3 - 16);
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                map.makeRandomPath(n + 8, n2, n, n2 + 8, n, n2, n + 15, n2 + 15, 17, false);
                map.makeRandomPath(n + 8, n2, n + 15, n2 + 8, n, n2, n + 15, n2 + 15, 17, false);
                map.spreadTiles(n, n2, n + 15, n2 + 15, 17, map.floor());
                map.rotateArea(n, n2, 16, n3 - 20);
                break;
            }
            case 24: {
                Town.buildWaterGarden(map, n, n2);
            }
        }
    }

    public static void addFeature(Map map, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (n7 == 0) {
            n7 = RPG.d(10);
        }
        switch (n7) {
            case 1: {
                Town.addShop(map, n, n2, n3, n4, n5, n6, 0);
                break;
            }
            default: {
                Town.addRoom(map, n, n2, n3, n4, n5, n6);
            }
        }
    }

    public static void addGraveYard(Map map, int n, int n2, int n3, int n4) {
        int n5;
        for (n5 = 0; n5 < (n3 - n + 1) * (n4 - n2 + 1) / 8; ++n5) {
            map.addThing(Lib.createType("IsGraveStone", map.getLevel()), n, n2, n3, n4);
        }
        for (n5 = 0; n5 < (n3 - n + 1) * (n4 - n2 + 1) / 18; ++n5) {
            map.addThing(Lib.createType("potted flower", map.getLevel()), n, n2, n3, n4);
        }
    }

    public static void addTownies(Map map) {
        Point point;
        int n;
        for (n = 0; n <= 10; ++n) {
            point = map.findFreeSquare();
            map.addThing(Lib.create("farmer"), point.x, point.y);
        }
        for (n = 0; n <= 6; ++n) {
            point = map.findFreeSquare();
            map.addThing(Lib.create("village woman"), point.x, point.y);
        }
        for (n = 0; n <= 4; ++n) {
            point = map.findFreeSquare();
            map.addThing(Lib.create("village girl"), point.x, point.y);
        }
        for (n = 0; n <= 8; ++n) {
            point = map.findFreeSquare();
            map.addThing(Lib.create("guard"), point.x, point.y);
        }
        Point point2 = map.findFreeSquare();
        map.addThing(Lib.create("teacher"), point2.x, point2.y);
    }

    public static Thing stockingPoint(Thing thing, String string, int n) {
        Thing thing2 = Lib.create("base stocking point");
        thing2.set("Name", "shop stocking point");
        thing2.set("StockingType", string);
        thing2.set("StockingLevel", n);
        thing2.set("Shopkeeper", thing);
        return thing2;
    }

    public static void addShop(Map map, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8;
        int n9 = n5 == 0 ? RPG.rspread(n + 1, n3 - 1) : (n8 = n5 == -1 ? n : n3);
        int n10 = n6 == 0 ? RPG.rspread(n2 + 1, n4 - 1) : (n6 == -1 ? n2 : n4);
        map.fillArea(n, n2, n3, n4, 1);
        map.fillBorder(n, n2, n3, n4, 10);
        map.setTile(n8, n10, 1);
        Thing thing = Lib.create("shop door");
        if (n7 == 0) {
            n7 = RPG.d(10);
        }
        switch (n7) {
            case 1: {
                Thing thing2 = Lib.create("wizard");
                for (int i = n + 1; i < n3; ++i) {
                    for (int j = n2 + 1; j < n4; ++j) {
                        map.addThing(Town.stockingPoint(thing2, "IsMagicItem", RPG.d(15)), i, j);
                    }
                }
                AI.setGuard(thing2, map, n, n2, n3, n4);
                map.addThing(thing2, (n + n3) / 2, (n2 + n4) / 2);
                map.addThing(Lib.create("magic shop sign"), n8 + n5 + n6 * (RPG.r(2) * 2 - 1), n10 + n6 + n5 * (RPG.r(2) * 2 - 1));
                break;
            }
            case 2: {
                Thing thing3 = Lib.create("guard");
                for (int i = n + 1; i < n3; ++i) {
                    for (int j = n2 + 1; j < n4; ++j) {
                        map.addThing(Town.stockingPoint(thing3, "IsWeapon", RPG.d(2, 6)), i, j);
                    }
                }
                AI.setGuard(thing3, map, n, n2, n3, n4);
                map.addThing(thing3, (n + n3) / 2, (n2 + n4) / 2);
                map.addThing(Lib.create("armoury sign"), n8 + n5 + n6 * (RPG.r(2) * 2 - 1), n10 + n6 + n5 * (RPG.r(2) * 2 - 1));
                break;
            }
            case 3: {
                Thing thing4 = Lib.create("shopkeeper");
                for (int i = n + 1; i < n3; ++i) {
                    for (int j = n2 + 1; j < n4; ++j) {
                        map.addThing(Town.stockingPoint(thing4, "IsShopFood", 10), i, j);
                    }
                }
                AI.setGuard(thing4, map, n, n2, n3, n4);
                map.addThing(thing4, (n + n3) / 2, (n2 + n4) / 2);
                map.addThing(Lib.create("food shop sign"), n8 + n5 + n6 * (RPG.r(2) * 2 - 1), n10 + n6 + n5 * (RPG.r(2) * 2 - 1));
                break;
            }
            case 5: {
                Thing thing5 = Lib.create("blacksmith");
                AI.setGuard(thing5, map, n, n2, n3, n4);
                map.addThing(thing5, (n + n3) / 2, (n2 + n4) / 2);
                map.addThing(Fire.create(5), n3 - 1, n4 - 1);
                map.addThing(Fire.create(5), n3 - 2, n4 - 1);
                map.addThing(Lib.create("smithy sign"), n8 + n5 + n6 * (RPG.r(2) * 2 - 1), n10 + n6 + n5 * (RPG.r(2) * 2 - 1));
                break;
            }
            case 6: {
                thing = Lib.create("goblin door");
                thing.set("IsLocked", 0);
                Thing thing6 = Lib.create("goblin shopkeeper");
                AI.setGuard(thing6, map, n, n2, n3, n4);
                thing6.set("IsHostile", 0);
                map.addThing(thing6, (n + n3) / 2, (n2 + n4) / 2);
                for (int i = n + 1; i < n3; ++i) {
                    for (int j = n2 + 1; j < n4; ++j) {
                        map.addThing(Town.stockingPoint(thing6, "IsMagicItem", 12), i, j);
                    }
                }
                break;
            }
            case 7: {
                Thing thing7 = Lib.create("shopkeeper");
                for (int i = n + 1; i < n3; ++i) {
                    for (int j = n2 + 1; j < n4; ++j) {
                        map.addThing(Town.stockingPoint(thing7, "IsEquipment", 10), i, j);
                    }
                }
                AI.setGuard(thing7, map, n, n2, n3, n4);
                map.addThing(thing7, (n + n3) / 2, (n2 + n4) / 2);
                map.addThing(Lib.create("armoury sign"), n8 + n5 + n6 * (RPG.r(2) * 2 - 1), n10 + n6 + n5 * (RPG.r(2) * 2 - 1));
                break;
            }
            case 8: {
                Thing thing8 = Lib.create("blacksmith");
                for (int i = n + 1; i < n3; ++i) {
                    for (int j = n2 + 1; j < n4; ++j) {
                        if (RPG.d(2) != 1) continue;
                        map.addThing(Town.stockingPoint(thing8, "IsArmour", 10), i, j);
                    }
                }
                AI.setGuard(thing8, map, n, n2, n3, n4);
                map.addThing(thing8, (n + n3) / 2, (n2 + n4) / 2);
                map.addThing(Lib.create("smithy sign"), n8 + n5 + n6 * (RPG.r(2) * 2 - 1), n10 + n6 + n5 * (RPG.r(2) * 2 - 1));
                break;
            }
            case 9: {
                thing = Lib.create("goblin door");
                thing.set("IsLocked", 0);
                Thing thing9 = Lib.create(RPG.pick(new String[]{"goblin shopkeeper", "learned sage", "shopkeeper", "wizard"}));
                AI.setGuard(thing9, map, n, n2, n3, n4);
                map.addThing(thing9, (n + n3) / 2, (n2 + n4) / 2);
                for (int i = n + 1; i < n3; ++i) {
                    for (int j = n2 + 1; j < n4; ++j) {
                        map.addThing(Town.stockingPoint(thing9, "IsRunestone", RPG.d(12)), i, j);
                    }
                }
                break;
            }
            default: {
                Thing thing10 = Lib.create("shopkeeper");
                for (int i = n + 1; i < n3; ++i) {
                    for (int j = n2 + 1; j < n4; ++j) {
                        map.addThing(Town.stockingPoint(thing10, "IsStoreItem", 10), i, j);
                    }
                }
                AI.setGuard(thing10, map, n, n2, n3, n4);
                map.addThing(thing10, (n + n3) / 2, (n2 + n4) / 2);
                map.addThing(Lib.create("store sign"), n8 + n5 + n6 * (RPG.r(2) * 2 - 1), n10 + n6 + n5 * (RPG.r(2) * 2 - 1));
            }
        }
        map.addThing(thing, n8, n10);
    }

    public static void addBuilding(Map map) {
        int n = RPG.d(2, 4) + 3;
        int n2 = RPG.d(2, 4) + 3;
        int n3 = RPG.r(map.width - n);
        int n4 = RPG.r(map.height - n2);
        int n5 = n3 + n;
        int n6 = n4 + n2;
        int n7 = RPG.r(3) - 1;
        int n8 = RPG.r(3) - 1;
        if (RPG.d(2) == 1) {
            n7 = 0;
        } else {
            n8 = 0;
        }
        if (map.countTiles(n3, n4, n5, n6, map.floor()) != (n + 1) * (n2 + 1)) {
            return;
        }
        Town.addRoom(map, n3 + 1, n4 + 1, n5 - 1, n6 - 1, n7, n8);
    }

    public static void addRoom(Map map, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        int n8 = n5 == 0 ? RPG.rspread(n + 1, n3 - 1) : (n7 = n5 == -1 ? n : n3);
        int n9 = n6 == 0 ? RPG.rspread(n2 + 1, n4 - 1) : (n6 == -1 ? n2 : n4);
        Town.addStandardRoom(map, n, n2, n3, n4, n7, n9);
    }

    public static void addStandardRoom(Map map, int n, int n2, int n3, int n4, int n5, int n6) {
        map.fillArea(n, n2, n3, n4, 1);
        map.fillBorder(n, n2, n3, n4, map.wall());
        boolean bl = false;
        Thing thing = Lib.create("door");
        switch (RPG.d(15)) {
            case 1: {
                thing.set("IsLocked", 1);
                Thing thing2 = Food.createFood(0);
                thing2.set("IsOwned", 1);
                map.addThing(thing2, n + 1, n2 + 1, n3 - 1, n4 - 1);
                break;
            }
            case 2: {
                thing.set("IsLocked", 1);
                Thing thing3 = Lib.createItem(8);
                thing3.set("IsOwned", true);
                map.addThing(thing3, n + 1, n2 + 1, n3 - 1, n4 - 1);
                break;
            }
            case 3: {
                Thing thing4 = Lib.createItem(3);
                map.addThing(Secret.hide(thing4), n + 1, n2 + 1, n3 - 1, n4 - 1);
                for (int i = RPG.d(8); i > 0; --i) {
                    map.addThing(Lib.create("sewer rat"), n + 1, n2 + 1, n3 - 1, n4 - 1);
                }
                break;
            }
            case 4: {
                map.addThing(Lib.create("table"), n + 1, n2 + 1, n3 - 1, n4 - 1);
                break;
            }
            case 5: {
                if (RPG.d(6) == 1) {
                    Thing thing5 = Lib.createItem(3);
                    map.addThing(Secret.hide(thing5), n + 1, n2 + 1, n3 - 1, n4 - 1);
                }
                thing = null;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                thing.set("IsLocked", RPG.d(3) == 1 ? 1 : 0);
                Town.decorateRoom(map, n + 1, n2 + 1, n3 - 1, n4 - 1);
                break;
            }
            case 10: {
                thing = Lib.create("stable door");
                thing.set("IsLocked", 1);
                map.addThing(Lib.create("[IsAnimal]"), n, n2, n3, n4);
                if (RPG.d(4) != 1) break;
                map.addThing(Lib.create("[IsAnimal]"), n, n2, n3, n4);
                break;
            }
            case 11: {
                if (RPG.d(4) == 1) {
                    Thing thing6 = Lib.createItem(10);
                    map.addThing(Secret.hide(thing6), n + 1, n2 + 1, n3 - 1, n4 - 1);
                }
                Town.decorateRoom(map, n + 1, n2 + 1, n3 - 1, n4 - 1);
                bl = true;
            }
        }
        if (bl) {
            map.addThing(Lib.create("secret door"), n5, n6);
        } else {
            map.setTile(n5, n6, 1);
            if (thing != null) {
                map.addThing(thing, n5, n6);
            }
        }
    }

    public static void decorateRoom(Map map, int n, int n2, int n3, int n4) {
        int n5 = n3 - n + 1;
        int n6 = n4 - n2 + 1;
        switch (RPG.d(12)) {
            case 1: {
                for (int i = n; i <= n3; ++i) {
                    for (int j = n2; j <= n4; ++j) {
                    }
                }
                break;
            }
            case 2: {
                if (n5 <= 3 || n6 < 3) break;
                Point point = Town.createPersonAndTable("townswoman", map, n, n2, n3, n4);
                map.addThing(Lib.create("stool"), point.x + 1 - 2 * RPG.r(2), point.y);
                map.addThing(Lib.create("stool"), point.x, point.y + 1 - 2 * RPG.r(2));
                map.addThing(Food.createFood(0), n, n2, n3, n4);
                map.addThing(Food.createFood(0), n, n2, n3, n4);
                break;
            }
            case 3: {
                if (n5 <= 3 || n6 < 3) break;
                Point point = Town.createPersonAndTable(RPG.pick(new String[]{"wizard", "priest"}), map, n, n2, n3, n4);
                map.addThing(Lib.create("stool"), point.x + 1 - 2 * RPG.r(2), point.y + 1 - 2 * RPG.r(2));
                map.addThing(Lib.createMagicItem(3), n, n2, n3, n4).set("IsOwned", 1);
                map.addThing(Lib.createMagicItem(3), n, n2, n3, n4).set("IsOwned", 1);
                map.addThing(Scroll.createScroll(6), n, n2, n3, n4).set("IsOwned", 1);
                map.addThing(Scroll.createScroll(8), n, n2, n3, n4).set("IsOwned", 1);
                break;
            }
            case 4: {
                if (n5 <= 3 || n6 < 3) break;
                map.fillArea(n + 1, n2 + 1, n3 - 1, n4 - 1, 26);
                break;
            }
            case 5: {
                map.addThing("potted plant", n, n2, n3, n4);
                map.addThing("chest", n, n2, n3, n4).set("IsOwned", 1);
                break;
            }
            case 6: {
                map.addThing("potted flower", n, n2, n3, n4);
                map.addThing("potted flower", n, n2, n3, n4);
                break;
            }
            case 7: {
                Thing thing = map.addThing("learned sage", n, n2, n3, n4);
                AI.setGuard(thing, map, n, n2, n3, n4);
                map.addThing(Lib.createMagicItem(3), n, n2, n3, n4).set("IsOwned", 1);
                map.addThing(Scroll.createScroll(6), n, n2, n3, n4).set("IsOwned", 1);
                map.addThing(Scroll.createScroll(8), n, n2, n3, n4).set("IsOwned", 1);
                break;
            }
            case 8: {
                map.addThing("pit trap", n, n2, n3, n4);
                break;
            }
            case 9: {
                map.addThing(Lib.createType("IsBook"), n, n2, n3, n4).set("IsOwned", 1);
                break;
            }
            default: {
                map.addThing(Lib.createItem(RPG.d(12)), n, n2, n3, n4).set("IsOwned", 1);
            }
        }
    }

    private static Point createPersonAndTable(String string, Map map, int n, int n2, int n3, int n4) {
        Thing thing = Lib.create(string);
        AI.setGuard(thing, map, n, n2, n3, n4);
        map.addThing(thing, n, n2, n3, n4);
        int n5 = RPG.rspread(n + 1, n3 - 1);
        int n6 = RPG.rspread(n2 + 1, n4 - 1);
        map.addThing(Lib.create("table"), n5, n6);
        return new Point(n5, n6);
    }

    public static void decorateTown(Map map, int n, int n2, int n3, int n4) {
        for (int i = n; i <= n3; ++i) {
            block6: for (int j = n2; j <= n4; ++j) {
                if (map.isBlocked(i, j) || map.getTile(i, j) != map.floor()) continue;
                switch (RPG.d(200)) {
                    case 1: 
                    case 2: 
                    case 3: {
                        map.addThing(Lib.create("plant"), i, j);
                        continue block6;
                    }
                    case 4: {
                        map.addThing("menhir", i, j);
                        continue block6;
                    }
                    case 5: {
                        map.addThing("[IsHerb]", i, j);
                    }
                }
            }
        }
    }

    public static Map buildNyckMap() {
        Map map = new Map(31, 31);
        map.set("Description", "A Strange Icy Place");
        map.set("WallTile", 12);
        map.set("FloorTile", 11);
        Maze.buildMaze(map, 0, 0, 30, 30);
        map.fillArea(11, 21, 19, 29, map.wall());
        int n = RPG.r(15) * 2 + 1;
        map.setTile(n, 0, map.floor());
        Thing thing = Portal.create("invisible portal");
        map.addThing(thing, n, 0);
        map.setEntrance(thing);
        map.fillArea(11, 21, 19, 29, map.floor());
        map.fillBorder(13, 23, 17, 27, map.wall());
        map.setTile(15, 23, map.floor());
        map.addThing(Fire.create(5), 15, 25);
        Thing thing2 = Lib.create("Jolly Old Nyck");
        map.addThing(thing2, 15, 26);
        AI.setGuard(thing2, map, 14, 24, 16, 26);
        return map;
    }
}

