/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

public class StringList {
    private String[] strings = new String[3];
    private int size = 3;
    private int count = 0;
    private static final int delta = 3;

    public void ensureSize(int n) {
        if (n > this.size) {
            String[] stringArray = new String[n += 3];
            for (int i = 0; i < this.count; ++i) {
                stringArray[i] = this.strings[i];
            }
            this.size = n;
            this.strings = stringArray;
        }
    }

    public int getCount() {
        return this.count;
    }

    public void add(String string) {
        this.ensureSize(this.count + 1);
        this.strings[this.count] = string;
        ++this.count;
    }

    public void setString(int n, String string) {
        if (n < 0 || n >= this.count) {
            return;
        }
        if (string == null) {
            throw new NullPointerException();
        }
        this.strings[n] = string;
    }

    public String getString(int n) {
        if (n < 0 || n >= this.count) {
            return null;
        }
        return this.strings[n];
    }

    public String getText(String string) {
        if (this.count <= 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(this.strings[0]);
        for (int i = 1; i < this.count; ++i) {
            stringBuffer.append(string);
            stringBuffer.append(this.strings[i]);
        }
        return stringBuffer.toString();
    }

    public void insert(String string, int n) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.ensureSize(this.count + 1);
        if (n < 0) {
            n = 0;
        }
        if (n > this.count) {
            n = this.count;
        }
        if (this.count > n) {
            System.arraycopy(this.strings, n, this.strings, n + 1, this.count - n);
        }
        this.strings[n] = string;
        ++this.count;
    }

    public void swap(int n, int n2) {
        if (n >= 0 && n2 >= 0 && n < this.count && n2 < this.count) {
            String string = this.strings[n];
            this.strings[n] = this.strings[n2];
            this.strings[n2] = string;
        }
    }

    public void sort() {
        boolean bl = false;
        while (!bl) {
            bl = true;
            for (int i = 0; i < this.count - 1; ++i) {
                if (this.strings[i].compareTo(this.strings[i + 1]) <= 0) continue;
                this.swap(i, i + 1);
                bl = false;
            }
        }
    }

    public StringList compress() {
        this.sort();
        StringList stringList = new StringList();
        if (this.count <= 0) {
            return stringList;
        }
        int n = 1;
        String string = this.strings[0];
        for (int i = 1; i < this.count; ++i) {
            if (this.strings[i].compareTo(string) != 0) {
                stringList.add(n == 1 ? string : string + " (x" + Integer.toString(n) + ")");
                string = this.strings[i];
                n = 0;
            }
            ++n;
        }
        stringList.add(n == 1 ? string : string + " (x" + Integer.toString(n) + ")");
        return stringList;
    }

    public StringList compact(int n, String string) {
        StringList stringList = new StringList();
        if (this.count <= 0) {
            return stringList;
        }
        String string2 = this.strings[0];
        for (int i = 1; i < this.count; ++i) {
            int n2 = string.length() + this.strings[i].length();
            if (string2.length() + n2 > n) {
                stringList.add(string2 + string);
                string2 = this.strings[i];
                continue;
            }
            string2 = string2 + string + this.strings[i];
        }
        stringList.add(string2);
        return stringList;
    }
}

