/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import mikera.tyrant.AI;
import mikera.tyrant.Event;
import mikera.tyrant.Game;
import mikera.tyrant.Lib;
import mikera.tyrant.Map;
import mikera.tyrant.RPG;
import mikera.tyrant.Script;
import mikera.tyrant.Scripts;
import mikera.tyrant.Thing;

public class Special {
    public static void init() {
        Thing thing = Lib.extend("base special", "base thing");
        thing.set("IsInvisible", 1);
        thing.set("IsDestructible", 0);
        thing.set("IsPhysical", 0);
        thing.set("ImageSource", "Effects");
        thing.set("LevelMin", 1);
        thing.set("Image", 25);
        Lib.add(thing);
        thing = Lib.extend("message point", "base special");
        thing.set("IsInvisible", 0);
        thing.set("IsDestructible", 0);
        thing.set("IsMessagePoint", true);
        thing.set("LevelMin", 1);
        thing.set("ImageSource", "Effects");
        thing.set("Image", 40);
        thing.set("Message", "No message here!");
        thing.set("OnEnterTrigger", new MessagePointAction());
        thing.set("ASCII", "m");
        Lib.add(thing);
        Special.initStockingPoints();
        Special.initPortalPoints();
        Special.initBuilderPoints();
        Special.initAIMarkers();
    }

    public static Thing messagePoint(String string) {
        Thing thing = Lib.create("message point");
        thing.set("Message", string);
        return thing;
    }

    private static void initStockingPoints() {
        Thing thing = Lib.extend("base stocking point", "base special");
        thing.set("IsStockingPoint", 1);
        thing.set("IsActive", 1);
        thing.set("Image", 20);
        thing.set("OnAction", new StockingAction());
        thing.set("StockingType", "IsFood");
        thing.set("StockingFlag", "IsShopOwned,IsOwned");
        thing.set("StockingRate", 10);
        thing.set("StockingStock", 2);
        thing.set("MapColour", 0x704040);
        thing.set("Shopkeeper", null);
        Lib.add(thing);
        thing = Lib.extend("artifact point", "base stocking point");
        thing.set("StockingType", "IsRandomArtifact");
        thing.set("StockingFlag", null);
        thing.set("StockingStock", 1);
        thing.set("StockingRate", 0);
        thing.set("Shopkeeper", 0);
        Lib.add(thing);
    }

    private static void initPortalPoints() {
        Thing thing = Lib.extend("base portal point", "base special");
        thing.set("IsPortalPoint", 1);
        thing.set("Image", 145);
        Lib.add(thing);
        thing = Lib.extend("entrance point", "base portal point");
        thing.set("IsEntrancePoint", 1);
        thing.set("PortalName", "stairs up");
        Lib.add(thing);
    }

    private static void initAIMarkers() {
        Thing thing = Lib.extend("base marker", "base special");
        thing.set("IsMarker", 1);
        Lib.add(thing);
        thing = Lib.extend("warning point", "base marker");
        thing.set("IsWarning", 1);
        thing.set("Image", 141);
        Lib.add(thing);
        thing = Lib.extend("guard point", "base marker");
        thing.set("ASCII", "_");
        thing.set("LevelMin", 1);
        thing.set("OnAction", new Script(){

            public boolean handle(Thing thing, Event event) {
                Map map = thing.getMap();
                Thing[] thingArray = map.getThings(thing.x, thing.y);
                for (int i = 0; i < thingArray.length; ++i) {
                    Thing thing2 = thingArray[i];
                    if (!thing2.getFlag("IsBeing")) continue;
                    AI.setGuard(thing2, thing);
                }
                thing.set("OnAction", null);
                return false;
            }
        });
        Lib.add(thing);
    }

    private static void initBuilderPoints() {
        Thing thing = Lib.extend("redistribution point", "base special");
        thing.set("OnAction", new Script(){

            public boolean handle(Thing thing, Event event) {
                Map map = thing.getMap();
                Thing[] thingArray = map.getThings(thing.x, thing.y);
                for (int i = 0; i < thingArray.length; ++i) {
                    map.addThing(thingArray[i]);
                }
                thing.remove();
                return false;
            }
        });
        thing.set("Image", 145);
        Lib.add(thing);
    }

    public static void initClouds() {
        Thing thing = Lib.extend("base cloud", "base thing");
        thing.set("IsBlocking", 0);
        thing.set("IsInvisible", 0);
        thing.set("IsPhysical", 0);
        thing.set("DecayRate", 1000);
        thing.set("ImageSource", "Effects");
        thing.set("Image", 42);
        thing.set("RES:normal", 1000);
        thing.set("RES:impact", 1000);
        thing.set("RES:piercing", 1000);
        thing.set("RES:shock", 1000);
        thing.set("IsActive", 1);
        thing.set("MoveSpeed", 30);
        thing.set("OnAction", new CloudAction());
        thing.set("OnEnterTrigger", new CloudTouch());
        thing.set("OnTouch", new CloudTouch());
        thing.addHandler("OnAction", Scripts.decay());
        thing.set("Z", 60);
        Lib.add(thing);
        thing = Lib.extend("poison cloud", "base cloud");
        thing.set("Image", 47);
        thing.set("AffectType", "IsLiving");
        thing.set("OnEffect", Scripts.addEffect("Target", "poison"));
        thing.set("LevelMin", 1);
        thing.set("RES:poison", 1000);
        thing.set("IsWarning", 1);
        thing.set("SingleEffect", 1);
        Lib.add(thing);
        thing = Lib.extend("acid cloud", "base cloud");
        thing.set("Image", 27);
        thing.set("AffectType", "IsPhysical");
        thing.set("LevelMin", 1);
        thing.set("IsWarning", 1);
        thing.set("SingleEffect", 0);
        thing.set("AreaDamage", 3);
        thing.set("RES:acid", 1000);
        thing.set("AreaDamageType", "acid");
        thing.set("AreaDamageMessage", "The acid cloud burns your flesh!");
        Lib.add(thing);
        thing = Lib.extend("flame cloud", "base cloud");
        thing.set("Image", 7);
        thing.set("AffectType", "IsPhysical");
        thing.set("LevelMin", 1);
        thing.set("IsWarning", 1);
        thing.set("SingleEffect", 0);
        thing.set("RES:fire", 1000);
        thing.set("AreaDamage", 4);
        thing.set("AreaDamageType", "fire");
        thing.set("AreaDamageMessage", "The flame cloud burns you!");
        Lib.add(thing);
        thing = Lib.extend("steam cloud", "base cloud");
        thing.set("Image", 87);
        thing.set("LevelMin", 1);
        thing.set("SingleEffect", 0);
        thing.set("RES:fire", 1000);
        thing.set("AreaDamage", 1);
        thing.set("AreaDamageType", "water");
        thing.set("AreaDamageMessage", "The steam cloud burns you!");
        Lib.add(thing);
        thing = Lib.extend("cloud of misfortune", "base cloud");
        thing.set("Image", 27);
        thing.set("AffectType", "IsBeing");
        thing.set("OnEffect", Scripts.addEffect("Target", "curse"));
        thing.set("LevelMin", 1);
        thing.set("IsWarning", 1);
        thing.set("SingleEffect", 1);
        Lib.add(thing);
        thing = Lib.extend("cloud of pestilence", "base cloud");
        thing.set("Image", 27);
        thing.set("AffectType", "IsLiving");
        thing.set("OnEffect", Scripts.addEffect("Target", "pestilence"));
        thing.set("LevelMin", 1);
        thing.set("IsWarning", 1);
        thing.set("SingleEffect", 1);
        thing.addHandler("OnAction", Scripts.generator("cloud of pestilence", thing.getStat("DecayRate")));
        Lib.add(thing);
        thing = Lib.extend("cloud of confusion", "base cloud");
        thing.set("Image", 27);
        thing.set("AffectType", "IsLiving");
        thing.set("OnEffect", Scripts.addEffect("Target", "confusion"));
        thing.set("LevelMin", 1);
        thing.set("IsWarning", 1);
        thing.set("SingleEffect", 1);
        Lib.add(thing);
        thing = Lib.extend("plague cloud", "base cloud");
        thing.set("Image", 27);
        thing.set("AffectType", "IsLiving");
        thing.set("OnEffect", Scripts.addEffect("Target", "plague"));
        thing.set("LevelMin", 1);
        thing.set("IsWarning", 1);
        thing.set("SingleEffect", 1);
        thing.addHandler("OnAction", Scripts.generator("plague cloud", thing.getStat("DecayRate")));
        Lib.add(thing);
    }

    private static class StockingAction
    extends Script {
        private static final long serialVersionUID = 8701791275653201559L;

        private StockingAction() {
        }

        public boolean handle(Thing thing, Event event) {
            int n = event.getStat("Time");
            if (thing.getFlag("StockingStock") || RPG.po(n * thing.getStat("StockingRate"), 1000000) > 0) {
                Map map = thing.getMap();
                if (map.getFlag("IsHostile")) {
                    return false;
                }
                if (map.isVisible(thing.x, thing.y)) {
                    return false;
                }
                String string = thing.getString("StockingType");
                String string2 = thing.getString("StockingFlag");
                int n2 = thing.getStat("StockingLevel");
                if (n2 <= 0) {
                    n2 = thing.getMap().getLevel();
                }
                if (!map.isBlocked(thing.x, thing.y) && map.getFlaggedObject(thing.x, thing.y, string) == null) {
                    int n3;
                    Thing thing2 = Lib.createType(string, n2);
                    if (string2 != null) {
                        String[] stringArray = string2.split(",");
                        for (int i = 0; i < stringArray.length; ++i) {
                            thing2.set(stringArray[i], 1);
                        }
                    }
                    map.addThing(thing2, thing.x, thing.y);
                    if (thing.getFlag("StockingStock") && (n3 = thing.incStat("StockingStock", -1)) <= 0) {
                        thing.set("OnAction", null);
                    }
                }
            }
            return false;
        }
    }

    private static class CloudTouch
    extends Script {
        private static final long serialVersionUID = 3258416110087977270L;

        private CloudTouch() {
        }

        public boolean handle(Thing thing, Event event) {
            Thing thing2 = event.getThing("Target");
            if (this.affects(thing, thing2)) {
                if (thing.getFlag("SingleEffect")) {
                    thing2.message("You are touched by " + thing.getTheName());
                }
                Event event2 = new Event("Effect");
                event2.set("Target", thing2);
                thing.handle(event2);
                if (thing.getFlag("SingleEffect")) {
                    thing.die();
                    return true;
                }
            }
            return false;
        }

        private boolean affects(Thing thing, Thing thing2) {
            String string = thing.getString("AffectType");
            return thing2.getFlag(string);
        }
    }

    private static class CloudAction
    extends Script {
        private static final long serialVersionUID = 4121129221436814640L;

        private CloudAction() {
        }

        public boolean handle(Thing thing, Event event) {
            int n = event.getStat("Time");
            for (int i = RPG.po(n * thing.getStat("MoveSpeed"), 10000); i > 0; --i) {
                this.wander(thing);
            }
            return this.doEffects(thing);
        }

        private void wander(Thing thing) {
            int n;
            Map map = thing.getMap();
            if (map == null) {
                return;
            }
            int n2 = thing.x + RPG.r(3) - 1;
            if (!map.isTileBlocked(n2, n = thing.y + RPG.r(3) - 1)) {
                thing.moveTo(map, n2, n);
            }
        }

        private boolean doEffects(Thing thing) {
            Map map = thing.getMap();
            if (map == null) {
                return true;
            }
            Thing[] thingArray = map.getThings(thing.x, thing.y);
            for (int i = 0; i < thingArray.length; ++i) {
                if (thingArray[i] == thing) continue;
                Event event = new Event("Touch");
                event.set("Target", thingArray[i]);
                if (!thing.handle(event)) continue;
                return true;
            }
            return false;
        }
    }

    private static class MessagePointAction
    extends Script {
        private static final long serialVersionUID = 3905525999230595378L;

        private MessagePointAction() {
        }

        public boolean handle(Thing thing, Event event) {
            Thing thing2 = event.getThing("Target");
            if (!thing2.isHero()) {
                return false;
            }
            thing2.isRunning(false);
            if (thing2.getMap().getFlag("IsHostile")) {
                return false;
            }
            Game.message(thing.getString("Message"));
            if (!Game.isDebug()) {
                Game.message("[Press space to continue]");
                char c = Game.getChar();
                while (c != ' ') {
                    c = Game.getChar();
                }
                Game.message("");
            }
            thing.remove();
            return true;
        }
    }
}

