/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import mikera.tyrant.Lib;
import mikera.tyrant.Modifier;
import mikera.tyrant.RPG;
import mikera.tyrant.Thing;

public class Ring {
    private static String[] types = new String[]{"gold", "silver", "ruby", "sapphire", "emerald", "skull", "moon", "diamond", "crystal", "brass", "black skull"};
    private static int[] images = new int[]{200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210};

    private static void addRing(Thing thing) {
        String string;
        int n = RPG.r(types.length);
        thing.set("ImageSource", "Items");
        thing.set("Image", images[n]);
        thing.set("UName", types[n] + " ring");
        if (types[n].equals("black skull")) {
            thing.set("IsCursed", 1);
        }
        if ((string = thing.getString("Name")).indexOf("ring") == 0) {
            String string2 = "rings" + string.substring(4);
            thing.set("NamePlural", string2);
        }
        Lib.add(thing);
    }

    public static void init() {
        Thing thing = Lib.extend("plain ring", "base item");
        thing.set("IsRing", 1);
        thing.set("WieldType", 5);
        thing.set("IsMagicItem", 1);
        thing.set("Image", 200);
        thing.set("HPS", 36);
        thing.set("ItemWeight", 100);
        thing.set("ValueBase", 500);
        thing.set("LevelMin", 1);
        thing.set("Frequency", 30);
        thing.set("ASCII", "=");
        Ring.addRing(thing);
        Ring.initBaseRings();
        Ring.initRings();
    }

    public static void initBaseRings() {
        Thing thing = Lib.extend("gold ring", "plain ring");
        thing.set("Image", 200);
        thing.set("ValueBase", 1200);
        thing.set("ItemWeight", 120);
        Lib.add(thing);
        thing = Lib.extend("silver ring", "plain ring");
        thing.set("Image", 201);
        thing.set("ValueBase", 300);
        thing.set("ItemWeight", 120);
        Lib.add(thing);
        thing = Lib.extend("ornate mithril ring", "silver ring");
        thing.set("ValueBase", 400);
        Lib.add(thing);
    }

    public static void initRings() {
        Thing thing = Lib.extend("ring of speed", "plain ring");
        thing.add("WieldedModifiers", Modifier.bonus("MoveSpeed", RPG.d(40)));
        thing.set("LevelMin", 5);
        Ring.addRing(thing);
        thing = Lib.extend("ring of strength", "plain ring");
        thing.add("WieldedModifiers", Modifier.bonus("ST", RPG.d(4)));
        thing.set("LevelMin", 1);
        Ring.addRing(thing);
        thing = Lib.extend("ring of skill", "plain ring");
        thing.add("WieldedModifiers", Modifier.bonus("SK", RPG.d(4)));
        thing.set("LevelMin", 1);
        Ring.addRing(thing);
        thing = Lib.extend("ring of agility", "plain ring");
        thing.add("WieldedModifiers", Modifier.bonus("AG", RPG.d(2, 4)));
        thing.set("LevelMin", 10);
        Ring.addRing(thing);
        thing = Lib.extend("ring of toughness", "plain ring");
        thing.add("WieldedModifiers", Modifier.bonus("TG", RPG.d(2, 4)));
        thing.set("LevelMin", 15);
        Ring.addRing(thing);
        thing = Lib.extend("ring of intelligence", "plain ring");
        thing.add("WieldedModifiers", Modifier.bonus("IN", RPG.d(4)));
        thing.set("LevelMin", 5);
        Ring.addRing(thing);
        thing = Lib.extend("ring of willpower", "plain ring");
        thing.add("WieldedModifiers", Modifier.bonus("WP", RPG.d(2, 4)));
        thing.set("LevelMin", 15);
        Ring.addRing(thing);
        thing = Lib.extend("ring of charisma", "plain ring");
        thing.add("WieldedModifiers", Modifier.bonus("CH", RPG.d(2, 4)));
        thing.set("LevelMin", 1);
        Ring.addRing(thing);
        thing = Lib.extend("ring of craft", "plain ring");
        thing.add("WieldedModifiers", Modifier.bonus("CR", RPG.d(2, 4)));
        thing.set("LevelMin", 5);
        Ring.addRing(thing);
        thing = Lib.extend("ring of protection", "plain ring");
        thing.add("WieldedModifiers", Modifier.bonus("ARM", RPG.d(3, 4)));
        thing.set("LevelMin", 3);
        Ring.addRing(thing);
        thing = Lib.extend("ring of reading", "plain ring");
        thing.add("WieldedModifiers", Modifier.bonus("Literacy", RPG.d(3)));
        thing.set("LevelMin", 8);
        Ring.addRing(thing);
        thing = Lib.extend("ring of the great trader", "plain ring");
        thing.add("WieldedModifiers", Modifier.bonus("Trading", RPG.d(2, 3)));
        thing.set("LevelMin", 10);
        Ring.addRing(thing);
        thing = Lib.extend("ring of thieves", "plain ring");
        thing.add("WieldedModifiers", Modifier.bonus("Dodge", RPG.r(2)));
        thing.add("WieldedModifiers", Modifier.bonus("Stealth", RPG.r(2)));
        thing.add("WieldedModifiers", Modifier.bonus("Lockpicking", RPG.r(2)));
        thing.add("WieldedModifiers", Modifier.bonus("Pickpocket", RPG.r(2)));
        thing.set("LevelMin", 15);
        Ring.addRing(thing);
        thing = Lib.extend("ring of the warrior", "plain ring");
        thing.add("WieldedModifiers", Modifier.bonus("Attack", RPG.r(3)));
        thing.add("WieldedModifiers", Modifier.bonus("Defence", RPG.r(3)));
        thing.add("WieldedModifiers", Modifier.bonus("Archery", RPG.r(3)));
        thing.add("WieldedModifiers", Modifier.bonus("Throwing", RPG.r(3)));
        thing.set("LevelMin", 25);
        Ring.addRing(thing);
        thing = Lib.extend("ring of armour reduction", "plain ring");
        thing.add("WieldedModifiers", Modifier.bonus("ARM", -1));
        thing.set("IsCursed", 1);
        thing.set("LevelMin", 5);
        Ring.addRing(thing);
        thing = Lib.extend("ring of short sight", "plain ring");
        thing.add("WieldedModifiers", Modifier.linear("VisionRange", 60, 0));
        thing.set("IsCursed", 1);
        thing.set("LevelMin", 1);
        Ring.addRing(thing);
        thing = Lib.extend("ring of long sight", "plain ring");
        thing.add("WieldedModifiers", Modifier.linear("VisionRange", 100, 2));
        thing.set("LevelMin", 3);
        Ring.addRing(thing);
        thing = Lib.extend("ring of far sight", "plain ring");
        thing.add("WieldedModifiers", Modifier.linear("VisionRange", 150, 2));
        thing.set("LevelMin", 23);
        Ring.addRing(thing);
        thing = Lib.extend("ring of fire resistance", "plain ring");
        thing.add("WieldedModifiers", Modifier.bonus("RES:fire", RPG.d(2, 6)));
        thing.set("LevelMin", 5);
        Ring.addRing(thing);
        thing = Lib.extend("ring of ice resistance", "plain ring");
        thing.add("WieldedModifiers", Modifier.bonus("RES:ice", RPG.d(2, 6)));
        thing.set("LevelMin", 5);
        Ring.addRing(thing);
        thing = Lib.extend("ring of poison resistance", "plain ring");
        thing.add("WieldedModifiers", Modifier.bonus("RES:poison", RPG.d(2, 6)));
        thing.set("LevelMin", 5);
        Ring.addRing(thing);
        thing = Lib.extend("ring of antivenom", "plain ring");
        thing.add("WieldedModifiers", Modifier.bonus("RES:poison", RPG.d(2, 8)));
        thing.set("LevelMin", 5);
        Ring.addRing(thing);
        thing = Lib.extend("ring of ferocity", "plain ring");
        thing.add("WieldedModifiers", Modifier.bonus("AttackSpeed", RPG.d(40)));
        thing.add("WieldedModifiers", Modifier.bonus("Attack", 1));
        thing.set("LevelMin", 13);
        Ring.addRing(thing);
        thing = Lib.extend("ring of survival", "plain ring");
        thing.add("WieldedModifiers", Modifier.bonus("Survival", RPG.d(3)));
        thing.set("LevelMin", 4);
        Ring.addRing(thing);
        thing = Lib.extend("ring of throwing", "plain ring");
        thing.add("WieldedModifiers", Modifier.bonus("Throwing", RPG.d(3)));
        thing.set("LevelMin", 7);
        Ring.addRing(thing);
        thing = Lib.extend("ring of stealth", "plain ring");
        thing.add("WieldedModifiers", Modifier.bonus("Stealth", RPG.d(2)));
        thing.set("LevelMin", 22);
        Ring.addRing(thing);
        thing = Lib.extend("wedding ring", "plain ring");
        thing.add("WieldedModifiers", Modifier.bonus("CH", RPG.r(3)));
        thing.set("LevelMin", 9);
        Ring.addRing(thing);
        thing = Lib.extend("ring of ugliness", "plain ring");
        thing.add("WieldedModifiers", Modifier.bonus("CH", -RPG.d(2, 6)));
        thing.set("IsCursed", 1);
        thing.set("LevelMin", 2);
        Ring.addRing(thing);
        thing = Lib.extend("ring of hunger", "plain ring");
        thing.add("WieldedModifiers", Modifier.linear("HungerThreshold", 50, 0));
        thing.set("IsCursed", 1);
        thing.set("LevelMin", 6);
        Ring.addRing(thing);
        thing = Lib.extend("ring of starvation", "plain ring");
        thing.add("WieldedModifiers", Modifier.linear("HungerThreshold", 25, 0));
        thing.set("IsCursed", 1);
        thing.set("LevelMin", 15);
        Ring.addRing(thing);
        thing = Lib.extend("ring of slow digestion", "plain ring");
        thing.add("WieldedModifiers", Modifier.linear("HungerThreshold", 150, 0));
        thing.set("LevelMin", 14);
        Ring.addRing(thing);
        thing = Lib.extend("ring of divine sustenance", "plain ring");
        thing.add("WieldedModifiers", Modifier.linear("HungerThreshold", 300, 0));
        thing.set("LevelMin", 22);
        Ring.addRing(thing);
        thing = Lib.extend("ring of slowness", "plain ring");
        thing.add("WieldedModifiers", Modifier.bonus("MoveSpeed", -RPG.d(2, 20)));
        thing.add("WieldedModifiers", Modifier.bonus("AG", -RPG.d(4)));
        thing.set("IsCursed", 1);
        thing.set("LevelMin", 5);
        Ring.addRing(thing);
        thing = Lib.extend("ring of weakness", "plain ring");
        thing.add("WieldedModifiers", Modifier.bonus("ST", -RPG.d(4)));
        thing.add("WieldedModifiers", Modifier.bonus("TG", -RPG.d(4)));
        thing.set("IsCursed", 1);
        thing.set("LevelMin", 9);
        Ring.addRing(thing);
        thing = Lib.extend("ring of weak will", "plain ring");
        thing.add("WieldedModifiers", Modifier.linear("WP", 50, 0));
        thing.set("IsCursed", 1);
        thing.set("LevelMin", 12);
        Ring.addRing(thing);
        thing = Lib.extend("ring of fortune", "plain ring");
        thing.add("WieldedModifiers", Modifier.bonus("Luck", 30));
        thing.set("LevelMin", 1);
        Ring.addRing(thing);
        thing = Lib.extend("ring of great fortune", "plain ring");
        thing.add("WieldedModifiers", Modifier.bonus("Luck", 50));
        thing.set("LevelMin", 26);
        Ring.addRing(thing);
        thing = Lib.extend("ring of misfortune", "plain ring");
        thing.add("WieldedModifiers", Modifier.bonus("Luck", -50));
        thing.set("IsCursed", 1);
        thing.set("LevelMin", 12);
        Ring.addRing(thing);
        thing = Lib.extend("ring of doom", "plain ring");
        thing.add("WieldedModifiers", Modifier.bonus("Luck", -100));
        thing.set("IsCursed", 1);
        thing.set("LevelMin", 27);
        Ring.addRing(thing);
        thing = Lib.extend("ring of prevent blindness", "plain ring");
        Modifier modifier = Modifier.linear("IsBlind", 0, 0);
        modifier.incStat("Priority", 10);
        thing.add("WieldedModifiers", modifier);
        thing.set("LevelMin", 6);
        Ring.addRing(thing);
        thing = Lib.extend("ring of blindness", "plain ring");
        thing.add("WieldedModifiers", Modifier.linear("IsBlind", 0, 1));
        thing.set("IsCursed", 1);
        thing.set("LevelMin", 25);
        Ring.addRing(thing);
    }
}

