/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import mikera.tyrant.Game;
import mikera.tyrant.GameScreen;
import mikera.tyrant.Lib;
import mikera.tyrant.Map;
import mikera.tyrant.Missile;
import mikera.tyrant.Point;
import mikera.tyrant.RPG;
import mikera.tyrant.Thing;

public class RangedWeapon {
    public static final int[] qualitymuls = new int[]{0, 20, 40, 60, 80, 100, 120, 140, 160, 180, 200, 220, 240, 260};
    public static final int[] qualitylevels = new int[]{0, -4, -3, -2, -1, 0, 2, 4, 6, 9, 13, 18, 25, 40};

    public static Thing createRangedWeapon(int n) {
        return Lib.createType("IsRangedWeapon", n);
    }

    public static int fireCost(Thing thing, Thing thing2) {
        int n = thing.getStat("FireCost");
        return n * 8 / (8 + thing2.getStat("Archery"));
    }

    public static void useRangedWeapon(Thing thing, Thing thing2) {
        if (thing2.isHero()) {
            Thing thing3 = thing2.getWielded(21);
            if (!RangedWeapon.isValidAmmo(thing, thing3)) {
                Thing[] thingArray;
                Object object = thing.get("RangedWeaponType");
                if (object == null) {
                    Game.warn(thing.name() + " has no RangedWeaponType!");
                }
                if ((thingArray = thing2.getContents("MissileType", object)).length > 1) {
                    thing3 = Game.selectItem("Select ammunition for your " + thing.getName(Game.hero()) + ":", thingArray);
                } else if (thingArray.length == 1) {
                    thing3 = thingArray[0];
                }
            }
            if (thing3 != null) {
                thing2.wield(thing3, 21);
                thing2.incStat("APS", -RangedWeapon.fireCost(thing, thing2));
                RangedWeapon.fire(thing, thing2, thing3);
            } else {
                Game.message("You have no ammunition for your " + thing.getName(Game.hero()));
            }
        }
    }

    public static boolean isValidAmmo(Thing thing, Thing thing2) {
        return thing2 != null && thing2.get("MissileType").equals(thing.get("RangedWeaponType"));
    }

    public static void fire(Thing thing, Thing thing2, Thing thing3) {
        Thing thing4 = Game.hero();
        Map map = thing2.getMap();
        if (map == null) {
            Game.warn("Trying to shoot " + thing.getName(Game.hero()) + " with null shooter");
            return;
        }
        if (thing2 == thing4) {
            if (RangedWeapon.isValidAmmo(thing, thing3)) {
                GameScreen gameScreen = Game.getQuestapp().getScreen();
                Point point = gameScreen.getTargetLocation(gameScreen.map.findNearestFoe(thing4));
                Game.message("");
                if (point != null) {
                    thing3 = thing3.remove(1);
                    RangedWeapon.fireAt(thing, thing2, thing3, gameScreen.map, point.x, point.y);
                }
            } else {
                Game.message("You are unable to use " + thing3.getTheName() + " as ammunition for your " + thing.getName(Game.hero()));
            }
        }
    }

    public static Thing createAmmo(Thing thing) {
        return RangedWeapon.createAmmo(thing, thing.getStat("Level"));
    }

    public static Thing createAmmo(Thing thing, int n) {
        String string = thing.getString("RangedWeaponType");
        for (int i = 0; i < 20; ++i) {
            Thing thing2 = Lib.createType("IsMissile", n);
            if (!thing2.getString("MissileType").equals(string)) continue;
            return thing2;
        }
        Game.warn("Can't create ammo for " + thing.name() + " (Level " + n + ")");
        return null;
    }

    public static void fireAt(Thing thing, Thing thing2, Thing thing3, Map map, int n, int n2) {
        if (thing3 != null) {
            thing2.incStat("APS", -(RangedWeapon.fireCost(thing, thing2) * 10) / (10 + thing2.getStat("Archery")));
            Point point = map.tracePath(thing2.x, thing2.y, n, n2);
            n = point.x;
            n2 = point.y;
            if (n == thing2.x && n2 == thing2.y) {
                thing2.dropThing(thing3);
                return;
            }
            int n3 = thing2.getStat("SK") * (3 + thing2.getStat("Archery")) / 3;
            n3 = n3 * thing.getStat("RSKMul") * thing3.getStat("RSKMul") / 10000;
            n3 = n3 + thing.getStat("RSKBonus") + thing3.getStat("RSKBonus");
            int n4 = n - thing2.x;
            int n5 = n2 - thing2.y;
            int n6 = (int)Math.sqrt(n4 * n4 + n5 * n5);
            Thing thing4 = map.getMobile(n, n2);
            Game.instance().doShot(thing2.x, thing2.y, n, n2, 100, 150.0);
            int n7 = Missile.shotDifficulty(thing4, n6);
            int n8 = RPG.hitFactor(n3, n7, thing2, thing4);
            if (thing4 == null) {
                thing2.message("You fire " + thing3.getTheName() + " at your target");
                thing3.moveTo(map, n, n2);
            } else {
                if (n8 > 0) {
                    int n9 = thing2.getStat("ST") * (4 + thing2.getStat("Archery")) / 4;
                    n9 = n9 * thing.getStat("RSTMul") * thing3.getStat("RSTMul") / 10000;
                    n9 = n9 + thing.getStat("RSTBonus") + thing3.getStat("RSTBonus");
                    if (thing4.isVisible(Game.hero())) {
                        if (thing2.isHero()) {
                            switch (n8) {
                                case 1: {
                                    Game.message("You fire and hit " + thing4.getTheName());
                                    break;
                                }
                                case 2: {
                                    Game.message("You fire and score a great hit on " + thing4.getTheName());
                                    break;
                                }
                                default: {
                                    Game.message("You fire and score a perfect hit on " + thing4.getTheName());
                                    break;
                                }
                            }
                        } else {
                            Game.message(thing2.getTheName() + " fires and hits " + thing4.getTheName());
                        }
                    }
                    Missile.hit(thing3, thing2, thing4, n9);
                    thing3.moveTo(map, point.x, point.y);
                    if (RPG.r(100) >= thing3.getStat("MissileRecovery")) {
                        thing3.die();
                    }
                    return;
                }
                Game.message(thing3.getTheName() + " misses " + thing4.getTheName());
                thing3.moveTo(map, n, n2);
            }
        } else {
            thing2.message("You have no ammunition!");
        }
    }

    public static void setStats(Thing thing, int n, int n2, int n3, int n4) {
        thing.set("RSKMul", n);
        thing.set("RSKBonus", n2);
        thing.set("RSTMul", n3);
        thing.set("RSTBonus", n4);
    }

    public static void init() {
        Thing thing = Lib.extend("base ranged weapon", "base item");
        thing.set("Image", 120);
        thing.set("IsRangedWeapon", 1);
        thing.set("LevelMin", 1);
        thing.set("RangedWeaponType", "arrow");
        thing.set("Range", 10);
        thing.set("WieldType", 20);
        thing.set("HPS", 30);
        thing.set("FireCost", 200);
        thing.set("ItemWeight", 4000);
        thing.set("ValueBase", 100);
        thing.set("Frequency", 100);
        thing.set("DamageLevels", 1);
        thing.set("ASCII", ")");
        Lib.add(thing);
        RangedWeapon.initBows();
        RangedWeapon.initSlings();
    }

    private static void initSlings() {
        Thing thing = Lib.extend("sling", "base ranged weapon");
        thing.set("Image", 120);
        thing.set("LevelMin", 3);
        thing.set("IsSling", 1);
        thing.set("RangedWeaponType", "bullet");
        thing.set("HPS", 8);
        thing.set("ItemWeight", 800);
        thing.set("ValueBase", 30);
        thing.set("Frequency", 70);
        RangedWeapon.setStats(thing, 60, -2, 60, 1);
        Lib.add(thing);
        thing = Lib.extend("makeshift sling", "sling");
        thing.set("UName", "sling");
        thing.set("LevelMin", 1);
        thing.set("HPS", 3);
        thing.set("ItemWeight", 500);
        thing.set("Frequency", 30);
        RangedWeapon.setStats(thing, 40, -3, 40, 0);
        Lib.add(thing);
    }

    private static void initBows() {
        Thing thing = Lib.extend("base bow", "base ranged weapon");
        thing.set("Image", 122);
        thing.set("RangedWeaponType", "arrow");
        thing.set("LevelMin", 6);
        thing.set("IsBow", 1);
        thing.set("HPS", 14);
        thing.set("ItemWeight", 2000);
        thing.set("Frequency", 70);
        thing.set("ValueBase", 300);
        RangedWeapon.setStats(thing, 70, 0, 12, 7);
        Lib.add(thing);
        thing = Lib.extend("short bow", "base bow");
        thing.set("ItemWeight", 1500);
        RangedWeapon.setStats(thing, 60, 0, 10, 4);
        thing.set("LevelMin", 1);
        Lib.add(thing);
        thing = Lib.extend("bow", "base bow");
        thing.set("LevelMin", 3);
        Lib.add(thing);
        thing = Lib.extend("bow of swift shooting", "base bow");
        thing.set("UName", "bow");
        thing.multiplyStat("FireCost", 0.5);
        thing.set("LevelMin", 10);
        Lib.add(thing);
        thing = Lib.extend("longbow", "base bow");
        thing.set("ItemWeight", 3000);
        RangedWeapon.setStats(thing, 80, 0, 15, 12);
        thing.set("LevelMin", 9);
        Lib.add(thing);
        thing = Lib.extend("elven longbow", "base bow");
        thing.set("UName", "longbow");
        thing.set("ItemWeight", 2500);
        RangedWeapon.setStats(thing, 100, 0, 15, 15);
        thing.multiplyStat("FireCost", 0.7);
        thing.set("LevelMin", 15);
        Lib.add(thing);
        thing = Lib.extend("black longbow", "longbow");
        thing.set("ItemWeight", 3500);
        RangedWeapon.setStats(thing, 80, 0, 16, 15);
        thing.set("LevelMin", 13);
        thing.set("IsCursed", 1);
        Lib.add(thing);
        thing = Lib.extend("longbow of power", "longbow");
        thing.set("UName", "longbow");
        thing.set("ItemWeight", 3200);
        RangedWeapon.setStats(thing, 70, 0, 15, 20);
        thing.set("LevelMin", 11);
        thing.set("Frequency", 30);
        Lib.add(thing);
        thing = Lib.extend("longbow of accuracy", "longbow");
        thing.set("UName", "longbow");
        thing.set("ItemWeight", 2800);
        RangedWeapon.setStats(thing, 160, 0, 15, 12);
        thing.set("Frequency", 30);
        thing.set("LevelMin", 13);
        Lib.add(thing);
        thing = Lib.extend("great bow", "base bow");
        thing.set("ItemWeight", 5000);
        RangedWeapon.setStats(thing, 70, 0, 20, 15);
        thing.multiplyStat("FireCost", 1.2);
        thing.set("LevelMin", 8);
        Lib.add(thing);
    }
}

