/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import java.util.HashMap;
import mikera.tyrant.AI;
import mikera.tyrant.BaseObject;
import mikera.tyrant.Caves;
import mikera.tyrant.Chest;
import mikera.tyrant.DeepForest;
import mikera.tyrant.Dungeon;
import mikera.tyrant.EndGame;
import mikera.tyrant.Event;
import mikera.tyrant.Game;
import mikera.tyrant.GoblinVillage;
import mikera.tyrant.Graveyard;
import mikera.tyrant.Lib;
import mikera.tyrant.Map;
import mikera.tyrant.Movement;
import mikera.tyrant.Pit;
import mikera.tyrant.RPG;
import mikera.tyrant.Script;
import mikera.tyrant.Text;
import mikera.tyrant.Thing;
import mikera.tyrant.Town;
import mikera.tyrant.Tutorial;
import mikera.tyrant.WorldMap;
import mikera.tyrant.author.MapMaker;

public class Portal {
    public static Thing create() {
        return Portal.create("invisible portal");
    }

    public static Thing create(String string, Map map, int n, int n2) {
        Thing thing = Portal.create(string);
        thing.set("Level", map.getLevel());
        map.addThing(thing, n, n2);
        return thing;
    }

    public static Thing create(String string) {
        return Lib.create(string);
    }

    public static Thing create(String string, String string2, int n) {
        Thing thing = Lib.create(string);
        thing.set("ComplexName", string2);
        thing.set("DestinationLevel", n);
        return thing;
    }

    public static boolean canTravel(Thing thing) {
        return thing.isHero();
    }

    public static void travel(Thing thing, Thing thing2) {
        Thing[] thingArray;
        int n;
        int n2;
        BaseObject baseObject;
        if (thing2 == Game.hero() && (baseObject = Portal.peekCritter(thing)) != null) {
            Game.message("The way is blocked by " + ((Thing)baseObject).getAName());
            return;
        }
        if (thing.handles("OnTravel")) {
            baseObject = new Event("Travel");
            baseObject.set("Target", thing2);
            if (thing.handle((Event)baseObject)) {
                return;
            }
        }
        if (thing2.isHero()) {
            baseObject = thing2.getMap();
            n2 = thing2.x;
            n = thing2.y;
            if (baseObject != null) {
                thingArray = ((Map)baseObject).getThings(n2 - 10, n - 10, n2 + 10, n + 10);
                for (int i = 0; i < thingArray.length; ++i) {
                    Thing thing3 = thingArray[i];
                    if (thing3.getFlag("IsHostile") && thing3.isVisible(Game.hero())) {
                        thing2.addThing(thing3);
                    }
                    if (!AI.isFollower(thing3, thing2)) continue;
                    thing2.addThing(thing3);
                }
            }
            thingArray = Portal.getCritter(thing);
            while (thingArray != null) {
                thing2.addThing((Thing)thingArray);
                thingArray = Portal.getCritter(thing);
            }
        }
        if ((baseObject = (Map)thing.get("PortalTargetMap")) == null) {
            Portal.ensurePortalDestination(thing);
            baseObject = (Map)thing.get("PortalTargetMap");
            if (baseObject == null) {
                throw new Error("Portal destination not created: " + thing.getName(Game.hero()));
            }
        }
        if ((thingArray = ((Map)baseObject).getFlaggedObject(n2 = thing.getStat("PortalTargetX"), n = thing.getStat("PortalTargetY"), "IsPortal")) != null && !thingArray.isInvisible()) {
            Portal.arrive((Thing)thingArray, thing2);
            return;
        }
        if (thing2.isHero() && !baseObject.getFlag("IsWorldMap")) {
            Thing[] thingArray2 = Game.hero().getFlaggedContents("IsBeing");
            for (int i = 0; i < thingArray2.length; ++i) {
                Thing thing4 = thingArray2[i];
                if (AI.isFollower(thing4, thing2)) {
                    thing4.moveTo((Map)baseObject, n2, n);
                    thing4.displace();
                    continue;
                }
                ((Map)baseObject).addThing(thing4);
            }
        }
        thing2.moveTo((Map)baseObject, n2, n);
    }

    public static void arrive(Thing thing, Thing thing2) {
        if (thing2.isHero()) {
            Map map = thing.getMap();
            int n = thing.getMapX();
            int n2 = thing.getMapY();
            Movement.moveTo(thing2, map, n, n2);
            if (!map.getFlag("IsWorldMap")) {
                Thing[] thingArray = Game.hero().getFlaggedContents("IsBeing");
                for (int i = 0; i < thingArray.length; ++i) {
                    Thing thing3 = thingArray[i];
                    thing.addThing(thing3);
                }
            }
        } else {
            thing.addThing(thing2);
        }
    }

    public static Map getTargetMap(Thing thing) {
        return Portal.ensurePortalDestination(thing);
    }

    public static Map ensurePortalDestination(Thing thing) {
        Map map = (Map)thing.get("PortalTargetMap");
        if (map != null) {
            return map;
        }
        String string = Portal.destinationComplex(thing);
        int n = Portal.destinationLevel(thing);
        int n2 = 0;
        if (thing.getFlag("NewMap")) {
            n2 = 1;
            HashMap hashMap = Game.instance().getMapStore();
            while (hashMap.containsKey(Portal.getHashName(string, n, n2))) {
                ++n2;
            }
        }
        if ((map = Portal.getMap(string, n, n2)) == null) {
            throw new Error("Can't ensure portal destination [" + string + ":" + n + "] for [" + thing.name() + "]");
        }
        Portal.makeLink(thing, map);
        return map;
    }

    public static String destinationComplex(Thing thing) {
        String string = thing.getString("ComplexName");
        if (string == null && thing.getFlag("IsRoutePortal")) {
            return thing.name();
        }
        if (string == null && thing.getFlag("IsPlacePortal")) {
            return thing.name();
        }
        if (string == null) {
            string = thing.getMap().getString("ComplexName");
        }
        return string;
    }

    private static String getHashName(String string, int n, int n2) {
        String string2 = string + ":" + Integer.toString(n);
        if (n2 > 0) {
            string2 = string2 + ":" + n2;
        }
        return string2;
    }

    public static Map getMap(String string, int n, int n2) {
        String string2 = Portal.getHashName(string, n, n2);
        HashMap hashMap = Game.instance().getMapStore();
        Map map = (Map)hashMap.get(string2);
        if (map == null) {
            map = Portal.createMap(string, n);
            hashMap.put(string2, map);
        }
        map.set("DungeonLevel", n);
        map.set("ComplexName", string);
        map.set("DungeonVersion", n2);
        map.set("HashName", string2);
        return map;
    }

    public static Map loadFromFile(String string) {
        MapMaker mapMaker = new MapMaker();
        Map map = mapMaker.create(Text.loadFromFile(string), false);
        if (map.getFlag("IsWorldMap")) {
            return map;
        }
        Thing[] thingArray = map.getObjects(0, 0, map.width - 1, map.height - 1, "IsEntrancePoint");
        if (thingArray.length > 0) {
            Thing thing = thingArray[RPG.r(thingArray.length)];
            Thing thing2 = Portal.create(thing.getString("PortalName"));
            map.addThing(thing2, thing.x, thing.y);
            map.setEntrance(thing2);
        } else {
            Game.warn("No entrance for map " + string);
        }
        return map;
    }

    private static Map createMap(String string, int n) {
        Map map;
        block18: {
            block35: {
                block34: {
                    block33: {
                        block32: {
                            block31: {
                                block30: {
                                    block29: {
                                        block28: {
                                            block27: {
                                                block26: {
                                                    block25: {
                                                        block24: {
                                                            block23: {
                                                                block22: {
                                                                    block21: {
                                                                        block20: {
                                                                            block19: {
                                                                                block17: {
                                                                                    map = null;
                                                                                    if (!string.equals("karrain")) break block17;
                                                                                    map = WorldMap.createWorld();
                                                                                    break block18;
                                                                                }
                                                                                if (!string.equals("town")) break block19;
                                                                                map = Town.createTown(80, 48);
                                                                                break block18;
                                                                            }
                                                                            if (!string.equals("caves")) break block20;
                                                                            map = Caves.createCaves(65, 65, n);
                                                                            break block18;
                                                                        }
                                                                        if (!string.equals("ruin")) break block21;
                                                                        map = DeepForest.create(71, 71);
                                                                        break block18;
                                                                    }
                                                                    if (!string.equals("pit")) break block22;
                                                                    map = Pit.create(n);
                                                                    break block18;
                                                                }
                                                                if (!string.equals("wood temple")) break block23;
                                                                map = new Map(71, 71);
                                                                DeepForest.makeWoodTemple(map);
                                                                break block18;
                                                            }
                                                            if (!string.equals("goblin village")) break block24;
                                                            map = GoblinVillage.makeGoblinVillage();
                                                            break block18;
                                                        }
                                                        if (!string.equals("graveyard")) break block25;
                                                        map = new Map(71, 71);
                                                        Graveyard.makeGraveyard(map);
                                                        break block18;
                                                    }
                                                    if (!string.equals("Old Nyck's hut")) break block26;
                                                    map = Town.buildNyckMap();
                                                    break block18;
                                                }
                                                if (!string.equals("dark forest")) break block27;
                                                map = DeepForest.makeDarkForest(n);
                                                break block18;
                                            }
                                            if (!string.equals("tutorial inn")) break block28;
                                            map = Tutorial.buildTutorialMap();
                                            break block18;
                                        }
                                        if (!string.equals("tutorial cellar")) break block29;
                                        map = Tutorial.buildCellar();
                                        break block18;
                                    }
                                    if (!string.equals("tutorial loft")) break block30;
                                    map = Tutorial.buildLoft();
                                    break block18;
                                }
                                if (!string.equals("dark tower")) break block31;
                                switch (n) {
                                    default: {
                                        map = Dungeon.createDarkTowerLevel(n);
                                        break;
                                    }
                                    case 10: {
                                        map = EndGame.getFinalMap();
                                        break;
                                    }
                                }
                                break block18;
                            }
                            if (!string.equals("old dungeon")) break block32;
                            switch (n) {
                                default: {
                                    map = Dungeon.createDungeon(60, 40, n);
                                    break;
                                }
                                case 10: {
                                    map = Caves.createBigCave(50, 50, 10);
                                    break;
                                }
                            }
                            break block18;
                        }
                        if (!string.equals("mysterious dungeon")) break block33;
                        switch (n) {
                            default: {
                                map = Dungeon.createDungeon(60, 40, n + 3);
                                break;
                            }
                            case 15: {
                                map = Dungeon.createDungeon(70, 25, n + 3);
                                map.getExit().remove();
                                map.setExit(null);
                                Thing thing = Chest.create(15);
                                thing.addThing(Lib.create("potion of literacy"));
                                map.addThing(thing);
                                break;
                            }
                        }
                        break block18;
                    }
                    if (!string.equals("deep dungeon")) break block34;
                    map = Dungeon.createDungeon(60, 40, n + 5);
                    map.set("Description", "Deep Dungeon");
                    break block18;
                }
                if (!string.equals("old catacombs")) break block35;
                switch (n) {
                    default: {
                        map = Dungeon.createDungeon(60, 40, 6 + n * 3);
                        map.set("Description", "Old Catacombs");
                        if (n == 3) {
                            Thing thing = Lib.create("skull key");
                            thing.set("IsDestructible", 0);
                            map.addThing(thing);
                            break;
                        }
                        break block18;
                    }
                    case 4: {
                        map = Pit.createArtifactVault("IsUndead", 15);
                        break;
                    }
                }
                break block18;
            }
            if (string.equals("dungeon")) {
                Thing thing = Lib.getLibraryInstance("dungeon");
                int n2 = thing.getStat("LastLevel");
                n2 = RPG.min(50, n2 + 1);
                thing.set("LastLevel", n2);
                map = Dungeon.createDungeon(60, 60, n2);
                map.getExit().remove();
                map.setExit(null);
            } else {
                Thing thing = Lib.getLibraryInstance(string);
                if (thing == null) {
                    throw new Error("Unknown portal [" + string + "]");
                }
                String string2 = thing.getString("MapFileName");
                if (string2 == null) {
                    throw new Error("No portal destination [" + string + "]");
                }
                Game.warn("Loading map [" + string2 + "]");
                map = Portal.loadFromFile(string2);
            }
        }
        map.action(Event.createActionEvent(0));
        return map;
    }

    public static int destinationLevel(Thing thing) {
        int n = thing.getStat("DestinationLevel");
        if (n > 0) {
            return n;
        }
        Map map = thing.getMap();
        if (map != null) {
            return map.getStat("DungeonLevel") + thing.getStat("DestinationLevelIncrement");
        }
        return 1;
    }

    public static void addCritter(Thing thing, Thing thing2) {
        if (thing.place != null) {
            thing.addThing(thing2);
        } else {
            Thing thing3 = (Thing)thing2.get("Leader");
            if (thing3 != null) {
                thing3.addThing(thing2);
            }
        }
    }

    public static Thing peekCritter(Thing thing) {
        return thing.getThing(0);
    }

    public static Thing getCritter(Thing thing) {
        Thing thing2 = thing.getThing(0);
        if (thing2 == null) {
            return null;
        }
        thing2.remove();
        return thing2;
    }

    private static void makeLink(Thing thing, Map map) {
        if (thing.getMap() == null) {
            throw new Error("Bad portal link attempted");
        }
        Thing thing2 = map.getEntrance();
        if (thing2 == null) {
            String string = thing.getMap().getString("ComplexName");
            if (string != null) {
                thing2 = map.find(string);
            }
            if (thing2 == null) {
                throw new Error("Target map [" + map.getString("Description") + "] of portal [" + thing.name() + "] has no entrance caled [" + string + "] in makeLink");
            }
        }
        Portal.setDestination(thing, map, thing2.getMapX(), thing2.getMapY());
        Portal.setDestination(thing2, thing.getMap(), thing.x, thing.y);
    }

    public static void setDestination(Thing thing, Map map, int n, int n2) {
        thing.set("PortalTargetMap", map);
        thing.set("PortalTargetX", n);
        thing.set("PortalTargetY", n2);
    }

    public static void init() {
        Thing thing = Lib.extend("base portal", "base scenery");
        thing.set("IsPortal", 1);
        thing.set("IsBlocking", 0);
        thing.set("IsDestructible", 0);
        thing.set("ImageSource", "Scenery");
        thing.set("ASCII", "*");
        thing.set("MapColour", 20640);
        thing.set("LevelMin", 1);
        thing.addHandler("OnAction", new PortalAction());
        Lib.add(thing);
        thing = Lib.extend("invisible portal", "base portal");
        thing.set("IsInvisible", 1);
        thing.set("ImageSource", "Effects");
        thing.set("Image", 145);
        thing.set("IsPortal", 0);
        thing.set("IsMarkerPortal", 1);
        thing.set("IsScenery", 0);
        Lib.add(thing);
        Portal.initPortals();
        Portal.initRoutePortals();
        Portal.initPlaces();
    }

    public static void initPortals() {
        Thing thing = Lib.extend("base stairs", "base portal");
        thing.set("IsStairs", 1);
        thing.set("IsBlocking", 0);
        thing.set("IsInvisible", 0);
        Lib.add(thing);
        thing = Lib.extend("stairs up", "base stairs");
        thing.set("Image", 0);
        thing.set("DestinationLevelIncrement", -1);
        Lib.add(thing);
        thing = Lib.extend("pit", "base portal");
        thing.set("ComplexName", "pit");
        thing.set("NewMap", 1);
        thing.set("Image", 41);
        Lib.add(thing);
        thing = Lib.extend("stairs down", "base stairs");
        thing.set("Image", 1);
        thing.set("DestinationLevelIncrement", 1);
        Lib.add(thing);
        thing = Lib.extend("ladder up", "base stairs");
        thing.set("DestinationLevelIncrement", -1);
        thing.set("Image", 2);
        Lib.add(thing);
        thing = Lib.extend("ladder down", "base stairs");
        thing.set("DestinationLevelIncrement", 1);
        thing.set("Image", 3);
        Lib.add(thing);
        thing = Lib.extend("infinite portal", "base stairs");
        thing.set("Image", 1);
        thing.set("DestinationLevelIncrement", 1);
        Lib.add(thing);
    }

    public static void initRoutePortals() {
        Thing thing = Lib.extend("route portal", "base portal");
        thing.set("IsInvisible", 1);
        thing.set("IsRoutePortal", 1);
        thing.set("ImageSource", "Effects");
        thing.set("Image", 145);
        thing.set("IsScenery", 0);
        Lib.add(thing);
        thing = Lib.extend("annenvale", "route portal");
        thing.set("MapFileName", "/maps/world/annenvale.txt");
        thing.set("DestinationLevel", 1);
        Lib.add(thing);
        thing = Lib.extend("karrain", "route portal");
        thing.set("MapFileName", "/maps/world/karrain.txt");
        thing.set("DestinationLevel", 1);
        Lib.add(thing);
        thing = Lib.extend("wilds", "route portal");
        thing.set("MapFileName", "/maps/world/wilds.txt");
        thing.set("DestinationLevel", 1);
        Lib.add(thing);
        thing = Lib.extend("doom", "route portal");
        thing.set("MapFileName", "/maps/world/doom.txt");
        thing.set("DestinationLevel", 1);
        Lib.add(thing);
    }

    public static void initPlaces() {
        Thing thing = Lib.extend("place portal", "base portal");
        thing.set("IsPlacePortal", 1);
        Lib.add(thing);
        thing = Lib.extend("tutorial inn", "place portal");
        thing.set("ComplexName", "tutorial inn");
        thing.set("Image", 310);
        Lib.add(thing);
        thing = Lib.extend("tutorial cellar", "place portal");
        thing.set("ComplexName", "tutorial cellar");
        thing.set("Image", 4);
        Lib.add(thing);
        thing = Lib.extend("tutorial loft", "place portal");
        thing.set("ComplexName", "tutorial loft");
        thing.set("Image", 2);
        Lib.add(thing);
        thing = Lib.extend("Old Nyck's hut", "place portal");
        thing.set("Image", 309);
        thing.set("ComplexName", "icy hut");
        Lib.add(thing);
        thing = Lib.extend("town", "place portal");
        thing.set("Image", 305);
        thing.set("NewMap", 1);
        thing.set("ComplexName", "town");
        Lib.add(thing);
        thing = Lib.extend("graveyard", "place portal");
        thing.set("Image", 220);
        thing.set("ComplexName", "graveyard");
        Lib.add(thing);
        thing = Lib.extend("ruin", "place portal");
        thing.set("DestinationLevel", 1);
        thing.set("ComplexName", "ruin");
        thing.set("Image", 302);
        Lib.add(thing);
        thing = Lib.extend("caves", "place portal");
        thing.set("ComplexName", "caves");
        thing.set("Image", 303);
        thing.set("DestinationLevel", 1);
        Lib.add(thing);
        thing = Lib.extend("grotto", "place portal");
        thing.set("MapFileName", "/maps/special/grotto.txt");
        thing.set("Image", 303);
        thing.set("DestinationLevel", 1);
        Lib.add(thing);
        thing = Lib.extend("dwarftown", "place portal");
        thing.set("MapFileName", "/maps/special/dwarftown.txt");
        thing.set("Image", 303);
        thing.set("DestinationLevel", 1);
        Lib.add(thing);
        thing = Lib.extend("firetop", "place portal");
        thing.set("MapFileName", "/maps/special/firetop.txt");
        thing.set("Image", 303);
        thing.set("DestinationLevel", 1);
        Lib.add(thing);
        thing = Lib.extend("yanthrall temple", "place portal");
        thing.set("MapFileName", "/maps/temples/yanthrall.txt");
        thing.set("Image", 300);
        thing.set("DestinationLevel", 1);
        Lib.add(thing);
        thing = Lib.extend("mysterious dungeon", "place portal");
        thing.set("ComplexName", "mysterious dungeon");
        thing.set("Image", 303);
        thing.set("DestinationLevel", 1);
        Lib.add(thing);
        thing = Lib.extend("deep dungeon", "place portal");
        thing.set("ComplexName", "deep dungeon");
        thing.set("Image", 303);
        thing.set("DestinationLevel", 1);
        Lib.add(thing);
        thing = Lib.extend("dungeon", "place portal");
        thing.set("ComplexName", "dungeon");
        thing.set("NewMap", 1);
        thing.set("Image", 303);
        thing.set("DestinationLevel", 1);
        Lib.add(thing);
        thing = Lib.extend("bandit caves", "place portal");
        thing.set("ComplexName", "bandit caves");
        thing.set("Image", 303);
        thing.set("DestinationLevel", 7);
        Lib.add(thing);
        thing = Lib.extend("goblin village", "place portal");
        thing.set("ComplexName", "goblin village");
        thing.set("DestinationLevel", 1);
        thing.set("Image", 304);
        Lib.add(thing);
        thing = Lib.extend("old dungeon", "stairs down");
        thing.set("ComplexName", "old dungeon");
        thing.set("DestinationLevel", 1);
        Lib.add(thing);
        thing = Lib.extend("dark forest", "place portal");
        thing.set("ComplexName", "dark forest");
        thing.set("DestinationLevel", 10);
        thing.set("Image", 307);
        Lib.add(thing);
        thing = Lib.extend("wood temple", "place portal");
        thing.set("ComplexName", "wood temple");
        thing.set("DestinationLevel", 10);
        thing.set("Image", 303);
        Lib.add(thing);
        thing = Lib.extend("dark tower", "place portal");
        thing.set("ComplexName", "dark tower");
        thing.set("DestinationLevel", 1);
        thing.set("Image", 308);
        Lib.add(thing);
    }

    private static class PortalAction
    extends Script {
        private PortalAction() {
        }

        public boolean handle(Thing thing, Event event) {
            Thing thing2;
            Map map = thing.getMap();
            if (!map.isBlocked(thing.x, thing.y) && (thing2 = Portal.getCritter(thing)) != null) {
                map.addThing(thing2, thing.x, thing.y);
            }
            return false;
        }
    }
}

