/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import java.util.Iterator;
import java.util.List;
import mikera.tyrant.Combat;
import mikera.tyrant.Describer;
import mikera.tyrant.Event;
import mikera.tyrant.Game;
import mikera.tyrant.Item;
import mikera.tyrant.Map;
import mikera.tyrant.Point;
import mikera.tyrant.RPG;
import mikera.tyrant.Thing;
import mikera.tyrant.Tile;

public class Movement {
    private static final double rt2 = Math.sqrt(2.0);

    public static boolean tryMove(Thing thing, Map map, int n, int n2) {
        if (thing.getFlag("IsConfused") && RPG.d(3) > 1) {
            n = thing.x + RPG.r(3) - 1;
            n2 = thing.y + RPG.r(3) - 1;
        }
        map.visitPath(thing.x, thing.y);
        boolean bl = false;
        if (map == null) {
            System.out.println("no map in Movement.tryMove [" + thing.getName(Game.hero()) + "]");
            return false;
        }
        int n3 = thing.getStatIfAbsent("RunDirectionX", Integer.MIN_VALUE);
        int n4 = thing.getStatIfAbsent("RunDirectionY", Integer.MIN_VALUE);
        if (n3 == Integer.MIN_VALUE) {
            n3 = RPG.sign(n - thing.x);
            n4 = RPG.sign(n2 - thing.y);
        } else {
            n = thing.x + n3;
            n2 = thing.y + n4;
        }
        if (thing.getFlag("IsMobile")) {
            thing.set("DirectionX", n3);
            thing.set("DirectionY", n4);
        }
        if (thing.isRunning()) {
            bl = Movement.tryRunningMove(thing, map, n, n2, n3, n4);
            return bl;
        }
        bl = Movement.canMove(thing, map, n, n2);
        if (n3 == 0 && n4 == 0) {
            Movement.doMove(thing, map, n, n2);
            return true;
        }
        Thing thing2 = map.getMobile(n, n2);
        if (thing2 != null) {
            if (thing.isHostile(thing2) || thing.getFlag("IsConfused")) {
                Combat.attack(thing, thing2);
                return true;
            }
            if (!bl && Movement.tryDisplace(thing, thing2)) {
                return true;
            }
        } else if (thing.getFlag("IsIntelligent") && Movement.tryBump(thing, map, n, n2)) {
            return true;
        }
        if (thing != Game.hero() && map.getFlaggedObject(n, n2, "IsWarning") != null) {
            bl = false;
        }
        if (bl) {
            return Movement.doMove(thing, map, n, n2);
        }
        return Movement.tryDig(thing, map, n, n2);
    }

    public static boolean tryDig(Thing thing, Map map, int n, int n2) {
        return Tile.isDiggable(map, n, n2) && Tile.dig(thing, map, n, n2);
    }

    public static int calcMoveSpeed(Thing thing) {
        int n = thing.getStat("MoveSpeed");
        int n2 = thing.getStat("Athletics");
        if (n2 > 0) {
            n += RPG.min(100, thing.getStat("AG")) * n2 / 4;
        }
        return n;
    }

    public static int moveCost(Map map, Thing thing, int n, int n2) {
        int n3;
        double d = map.getMoveCost(n, n2);
        if (thing.getFlag("IsFlying")) {
            d = 100.0;
        }
        if (map.getFlag("IsWorldMap")) {
            d *= 20.0;
        }
        if ((n3 = (n - thing.x) * (n - thing.x) + (n2 - thing.y) * (n2 - thing.y)) == 2) {
            d *= rt2;
        }
        int n4 = thing.getStat("MoveCost");
        if ((d = d * (double)(n4 += thing.getStat("Encumberance")) / (double)Movement.calcMoveSpeed(thing)) == 0.0) {
            Game.warn(thing.getName(Game.hero()) + " has zero move cost!");
        }
        return (int)d;
    }

    public static boolean push(Thing thing, int n, int n2) {
        Map map = thing.getMap();
        if (map == null || thing.place != map) {
            return false;
        }
        int n3 = thing.x + n;
        int n4 = thing.y + n2;
        if (!map.isBlocked(n3, n4)) {
            thing.moveTo(map, n3, n4);
            return true;
        }
        return false;
    }

    public static void jump(Thing thing, int n, int n2) {
        Map map = thing.getMap();
        double d = thing.x;
        double d2 = thing.y;
        double d3 = (double)n - d;
        double d4 = (double)n2 - d2;
        if (d3 == 0.0 && d4 == 0.0) {
            return;
        }
        int n3 = 0;
        if (Math.abs(d3) < Math.abs(d4)) {
            n3 = (int)Math.abs((double)n2 - d2);
            d3 /= Math.abs(d4);
            d4 = d4 > 0.0 ? 1.0 : -1.0;
        } else {
            n3 = (int)Math.abs((double)n - d);
            d4 /= Math.abs(d3);
            d3 = d3 > 0.0 ? 1.0 : -1.0;
        }
        int n4 = (int)(1.0 + Math.sqrt(thing.getStat("Athletics")));
        n3 = RPG.min(n3, n4);
        for (int i = 0; i < n3; ++i) {
            int n5;
            int n6 = (int)Math.round(d += d3);
            if (!Movement.canJump(thing, map, n6, n5 = (int)Math.round(d2 += d4))) {
                thing.displace();
                return;
            }
            thing.incStat("APS", -(Movement.moveCost(map, thing, n6, n5) * 2));
            Movement.flyTo(thing, map, n6, n5);
        }
    }

    private static boolean tryBump(Thing thing, Map map, int n, int n2) {
        Thing thing2 = map.getObjects(n, n2);
        while (thing2 != null) {
            if (thing2.isBlocking() && thing2.handles("OnBump")) {
                Event event = new Event("Bump");
                event.set("Target", thing);
                thing2.handle(event);
                return event.getFlag("ActionTaken");
            }
            thing2 = thing2.next;
        }
        return false;
    }

    private static boolean tryDisplace(Thing thing, Thing thing2) {
        if (thing == thing2) {
            Game.warn("Trying to displace self!");
        }
        if (!thing.isHero() && thing.getStat("TG") < thing2.getStat("TG")) {
            return false;
        }
        thing.incStat("APS", -100);
        boolean bl = RPG.test(thing.getStat("ST"), thing2.getStat("ST"));
        if (bl && !thing2.getFlag("IsDisplaceable")) {
            bl = false;
        }
        if (bl) {
            Map map = thing.getMap();
            int n = thing.x;
            int n2 = thing.y;
            int n3 = thing2.x;
            int n4 = thing2.y;
            if (Tile.isSensibleMove(thing, map, n3, n4) && Tile.isSensibleMove(thing2, map, n, n2)) {
                thing.moveTo(map, n3, n4);
                thing2.moveTo(map, n, n2);
                thing.message("You push " + thing2.getTheName() + " out of the way");
                return true;
            }
        }
        thing.message("You can't get past " + thing2.getTheName());
        return false;
    }

    public static boolean canMove(Thing thing, Map map, int n, int n2) {
        if (map.isObjectBlocked(n, n2)) {
            return false;
        }
        return Movement.canMoveToTile(thing, map, n, n2);
    }

    public static boolean canMoveToTile(Thing thing, Map map, int n, int n2) {
        return Tile.isPassable(thing, map, n, n2);
    }

    public static boolean canJump(Thing thing, Map map, int n, int n2) {
        if (Movement.canMove(thing, map, n, n2)) {
            return true;
        }
        if (!map.isBlocked(n, n2)) {
            return true;
        }
        int n3 = map.getTile(n, n2);
        if (Tile.isFilling(n3)) {
            return false;
        }
        Thing[] thingArray = map.getThings(n, n2);
        for (int i = 0; i < thingArray.length; ++i) {
            Thing thing2 = thingArray[i];
            if (!thing2.getFlag("IsBlocking") || thing2.getFlag("IsJumpable")) continue;
            return false;
        }
        return true;
    }

    public static void teleport(Thing thing, Map map, int n, int n2) {
        Movement.moveTo(thing, map, n, n2);
    }

    public static void moveTo(Thing thing, Map map, int n, int n2) {
        thing = map.addThing(thing, n, n2);
        if (thing.place != map) {
            throw new Error("Thing not added!");
        }
        Movement.enterTrigger(thing, map, n, n2, !thing.getFlag("IsFlying"));
        if (thing.isHero()) {
            Movement.locationMessage();
        }
    }

    public static void flyTo(Thing thing, Map map, int n, int n2) {
        map.addThing(thing, n, n2);
        Movement.enterTrigger(thing, map, n, n2, false);
        if (thing.isHero()) {
            Movement.locationMessage();
        }
    }

    private static void enterTrigger(Thing thing, Map map, int n, int n2, boolean bl) {
        Thing[] thingArray = map.getThings(n, n2);
        boolean bl2 = false;
        for (int i = 0; i < thingArray.length; ++i) {
            Thing thing2 = thingArray[i];
            if (thing2.place != map || !thing2.handles("OnEnterTrigger")) continue;
            Event event = new Event("EnterTrigger");
            event.set("Target", thing);
            event.set("TouchFloor", bl);
            bl2 |= thing2.handle(event);
        }
        if (!bl2) {
            Tile.enterTrigger(thing, map, n, n2, bl);
        }
    }

    private static void locationMessage() {
        Thing thing = Game.hero();
        Thing thing2 = thing.getMap().getObjects(thing.x, thing.y);
        while (thing2 != null) {
            if (thing2.getFlag("IsItem")) {
                Item.tryIdentify(thing, thing2);
                Game.message("There " + (Describer.isPlural(thing2) ? "are " : "is ") + thing2.getAName() + " here");
                thing.isRunning(false);
            }
            thing2 = thing2.next;
        }
    }

    private static boolean doMove(Thing thing, Map map, int n, int n2) {
        map.visitPath(n, n2);
        Movement.moveTo(thing, map, n, n2);
        thing.incStat("APS", -Movement.moveCost(map, thing, n, n2));
        return true;
    }

    private static boolean tryRunningMove(Thing thing, Map map, int n, int n2, int n3, int n4) {
        boolean bl = Movement.canMove(thing, map, n, n2);
        int n5 = -1;
        int n6 = thing.getStat("RunCount");
        if (n6 != 1) {
            boolean bl2 = bl = !Movement.interruptsRunning(thing, map, n, n2);
        }
        if (bl) {
            boolean bl3;
            n5 = thing.orthogonalExits(n3, n4).size();
            Movement.doMove(thing, map, n, n2);
            if (n6 == 1) {
                return true;
            }
            bl = bl3 = n5 == thing.orthogonalExits(n3, n4).size();
            if (bl3) {
                return bl3;
            }
        }
        if (n6 == 1) {
            return false;
        }
        if (thing.areSeveralDirectionsNotVisited()) {
            return false;
        }
        if (thing.inARoom()) {
            return false;
        }
        List list = thing.moreExits(n3, n4);
        if (list.isEmpty()) {
            return false;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Point point = (Point)iterator.next();
            if (map.getPath(point.x, point.y) == 1 || Movement.interruptsRunning(thing, map, point.x, point.y)) continue;
            int n7 = thing.x;
            int n8 = thing.y;
            Movement.doMove(thing, map, point.x, point.y);
            thing.set("RunDirectionX", RPG.sign(point.x - n7));
            thing.set("RunDirectionY", RPG.sign(point.y - n8));
            return thing.isRunning();
        }
        return false;
    }

    private static boolean interruptsRunning(Thing thing, Map map, int n, int n2) {
        if (map.isBlocked(n, n2)) {
            return true;
        }
        Thing thing2 = map.getObjects(n, n2);
        while (thing2 != null) {
            if (thing.isDoorVisible(n, n2)) {
                return true;
            }
            if (thing2.get("Message") == null && !thing2.getFlag("IsMarkerPortal") && !thing2.getFlag("IsMarker")) {
                return true;
            }
            thing2 = thing2.next;
        }
        return false;
    }
}

