/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import mikera.tyrant.Damage;
import mikera.tyrant.Event;
import mikera.tyrant.Game;
import mikera.tyrant.Item;
import mikera.tyrant.Lib;
import mikera.tyrant.Map;
import mikera.tyrant.RPG;
import mikera.tyrant.Scripts;
import mikera.tyrant.Thing;
import mikera.tyrant.Weapon;

public class Missile {
    public static Thing createThrowingWeapon(int n) {
        return Lib.createType("IsThrowingWeapon", n);
    }

    public static Thing createMissile(int n) {
        return Lib.createType("IsMissile", n);
    }

    public static int shotDifficulty(Thing thing, int n) {
        int n2 = 2 + n;
        if (thing != null) {
            n2 += thing.getStat("AG") * (n - 1) * (1 + thing.getStat("Dodge")) / 10;
        }
        return n2;
    }

    public static Thing getTarget(Map map, int n, int n2) {
        return map.getMobile(n, n2);
    }

    public static int throwRange(Thing thing) {
        int n = thing.getStat("ThrowRange");
        if (n < 6) {
            n = 6;
        }
        return n;
    }

    public static void throwAt(Thing thing, Thing thing2, Map map, int n, int n2) {
        int n3;
        Thing thing3 = Missile.getTarget(map, n, n2);
        thing2.incStat("APS", -Missile.throwCost(thing2));
        int n4 = thing2.getStat("SK");
        n4 = n4 * (3 + thing2.getStat("Throwing")) / 3;
        int n5 = Missile.throwRange(thing);
        int n6 = thing.getStat("RSKMul") * n4 / 100 + thing.getStat("RSKBonus");
        if (!thing.getFlag("IsThrowingWeapon")) {
            n6 = n4 /= 2;
            n5 /= 2;
        }
        if (thing3 != null) {
            n3 = n - thing2.x;
            int n7 = n2 - thing2.y;
            int n8 = (int)Math.sqrt(n3 * n3 + n7 * n7);
            Game.instance().doShot(thing2.x, thing2.y, n, n2, 100, 80.0);
            boolean bl = false;
            int n9 = Missile.shotDifficulty(thing3, n8);
            if (RPG.test(n6, n9, thing2, thing3)) {
                Missile.throwHit(thing, thing2, thing3);
                if (thing.getFlag("IsMissile") && RPG.r(100) >= thing.getStat("MissileRecovery")) {
                    bl = true;
                }
            } else {
                thing3.visibleMessage(thing.getTheName() + " misses " + thing3.getTheName());
            }
            if (bl) {
                thing.die();
                return;
            }
        }
        if ((n3 = thing.getStat("MissileReturns")) > 0 && RPG.test(n3 * n4, 100)) {
            if (thing2.isHero()) {
                Game.message(thing.getTheName() + " returns!");
            }
            if (thing.getFlag("IsBlessed") || RPG.test(n4 * (1 + thing2.getStat("Sleight Of Hand")), 10)) {
                thing2.message("You catch " + thing.getTheName());
                thing2.addThingWithStacking(thing);
                return;
            }
            if (thing2.isHero()) {
                Game.message(thing.getTheName() + " lands near your feet");
            }
            n = thing2.x;
            n2 = thing2.y;
            thing.moveTo(map, n, n2);
            thing.displace();
            return;
        }
        if (map.isTileBlocked(n, n2)) {
            n -= RPG.sign(n - thing2.x);
            n2 -= RPG.sign(n2 - thing2.y);
        }
        thing.moveTo(map, n, n2);
        if (thing.getWeight() > 100) {
            Damage.inflict(thing, 1, "impact");
        }
    }

    public static void throwHit(Thing thing, Thing thing2, Thing thing3) {
        int n;
        double d = thing.getStat("RSTMul") * thing2.getStat("ST") / 100 + thing.getStat("RSTBonus");
        if (!thing.getFlag("IsThrowingWeapon")) {
            if (thing.getFlag("IsWeapon")) {
                d = thing.getStat("ASTMul") * thing2.getStat("ST") / 100 + thing.getStat("ASTBonus");
            } else {
                n = thing.getWeight();
                d = (double)(thing2.getStat("ST") * n) / (3000.0 + (double)n);
            }
            if (!RPG.test(thing2.getStat("Throwing"), 2)) {
                d /= 3.0;
            }
        }
        d *= 1.0 + 0.3 * (double)thing2.getStat("Throwing");
        if (thing3.isVisible(Game.hero())) {
            Game.message(thing.getTheName() + " hits " + thing3.getTheName());
        }
        n = RPG.round(d);
        Missile.hit(thing, thing2, thing3, n);
    }

    public static int throwCost(Thing thing) {
        return 800 / (8 + thing.getStat("Throwing"));
    }

    public static int hit(Thing thing, Thing thing2, Thing thing3, int n) {
        int n2;
        n = (int)Math.round((double)n * Weapon.slayingModifier(thing, thing3) * (double)(1.0f - RPG.luckRandom(thing2, thing3)));
        String string = thing.getString("MissileDamageType");
        if (string == null) {
            if (RPG.test(thing2.getStat("Throwing"), 1)) {
                string = thing.getString("WeaponDamageType");
            }
            if (string == null) {
                string = "impact";
            }
        }
        if (thing.handles("OnWeaponHit")) {
            Event event = new Event("WeaponHit");
            event.set("Shooter", thing2);
            event.set("Target", thing3);
            event.set("AST", n);
            if (thing.handle(event)) {
                return event.getStat("Damage");
            }
            n = event.getStat("AST");
        }
        if ((n2 = thing3.damage(n, string)) > 0 && thing.handles("OnWeaponDamage")) {
            Event event = new Event("WeaponDamage");
            event.set("Shooter", thing2);
            event.set("Damage", n2);
            event.set("Target", thing3);
            thing.handle(event);
            n2 = thing.getStat("Damage");
        }
        Item.touch(thing, thing3);
        return n2;
    }

    public static void setStats(Thing thing, int n, int n2, int n3, int n4) {
        thing.set("IsMissile", 1);
        thing.set("RSKMul", n);
        thing.set("RSKBonus", n2);
        thing.set("RSTMul", n3);
        thing.set("RSTBonus", n4);
    }

    public static void init() {
        Thing thing = Lib.extend("base missile", "base item");
        thing.set("Image", 80);
        thing.set("IsMissile", 1);
        thing.set("MissileRecovery", 50);
        thing.set("IsMissile", 1);
        thing.set("WieldType", 21);
        thing.set("MissileDamageType", "normal");
        thing.set("HPS", 4);
        thing.set("ItemWeight", 500);
        thing.set("Frequency", 40);
        Lib.add(thing);
        Missile.initRocks();
        Missile.initArrows();
        Missile.initThrowingWeapons();
    }

    public static void initRocks() {
        Thing thing = Lib.extend("rock", "base missile");
        thing.set("IsRock", 1);
        thing.set("MissileType", "bullet");
        thing.set("MissileRecovery", 98);
        thing.set("MissileDamageType", "impact");
        thing.set("Image", 105);
        thing.set("HPS", 40);
        thing.set("ItemWeight", 2000);
        thing.set("RSKMul", 50);
        thing.set("RSTMul", 70);
        thing.set("LevelMin", 1);
        thing.set("Frequency", 80);
        thing.set("ASCII", "`");
        Lib.add(thing);
        thing = Lib.extend("large rock", "rock");
        thing.set("LevelMin", 5);
        thing.set("HPS", 80);
        thing.set("ItemWeight", 6000);
        Missile.setStats(thing, 40, -3, 100, -5);
        thing.multiplyStat("Frequency", 0.5);
        Lib.add(thing);
        thing = Lib.extend("strange rock", "rock");
        thing.set("Image", 104);
        thing.set("Frequency", 0);
        Lib.add(thing);
        thing = Lib.extend("stone", "rock");
        thing.set("Image", 105);
        thing.set("HPS", 20);
        thing.set("RSKMul", 60);
        thing.set("RSTMul", 60);
        thing.set("ItemWeight", 600);
        thing.set("Frequency", 60);
        Lib.add(thing);
        thing = Lib.extend("smooth stone", "rock");
        thing.set("IsThrowingWeapon", 1);
        thing.set("Image", 105);
        thing.set("HPS", 20);
        thing.set("RSKMul", 80);
        thing.set("RSTMul", 60);
        thing.set("ItemWeight", 600);
        thing.set("LevelMin", 7);
        thing.set("Frequency", 20);
        Lib.add(thing);
        thing = Lib.extend("pebble", "rock");
        thing.set("Image", 105);
        thing.set("HPS", 8);
        thing.set("RSKMul", 70);
        thing.set("RSTMul", 50);
        thing.set("ItemWeight", 200);
        thing.set("Frequency", 80);
        Lib.add(thing);
    }

    public static void initArrows() {
        Thing thing = Lib.extend("arrow", "base missile");
        thing.set("MissileType", "arrow");
        thing.set("Image", 80);
        thing.set("IsArrow", 1);
        thing.set("HPS", 5);
        thing.set("MissileRecovery", 70);
        thing.set("ItemWeight", 200);
        Missile.setStats(thing, 100, 0, 100, 0);
        thing.set("LevelMin", 1);
        thing.set("ValueBase", 50);
        thing.set("Number", 6);
        thing.set("Frequency", 100);
        thing.set("ASCII", "/");
        Lib.add(thing);
        thing = Lib.extend("unbreakable arrow", "arrow");
        thing.set("UName", "arrow");
        thing.set("IsMagicItem", 1);
        thing.set("MissileRecovery", 100);
        Missile.setStats(thing, 100, 0, 100, 0);
        thing.set("Frequency", 40);
        thing.set("LevelMin", 10);
        thing.set("HPS", 500);
        Lib.add(thing);
        thing = Lib.extend("charmed arrow", "arrow");
        thing.set("UName", "arrow");
        thing.set("IsMagicItem", 1);
        thing.set("LevelMin", 7);
        thing.set("MissileRecovery", 90);
        Missile.setStats(thing, 200, 1, 100, 1);
        thing.set("Frequency", 40);
        thing.set("HPS", 20);
        Lib.add(thing);
        thing = Lib.extend("fire arrow", "arrow");
        thing.set("Image", 81);
        thing.set("UName", "arrow");
        thing.set("IsMagicItem", 1);
        thing.set("LevelMin", 10);
        thing.set("MissileRecovery", 0);
        Missile.setStats(thing, 100, 1, 100, 1);
        thing.set("Frequency", 30);
        thing.set("HPS", 25);
        thing.addHandler("OnWeaponHit", Scripts.spellEffect("Target", "Fireball", 100));
        Lib.add(thing);
        thing = Lib.extend("armour piercing arrow", "arrow");
        thing.set("UName", "arrow");
        thing.set("LevelMin", 11);
        thing.set("WeaponDamageType", "piercing");
        thing.set("MissileRecovery", 80);
        Missile.setStats(thing, 90, 1, 110, 1);
        thing.set("Frequency", 20);
        thing.set("HPS", 8);
        thing.set("LevelMin", 11);
        Lib.add(thing);
        thing = Lib.extend("huntsman's arrow", "arrow");
        thing.set("UName", "arrow");
        thing.set("MissileRecovery", 70);
        thing.set("LevelMin", 12);
        Missile.setStats(thing, 100, 0, 70, 6);
        thing.set("Frequency", 60);
        thing.set("HPS", 10);
        Lib.add(thing);
        thing = Lib.extend("elven arrow", "arrow");
        thing.set("UName", "arrow");
        thing.set("Image", 81);
        thing.set("MissileRecovery", 80);
        thing.set("HPS", 8);
        thing.set("ItemWeight", 200);
        thing.set("LevelMin", 9);
        Missile.setStats(thing, 130, 0, 100, 2);
        thing.set("Frequency", 30);
        Lib.add(thing);
        thing = Lib.extend("lesser elven arrow", "arrow");
        thing.set("UName", "arrow");
        thing.set("MissileRecovery", 80);
        thing.set("HPS", 8);
        thing.set("ItemWeight", 100);
        thing.set("LevelMin", 1);
        Missile.setStats(thing, 100, 0, 100, 2);
        thing.set("Frequency", 30);
        Lib.add(thing);
        thing = Lib.extend("doom arrow", "arrow");
        thing.set("UName", "arrow");
        thing.set("Image", 81);
        thing.set("MissileRecovery", 50);
        thing.set("HPS", 18);
        thing.set("ItemWeight", 200);
        thing.set("LevelMin", 19);
        Missile.setStats(thing, 130, 0, 130, 2);
        thing.set("Frequency", 10);
        thing.set("OnWeaponDamage", Weapon.damageEffect("curse"));
        Lib.add(thing);
        thing = Lib.extend("slaying arrow", "arrow");
        thing.set("UName", "arrow");
        thing.multiplyStat("Frequency", 0.1);
        Missile.setStats(thing, 100, 0, 100, 1);
        thing.set("MissileRecovery", 75);
        thing.set("LevelMin", 10);
        thing.set("ValueBase", 100);
        Lib.add(thing);
        thing = Lib.extend("goblin-slaying arrow", "slaying arrow");
        thing.set("SlayingStats", "IsGoblin*3");
        thing.set("LevelMin", 11);
        Lib.add(thing);
        thing = Lib.extend("orc-slaying arrow", "slaying arrow");
        thing.set("SlayingStats", "IsOrc*3");
        thing.set("LevelMin", 13);
        Lib.add(thing);
        thing = Lib.extend("slime-slaying arrow", "slaying arrow");
        thing.set("SlayingStats", "IsSlime*3");
        thing.set("LevelMin", 8);
        Lib.add(thing);
        thing = Lib.extend("dragon-slaying arrow", "slaying arrow");
        thing.set("SlayingStats", "IsDragon*3");
        thing.set("LevelMin", 30);
        Lib.add(thing);
        thing = Lib.extend("goblin arrow", "arrow");
        thing.set("Image", 81);
        thing.set("MissileRecovery", 80);
        thing.set("HPS", 2);
        thing.set("LevelMin", 4);
        thing.set("ItemWeight", 240);
        Missile.setStats(thing, 80, 4, 90, 4);
        thing.set("Frequency", 60);
        Lib.add(thing);
        thing = Lib.extend("poisoned goblin arrow", "goblin arrow");
        thing.set("UName", "goblin arrow");
        thing.set("Image", 82);
        thing.set("MissileRecovery", 80);
        thing.set("HPS", 3);
        thing.set("LevelMin", 9);
        thing.set("ItemWeight", 240);
        Missile.setStats(thing, 80, 5, 90, 3);
        thing.set("Frequency", 30);
        thing.set("OnWeaponDamage", Weapon.damageEffect("poison"));
        Lib.add(thing);
    }

    public static void initThrowingWeapons() {
        Thing thing = Lib.extend("base throwing weapon", "base missile");
        thing.set("MissileType", "thrown");
        thing.set("IsThrowingWeapon", 1);
        thing.set("LevelMin", 4);
        thing.set("MissileRecovery", 80);
        thing.set("Image", 100);
        thing.set("HPS", 15);
        thing.set("ItemWeight", 1000);
        thing.set("ValueBase", 200);
        Missile.setStats(thing, 50, 0, 100, 0);
        thing.set("Frequency", 100);
        Lib.add(thing);
        Missile.initDarts();
        Missile.initThrowingKnives();
        Missile.initThrowingStars();
    }

    public static void initThrowingStars() {
        Thing thing = Lib.extend("base throwing star", "base throwing weapon");
        thing.set("Image", 101);
        thing.set("LevelMin", 6);
        thing.set("ItemWeight", 1000);
        thing.set("MissileRecovery", 99);
        thing.set("Frequency", 10);
        thing.set("ValueBase", 400);
        thing.set("Number", 1);
        Missile.setStats(thing, 40, 0, 80, 0);
        Lib.add(thing);
        thing = Lib.extend("throwing star", "base throwing star");
        thing.set("LevelMin", 6);
        Lib.add(thing);
        thing = Lib.extend("poison star", "base throwing star");
        thing.set("UName", "dark throwing star");
        thing.set("OnWeaponDamage", Weapon.damageEffect("poison"));
        thing.set("LevelMin", 9);
        Lib.add(thing);
        thing = Lib.extend("death star", "base throwing star");
        thing.set("UName", "dark throwing star");
        Missile.setStats(thing, 140, 0, 180, 0);
        thing.set("LevelMin", 19);
        Lib.add(thing);
    }

    public static void initThrowingKnives() {
        Thing thing = Lib.extend("base throwing knife", "base throwing weapon");
        thing.set("Image", 106);
        thing.set("LevelMin", 1);
        thing.set("ItemWeight", 1000);
        thing.set("MissileRecovery", 98);
        thing.set("Frequency", 50);
        thing.set("ValueBase", 250);
        thing.set("Number", 3);
        Missile.setStats(thing, 50, 0, 50, 0);
        Weapon.setStats(thing, 50, 0, 50, 0, 20, 0);
        Lib.add(thing);
        thing = Lib.extend("throwing knife", "base throwing knife");
        thing.set("LevelMin", 4);
        Lib.add(thing);
        thing = Lib.extend("curved stick", "base throwing weapon");
        thing.set("Image", 100);
        thing.set("LevelMin", 6);
        Missile.setStats(thing, 50, 0, 70, 0);
        thing.set("MissileRecovery", 90);
        thing.set("Number", 1);
        thing.set("MissileReturns", 20);
        Lib.add(thing);
        thing = Lib.extend("magic curved stick", "curved stick");
        thing.set("UName", "decorated curved stick");
        thing.set("LevelMin", 13);
        Missile.setStats(thing, 100, 0, 100, 0);
        thing.set("MissileRecovery", 97);
        thing.set("MissileReturns", 100);
        Lib.add(thing);
        thing = Lib.extend("golden throwing knife", "base throwing knife");
        thing.set("Number", 2);
        Missile.setStats(thing, 80, 0, 80, 0);
        thing.set("LevelMin", 10);
        Lib.add(thing);
        thing = Lib.extend("knife of returning", "base throwing knife");
        thing.set("UName", "shining throwing knife");
        Missile.setStats(thing, 80, 0, 60, 0);
        thing.set("MissileReturns", 100);
        thing.set("LevelMin", 7);
        Lib.add(thing);
    }

    public static void initDarts() {
        Thing thing = Lib.extend("base dart", "base throwing weapon");
        thing.set("Image", 88);
        thing.set("HPS", 15);
        thing.set("LevelMin", 1);
        thing.set("ItemWeight", 300);
        thing.set("MissileRecovery", 85);
        thing.set("Frequency", 50);
        thing.set("ValueBase", 150);
        thing.set("Number", 5);
        Missile.setStats(thing, 70, 3, 30, 3);
        Lib.add(thing);
        thing = Lib.extend("dart", "base dart");
        thing.set("Image", 88);
        thing.set("HPS", 15);
        thing.set("LevelMin", 4);
        Missile.setStats(thing, 70, 3, 30, 3);
        Lib.add(thing);
        thing = Lib.extend("poison dart", "base dart");
        thing.set("Image", 89);
        thing.set("HPS", 10);
        thing.set("LevelMin", 8);
        thing.set("OnWeaponDamage", Weapon.damageEffect("poison"));
        Missile.setStats(thing, 70, 3, 30, 3);
        Lib.add(thing);
        thing = Lib.extend("runic dart", "base dart");
        thing.set("Image", 91);
        thing.set("MissileRecovery", 60);
        thing.set("Frequency", 20);
        thing.set("HPS", 35);
        thing.set("LevelMin", 14);
        thing.addHandler("OnWeaponHit", Scripts.spellEffect("Target", "Fireball", 100));
        Missile.setStats(thing, 120, 0, 40, 10);
        Lib.add(thing);
    }
}

