/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.TextArea;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import mikera.tyrant.Animation;
import mikera.tyrant.BaseObject;
import mikera.tyrant.Being;
import mikera.tyrant.GameScreen;
import mikera.tyrant.IMessageHandler;
import mikera.tyrant.InfoScreen;
import mikera.tyrant.InputHandler;
import mikera.tyrant.Interface;
import mikera.tyrant.InventoryScreen;
import mikera.tyrant.Item;
import mikera.tyrant.Lib;
import mikera.tyrant.ListScreen;
import mikera.tyrant.Map;
import mikera.tyrant.MapPanel;
import mikera.tyrant.MessagePanel;
import mikera.tyrant.Point;
import mikera.tyrant.Portal;
import mikera.tyrant.QuestApp;
import mikera.tyrant.RPG;
import mikera.tyrant.Text;
import mikera.tyrant.Thing;
import mikera.tyrant.author.MapMaker;

public final class Game
extends BaseObject
implements Serializable {
    private static final long serialVersionUID = 3544670698288460592L;
    private static Game instance = new Game();
    public static transient IMessageHandler messagepanel;
    public static String VERSION;
    private Thing hero;
    private transient InputHandler inputHandler = null;
    public static Thing actor;
    public static boolean over;
    private static Interface userinterface;
    private static boolean saveHasBeenCalledAlready;
    public static Thread thread;
    private ArrayList messageList = new ArrayList();
    private boolean debug = false;
    public static boolean visuals;
    private Stack messageStack = new Stack();
    private boolean lineOfSightDisabled;
    private boolean isDesigner = false;
    static /* synthetic */ Class class$mikera$tyrant$Game;

    public static int seed() {
        return Game.hero().getStat("Seed");
    }

    public static void loadVersionNumber() {
        if (VERSION != null) {
            return;
        }
        Properties properties = null;
        try {
            InputStream inputStream = (class$mikera$tyrant$Game == null ? (class$mikera$tyrant$Game = Game.class$("mikera.tyrant.Game")) : class$mikera$tyrant$Game).getResourceAsStream("/version.txt");
            properties = new Properties();
            properties.load(inputStream);
            VERSION = properties.getProperty("version");
        }
        catch (Exception exception) {
            Game.warn("Version number problem!");
            exception.printStackTrace();
        }
    }

    public ArrayList getMessageList() {
        return this.messageList;
    }

    public String messageList() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.messageList.size(); ++i) {
            stringBuffer.append("\n" + (String)this.messageList.get(i));
        }
        return stringBuffer.toString();
    }

    public static void message(String string) {
        if (Game.instance().messageStack.isEmpty()) {
            Game.instance().displayMessage(string);
        } else {
            ArrayList arrayList = (ArrayList)Game.instance().messageStack.peek();
            arrayList.add(string);
        }
    }

    public static void quotedMessage(String string) {
        String string2 = "\"" + string + "\"";
        if (Game.instance().messageStack.isEmpty()) {
            Game.instance().displayMessage(string2);
        } else {
            ArrayList arrayList = (ArrayList)Game.instance().messageStack.peek();
            arrayList.add(string2);
        }
    }

    public static void message(ArrayList arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            Game.message((String)arrayList.get(i));
        }
    }

    public void pushMessages() {
        this.messageStack.push(new ArrayList());
    }

    public ArrayList popMessages() {
        ArrayList arrayList = (ArrayList)this.messageStack.pop();
        return arrayList;
    }

    public void clearMessageList() {
        this.messageStack = new Stack();
    }

    public static char showData(String string) {
        GameScreen gameScreen = Game.getQuestapp().getScreen();
        InfoScreen infoScreen = new InfoScreen(Game.getQuestapp(), "");
        TextArea textArea = new TextArea();
        infoScreen.setLayout(new BorderLayout());
        textArea.setText(string);
        textArea.setBackground(Color.darkGray);
        textArea.setForeground(Color.lightGray);
        textArea.addKeyListener(Game.getQuestapp().keyadapter);
        infoScreen.add(textArea);
        Game.getQuestapp().switchScreen(infoScreen);
        textArea.setCaretPosition(1000000);
        char c = Game.getChar();
        Game.getQuestapp().switchScreen(gameScreen);
        return c;
    }

    private void displayMessage(String string) {
        if (string == null) {
            Game.warn("Null message!");
            return;
        }
        if ((string = Text.capitalise(string)).equals("")) {
            messagepanel.clear();
        } else {
            if (messagepanel != null) {
                messagepanel.add(Text.capitalise(string + "\n"));
            }
            int n = 1;
            if (this.messageList.size() > 0) {
                String string2 = (String)this.messageList.get(this.messageList.size() - 1);
                if (string2.startsWith(string) && string2.endsWith(")") && string2.indexOf("(x") > 0) {
                    int n2 = string2.indexOf("(x") + 2;
                    String string3 = string2.substring(n2, string2.length() - 1);
                    try {
                        n = Integer.parseInt(string3) + 1;
                    }
                    catch (Exception exception) {
                        Game.warn("Count problem: " + string2);
                        n = 1;
                    }
                } else if (string2.equals(string)) {
                    n = 2;
                }
            }
            if (n > 1) {
                this.messageList.set(this.messageList.size() - 1, string + " (x" + n + ")");
            } else {
                this.messageList.add(string);
            }
            while (this.messageList.size() > 100) {
                this.messageList.remove(0);
            }
        }
    }

    public InputHandler createInputHandler() {
        InputHandler inputHandler = new InputHandler(){

            public char getCharacter() {
                return this.getKeyEvent().getKeyChar();
            }

            public KeyEvent getKeyEvent() {
                Game.getUserinterface().getInput();
                return Game.getUserinterface().keyevent;
            }
        };
        return inputHandler;
    }

    public static KeyEvent getInput() {
        return Game.getInput(true);
    }

    public static KeyEvent getInput(boolean bl) {
        if (bl && Game.getMappanel() != null && Game.getQuestapp().isGameScreen()) {
            Game.getMappanel().render();
            Game.getMappanel().repaint();
        }
        if (messagepanel != null && messagepanel instanceof MessagePanel) {
            ((MessagePanel)messagepanel).repaint();
        }
        Game game = Game.instance();
        if (game.inputHandler == null) {
            game.inputHandler = game.createInputHandler();
        }
        return game.inputHandler.getKeyEvent();
    }

    public static String getLine(String string) {
        return Game.getLine(string, "");
    }

    public static String getLine(String string, String string2) {
        messagepanel.add(string + string2);
        messagepanel.getPanel().invalidate();
        messagepanel.getPanel().repaint();
        while (true) {
            KeyEvent keyEvent = Game.getInput(false);
            char c = keyEvent.getKeyChar();
            if (keyEvent.getKeyCode() == 10) break;
            if (keyEvent.getKeyCode() == 27) {
                string2 = "ESC";
                break;
            }
            if (keyEvent.getKeyCode() != 8) {
                if (Character.isLetterOrDigit(c) || " -.:+'[]()=<>".indexOf(c) >= 0) {
                    string2 = string2 + c;
                }
            } else if (string2.length() > 0) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            messagepanel.clear();
            messagepanel.add(string + string2);
        }
        Game.message("");
        return string2;
    }

    public static void simulateKey(char c) {
        if (Game.getUserinterface() != null) {
            KeyEvent keyEvent = new KeyEvent(Game.getMappanel(), 0, System.currentTimeMillis(), 0, 0, 'c');
            keyEvent.setKeyChar(c);
            Game.getUserinterface().go(keyEvent);
        }
    }

    public static void infoScreen(String string) {
        GameScreen gameScreen = Game.getQuestapp().getScreen();
        InfoScreen infoScreen = new InfoScreen(Game.getQuestapp(), string);
        Game.getQuestapp().switchScreen(infoScreen);
        Game.getInput();
        Game.getQuestapp().switchScreen(gameScreen);
    }

    public static void scrollTextScreen(String string) {
        Game.scrollTextScreen(string, false);
    }

    public static void scrollTextScreen(String string, boolean bl) {
        QuestApp questApp = Game.getQuestapp();
        GameScreen gameScreen = questApp.getScreen();
        InfoScreen infoScreen = new InfoScreen(questApp, "");
        TextArea textArea = new TextArea();
        infoScreen.setLayout(new BorderLayout());
        textArea.setText(string);
        textArea.setBackground(Color.darkGray);
        textArea.setForeground(Color.lightGray);
        textArea.addKeyListener(questApp.keyadapter);
        infoScreen.add(textArea);
        questApp.switchScreen(infoScreen);
        if (bl) {
            textArea.setCaretPosition(1000000);
        }
        Game.getInput();
        questApp.switchScreen(gameScreen);
    }

    public static void viewMap(Map map) {
        if (Game.getQuestapp().getScreen() == null) {
            Game.getQuestapp().setupScreen();
        }
        GameScreen gameScreen = Game.getQuestapp().getScreen();
        gameScreen.map = map;
        gameScreen.getMappanel().map = map;
    }

    public static void enterMap(Map map, int n, int n2) {
        Game.viewMap(map);
        map.addThing(Game.hero(), n, n2);
        Game.message(map.getEnterMessage());
        if (Game.hero().getStat("BestLevel") < map.getLevel()) {
            Game.hero().set("BestLevel", map.getLevel());
        }
    }

    public HashMap getMapStore() {
        HashMap hashMap = (HashMap)Game.instance().get("MapStore");
        if (hashMap == null) {
            hashMap = new HashMap();
            Game.instance().set("MapStore", hashMap);
        }
        return hashMap;
    }

    private HashMap getMapObjectStore() {
        HashMap hashMap = (HashMap)Game.instance().get("MapObjectStore");
        if (hashMap == null) {
            hashMap = new HashMap();
            Game.instance().set("MapObjectStore", hashMap);
        }
        return hashMap;
    }

    private ArrayList getMapObjectList(String string) {
        HashMap hashMap = this.getMapObjectStore();
        ArrayList arrayList = (ArrayList)hashMap.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList();
            hashMap.put(string, arrayList);
        }
        return arrayList;
    }

    public void addMapObject(Thing thing, String string) {
        this.addMapObject(thing, string, 0, 0);
    }

    public void addMapObject(Thing thing, String string, int n, int n2) {
        thing.remove();
        thing.x = n;
        thing.y = n2;
        Map map = (Map)this.getMapStore().get(string);
        if (map == null) {
            ArrayList arrayList = this.getMapObjectList(string);
            arrayList.add(thing);
        } else {
            this.addMapObject(thing, map);
        }
    }

    private void addMapObject(Thing thing, Map map) {
        if (thing.x == 0 && thing.y == 0) {
            map.addThing(thing);
        } else {
            map.addThing(thing, thing.x, thing.y);
        }
    }

    public void addMapObjects(Map map) {
        ArrayList arrayList = this.getMapObjectList(map.getString("HashName"));
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Thing thing = (Thing)iterator.next();
            this.addMapObject(thing, map);
        }
        arrayList.clear();
    }

    public Map createWorld() {
        this.set("MapStore", null);
        return Portal.getMap("karrain", 1, 0);
    }

    public void compressAllData() {
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = this.getMapStore();
        Set set = this.getMapStore().keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map map = (Map)hashMap2.get(iterator.next());
            this.compressMapData(hashMap, map);
        }
    }

    private void compressMapData(HashMap hashMap, Map map) {
        Thing[] thingArray = map.getThings();
        for (int i = 0; i < thingArray.length; ++i) {
            thingArray[i].compressData(hashMap);
        }
    }

    public static void assertTrue(boolean bl) {
        if (!bl) {
            try {
                throw new AssertionError();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static void simulateDirection(int n, int n2) {
        switch (n2) {
            case -1: {
                switch (n) {
                    case 1: {
                        Game.simulateKey('9');
                        return;
                    }
                    case 0: {
                        Game.simulateKey('8');
                        return;
                    }
                    case -1: {
                        Game.simulateKey('7');
                        return;
                    }
                }
            }
            case 0: {
                switch (n) {
                    case 1: {
                        Game.simulateKey('6');
                        return;
                    }
                    case 0: {
                        Game.simulateKey('5');
                        return;
                    }
                    case -1: {
                        Game.simulateKey('4');
                        return;
                    }
                }
            }
            case 1: {
                switch (n) {
                    case 1: {
                        Game.simulateKey('3');
                        return;
                    }
                    case 0: {
                        Game.simulateKey('2');
                        return;
                    }
                    case -1: {
                        Game.simulateKey('1');
                        return;
                    }
                }
            }
        }
    }

    public static char getOption(String string) {
        KeyEvent keyEvent;
        do {
            char c;
            if (string.indexOf(c = GameScreen.getKey(keyEvent = Game.getInput())) >= 0) {
                return c;
            }
            if (keyEvent.getKeyCode() != 27) continue;
            return 'q';
        } while (keyEvent.getKeyCode() != 10);
        return 'e';
    }

    public static char getChar() {
        KeyEvent keyEvent = Game.getInput();
        return keyEvent.getKeyChar();
    }

    public static int getNumber(String string, int n) {
        String string2 = Game.getLine(string);
        try {
            if (string2.equals("ESC")) {
                return 0;
            }
            if (string2.equals("") || string2.equals("all")) {
                return n;
            }
            int n2 = Integer.parseInt(string2);
            n2 = RPG.middle(0, n2, n);
            return n2;
        }
        catch (Exception exception) {
            Game.warn("Invalid number in Game.getNumber(...)");
            return 0;
        }
    }

    public static void warn(String string) {
        if (Game.isDebug()) {
            System.out.println(string);
        }
    }

    public static Game instance() {
        return instance;
    }

    public static int level() {
        return Game.hero() == null ? 1 : Game.hero().getLevel();
    }

    public static Point getDirection() {
        char c;
        Point point;
        do {
            KeyEvent keyEvent = Game.getInput();
            c = Character.toLowerCase(keyEvent.getKeyChar());
            int n = keyEvent.getKeyCode();
            if (n == 38) {
                c = '8';
            }
            if (n == 40) {
                c = '2';
            }
            if (n == 37) {
                c = '4';
            }
            if (n == 39) {
                c = '6';
            }
            if (n == 36) {
                c = '7';
            }
            if (n == 35) {
                c = '1';
            }
            if (n == 33) {
                c = '9';
            }
            if (n == 34) {
                c = '3';
            }
            if (n == 27) {
                c = 'q';
            }
            if (c != 113) continue;
            return null;
        } while ((point = Game.getQuestapp().getScreen().gameHandler.convertKeyToDirection(c)) == null);
        return point;
    }

    public static String selectString(String string, String[] stringArray) {
        GameScreen gameScreen = Game.getQuestapp().getScreen();
        ListScreen listScreen = new ListScreen(string, stringArray);
        Game.getQuestapp().switchScreen(listScreen);
        String string2 = (String)listScreen.getObject();
        Game.getQuestapp().switchScreen(gameScreen);
        return string2;
    }

    public static String selectString(String string, ArrayList arrayList) {
        return Game.selectString(string, arrayList, arrayList);
    }

    public static String selectString(String string, ArrayList arrayList, ArrayList arrayList2) {
        int n;
        String[] stringArray = new String[arrayList.size()];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = (String)arrayList.get(n);
        }
        n = arrayList.indexOf(Game.selectString(string, stringArray));
        return n >= 0 ? (String)arrayList2.get(n) : null;
    }

    public static Thing selectItem(String string, Thing[] thingArray) {
        return Game.selectItem(string, thingArray, false);
    }

    public static Thing selectItem(String string, Thing[] thingArray, boolean bl) {
        Item.tryIdentify(Game.hero(), thingArray);
        GameScreen gameScreen = Game.getQuestapp().getScreen();
        InventoryScreen inventoryScreen = Game.getQuestapp().getScreen().getInventoryScreen();
        inventoryScreen.setUp(string, null, thingArray);
        if (!bl) {
            inventoryScreen.inventoryPanel.clearFilter();
        }
        Game.getQuestapp().switchScreen(inventoryScreen);
        Thing thing = inventoryScreen.getObject();
        Game.getQuestapp().switchScreen(gameScreen);
        return thing;
    }

    public static Thing selectSaleItem(String string, Thing thing, Thing thing2) {
        Thing[] thingArray = thing.getItems();
        Item.tryIdentify(thing, thingArray);
        GameScreen gameScreen = Game.getQuestapp().getScreen();
        InventoryScreen inventoryScreen = Game.getQuestapp().getScreen().getInventoryScreen();
        inventoryScreen.setUp(string, thing2, thingArray);
        Game.getQuestapp().switchScreen(inventoryScreen);
        Thing thing3 = inventoryScreen.getObject();
        Game.getQuestapp().switchScreen(gameScreen);
        return thing3;
    }

    public static int selectSaleNumber(String string, Thing thing, Thing thing2, int n) {
        Thing[] thingArray = thing.getItems();
        Item.tryIdentify(thing, thingArray);
        InventoryScreen inventoryScreen = Game.getQuestapp().getScreen().getInventoryScreen();
        inventoryScreen.setUp(string, thing2, thingArray);
        Game.getQuestapp().switchScreen(inventoryScreen);
        String string2 = inventoryScreen.getLine();
        try {
            if (string2.equals("ESC")) {
                return 0;
            }
            if (string2.equals("") || string2.equals("all")) {
                return n;
            }
            int n2 = Integer.parseInt(string2);
            n2 = RPG.middle(0, n2, n);
            return n2;
        }
        catch (Exception exception) {
            Game.warn("Invalid number in Game.getNumber(...)");
            return 0;
        }
    }

    public static Thing selectItem(String string, Thing thing) {
        return Game.selectItem(string, thing.getItems());
    }

    public void doShot(int n, int n2, int n3, int n4, int n5, double d) {
        Animation animation = Animation.shot(n, n2, n3, n4, n5, d);
        Animation animation2 = Animation.spark(n3, n4, n5);
        Game.getMappanel().addAnimation(Animation.sequence(animation, animation2));
        Game.getMappanel().repaint();
    }

    public void doBreath(int n, int n2, int n3, int n4, int n5, double d) {
        for (int i = 0; i < 20; ++i) {
            Animation animation = Animation.delay(i * 50);
            Animation animation2 = Animation.spray(n, n2, n3, n4, n5, d);
            Game.getMappanel().addAnimation(Animation.sequence(animation, animation2));
        }
        Game.getMappanel().repaint();
    }

    public void doSpellShot(int n, int n2, int n3, int n4, int n5, double d, int n6) {
        Animation animation = Animation.shot(n, n2, n3, n4, n5, d);
        Animation animation2 = n6 == 0 ? Animation.spark(n3, n4, n5) : Animation.explosion(n3, n4, n5, n6);
        Game.getMappanel().addAnimation(Animation.sequence(animation, animation2));
        Game.getMappanel().repaint();
    }

    public void doDamageMark(int n, int n2, int n3) {
        Game.getMappanel().addAnimation(Animation.hit(n, n2, n3));
    }

    public void doExplosion(int n, int n2, int n3, int n4) {
        if (n4 <= 0) {
            this.doSpark(n, n2, n3);
            return;
        }
        Game.getMappanel().addAnimation(Animation.explosion(n, n2, n3, n4));
    }

    public void doSpark(int n, int n2, int n3) {
        Game.getMappanel().addAnimation(Animation.spark(n, n2, n3));
    }

    public static boolean saveMap(Map map) {
        try {
            String string = "map.xml";
            FileDialog fileDialog = new FileDialog(new Frame(), "Save Map", 1);
            fileDialog.setFile(string);
            fileDialog.setVisible(true);
            if (fileDialog.getFile() == null) {
                return false;
            }
            string = fileDialog.getFile();
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            PrintWriter printWriter = new PrintWriter(fileOutputStream);
            String string2 = map.getLevelXML();
            printWriter.write(string2);
            Game.warn(string2);
            printWriter.flush();
            fileOutputStream.close();
            Game.message("Map saved - " + string);
            return true;
        }
        catch (Exception exception) {
            Game.message("Error encountered while saving the map");
            if (QuestApp.isapplet) {
                Game.message("This may be due to your browser security restrictions");
                Game.message("If so, run the web start or downloaded application version instead");
            }
            exception.printStackTrace();
            return false;
        }
    }

    public static int save() {
        try {
            String string = "tyrant.sav";
            FileDialog fileDialog = new FileDialog(new Frame(), "Save Game", 1);
            fileDialog.setFile(string);
            fileDialog.setVisible(true);
            if (fileDialog.getFile() == null) {
                return 0;
            }
            string = fileDialog.getDirectory() + fileDialog.getFile();
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
            zipOutputStream.putNextEntry(new ZipEntry("data.xml"));
            if (!Game.save(new ObjectOutputStream(zipOutputStream))) {
                throw new Error("Save game failed");
            }
            Game.message("Game saved - " + string);
            zipOutputStream.closeEntry();
            zipOutputStream.close();
            if (saveHasBeenCalledAlready) {
                Game.message("Please note that you can only restore the game with the same version of Tyrant (v" + VERSION + ").");
            }
            saveHasBeenCalledAlready = false;
        }
        catch (Exception exception) {
            Game.message("Error while saving: " + exception.toString());
            if (QuestApp.isapplet) {
                Game.message("This may be due to your browser security restrictions");
                Game.message("If so, run the web start or downloaded application version instead");
            }
            System.out.println(exception);
            return -1;
        }
        return 1;
    }

    public Map loadMap(String string) {
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(string);
            StringBuffer stringBuffer = new StringBuffer();
            String string2 = null;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2);
                stringBuffer.append(MapMaker.NL);
            }
            Map map = new MapMaker().create(stringBuffer.toString(), false);
            return map;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public static String tryToRestore(String string) {
        String string2 = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            ZipInputStream zipInputStream = new ZipInputStream(fileInputStream);
            zipInputStream.getNextEntry();
            if (!Game.restore(new ObjectInputStream(zipInputStream))) {
                string2 = "Cannot load " + string + " game file";
            }
            zipInputStream.closeEntry();
            zipInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception);
            string2 = exception.toString() == null ? "Unknown problem" : exception.toString();
        }
        return string2;
    }

    public static boolean restore() {
        String string;
        try {
            String string2 = "tyrant.sav";
            FileDialog fileDialog = new FileDialog(new Frame(), "Load Game", 0);
            fileDialog.setFile(string2);
            fileDialog.setVisible(true);
            if (fileDialog.getFile() == null) {
                return false;
            }
            string2 = fileDialog.getDirectory() + fileDialog.getFile();
            string = Game.tryToRestore(string2);
            if (string == null) {
                return true;
            }
        }
        catch (Exception exception) {
            string = exception.toString();
            System.out.println(exception);
        }
        Game.message("Load game failed: " + string);
        if (QuestApp.isapplet) {
            Game.message("This may be due to browser security restrictions");
            Game.message("If so, run the downloaded application version instead");
        }
        return false;
    }

    public static int hash(int n, int n2) {
        return (n ^ Game.hero().getStat("Seed")) % n2;
    }

    public void initialize(Thing thing) {
        this.hero = thing;
        if (thing == null) {
            throw new Error("Null hero in Game.initialize()");
        }
        Lib lib = (Lib)this.get("Library");
        if (lib != null) {
            Lib.setInstance(lib);
        } else {
            lib = Lib.instance();
            if (lib == null) {
                throw new Error("No library in Game.initialize()");
            }
            this.set("Library", lib);
        }
    }

    public static void create() {
        instance = new Game();
    }

    public static boolean save(ObjectOutputStream objectOutputStream) {
        try {
            Game game = Game.instance();
            game.compressAllData();
            objectOutputStream.writeObject(Game.instance());
            objectOutputStream.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean restore(ObjectInputStream objectInputStream) {
        try {
            Lib.clear();
            instance = (Game)objectInputStream.readObject();
            instance.initialize(Game.instance.hero);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public static void registerDeath(Thing thing) {
        Being.registerKill(actor, thing);
    }

    public void setHero(Thing thing) {
        Game.instance().hero = thing;
        thing.set("Game", Game.instance());
    }

    public static Thing hero() {
        return Game.instance().hero;
    }

    public char getCharacter() {
        KeyEvent keyEvent = Game.getInput();
        return GameScreen.getKey(keyEvent);
    }

    public void setInputHandler(InputHandler inputHandler) {
        this.inputHandler = inputHandler;
    }

    public boolean lineOfSightDisabled() {
        return this.lineOfSightDisabled;
    }

    public void isLineOfSightDisabled(boolean bl) {
        this.lineOfSightDisabled = bl;
    }

    public static MapPanel getMappanel() {
        QuestApp questApp = Game.getQuestapp();
        if (questApp == null) {
            return null;
        }
        GameScreen gameScreen = questApp.getScreen();
        if (gameScreen == null) {
            return null;
        }
        return gameScreen.getMappanel();
    }

    public static void setDebug(boolean bl) {
        Game.instance().debug = bl;
    }

    public static boolean isDebug() {
        return Game.instance().debug;
    }

    public static void setQuestapp(QuestApp questApp) {
        QuestApp.setInstance(questApp);
    }

    public static QuestApp getQuestapp() {
        return QuestApp.getInstance();
    }

    public static void setUserinterface(Interface interface_) {
        userinterface = interface_;
    }

    public static Interface getUserinterface() {
        return userinterface;
    }

    public void setDesignerMode(boolean bl) {
        this.isDesigner = bl;
    }

    public boolean isDesigner() {
        return this.isDesigner;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        VERSION = null;
        over = true;
        saveHasBeenCalledAlready = true;
        visuals = false;
        Game.loadVersionNumber();
    }
}

