/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import mikera.tyrant.Door;
import mikera.tyrant.Event;
import mikera.tyrant.Game;
import mikera.tyrant.Lib;
import mikera.tyrant.Map;
import mikera.tyrant.Modifier;
import mikera.tyrant.Point;
import mikera.tyrant.RPG;
import mikera.tyrant.Script;
import mikera.tyrant.Thing;
import mikera.tyrant.Weapon;

public class Equipment {
    public static void init() {
        Thing thing = Lib.extend("base equipment", "base item");
        thing.set("Frequency", 0);
        thing.set("IsEquipment", 1);
        thing.set("LevelMin", 1);
        thing.set("ASCII", "]");
        Lib.add(thing);
        Equipment.initBoats();
        Equipment.initKeys();
        Equipment.initTools();
        Equipment.initBarrels();
        Equipment.initDiggingTools();
        Equipment.initContainers();
    }

    private static void initTools() {
        Thing thing = Lib.extend("base tool", "base equipment");
        thing.set("IsTool", 1);
        thing.set("ValueBase", 5);
        thing.set("Frequency", 10);
        Lib.add(thing);
        thing = Lib.extend("fishing rod", "base tool");
        thing.set("Image", 441);
        thing.set("ItemWeight", 1600);
        thing.set("OnUse", new GoFish());
        Lib.add(thing);
        thing = Lib.extend("lock pick", "base tool");
        thing.set("HPS", 2);
        thing.set("Image", 464);
        thing.set("ItemWeight", 200);
        Lib.add(thing);
    }

    private static void initDiggingTools() {
        Thing thing = Lib.extend("base digging tool", "base tool");
        thing.set("Image", 52);
        thing.set("IsDiggingTool", 1);
        thing.set("IsWeapon", 1);
        thing.set("AttackCost", 100);
        thing.set("WeaponDamageType", "normal");
        thing.set("WieldType", 1);
        thing.set("HitVerb", "hit/hits");
        Lib.add(thing);
        thing = Lib.extend("wooden spade", "base digging tool");
        thing.set("Image", 52);
        thing.set("ItemWeight", 3000);
        thing.set("HPS", 10);
        thing.set("DigDamage", 5);
        thing.set("DigCost", 1000);
        thing.set("DamageLevels", 2);
        thing.set("LevelMin", 5);
        Weapon.setStats(thing, 60, 0, 50, 0, 30, 1);
        Lib.add(thing);
        thing = Lib.extend("sturdy spade", "wooden spade");
        thing.set("HPS", 40);
        thing.set("LevelMin", 17);
        Lib.add(thing);
        thing = Lib.extend("pickaxe", "base digging tool");
        thing.set("Image", 51);
        thing.set("ItemWeight", 2500);
        thing.set("IsWeapon", 1);
        thing.set("WieldType", 1);
        thing.set("HPS", 20);
        thing.set("DigDamage", 2);
        thing.set("IsDiggingTool", 1);
        thing.set("DigCost", 1300);
        thing.set("LevelMin", 10);
        Weapon.setStats(thing, 60, 0, 60, 0, 20, 0);
        Lib.add(thing);
        thing = Lib.extend("old pickaxe", "pickaxe");
        thing.set("HPS", 1);
        Weapon.setStats(thing, 50, 0, 50, 0, 10, 0);
        thing.set("LevelMin", 1);
        Lib.add(thing);
    }

    private static void initBoats() {
        Thing thing = Lib.extend("base boat", "base equipment");
        thing.set("IsBoat", 1);
        thing.set("Frequency", 10);
        thing.set("ValueBase", 10);
        thing.add("CarriedModifiers", Modifier.bonus("Swimming", 1));
        Lib.add(thing);
        thing = Lib.extend("canoe", "base boat");
        thing.set("LevelMin", 8);
        thing.set("Image", 440);
        thing.set("ItemWeight", 20000);
        Lib.add(thing);
        thing = Lib.extend("old canoe", "canoe");
        thing.set("LevelMin", 1);
        thing.set("Image", 440);
        Lib.add(thing);
    }

    private static void initBarrels() {
        Thing thing = Lib.extend("base barrel", "base equipment");
        thing.set("IsBarrel", 1);
        thing.set("Image", 263);
        thing.set("Frequency", 10);
        thing.set("ItemWeight", 20000);
        Lib.add(thing);
        thing = Lib.extend("water barrel", "base barrel");
        thing.set("Uname", "barrel");
        thing.set("LevelMin", 1);
        thing.set("DeathDecoration", "water pool,5% [IsRing]");
        Lib.add(thing);
        thing = Lib.extend("powder keg", "base barrel");
        thing.set("Uname", "barrel");
        thing.set("LevelMin", 10);
        thing.set("DeathDecoration", "Blaze");
        Lib.add(thing);
        thing = Lib.extend("food barrel", "base barrel");
        thing.set("Uname", "barrel");
        thing.set("LevelMin", 10);
        thing.set("DefaultThings", "50% ham,50% steak,50% juicy apple,50% mushroom");
        Lib.add(thing);
        thing = Lib.extend("mouldy keg", "base barrel");
        thing.set("Uname", "barrel");
        thing.set("LevelMin", 3);
        thing.set("DeathDecoration", "Poison Cloud");
        Lib.add(thing);
        thing = Lib.extend("barrel of woe", "base barrel");
        thing.set("Uname", "black barrel");
        thing.set("LevelMin", 7);
        thing.set("DeathDecoration", "haunted skull");
        Lib.add(thing);
        thing = Lib.extend("plague casket", "base barrel");
        thing.set("Uname", "barrel");
        thing.set("LevelMin", 14);
        thing.set("DeathDecoration", "plague cloud");
        Lib.add(thing);
    }

    private static void initKeys() {
        Thing thing = Lib.extend("base key", "base equipment");
        thing.set("IsKey", 1);
        thing.set("ItemWeight", 200);
        thing.set("LevelMin", 1);
        thing.set("ValueBase", 1000);
        thing.set("Frequency", 10);
        thing.set("OnUse", new KeyUse());
        thing.set("Image", 460);
        Lib.add(thing);
        thing = Lib.extend("copper key", "base key");
        thing.set("Image", 460);
        thing.set("LevelMin", 1);
        Lib.add(thing);
        thing = Lib.extend("brass key", "base key");
        thing.set("Image", 460);
        thing.set("LevelMin", 1);
        Lib.add(thing);
        thing = Lib.extend("bronze key", "base key");
        thing.set("Image", 460);
        thing.set("LevelMin", 1);
        Lib.add(thing);
        thing = Lib.extend("golden key", "base key");
        thing.set("Image", 461);
        thing.set("LevelMin", 10);
        Lib.add(thing);
        thing = Lib.extend("ornate key", "base key");
        thing.set("Image", 461);
        thing.set("LevelMin", 5);
        Lib.add(thing);
        thing = Lib.extend("skull key", "base key");
        thing.set("Image", 462);
        thing.set("LevelMin", 15);
        Lib.add(thing);
        thing = Lib.extend("iron key", "base key");
        thing.set("Image", 463);
        thing.set("LevelMin", 3);
        Lib.add(thing);
        thing = Lib.extend("dull key", "base key");
        thing.set("LevelMin", 8);
        thing.set("Image", 463);
        Lib.add(thing);
        thing = Lib.extend("runic key", "base key");
        thing.set("Image", 463);
        thing.set("LevelMin", 20);
        Lib.add(thing);
    }

    private static void initContainers() {
        Thing thing = Lib.extend("base container", "base equipment");
        thing.set("IsContainer", 1);
        thing.set("IsStoreItem", 0);
        thing.set("ItemWeight", 200);
        thing.set("LevelMin", 1);
        thing.set("ValueBase", 1000);
        thing.set("Frequency", 5);
        Lib.add(thing);
        thing = Lib.extend("key ring", "base container");
        thing.set("Image", 463);
        thing.set("WieldType", 75);
        thing.set("Holds", "IsKey");
        thing.set("LevelMin", 3);
        Lib.add(thing);
        thing = Lib.extend("waterproof key ring", "key ring");
        thing.set("Uname", "key ring");
        thing.set("RES:water", 1000);
        thing.set("LevelMin", 4);
        Lib.add(thing);
        thing = Lib.extend("fireproof key ring", "key ring");
        thing.set("Uname", "key ring");
        thing.set("RES:fire", 1000);
        thing.set("LevelMin", 10);
        Lib.add(thing);
        thing = Lib.extend("acidproof key ring", "key ring");
        thing.set("Uname", "key ring");
        thing.set("RES:acid", 1000);
        thing.set("LevelMin", 10);
        Lib.add(thing);
        thing = Lib.extend("frostproof key ring", "key ring");
        thing.set("Uname", "key ring");
        thing.set("RES:ice", 1000);
        thing.set("RES:chill", 1000);
        thing.set("LevelMin", 10);
        Lib.add(thing);
        thing = Lib.extend("theftproof key ring", "key ring");
        thing.set("Uname", "key ring");
        thing.set("TheftProof", 1);
        thing.set("LevelMin", 10);
        Lib.add(thing);
        thing = Lib.extend("invulnerable key ring", "key ring");
        thing.set("Uname", "key ring");
        thing.set("IsDestructible", 0);
        thing.set("LevelMin", 20);
        Lib.add(thing);
        thing = Lib.extend("scroll case", "base container");
        thing.set("Image", 142);
        thing.set("WieldType", 79);
        thing.set("Holds", "IsScroll");
        thing.set("LevelMin", 3);
        Lib.add(thing);
        thing = Lib.extend("waterproof scroll case", "scroll case");
        thing.set("Uname", "scroll case");
        thing.set("RES:water", 1000);
        thing.set("LevelMin", 4);
        Lib.add(thing);
        thing = Lib.extend("fireproof scroll case", "scroll case");
        thing.set("Uname", "scroll case");
        thing.set("RES:fire", 1000);
        thing.set("LevelMin", 10);
        Lib.add(thing);
        thing = Lib.extend("acidproof scroll case", "scroll case");
        thing.set("Uname", "scroll case");
        thing.set("RES:acid", 1000);
        thing.set("LevelMin", 10);
        Lib.add(thing);
        thing = Lib.extend("frostproof scroll case", "scroll case");
        thing.set("Uname", "scroll case");
        thing.set("RES:ice", 1000);
        thing.set("RES:chill", 1000);
        thing.set("LevelMin", 10);
        Lib.add(thing);
        thing = Lib.extend("theftproof scroll case", "scroll case");
        thing.set("Uname", "scroll case");
        thing.set("TheftProof", 1);
        thing.set("LevelMin", 10);
        Lib.add(thing);
        thing = Lib.extend("invulnerable scroll case", "scroll case");
        thing.set("Uname", "scroll case");
        thing.set("IsDestructible", 0);
        thing.set("LevelMin", 20);
        Lib.add(thing);
        thing = Lib.extend("book bag", "base container");
        thing.set("Image", 142);
        thing.set("WieldType", 70);
        thing.set("Holds", "IsBook");
        thing.set("LevelMin", 3);
        Lib.add(thing);
        thing = Lib.extend("waterproof book bag", "book bag");
        thing.set("Uname", "book bag");
        thing.set("RES:water", 1000);
        thing.set("LevelMin", 4);
        Lib.add(thing);
        thing = Lib.extend("fireproof book bag", "book bag");
        thing.set("Uname", "book bag");
        thing.set("RES:fire", 1000);
        thing.set("LevelMin", 10);
        Lib.add(thing);
        thing = Lib.extend("acidproof book bag", "book bag");
        thing.set("Uname", "book bag");
        thing.set("RES:acid", 1000);
        thing.set("LevelMin", 10);
        Lib.add(thing);
        thing = Lib.extend("frostproof book bag", "book bag");
        thing.set("Uname", "book bag");
        thing.set("RES:ice", 1000);
        thing.set("RES:chill", 1000);
        thing.set("LevelMin", 10);
        Lib.add(thing);
        thing = Lib.extend("theftproof book bag", "book bag");
        thing.set("Uname", "book bag");
        thing.set("TheftProof", 1);
        thing.set("LevelMin", 10);
        Lib.add(thing);
        thing = Lib.extend("invulnerable book bag", "book bag");
        thing.set("Uname", "book bag");
        thing.set("IsDestructible", 0);
        thing.set("LevelMin", 20);
        Lib.add(thing);
        thing = Lib.extend("potion case", "base container");
        thing.set("Image", 142);
        thing.set("WieldType", 76);
        thing.set("Holds", "IsDrinkable");
        thing.set("LevelMin", 3);
        Lib.add(thing);
        thing = Lib.extend("waterproof potion case", "potion case");
        thing.set("Uname", "potion case");
        thing.set("RES:water", 1000);
        thing.set("LevelMin", 4);
        Lib.add(thing);
        thing = Lib.extend("fireproof potion case", "potion case");
        thing.set("Uname", "potion case");
        thing.set("RES:fire", 1000);
        thing.set("LevelMin", 10);
        Lib.add(thing);
        thing = Lib.extend("acidproof potion case", "potion case");
        thing.set("Uname", "potion case");
        thing.set("RES:acid", 1000);
        thing.set("LevelMin", 10);
        Lib.add(thing);
        thing = Lib.extend("frostproof potion case", "potion case");
        thing.set("Uname", "potion case");
        thing.set("RES:ice", 1000);
        thing.set("RES:chill", 1000);
        thing.set("LevelMin", 10);
        Lib.add(thing);
        thing = Lib.extend("theftproof potion case", "potion case");
        thing.set("Uname", "potion case");
        thing.set("TheftProof", 1);
        thing.set("LevelMin", 10);
        Lib.add(thing);
        thing = Lib.extend("invulnerable potion case", "potion case");
        thing.set("Uname", "potion case");
        thing.set("IsDestructible", 0);
        thing.set("LevelMin", 20);
        Lib.add(thing);
        thing = Lib.extend("food sack", "base container");
        thing.set("Image", 142);
        thing.set("WieldType", 71);
        thing.set("Holds", "IsEdible");
        thing.set("LevelMin", 3);
        Lib.add(thing);
        thing = Lib.extend("waterproof food sack", "food sack");
        thing.set("Uname", "food sack");
        thing.set("RES:water", 1000);
        thing.set("LevelMin", 4);
        Lib.add(thing);
        thing = Lib.extend("fireproof food sack", "food sack");
        thing.set("Uname", "food sack");
        thing.set("RES:fire", 1000);
        thing.set("LevelMin", 10);
        Lib.add(thing);
        thing = Lib.extend("acidproof food sack", "food sack");
        thing.set("Uname", "food sack");
        thing.set("RES:acid", 1000);
        thing.set("LevelMin", 10);
        Lib.add(thing);
        thing = Lib.extend("frostproof food sack", "food sack");
        thing.set("Uname", "food sack");
        thing.set("RES:ice", 1000);
        thing.set("RES:chill", 1000);
        thing.set("LevelMin", 10);
        Lib.add(thing);
        thing = Lib.extend("theftproof food sack", "food sack");
        thing.set("Uname", "food sack");
        thing.set("TheftProof", 1);
        thing.set("LevelMin", 10);
        Lib.add(thing);
        thing = Lib.extend("invulnerable food sack", "food sack");
        thing.set("Uname", "food sack");
        thing.set("IsDestructible", 0);
        thing.set("LevelMin", 20);
        Lib.add(thing);
        thing = Lib.extend("ingredient pouch", "base container");
        thing.set("Image", 142);
        thing.set("WieldType", 73);
        thing.set("Holds", "IsIngredient");
        thing.set("LevelMin", 3);
        Lib.add(thing);
        thing = Lib.extend("waterproof ingredient pouch", "ingredient pouch");
        thing.set("Uname", "ingredient pouch");
        thing.set("RES:water", 1000);
        thing.set("LevelMin", 4);
        Lib.add(thing);
        thing = Lib.extend("fireproof ingredient pouch", "ingredient pouch");
        thing.set("Uname", "ingredient pouch");
        thing.set("RES:fire", 1000);
        thing.set("LevelMin", 10);
        Lib.add(thing);
        thing = Lib.extend("acidproof ingredient pouch", "ingredient pouch");
        thing.set("Uname", "ingredient pouch");
        thing.set("RES:acid", 1000);
        thing.set("LevelMin", 10);
        Lib.add(thing);
        thing = Lib.extend("frostproof ingredient pouch", "ingredient pouch");
        thing.set("Uname", "ingredient pouch");
        thing.set("RES:ice", 1000);
        thing.set("RES:chill", 1000);
        thing.set("LevelMin", 10);
        Lib.add(thing);
        thing = Lib.extend("theftproof ingredient pouch", "ingredient pouch");
        thing.set("Uname", "ingredient pouch");
        thing.set("TheftProof", 1);
        thing.set("LevelMin", 10);
        Lib.add(thing);
        thing = Lib.extend("invulnerable ingredient pouch", "ingredient pouch");
        thing.set("Uname", "ingredient pouch");
        thing.set("IsDestructible", 0);
        thing.set("LevelMin", 20);
        Lib.add(thing);
        thing = Lib.extend("quiver", "base container");
        thing.set("Image", 142);
        thing.set("WieldType", 77);
        thing.set("Holds", "IsArrow");
        thing.set("LevelMin", 3);
        Lib.add(thing);
        thing = Lib.extend("waterproof quiver", "quiver");
        thing.set("Uname", "quiver");
        thing.set("RES:water", 1000);
        thing.set("LevelMin", 4);
        Lib.add(thing);
        thing = Lib.extend("fireproof quiver", "quiver");
        thing.set("Uname", "quiver");
        thing.set("RES:fire", 1000);
        thing.set("LevelMin", 10);
        Lib.add(thing);
        thing = Lib.extend("acidproof quiver", "quiver");
        thing.set("Uname", "quiver");
        thing.set("RES:acid", 1000);
        thing.set("LevelMin", 10);
        Lib.add(thing);
        thing = Lib.extend("frostproof quiver", "quiver");
        thing.set("Uname", "quiver");
        thing.set("RES:ice", 1000);
        thing.set("RES:chill", 1000);
        thing.set("LevelMin", 10);
        Lib.add(thing);
        thing = Lib.extend("theftproof quiver", "quiver");
        thing.set("Uname", "quiver");
        thing.set("TheftProof", 1);
        thing.set("LevelMin", 10);
        Lib.add(thing);
        thing = Lib.extend("invulnerable quiver", "quiver");
        thing.set("Uname", "quiver");
        thing.set("IsDestructible", 0);
        thing.set("LevelMin", 20);
        Lib.add(thing);
        thing = Lib.extend("jewelry case", "base container");
        thing.set("Image", 142);
        thing.set("WieldType", 74);
        thing.set("Holds", "IsRing");
        thing.set("LevelMin", 3);
        Lib.add(thing);
        thing = Lib.extend("waterproof jewelry case", "jewelry case");
        thing.set("Uname", "jewelry case");
        thing.set("RES:water", 1000);
        thing.set("LevelMin", 4);
        Lib.add(thing);
        thing = Lib.extend("fireproof jewelry case", "jewelry case");
        thing.set("Uname", "jewelry case");
        thing.set("RES:fire", 1000);
        thing.set("LevelMin", 10);
        Lib.add(thing);
        thing = Lib.extend("acidproof jewelry case", "jewelry case");
        thing.set("Uname", "jewelry case");
        thing.set("RES:acid", 1000);
        thing.set("LevelMin", 10);
        Lib.add(thing);
        thing = Lib.extend("frostproof jewelry case", "jewelry case");
        thing.set("Uname", "jewelry case");
        thing.set("RES:ice", 1000);
        thing.set("RES:chill", 1000);
        thing.set("LevelMin", 10);
        Lib.add(thing);
        thing = Lib.extend("theftproof jewelry case", "jewelry case");
        thing.set("Uname", "jewelry case");
        thing.set("TheftProof", 1);
        thing.set("LevelMin", 10);
        Lib.add(thing);
        thing = Lib.extend("invulnerable jewelry case", "jewelry case");
        thing.set("Uname", "jewelry case");
        thing.set("IsDestructible", 0);
        thing.set("LevelMin", 20);
        Lib.add(thing);
        thing = Lib.extend("rune bag", "base container");
        thing.set("Image", 142);
        thing.set("WieldType", 78);
        thing.set("Holds", "IsRune");
        thing.set("LevelMin", 3);
        Lib.add(thing);
        thing = Lib.extend("waterproof rune bag", "rune bag");
        thing.set("Uname", "rune bag");
        thing.set("RES:water", 1000);
        thing.set("LevelMin", 4);
        Lib.add(thing);
        thing = Lib.extend("fireproof rune bag", "rune bag");
        thing.set("Uname", "rune bag");
        thing.set("RES:fire", 1000);
        thing.set("LevelMin", 10);
        Lib.add(thing);
        thing = Lib.extend("acidproof rune bag", "rune bag");
        thing.set("Uname", "rune bag");
        thing.set("RES:acid", 1000);
        thing.set("LevelMin", 10);
        Lib.add(thing);
        thing = Lib.extend("frostproof rune bag", "rune bag");
        thing.set("Uname", "rune bag");
        thing.set("RES:ice", 1000);
        thing.set("RES:chill", 1000);
        thing.set("LevelMin", 10);
        Lib.add(thing);
        thing = Lib.extend("theftproof rune bag", "rune bag");
        thing.set("Uname", "rune bag");
        thing.set("TheftProof", 1);
        thing.set("LevelMin", 10);
        Lib.add(thing);
        thing = Lib.extend("invulnerable rune bag", "rune bag");
        thing.set("Uname", "rune bag");
        thing.set("IsDestructible", 0);
        thing.set("LevelMin", 20);
        Lib.add(thing);
        thing = Lib.extend("wand case", "base container");
        thing.set("Image", 142);
        thing.set("WieldType", 80);
        thing.set("Holds", "IsWand");
        thing.set("LevelMin", 3);
        Lib.add(thing);
        thing = Lib.extend("waterproof wand case", "wand case");
        thing.set("Uname", "wand case");
        thing.set("RES:water", 1000);
        thing.set("LevelMin", 4);
        Lib.add(thing);
        thing = Lib.extend("fireproof wand case", "wand case");
        thing.set("Uname", "wand case");
        thing.set("RES:fire", 1000);
        thing.set("LevelMin", 10);
        Lib.add(thing);
        thing = Lib.extend("acidproof wand case", "wand case");
        thing.set("Uname", "wand case");
        thing.set("RES:acid", 1000);
        thing.set("LevelMin", 10);
        Lib.add(thing);
        thing = Lib.extend("frostproof wand case", "wand case");
        thing.set("Uname", "wand case");
        thing.set("RES:ice", 1000);
        thing.set("RES:chill", 1000);
        thing.set("LevelMin", 10);
        Lib.add(thing);
        thing = Lib.extend("theftproof wand case", "wand case");
        thing.set("Uname", "wand case");
        thing.set("TheftProof", 1);
        thing.set("LevelMin", 10);
        Lib.add(thing);
        thing = Lib.extend("invulnerable wand case", "wand case");
        thing.set("Uname", "wand case");
        thing.set("IsDestructible", 0);
        thing.set("LevelMin", 20);
        Lib.add(thing);
        thing = Lib.extend("bag of holding", "base container");
        thing.set("Image", 142);
        thing.set("WieldType", 72);
        thing.set("IsFeatherWeight", 1);
        thing.set("Holds", "IsItem");
        thing.set("LevelMin", 20);
        Lib.add(thing);
        thing = Lib.extend("waterproof bag of holding", "bag of holding");
        thing.set("Uname", "bag of holding");
        thing.set("RES:water", 1000);
        thing.set("LevelMin", 4);
        Lib.add(thing);
        thing = Lib.extend("fireproof bag of holding", "bag of holding");
        thing.set("Uname", "bag of holding");
        thing.set("RES:fire", 1000);
        thing.set("LevelMin", 10);
        Lib.add(thing);
        thing = Lib.extend("acidproof bag of holding", "bag of holding");
        thing.set("Uname", "bag of holding");
        thing.set("RES:acid", 1000);
        thing.set("LevelMin", 10);
        Lib.add(thing);
        thing = Lib.extend("frostproof bag of holding", "bag of holding");
        thing.set("Uname", "bag of holding");
        thing.set("RES:ice", 1000);
        thing.set("RES:chill", 1000);
        thing.set("LevelMin", 10);
        Lib.add(thing);
        thing = Lib.extend("theftproof bag of holding", "bag of holding");
        thing.set("Uname", "bag of holding");
        thing.set("TheftProof", 1);
        thing.set("LevelMin", 10);
        Lib.add(thing);
        thing = Lib.extend("invulnerable bag of holding", "bag of holding");
        thing.set("Uname", "bag of holding");
        thing.set("IsDestructible", 0);
        thing.set("LevelMin", 20);
        Lib.add(thing);
    }

    private static class GoFish
    extends Script {
        private static final long serialVersionUID = 3833466197629743666L;
        private static String[] theFish = new String[]{"tiny fish", "small fish", "fish", "large fish", "trout", "salmon", "large salmon"};

        private GoFish() {
        }

        public boolean handle(Thing thing, Event event) {
            int n;
            int n2;
            Thing thing2 = event.getThing("User");
            Map map = thing2.getMap();
            thing2.incStat("APS", -1000);
            int n3 = 0;
            for (n2 = thing2.x - 1; n2 <= thing2.x + 1; ++n2) {
                block6: for (n = thing2.y - 1; n <= thing2.y + 1; ++n) {
                    switch (map.getTile(n2, n)) {
                        case 17: {
                            n3 += 2;
                            continue block6;
                        }
                        case 25: {
                            n3 += 3;
                            continue block6;
                        }
                        case 26: {
                            ++n3;
                        }
                    }
                }
            }
            if (n3 <= 0) {
                thing2.message("There is nowhere good to fish here!");
                return true;
            }
            n2 = thing2.getStat("CR") * (1 + thing2.getStat("Survival"));
            n = -4;
            for (int i = 0; i < 10; ++i) {
                if (!RPG.test(n3 * n2, 500)) continue;
                ++n;
            }
            if (n < 0) {
                thing2.message("You don't manage to catch anything");
                return true;
            }
            Thing thing3 = Lib.create(theFish[n]);
            thing2.message("You catch " + thing3.getAName() + "!");
            thing2.addThingWithStacking(thing3);
            return true;
        }
    }

    private static class KeyUse
    extends Script {
        private static final long serialVersionUID = 1L;

        private KeyUse() {
        }

        public boolean handle(Thing thing, Event event) {
            Thing thing2 = event.getThing("User");
            thing2.message("Select direction:");
            Point point = Game.getDirection();
            if (point == null) {
                thing2.message("");
                return false;
            }
            Map map = thing2.getMap();
            Thing thing3 = map.getFlaggedObject(thing2.x + point.x, thing2.y + point.y, "IsDoor");
            if (thing3 == null) {
                thing2.message("There is no door to lock in that direction");
            } else {
                if (!Door.keyFits(thing, thing3)) {
                    thing2.message(thing.getYourName() + " does not seem to fit " + thing3.getTheName());
                    return false;
                }
                if (!thing3.getFlag("IsLocked")) {
                    if (Door.canLock(thing, thing3)) {
                        thing2.message("You lock " + thing3.getTheName());
                        thing3.set("IsLocked", 1);
                    } else {
                        thing2.message("You seem unable to lock " + thing3.getTheName());
                    }
                } else if (Door.unlock(thing, thing3)) {
                    thing2.message("You unlock " + thing3.getTheName());
                }
            }
            return false;
        }
    }
}

